/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.favorites;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.TileEntityUpdate;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.favorites.FavoritesCore;
import project.studio.manametalmod.favorites.FavoritesType;

public class TileEntityFavorites
extends TileEntityUpdate {
    public FavoritesType type = FavoritesType.Ores;
    public String name = "missingNO";
    public boolean[] data;

    public void func_145839_a(NBTTagCompound nbt) {
        block4: {
            byte[] temp;
            int newsize;
            block5: {
                block3: {
                    super.func_145839_a(nbt);
                    this.type = FavoritesType.values()[NBTHelp.getIntSafe("FavoritesType", nbt, 0)];
                    this.name = NBTHelp.getStringSafe("player_name", nbt, "missingNO");
                    newsize = TileEntityFavorites.getFavoritesList(this.type).size();
                    temp = NBTHelp.getByteArraySafe("FavoritesData", nbt, new byte[newsize]);
                    if (temp.length != newsize) break block3;
                    this.data = new boolean[temp.length];
                    for (int s = 0; s < temp.length; ++s) {
                        this.data[s] = temp[s] == 1;
                    }
                    break block4;
                }
                if (temp.length >= newsize) break block5;
                this.data = new boolean[newsize];
                for (int s = 0; s < temp.length; ++s) {
                    this.data[s] = temp[s] == 1;
                }
                break block4;
            }
            if (temp.length <= newsize) break block4;
            this.data = new boolean[newsize];
            for (int s = 0; s < newsize; ++s) {
                this.data[s] = temp[s] == 1;
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("FavoritesType", this.type.ordinal());
        nbt.func_74778_a("player_name", this.name);
        if (this.data == null) {
            int newsize = TileEntityFavorites.getFavoritesList(this.type).size();
            this.data = new boolean[newsize];
        }
        byte[] temp = new byte[this.data.length];
        for (int s = 0; s < temp.length; ++s) {
            temp[s] = this.data[s] ? (byte)1 : 0;
        }
        nbt.func_74773_a("FavoritesData", temp);
    }

    public void onBlock(EntityPlayer player, int data) {
        this.type = FavoritesType.values()[data];
        this.name = player.func_70005_c_();
        this.data = new boolean[TileEntityFavorites.getFavoritesList(this.type).size()];
    }

    public void sendFavorites(EntityPlayer player, ManaMetalModRoot root) {
        byte temp = root.money.Favoritesdata[this.type.ordinal()];
        if (temp == 3) {
            MMM.addMessage(player, "MMM.info.cantFavorites", MMM.getTranslateText("GuiFavorites.info." + this.type.toString()));
            return;
        }
        List<ItemStack> list = TileEntityFavorites.getFavoritesList(this.type);
        StringBuilder text = new StringBuilder();
        text.append(MMM.getTranslateText("MMM.info.FavoritesOK"));
        boolean isok = false;
        float tempok = 0.0f;
        float max = this.data.length;
        for (int s = 0; s < list.size(); ++s) {
            if (this.data[s]) {
                tempok += 1.0f;
            }
            if (this.data[s]) continue;
            ItemStack itemtarget = list.get(s);
            itemtarget.field_77994_a = 1;
            if (!MMM.clearItemsNoNBT(itemtarget, player)) continue;
            this.data[s] = true;
            text.append(itemtarget.func_82833_r());
            text.append(" ");
            isok = true;
            tempok += 1.0f;
        }
        if (isok) {
            float done = tempok / max;
            text.append(" ");
            MMM.addMessageBase(player, text.toString());
            MMM.addMessageBase(player, MMM.getTranslateText("MMM.info.FavoritesDatas") + (int)(done * 100.0f) + "%");
            if (done >= 0.3f && temp < 1) {
                MMM.addMessageWorldBase(player.field_70170_p, player.func_70005_c_() + MMM.getTranslateText("GuiFavorites.info." + this.type.toString()) + MMM.getTranslateText("MMM.info.Favorites30"));
                root.money.Favoritesdata[this.type.ordinal()] = 1;
                MMM.addItemToPlayer(new ItemStack(TileEntityFavorites.getFavoritesItem(this.type), 1, 0), player);
            }
            if (done >= 0.5f && temp < 2) {
                MMM.addMessageWorldBase(player.field_70170_p, player.func_70005_c_() + MMM.getTranslateText("GuiFavorites.info." + this.type.toString()) + MMM.getTranslateText("MMM.info.Favorites50"));
                root.money.Favoritesdata[this.type.ordinal()] = 2;
                MMM.addItemToPlayer(new ItemStack(TileEntityFavorites.getFavoritesItem(this.type), 1, 1), player);
            }
            if (done >= 1.0f && temp < 3) {
                MMM.addMessageWorldBase(player.field_70170_p, player.func_70005_c_() + MMM.getTranslateText("GuiFavorites.info." + this.type.toString()) + MMM.getTranslateText("MMM.info.Favorites100"));
                root.money.Favoritesdata[this.type.ordinal()] = 3;
                MMM.addItemToPlayer(new ItemStack(TileEntityFavorites.getFavoritesItem(this.type), 1, 2), player);
            }
        } else {
            MMM.addMessage(player, "MMM.info.FavoritesFail");
        }
        this.update_data();
    }

    public static final List<ItemStack> getFavoritesList(FavoritesType type) {
        switch (type) {
            case Ores: {
                return FavoritesCore.Ores;
            }
            case Gems: {
                return FavoritesCore.Gems;
            }
            case Farms: {
                return FavoritesCore.Farms;
            }
            case Treasures: {
                return FavoritesCore.Treasures;
            }
            case Fishs: {
                return FavoritesCore.Fishs;
            }
            case Baubles1: {
                return FavoritesCore.Baubles1;
            }
            case Baubles2: {
                return FavoritesCore.Baubles2;
            }
            case MagicJadeRed: {
                return FavoritesCore.MagicJadeReds;
            }
            case Food: {
                return FavoritesCore.Food;
            }
            case BeeKeeping: {
                return FavoritesCore.BeeKeeping;
            }
        }
        return null;
    }

    public static final Item getFavoritesItem(FavoritesType type) {
        switch (type) {
            case Ores: {
                return FavoritesCore.ItemBagFavoritesOres;
            }
            case Gems: {
                return FavoritesCore.ItemBagFavoritesGem;
            }
            case Farms: {
                return FavoritesCore.ItemBagFavoritesFarms;
            }
            case Treasures: {
                return FavoritesCore.ItemBagFavoritesTreasures;
            }
            case Fishs: {
                return FavoritesCore.ItemBagFavoritesFish;
            }
            case Baubles1: {
                return FavoritesCore.ItemBagFavoritesBaubles1;
            }
            case Baubles2: {
                return FavoritesCore.ItemBagFavoritesBaubles2;
            }
            case MagicJadeRed: {
                return FavoritesCore.ItemBagFavoritesMagicJadeRed;
            }
            case Food: {
                return FavoritesCore.ItemBagFavoritesFood;
            }
            case BeeKeeping: {
                return FavoritesCore.ItemBagFavoritesBeeKeeping;
            }
        }
        return null;
    }
}

