/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.food_collection;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.food_collection.FoodCollection;
import project.studio.manametalmod.food_collection.FoodCollectionItem;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.magic.magicItem.MagicItemType;

public class FoodCollectionCore {
    public static final Map<String, FoodCollection> FoodCollectionPool = new HashMap<String, FoodCollection>();
    public static final String key = "FoodCollection";
    public static final String keyList = "FoodCollectionList";
    public static final String keyPlayerName = "FoodCollectionPlayer";

    public static boolean add(ItemStack item, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            FoodCollection fc = FoodCollectionCore.get(player);
            return fc.add(item, player);
        }
        return false;
    }

    public static final void addItemEffect(Object item, MagicItemType type, float data, short maxUse) {
        ItemStack temp = MMM.item(item);
        String nameItem = Item.field_150901_e.func_148750_c((Object)temp.func_77973_b());
        FoodCollectionItem fc = new FoodCollectionItem(nameItem, (short)temp.func_77960_j(), maxUse);
        fc.effect = new IMagicEffect[]{new IMagicEffect(type, data)};
        ManaMetalAPI.FoodCollectionItemList.add(fc);
    }

    public static final void addItemEffect(Object item, IMagicEffect[] data, short maxUse) {
        ItemStack temp = MMM.item(item);
        String nameItem = Item.field_150901_e.func_148750_c((Object)temp.func_77973_b());
        FoodCollectionItem fc = new FoodCollectionItem(nameItem, (short)temp.func_77960_j(), maxUse);
        fc.effect = data;
        ManaMetalAPI.FoodCollectionItemList.add(fc);
    }

    public static FoodCollection get(EntityPlayer player) {
        String name = player.func_70005_c_();
        if (FoodCollectionPool.containsKey(name)) {
            return FoodCollectionPool.get(name);
        }
        FoodCollection fc = new FoodCollection(name);
        FoodCollectionPool.put(name, fc);
        return fc;
    }

    public static void load(WorldEvent.Load event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getFoodCollectionData().func_150297_b(key, 9)) {
            NBTTagList list = MMM.getWorldData(event.world).getFoodCollectionData().func_150295_c(key, 10);
            int size = list.func_74745_c();
            if (size > 0) {
                FoodCollectionPool.clear();
                for (int s = 0; s < size; ++s) {
                    NBTTagCompound tag = list.func_150305_b(s);
                    String playername = tag.func_74779_i(keyPlayerName);
                    FoodCollectionPool.put(playername, FoodCollection.readFromNBT(tag, playername));
                }
                MMM.Logg("load FoodCollection");
            } else {
                MMM.Logg("trying to load an empty FoodCollection");
            }
        }
    }

    public static void save(WorldEvent.Save event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, FoodCollection> entry : FoodCollectionPool.entrySet()) {
                FoodCollection temp = entry.getValue();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(keyPlayerName, entry.getKey());
                FoodCollection.saveToNBT(tag, temp);
                list.func_74742_a((NBTBase)tag);
            }
            if (list.func_74745_c() > 0) {
                MMM.getWorldData(event.world).getFoodCollectionData().func_74782_a(key, (NBTBase)list);
                MMM.getWorldData(event.world).func_76185_a();
                MMM.Logg("save FoodCollection");
            } else {
                MMM.Logg("trying to save an empty FoodCollection");
            }
        }
    }
}

