/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.furniture;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.furniture.EntitySittableBlockFurniture;
import project.studio.manametalmod.furniture.TileEntityFurniture;
import project.studio.manametalmod.furniture.TileEntityFurnitureLight;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.pagan.BadGuyCore;
import project.studio.manametalmod.produce.Produce;
import project.studio.manametalmod.produce.ProduceCore;
import project.studio.manametalmod.produce.fishing.FishingCore;
import project.studio.manametalmod.produce.textile.TextileCore;
import project.studio.manametalmod.survivalfactor.SurvivalFactorCore;
import project.studio.manametalmod.zombiedoomsday.ZombiedoomsdayCore;

public class BlockFurnitureBase
extends Block
implements ITileEntityProvider {
    boolean light;

    public BlockFurnitureBase(boolean light) {
        super(Material.field_151575_d);
        this.light = light;
        if (light) {
            this.func_149663_c("BlockFurnitureBaseLight");
        } else {
            this.func_149663_c("BlockFurnitureBase");
        }
        this.func_149647_a(ManaMetalMod.tab_Furniture);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149658_d(MMM.getMODID() + ":BlockFurnitureBase");
        this.func_149672_a(Block.field_149766_f);
        this.func_149715_a(light ? 1.0f : 0.0f);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int p_149696_5_, int p_149696_6_) {
        TileEntity tilebase = world.func_147438_o(x, y, z);
        if (tilebase != null) {
            TileEntity tile;
            if (tilebase instanceof TileEntityFurniture) {
                tile = (TileEntityFurniture)tilebase;
                tile.send();
            }
            if (tilebase instanceof TileEntityFurnitureLight) {
                tile = (TileEntityFurnitureLight)tilebase;
                tile.send();
            }
        }
        return false;
    }

    public void serBounds4(int metadata, float minY, float maxY) {
        switch (metadata) {
            case 0: {
                this.func_149676_a(0.0f, minY, 0.8f, 1.0f, maxY, 1.0f);
                return;
            }
            case 2: {
                this.func_149676_a(0.0f, minY, 0.0f, 1.0f, maxY, 0.2f);
                return;
            }
            case 3: {
                this.func_149676_a(0.8f, minY, 0.0f, 1.0f, maxY, 1.0f);
                return;
            }
            case 1: {
                this.func_149676_a(0.0f, minY, 0.0f, 0.2f, maxY, 1.0f);
                return;
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tilebase2;
        TileEntity tilebase = world.func_147438_o(x, y, z);
        if (tilebase != null && tilebase instanceof TileEntityFurniture) {
            TileEntityFurniture tile = (TileEntityFurniture)tilebase;
            switch (tile.type) {
                case 56: 
                case 75: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    this.serBounds4(tile.func_145832_p(), 0.0f, 2.0f);
                    return;
                }
                case 57: {
                    this.serBounds4(tile.func_145832_p(), 0.0f, 1.0f);
                    return;
                }
                case 55: {
                    this.serBounds4(tile.func_145832_p(), 0.6f, 1.2f);
                    return;
                }
                case 76: {
                    this.serBounds4(tile.func_145832_p(), 0.0f, 1.0f);
                    return;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.8f, 0.8f);
                    return;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: 
                case 14: {
                    this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
                    return;
                }
                case 83: {
                    this.func_149676_a(0.2f, 0.5f, 0.2f, 0.8f, 1.0f, 0.8f);
                    return;
                }
                case 85: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                    return;
                }
                case 79: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.5f, 1.0f);
                    return;
                }
                case 89: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                    return;
                }
                case 95: {
                    this.func_149676_a(0.0f, 0.6f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
        }
        if (this.light && (tilebase2 = world.func_147438_o(x, y, z)) != null && tilebase2 instanceof TileEntityFurnitureLight) {
            TileEntityFurnitureLight tile = (TileEntityFurnitureLight)tilebase2;
            switch (tile.type) {
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: {
                    this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
                    return;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 0.5f, 0.7f);
                    return;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.5f, 0.9f);
                    return;
                }
                case 19: 
                case 20: 
                case 21: {
                    this.func_149676_a(0.0f, 0.8f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int dx, int dy, int dz) {
        TileEntity tilebase2;
        TileEntity tilebase = world.func_147438_o(dx, dy, dz);
        if (tilebase != null && tilebase instanceof TileEntityFurniture) {
            TileEntityFurniture tile = (TileEntityFurniture)tilebase;
            if (tile.type < 15 || tile.type == 53) {
                return AxisAlignedBB.func_72330_a((double)((double)dx + this.field_149759_B), (double)((double)dy + this.field_149760_C), (double)((double)dz + this.field_149754_D), (double)((double)dx + this.field_149755_E), (double)((double)dy + 0.6), (double)((double)dz + this.field_149757_G));
            }
            switch (tile.type) {
                case 96: 
                case 97: 
                case 98: 
                case 99: {
                    return AxisAlignedBB.func_72330_a((double)((double)dx + this.field_149759_B), (double)((double)dy + this.field_149760_C), (double)((double)dz + this.field_149754_D), (double)((double)dx + this.field_149755_E), (double)((double)dy + 0.3), (double)((double)dz + this.field_149757_G));
                }
                case 89: {
                    return AxisAlignedBB.func_72330_a((double)((double)dx + this.field_149759_B), (double)((double)dy + this.field_149760_C), (double)((double)dz + this.field_149754_D), (double)((double)dx + this.field_149755_E), (double)((double)dy + 0.4), (double)((double)dz + this.field_149757_G));
                }
                case 47: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 73: 
                case 78: 
                case 83: 
                case 95: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    return null;
                }
            }
        }
        if (this.light && (tilebase2 = world.func_147438_o(dx, dy, dz)) != null && tilebase2 instanceof TileEntityFurnitureLight) {
            TileEntityFurnitureLight tile = (TileEntityFurnitureLight)tilebase2;
            switch (tile.type) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: {
                    return null;
                }
            }
        }
        return super.func_149668_a(world, dx, dy, dz);
    }

    public boolean addWater(World world, int x, int y, int z, EntityPlayer player, TileEntityFurniture tile) {
        ItemStack items = player.func_71045_bC();
        if (items != null) {
            if (items.func_77973_b() == Items.field_151069_bo) {
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack((Item)Items.field_151068_bn), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == Items.field_151133_ar) {
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack(Items.field_151131_as), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == ProduceCore.ManaPotionBottles && items.func_77960_j() == 0) {
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack(ProduceCore.ManaPotionBottles, 1, 1), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == SurvivalFactorCore.ItemKettles) {
                items.func_77964_b(0);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == FishingCore.ItemKettleGold) {
                items.func_77964_b(0);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == ZombiedoomsdayCore.water_0) {
                int datameta = items.func_77960_j();
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack(ZombiedoomsdayCore.water_1, 1, datameta), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public boolean pushWater(World world, int x, int y, int z, EntityPlayer player, TileEntityFurniture tile) {
        ItemStack items = player.func_71045_bC();
        if (items != null) {
            if (items.func_77973_b() == Items.field_151068_bn) {
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack(Items.field_151069_bo), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == Items.field_151131_as) {
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack(Items.field_151133_ar), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
            if (items.func_77973_b() == ZombiedoomsdayCore.water_1) {
                int datameta = items.func_77960_j();
                MMM.removePlayerCurrentItem(player);
                MMM.addItemToPlayer(new ItemStack(ZombiedoomsdayCore.water_0, 1, datameta), player);
                player.func_85030_a(MMM.getMODID() + ":fill_bottle", 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int data, float f1, float f2, float f3) {
        if (this.light) {
            return false;
        }
        TileEntityFurniture tile = (TileEntityFurniture)world.func_147438_o(x, y, z);
        switch (tile.type) {
            case 52: {
                if (!this.addWater(world, x, y, z, player, tile)) break;
                tile.type = 120;
                tile.send();
                return true;
            }
            case 53: {
                if (!this.addWater(world, x, y, z, player, tile)) break;
                tile.type = 121;
                tile.send();
                return true;
            }
            case 54: {
                if (!this.addWater(world, x, y, z, player, tile)) break;
                tile.type = 122;
                tile.send();
                return true;
            }
            case 58: {
                if (!this.addWater(world, x, y, z, player, tile)) break;
                tile.type = 123;
                tile.send();
                return true;
            }
            case 74: {
                if (!this.addWater(world, x, y, z, player, tile)) break;
                tile.type = 124;
                tile.send();
                return true;
            }
        }
        switch (tile.type) {
            case 120: {
                if (!this.pushWater(world, x, y, z, player, tile)) break;
                tile.type = 52;
                tile.send();
                return true;
            }
            case 121: {
                if (!this.pushWater(world, x, y, z, player, tile)) break;
                tile.type = 53;
                tile.send();
                return true;
            }
            case 122: {
                if (!this.pushWater(world, x, y, z, player, tile)) break;
                tile.type = 54;
                tile.send();
                return true;
            }
            case 123: {
                if (!this.pushWater(world, x, y, z, player, tile)) break;
                tile.type = 58;
                tile.send();
                return true;
            }
            case 124: {
                if (!this.pushWater(world, x, y, z, player, tile)) break;
                tile.type = 74;
                tile.send();
                return true;
            }
        }
        if (tile.type == 69) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() == TextileCore.ItemLeather && item.func_77960_j() == 1) {
                tile.type = 70;
                world.func_147471_g(x, y, z);
                MMM.removePlayerCurrentItem(player);
            }
            return false;
        }
        if (tile.type == 71) {
            int count = 4;
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root != null) {
                root.produce.addEXP(100, Produce.Tailor);
                if (root.produce.getLV(Produce.Tailor) >= 6) {
                    ++count;
                }
                if (root.produce.getLV(Produce.Tailor) >= 9) {
                    count += 2;
                }
            }
            MMM.addItemToPlayer(new ItemStack(TextileCore.ItemLeather, count, 2), player);
            tile.type = 69;
            world.func_147471_g(x, y, z);
            return false;
        }
        if (tile.type == 72) {
            player.func_85030_a(MMM.getMODID() + ":bell_use01", 1.0f, 1.0f);
            return true;
        }
        if (tile.type == 63 || tile.type == 64) {
            return this.doCannon(tile, world, x, y, z, player, data, f1, f2, f3);
        }
        if (tile.type < 15 || tile.type == 53 || tile.type == 89 || tile.type == 92 || tile.type == 96 || tile.type == 97 || tile.type == 98 || tile.type == 99) {
            this.sitOnBlock(world, x, y, z, player, 0.5);
            return true;
        }
        if (tile.type == 110 || tile.type == 112 || tile.type == 114 || tile.type == 116) {
            ++tile.type;
            tile.send();
            return true;
        }
        if (tile.type == 111 || tile.type == 113 || tile.type == 115 || tile.type == 117) {
            --tile.type;
            tile.send();
            return true;
        }
        return false;
    }

    public boolean doCannon(TileEntityFurniture tile, World world, int x, int y, int z, EntityPlayer player, int data, float f1, float f2, float f3) {
        if (tile.type == 63) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() == BadGuyCore.Cannonball) {
                tile.type = 64;
                world.func_147471_g(x, y, z);
                MMM.removePlayerCurrentItem(player);
                player.func_85030_a("fire.ignite", 1.0f, 1.0f);
            }
            return true;
        }
        if (tile.type == 64) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() instanceof ItemFlintAndSteel) {
                this.fire(world, x, y, z, player);
                tile.type = 63;
                world.func_147471_g(x, y, z);
            }
            return true;
        }
        return false;
    }

    public void fire(World world, int x, int y, int z, EntityPlayer player) {
        player.func_85030_a(MMM.getMODID() + ":cannon", 5.0f, 1.0f);
        EntityMagicBallNew ball = new EntityMagicBallNew(world, (EntityLivingBase)player, 500, ManaElements.Fire, 9, null);
        ball.func_70080_a(x, y, z, 0.0f, 0.0f);
        ball.setSpaceTextureID(4);
        ball.field_70161_v += 0.5;
        ball.field_70165_t += 0.5;
        ball.field_70163_u += 0.5;
        ball.field_70159_w = 0.0;
        ball.field_70181_x = 0.15;
        ball.field_70179_y = 0.0;
        switch (world.func_72805_g(x, y, z)) {
            case 1: {
                ball.field_70159_w = 2.5;
                ball.field_70165_t += 1.0;
                break;
            }
            case 3: {
                ball.field_70159_w = -2.5;
                ball.field_70165_t += -1.0;
                break;
            }
            case 0: {
                ball.field_70179_y = -2.5;
                ball.field_70161_v += -1.0;
                break;
            }
            case 2: {
                ball.field_70179_y = 2.5;
                ball.field_70161_v += 1.0;
            }
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)ball);
        }
    }

    public boolean sitOnBlock(World world, int x, int y, int z, EntityPlayer player, double data) {
        if (!world.field_72995_K) {
            this.checkForExistingEntity(world, x, y, z, player);
            EntitySittableBlockFurniture nemb = new EntitySittableBlockFurniture(world, x, y, z, data);
            world.func_72838_d((Entity)nemb);
            player.func_70078_a((Entity)nemb);
        }
        return true;
    }

    public boolean checkForExistingEntity(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        List listEMB = par1World.func_72872_a(EntitySittableBlockFurniture.class, AxisAlignedBB.func_72330_a((double)par2, (double)par3, (double)par4, (double)((double)par2 + 1.0), (double)((double)par3 + 1.0), (double)((double)par4 + 1.0)).func_72314_b(1.0, 1.0, 1.0));
        for (int s = 0; s < listEMB.size(); ++s) {
            if (listEMB.get(s) instanceof EntitySittableBlockFurniture) {
                EntitySittableBlockFurniture mount = (EntitySittableBlockFurniture)((Object)listEMB.get(s));
                if (mount.blockPosX != par2 || mount.blockPosY != par3 || mount.blockPosZ != par4) continue;
                if (mount.field_70153_n == null) {
                    par5EntityPlayer.func_70078_a((Entity)mount);
                }
            }
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (angle == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (angle == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (angle == 2) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (angle == 3) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (this.light) {
            TileEntityFurnitureLight tile = (TileEntityFurnitureLight)world.func_147438_o(x, y, z);
            tile.type = stack.func_77960_j();
        } else {
            TileEntityFurniture tile = (TileEntityFurniture)world.func_147438_o(x, y, z);
            tile.type = stack.func_77960_j();
        }
    }

    public TileEntity func_149915_a(World World2, int id) {
        if (this.light) {
            return new TileEntityFurnitureLight();
        }
        return new TileEntityFurniture();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149749_a(World world, int x, int y, int z, Block Block2, int p_149749_6_) {
        if (world.func_147438_o(x, y, z) != null) {
            if (this.light) {
                TileEntityFurnitureLight tile = (TileEntityFurnitureLight)world.func_147438_o(x, y, z);
                MMM.spawnItemInWorld(world, new ItemStack((Block)this, 1, tile.type), (double)x, (double)((float)y + 0.5f), (double)z);
            } else {
                TileEntityFurniture tile = (TileEntityFurniture)world.func_147438_o(x, y, z);
                MMM.spawnItemInWorld(world, new ItemStack((Block)this, 1, tile.type), (double)x, (double)((float)y + 0.5f), (double)z);
            }
        }
        super.func_149749_a(world, x, y, z, Block2, p_149749_6_);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item item = Item.func_150898_a((Block)this);
        if (item == null) {
            return null;
        }
        if (this.light) {
            TileEntityFurnitureLight tile = (TileEntityFurnitureLight)world.func_147438_o(x, y, z);
            return new ItemStack(item, 1, tile.type);
        }
        TileEntityFurniture tile = (TileEntityFurniture)world.func_147438_o(x, y, z);
        return new ItemStack(item, 1, tile.type);
    }

    protected ItemStack func_149644_j(int id) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, id);
    }

    public int func_149692_a(int id) {
        return id;
    }
}

