/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.M3StatList;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.StatBasicM3;
import project.studio.manametalmod.core.WorldSaveDataMana;
import project.studio.manametalmod.enchantmentskey.EnchantmentsKeyEffect;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.instance_dungeon.IDungeonBoss;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonTPType;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.ItemDungeonDedicated;
import project.studio.manametalmod.instance_dungeon.ItemDungeonKeyOpen;
import project.studio.manametalmod.instance_dungeon.TeleporterInstanceDungeonPortal;
import project.studio.manametalmod.instance_dungeon.TileEntityInstanceDungeon;
import project.studio.manametalmod.optool.OpToolCore;
import project.studio.manametalmod.potion.PotionData;
import project.studio.manametalmod.potion.PotionEffectM3;

public class BlockInstanceDungeonPortal
extends BlockContainer {
    public static final Map<String, Pos> doorPos = new HashMap<String, Pos>();
    public static boolean[] complete = new boolean[InstanceDungeonType.values().length];

    public BlockInstanceDungeonPortal() {
        super(Material.field_151576_e);
        this.func_149663_c("BlockInstanceDungeonPortal");
        this.func_149647_a(null);
        this.func_149711_c(-1.0f);
        this.func_149752_b(1.0E9f);
        this.func_149715_a(1.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149658_d("manametalmod:BlockInstanceDungeonPortal");
    }

    public static void load(WorldEvent.Load event) {
        if (MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getData().func_150297_b("DungeonDoor_NextPosKey", 9)) {
            NBTTagList list = MMM.getWorldData(event.world).getData().func_150295_c("DungeonDoor_NextPosKey", 10);
            Pos pos = new Pos();
            int size = list.func_74745_c();
            for (int s = 0; s < size; ++s) {
                pos = new Pos();
                NBTTagCompound tag1 = list.func_150305_b(s);
                pos.readFromNBT(tag1.func_74775_l("value"));
                doorPos.put(tag1.func_74779_i("key"), pos);
            }
        }
    }

    public static void save(WorldEvent.Save event) {
        if (MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, Pos> entry : doorPos.entrySet()) {
                NBTTagCompound tag1 = new NBTTagCompound();
                NBTTagCompound value = new NBTTagCompound();
                entry.getValue().saveToNBT(value);
                tag1.func_74778_a("key", entry.getKey());
                tag1.func_74782_a("value", (NBTBase)value);
                list.func_74742_a((NBTBase)tag1);
            }
            MMM.getWorldData(event.world).getData().func_74782_a("DungeonDoor_NextPosKey", (NBTBase)list);
            MMM.getWorldData(event.world).func_76185_a();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getPickBlock(target, world, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityInstanceDungeon tile = (TileEntityInstanceDungeon)world.func_147438_o(x, y, z);
        return new ItemStack(InstanceDungeonCore.ItemDungeonSetTool, 1, tile.type.ordinal());
    }

    public IIcon func_149691_a(int side, int data) {
        return this.field_149761_L;
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a("stone");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public static IDungeonDifficult getItemToDiff(ItemStack item, InstanceDungeonType type, String customname) {
        for (int s = 0; s < IDungeonDifficult.data.length; ++s) {
            if (!MMM.isItemStackEqualNoNBT(item, type.getSacrificeItem(IDungeonDifficult.data[s], customname))) continue;
            return IDungeonDifficult.data[s];
        }
        return null;
    }

    public boolean canLeaveBoss(EntityPlayer player) {
        List<Entity> list = MMM.findEntity((Entity)player, 100);
        if (!list.isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                IDungeonBoss bosstemp;
                if (!(list.get(s) instanceof IDungeonBoss) || !(bosstemp = (IDungeonBoss)list.get(s)).isBoss()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float fx, float fy, float fz) {
        int did = MMM.getDimensionID(world);
        if (did == M3Config.WorldInstanceDungeonID) {
            this.open_dungeon(world, x, y, z, player);
        } else {
            TileEntityInstanceDungeon tile = (TileEntityInstanceDungeon)world.func_147438_o(x, y, z);
            if (!complete[tile.type.ordinal()] && tile.type != InstanceDungeonType.Custom) {
                MMM.addMessage(player, "MMM.info.BlockInstanceDungeonPortal.cant.goin", MMM.getTranslateText("GuiInstanceDungeon." + tile.type.ordinal()));
                return true;
            }
            if (MMM.isPlayerCreativeMode(player) && !player.field_71071_by.func_146028_b(InstanceDungeonCore.ItemKeyDungeon)) {
                MMM.addItemToPlayer(new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 64), player);
            }
            if (tile.type == InstanceDungeonType.Mechanism) {
                if (!world.field_72995_K) {
                    MMM.addMessage(player, "MMM.info.dungeon.cant.open.Mechanism");
                }
                return true;
            }
            if (!world.field_72995_K) {
                WorldSaveDataMana data = MMM.getWorldData((World)DimensionManager.getWorld((int)0));
                if (data.getInstanceDungeonData().func_150297_b(InstanceDungeonCore.getSaveDataName(new Pos(tile), did), 10)) {
                    NBTTagCompound tag = data.getInstanceDungeonData().func_74775_l(InstanceDungeonCore.getSaveDataName(new Pos(tile), did));
                    long time = DimensionManager.getWorld((int)0).func_82737_E();
                    long over = time - tag.func_74763_f("time");
                    tile.rest_time = over > (long)M3Config.DungeonResetTime ? 0 : (int)(((long)M3Config.DungeonResetTime - over) / 20L / 60L + 1L);
                } else {
                    tile.rest_time = -1;
                }
                tile.update_data();
            }
            if (world.field_72995_K) {
                player.openGui((Object)ManaMetalMod.instance, 235, world, x, y, z);
            }
        }
        return true;
    }

    public boolean open_dungeon(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K && player.field_70154_o == null && player.field_70153_n == null && player instanceof EntityPlayerMP) {
            ManaMetalModRoot root;
            int medadata = world.func_72805_g(x, y, z);
            int did = MMM.getDimensionID(world);
            EntityPlayerMP thePlayer = (EntityPlayerMP)player;
            TileEntityInstanceDungeon tile = (TileEntityInstanceDungeon)world.func_147438_o(x, y, z);
            WorldSaveDataMana data = MMM.getWorldData((World)DimensionManager.getWorld((int)0));
            if (did != M3Config.WorldInstanceDungeonID) {
                tile.posMainWorld = new Pos(tile);
                tile.mainWorldID = did;
            }
            if ((root = MMM.getEntityNBT(player)) != null) {
                if (did == M3Config.WorldInstanceDungeonID) {
                    if (tile.blocktype == 1) {
                        if (this.canLeaveBoss((EntityPlayer)thePlayer)) {
                            MMM.teleport(player, tile.pos);
                        } else if (!thePlayer.field_70170_p.field_72995_K) {
                            MMM.addMessage((EntityPlayer)thePlayer, "MMM.info.cantLeaveBoss");
                        }
                        return true;
                    }
                    this.move(world, x, y, z, thePlayer, tile, null, null, medadata, null, tile.mainWorldID, null);
                    if (!root.carrer.pos_spawn.isEmpty()) {
                        ChunkCoordinates coord = new ChunkCoordinates(root.carrer.pos_spawn.X, root.carrer.pos_spawn.Y, root.carrer.pos_spawn.Z);
                        player.setSpawnChunk(coord, true, 0);
                    }
                    return true;
                }
                if (did != M3Config.WorldInstanceDungeonID) {
                    int needLV = tile.type.getNeedLV(tile.customname);
                    if (root.carrer.getLv() < needLV) {
                        MMM.addMessage(player, "MMM.info.DungeonPortal.lv.1", needLV);
                        return true;
                    }
                    ChunkCoordinates chunkcoordinates = player.getBedLocation(MMM.getDimensionID(world));
                    if (chunkcoordinates != null) {
                        root.carrer.pos_spawn = new Pos(chunkcoordinates);
                    } else {
                        player.setSpawnChunk(new ChunkCoordinates((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), true, MMM.getDimensionID(world));
                        root.carrer.pos_spawn = new Pos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                        MMM.addMessage((EntityPlayer)thePlayer, "MMM.info.nobedspawn");
                    }
                    ItemStack item = player.func_71045_bC();
                    if (item == null) {
                        return true;
                    }
                    IDungeonDifficult diff = BlockInstanceDungeonPortal.getItemToDiff(item, tile.type, tile.customname);
                    if (diff == null) {
                        MMM.addMessage(player, "MMM.info.DungeonPortal.0");
                        MMM.addMessage(player, "MMM.info.DungeonPortal.1");
                        return true;
                    }
                    if (item.func_77942_o() && item.func_77978_p().func_150297_b("listEffect", 9) && tile.type.isBossDungeon()) {
                        MMM.addMessage(player, "MMM.info.DungeonPortal.isBossDungeon.key");
                        return true;
                    }
                    if (root.carrer.needUpdateName) {
                        MMM.addMessage(player, "MMM.info.DungeonPortal.needUpdateName");
                        return true;
                    }
                    if (root.carrer.getLv() >= needLV) {
                        Pos pos = BlockInstanceDungeonPortal.getGOPos("pos_" + tile.field_145851_c + "_" + tile.field_145848_d + "_" + tile.field_145849_e + "#" + did);
                        EnchantmentsKeyEffect keyeffecct = ItemDungeonKeyOpen.getEnchantmentsKeyEffect(item);
                        if (data.getInstanceDungeonData().func_150297_b(InstanceDungeonCore.getSaveDataName(new Pos(tile), did), 10)) {
                            NBTTagCompound tag = data.getInstanceDungeonData().func_74775_l(InstanceDungeonCore.getSaveDataName(new Pos(tile), did));
                            long time = DimensionManager.getWorld((int)0).func_82737_E();
                            long over = time - tag.func_74763_f("time");
                            if (over > (long)M3Config.DungeonResetTime) {
                                MMM.removePlayerCurrentItem((EntityPlayer)thePlayer);
                                InstanceDungeonTPType gototype = InstanceDungeonTPType.Refresh;
                                if (player.field_71071_by.func_146026_a(OpToolCore.ItemDungeonReset)) {
                                    gototype = InstanceDungeonTPType.UpDate;
                                }
                                this.move(world, x, y, z, thePlayer, tile, gototype, diff, medadata, pos, did, keyeffecct);
                            } else {
                                this.move(world, x, y, z, thePlayer, tile, InstanceDungeonTPType.NotYet, diff, medadata, pos, did, keyeffecct);
                            }
                        } else {
                            MMM.removePlayerCurrentItem((EntityPlayer)thePlayer);
                            this.move(world, x, y, z, thePlayer, tile, InstanceDungeonTPType.FirstTime, diff, medadata, pos, did, keyeffecct);
                        }
                    }
                }
            }
        }
        return true;
    }

    public static Pos getGOPos(String text) {
        if (doorPos.containsKey(text)) {
            return doorPos.get(text);
        }
        int size = doorPos.size();
        Pos target = new Pos(size % 10 * 500, 0, size / 10 * 500);
        doorPos.put(text, target);
        return target;
    }

    public void move(World world, int x, int y, int z, EntityPlayerMP player, TileEntityInstanceDungeon tile, InstanceDungeonTPType gototype, IDungeonDifficult diff, int medadata, Pos goPos, int mainWorldID, EnchantmentsKeyEffect keyeffect) {
        if (player.field_71088_bW > 0) {
            return;
        }
        if (player.field_71093_bK != M3Config.WorldInstanceDungeonID) {
            player.field_71088_bW = 10;
            player.field_70165_t = goPos.X;
            player.field_70161_v = goPos.Z;
            player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, M3Config.WorldInstanceDungeonID, (Teleporter)new TeleporterInstanceDungeonPortal(player.field_71133_b.func_71218_a(M3Config.WorldInstanceDungeonID), tile.type, new Pos(tile), gototype, false, diff, medadata, DimensionManager.getWorld((int)0).func_82737_E(), tile, mainWorldID, keyeffect, tile.customname));
            InstanceDungeonType dungeontype = tile.type;
            for (int s = 0; s < M3StatList.LIST.size(); ++s) {
                StatBasicM3 stat = M3StatList.LIST.get(s);
                if (stat.tag == null || stat.tag != dungeontype) continue;
                M3StatList.addStat(player.field_70170_p, (EntityPlayer)player, (StatBase)stat, 1);
                break;
            }
            if (M3Config.DEBUG) {
                MMM.addMessage((EntityPlayer)player, "move dungeon , gototype : " + gototype.toString() + " , difficult : " + diff.toString() + " , type : " + tile.type.toString() + " , medadata : " + medadata + " , mainWorldID : " + mainWorldID);
            }
            return;
        }
        BlockInstanceDungeonPortal.clearDungeonlimitedItem((EntityPlayer)player);
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (root != null) {
            root.carrer.special_dungeon_resource = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            List<PotionEffectM3> list = PotionEffectM3.getPotions(root);
            for (int s = 0; s < list.size(); ++s) {
                if (PotionData.canLeaveDungeon(list.get((int)s).ID)) continue;
                list.remove(s);
                --s;
            }
        }
        if (!world.field_72995_K) {
            if (!tile.posMainWorld.isEmpty()) {
                player.field_70165_t = (float)tile.posMainWorld.X + 0.5f;
                player.field_70163_u = (float)tile.posMainWorld.Y + 0.5f;
                player.field_70161_v = (float)tile.posMainWorld.Z + 0.5f;
            } else {
                Pos pos = new Pos(DimensionManager.getWorld((int)mainWorldID).func_72861_E());
                player.field_70165_t = (float)pos.X + 0.5f;
                player.field_70163_u = (float)pos.Y + 0.5f;
                player.field_70161_v = (float)pos.Z + 0.5f;
                MMM.addMessage((EntityPlayer)player, "MMM.info.gomainworlderror");
            }
            this.transferPlayerToDimension(player, mainWorldID);
            player.field_71088_bW = 10;
        }
    }

    public void transferPlayerToDimension(EntityPlayerMP player, int worldID) {
        ServerConfigurationManager sc = player.field_71133_b.func_71203_ab();
        int did = player.field_71093_bK;
        WorldServer worldserver = player.field_71133_b.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = worldID;
        WorldServer worldserver1 = player.field_71133_b.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, worldserver1.field_73013_u, worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        this.transferEntityToWorld((Entity)player, did, worldserver, worldserver1);
        sc.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        sc.func_72354_b(player, worldserver1);
        sc.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, did, worldID);
    }

    public void transferEntityToWorld(Entity player, int did, WorldServer worldserver, WorldServer worldtarget) {
        WorldProvider pOld = worldserver.field_73011_w;
        WorldProvider pNew = worldtarget.field_73011_w;
        double moveFactor = 1.0;
        double d0 = player.field_70165_t * moveFactor;
        double d1 = player.field_70161_v * moveFactor;
        double d3 = player.field_70165_t;
        double d4 = player.field_70163_u;
        double d5 = player.field_70161_v;
        float f = player.field_70177_z;
        worldserver.field_72984_F.func_76320_a("moving");
        if (player.field_71093_bK == 1) {
            ChunkCoordinates chunkcoordinates = did == 1 ? worldtarget.func_72861_E() : worldtarget.func_73054_j();
            d0 = chunkcoordinates.field_71574_a;
            player.field_70163_u = chunkcoordinates.field_71572_b;
            d1 = chunkcoordinates.field_71573_c;
            player.func_70012_b(d0, player.field_70163_u, d1, 90.0f, 0.0f);
            if (player.func_70089_S()) {
                worldserver.func_72866_a(player, false);
            }
        }
        worldserver.field_72984_F.func_76319_b();
        if (did != 1) {
            worldserver.field_72984_F.func_76320_a("placing");
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            if (player.func_70089_S()) {
                player.func_70012_b(d0, player.field_70163_u, d1, player.field_70177_z, player.field_70125_A);
                worldtarget.func_72838_d(player);
                worldtarget.func_72866_a(player, false);
            }
            worldserver.field_72984_F.func_76319_b();
        }
        player.func_70029_a((World)worldtarget);
    }

    public static void clearDungeonlimitedItem(EntityPlayer player) {
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            if (player.field_71071_by.func_70301_a(s) == null || !(player.field_71071_by.func_70301_a(s).func_77973_b() instanceof ItemDungeonDedicated)) continue;
            player.field_71071_by.func_70299_a(s, null);
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        super.func_149689_a(world, x, y, z, player, item);
    }

    public TileEntity func_149915_a(World World2, int data) {
        return new TileEntityInstanceDungeon();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        for (int s = 0; s < 4; ++s) {
            float mx = (0.5f - rand.nextFloat()) / 4.0f;
            float my = (0.5f - rand.nextFloat()) / 4.0f;
            float mz = (0.5f - rand.nextFloat()) / 4.0f;
            FXHelp.spawnParticle(world, Particle.magic, (double)x + 0.5, y + 1, (double)z + 0.5, mx, my, mz, 0.8f, false);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int dx, int dy, int dz) {
        return null;
    }

    static {
        for (int s = 0; s < complete.length; ++s) {
            Schematic sh = new Schematic();
            BlockInstanceDungeonPortal.complete[s] = (sh = sh.loadSchematicFromJar("InstanceDungeon/" + InstanceDungeonType.values()[s].toString() + ".schematic")) != null;
        }
    }
}

