/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.archeology.ArcheologyCore;
import project.studio.manametalmod.archeology.TileEntityArcheology;
import project.studio.manametalmod.atlantis.AtlantisCore;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.chess.ChessCore;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.BlockData;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.WorldSaveDataMana;
import project.studio.manametalmod.decoration.Decoration;
import project.studio.manametalmod.dungeon.DungeonCore;
import project.studio.manametalmod.enchantmentskey.EnchantmentsKeyEffect;
import project.studio.manametalmod.furniture.FurnitureCore;
import project.studio.manametalmod.furniture.TileEntityFurniture;
import project.studio.manametalmod.instance_dungeon.BlockInstanceDungeonPortal;
import project.studio.manametalmod.instance_dungeon.DungeonBlockFunctionType;
import project.studio.manametalmod.instance_dungeon.DungeonChestType;
import project.studio.manametalmod.instance_dungeon.DungeonSpawnObject;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.IDungeonSpawnSpecialReplacement;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonTPType;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.TileEntityAutoTrap;
import project.studio.manametalmod.instance_dungeon.TileEntityDoorColor;
import project.studio.manametalmod.instance_dungeon.TileEntityDungeonChest;
import project.studio.manametalmod.instance_dungeon.TileEntityDungeonItem;
import project.studio.manametalmod.instance_dungeon.TileEntityDungeonstatue;
import project.studio.manametalmod.instance_dungeon.TileEntityGeneralDungeonObject;
import project.studio.manametalmod.instance_dungeon.TileEntityIncrease;
import project.studio.manametalmod.instance_dungeon.TileEntityInstanceDungeon;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeon;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeonCore;
import project.studio.manametalmod.loot.DungeonChestLoot;
import project.studio.manametalmod.newmc.NewMinecraftBlockReplace;
import project.studio.manametalmod.watergame.WaterGameCore;

public class TeleporterInstanceDungeonPortal
extends Teleporter {
    public final WorldServer field_85192_a;
    public final Random field_77187_a;
    public final LongHashMap field_85191_c = new LongHashMap();
    public final List field_85190_d = new ArrayList();
    public final InstanceDungeonType dungeon_type;
    public Pos pos_door = new Pos();
    public final InstanceDungeonTPType movetype;
    public final boolean isGoToMainWorld = false;
    IDungeonDifficult diff;
    int medadata;
    long mobuuid = -1L;
    public Pos posMainWorld = new Pos();
    TileEntityInstanceDungeon tile;
    public int mainWorldID = 0;
    public EnchantmentsKeyEffect keyeffect = null;
    public String customname;

    public TeleporterInstanceDungeonPortal(WorldServer par1WorldServer, InstanceDungeonType type, Pos pos, InstanceDungeonTPType movetype, boolean isGoToMainWorld, IDungeonDifficult diff, int medadata, long mobuuid, TileEntityInstanceDungeon tile, int mainWorldID, EnchantmentsKeyEffect keyeffect, String customname) {
        super(par1WorldServer);
        this.field_85192_a = par1WorldServer;
        this.field_77187_a = new Random(par1WorldServer.func_72905_C());
        this.dungeon_type = type;
        this.pos_door = pos.copy();
        this.movetype = movetype;
        this.diff = diff;
        this.medadata = medadata;
        this.mobuuid = mobuuid;
        this.tile = tile;
        this.posMainWorld = tile.posMainWorld.copy();
        this.mainWorldID = mainWorldID;
        this.keyeffect = keyeffect;
        this.customname = customname;
    }

    public Pos findNextPos() {
        return new Pos();
    }

    public void func_77185_a(Entity player, double x, double y, double z, float rotationYaw) {
        if (!this.func_77184_b(player, x, y, z, rotationYaw)) {
            this.func_85188_a(player);
            this.func_77184_b(player, x, y, z, rotationYaw);
        }
    }

    public boolean isLegalDoor(World world, int x, int y, int z) {
        TileEntity tile;
        return world.func_147439_a(x, y, z) == InstanceDungeonCore.InstanceDungeonPortal && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileEntityInstanceDungeon && ((TileEntityInstanceDungeon)tile).type == this.dungeon_type;
    }

    public boolean func_77184_b(Entity entityplayer, double posx, double posy, double posz, float rotationYaw) {
        double finalPosZ;
        int l3;
        int searchDistance = 16;
        double searchResults = -1.0;
        int tempX = 0;
        int tempY = 0;
        int tempZ = 0;
        boolean hasDoorID = true;
        int entityPosx = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
        int entityPosz = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
        long doorID = ChunkCoordIntPair.func_77272_a((int)entityPosx, (int)entityPosz);
        boolean islegal = false;
        if (this.field_85191_c.func_76161_b(doorID)) {
            MMM.Logg("use cache dungeon door pos ...");
            Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.field_85191_c.func_76164_a(doorID);
            searchResults = 0.0;
            tempX = portalposition.field_71574_a;
            tempY = portalposition.field_71572_b;
            tempZ = portalposition.field_71573_c;
            portalposition.field_85087_d = this.field_85192_a.func_82737_E();
            hasDoorID = false;
        } else {
            MMM.Logg("start search dungeon door pos ...");
            for (l3 = entityPosx - searchDistance; l3 <= entityPosx + searchDistance; ++l3) {
                double d4 = (double)l3 + 0.5 - entityplayer.field_70165_t;
                for (int l1 = entityPosz - searchDistance; l1 <= entityPosz + searchDistance; ++l1) {
                    double d5 = (double)l1 + 0.5 - entityplayer.field_70161_v;
                    for (int i2 = this.field_85192_a.func_72940_L() - 1; i2 >= 0; --i2) {
                        if (this.field_85192_a.func_147439_a(l3, i2, l1) != InstanceDungeonCore.InstanceDungeonPortal) continue;
                        islegal = this.isLegalDoor((World)this.field_85192_a, l3, i2, l1);
                        MMM.Logg("find dungeon door in ", l3, i2, l1, " is legal : " + islegal);
                        finalPosZ = (double)i2 + 0.5 - entityplayer.field_70163_u;
                        double d8 = d4 * d4 + finalPosZ * finalPosZ + d5 * d5;
                        if (!(searchResults < 0.0) && !(d8 < searchResults)) continue;
                        searchResults = d8;
                        tempX = l3;
                        tempY = i2;
                        tempZ = l1;
                    }
                }
            }
        }
        if (searchResults >= 0.0 && !islegal) {
            String name = "pos_" + this.tile.field_145851_c + "_" + this.tile.field_145848_d + "_" + this.tile.field_145849_e + "#" + this.mainWorldID;
            int size = BlockInstanceDungeonPortal.doorPos.size();
            Pos target = new Pos(size % 10 * -500, 0, size / 10 * -500);
            target.add(-500, 0, -500);
            BlockInstanceDungeonPortal.doorPos.put(name, target);
            MMM.Logg(this.pos_door, " has error , player " + entityplayer.func_70005_c_() + " go to a illegal dungeon , now specify new dungeon pos to", target);
        }
        if (searchResults >= 0.0) {
            WorldSaveDataMana data;
            int dz;
            int dy;
            int dx;
            if (hasDoorID) {
                this.field_85191_c.func_76163_a(doorID, (Object)new Teleporter.PortalPosition((Teleporter)this, tempX, tempY, tempZ, this.field_85192_a.func_82737_E()));
                this.field_85190_d.add(doorID);
            }
            double finalPosX = (double)tempX + 0.5;
            double finalPosY = (double)tempY + 0.5;
            finalPosZ = (double)tempZ + 0.5;
            int doorSide = -1;
            if (this.field_85192_a.func_147439_a(tempX - 1, tempY, tempZ) == InstanceDungeonCore.InstanceDungeonPortal) {
                doorSide = 2;
            }
            if (this.field_85192_a.func_147439_a(tempX + 1, tempY, tempZ) == InstanceDungeonCore.InstanceDungeonPortal) {
                doorSide = 0;
            }
            if (this.field_85192_a.func_147439_a(tempX, tempY, tempZ - 1) == InstanceDungeonCore.InstanceDungeonPortal) {
                doorSide = 3;
            }
            if (this.field_85192_a.func_147439_a(tempX, tempY, tempZ + 1) == InstanceDungeonCore.InstanceDungeonPortal) {
                doorSide = 1;
            }
            int j2 = entityplayer.func_82148_at();
            if (doorSide > -1) {
                boolean flag2;
                int l2 = Direction.field_71583_a[doorSide];
                int k2 = Direction.field_71578_g[doorSide];
                int j3 = Direction.field_71583_a[k2];
                int i3 = Direction.field_71581_b[doorSide];
                int k3 = Direction.field_71581_b[k2];
                boolean flag1 = !this.field_85192_a.func_147437_c(tempX + l2 + j3, tempY, tempZ + i3 + k3) || !this.field_85192_a.func_147437_c(tempX + l2 + j3, tempY + 1, tempZ + i3 + k3);
                boolean bl = flag2 = !this.field_85192_a.func_147437_c(tempX + l2, tempY, tempZ + i3) || !this.field_85192_a.func_147437_c(tempX + l2, tempY + 1, tempZ + i3);
                if (flag1 && flag2) {
                    doorSide = Direction.field_71580_e[doorSide];
                    k2 = Direction.field_71580_e[k2];
                    l2 = Direction.field_71583_a[doorSide];
                    i3 = Direction.field_71581_b[doorSide];
                    j3 = Direction.field_71583_a[k2];
                    k3 = Direction.field_71581_b[k2];
                    l3 = tempX - j3;
                    finalPosX -= (double)j3;
                    int k1 = tempZ - k3;
                    finalPosZ -= (double)k3;
                    flag1 = !this.field_85192_a.func_147437_c(l3 + l2 + j3, tempY, k1 + i3 + k3) || !this.field_85192_a.func_147437_c(l3 + l2 + j3, tempY + 1, k1 + i3 + k3);
                    flag2 = !this.field_85192_a.func_147437_c(l3 + l2, tempY, k1 + i3) || !this.field_85192_a.func_147437_c(l3 + l2, tempY + 1, k1 + i3);
                }
                float f1 = 0.5f;
                float f2 = 0.5f;
                if (!flag1 && flag2) {
                    f1 = 1.0f;
                } else if (flag1 && !flag2) {
                    f1 = 0.0f;
                } else if (flag1 && flag2) {
                    f2 = 0.0f;
                }
                finalPosX += (double)((float)j3 * f1 + f2 * (float)l2);
                finalPosZ += (double)((float)k3 * f1 + f2 * (float)i3);
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (doorSide == j2) {
                    f3 = 1.0f;
                    f4 = 1.0f;
                } else if (doorSide == Direction.field_71580_e[j2]) {
                    f3 = -1.0f;
                    f4 = -1.0f;
                } else if (doorSide == Direction.field_71577_f[j2]) {
                    f5 = 1.0f;
                    f6 = -1.0f;
                } else {
                    f5 = -1.0f;
                    f6 = 1.0f;
                }
                double d9 = entityplayer.field_70159_w;
                double d10 = entityplayer.field_70179_y;
                entityplayer.field_70159_w = d9 * (double)f3 + d10 * (double)f6;
                entityplayer.field_70179_y = d9 * (double)f5 + d10 * (double)f4;
                entityplayer.field_70177_z = rotationYaw - (float)(j2 * 90) + (float)(doorSide * 90);
            } else {
                entityplayer.field_70179_y = 0.0;
                entityplayer.field_70181_x = 0.0;
                entityplayer.field_70159_w = 0.0;
            }
            entityplayer.func_70012_b(finalPosX, finalPosY, finalPosZ, entityplayer.field_70177_z, entityplayer.field_70125_A);
            EntityPlayer player = (EntityPlayer)entityplayer;
            ChunkCoordinates chunkcoordinates = player.func_82114_b();
            chunkcoordinates.func_71571_b(chunkcoordinates.field_71574_a + 1, chunkcoordinates.field_71572_b, chunkcoordinates.field_71573_c);
            player.setSpawnChunk(chunkcoordinates, true, M3Config.WorldInstanceDungeonID);
            if (this.movetype == InstanceDungeonTPType.Refresh) {
                NBTTagCompound tag;
                WorldSaveDataMana data2 = MMM.getWorldData((World)DimensionManager.getWorld((int)0));
                if (data2.getInstanceDungeonData().func_150297_b(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), 10)) {
                    tag = data2.getInstanceDungeonData().func_74775_l(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID));
                    tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
                    data2.func_76185_a();
                } else {
                    MMM.Logg("dungeon " + this.pos_door.toString() + " DID : " + this.mainWorldID + " has dungeon building but don't has save data! , now generate save data ...");
                    tag = new NBTTagCompound();
                    tag.func_74768_a("x", this.pos_door.X);
                    tag.func_74768_a("y", this.pos_door.Y);
                    tag.func_74768_a("z", this.pos_door.Z);
                    tag.func_74768_a("type", this.dungeon_type.ordinal());
                    tag.func_74778_a("name", this.dungeon_type.toString());
                    tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
                    tag.func_74768_a("mainWorldID", this.mainWorldID);
                    data2.getInstanceDungeonData().func_74782_a(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), (NBTBase)tag);
                    data2.func_76185_a();
                }
                dx = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                dy = 100;
                dz = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                MMM.Logg(new Object[]{"spawn dungeon repeat ", dx, 100, dz, this.dungeon_type});
                Pos postemp = this.dungeon_type.getPosOffset(this.customname);
                int sx = dx - postemp.X;
                int sy = 100 - postemp.Y;
                int sz = dz - postemp.Z;
                DungeonSpawnObject DSO = new DungeonSpawnObject();
                DSO.name = "InstanceDungeon/" + this.dungeon_type.toString() + ".schematic";
                DSO.type = this.dungeon_type;
                DSO.diff = this.diff;
                DSO.mobuuid = this.mobuuid;
                DSO.keyeffect = this.keyeffect;
                DSO.needLV = this.dungeon_type.getNeedLV(this.customname);
                this.spawnDungeon((World)this.field_85192_a, sx, sy, sz, false, DSO, this.customname);
                MMM.Logg("dungeon refresh success in " + this.pos_door + " DID : " + this.mainWorldID + " , now time " + DimensionManager.getWorld((int)0).func_82737_E() + " , refresh player : " + player.func_70005_c_());
            }
            if (this.movetype == InstanceDungeonTPType.UpDate) {
                NBTTagCompound tag;
                WorldSaveDataMana data3 = MMM.getWorldData((World)DimensionManager.getWorld((int)0));
                if (data3.getInstanceDungeonData().func_150297_b(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), 10)) {
                    tag = data3.getInstanceDungeonData().func_74775_l(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID));
                    tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
                    data3.func_76185_a();
                } else {
                    MMM.Logg("dungeon " + this.pos_door.toString() + " DID : " + this.mainWorldID + " has dungeon building but don't has save data! , now generate save data ...");
                    tag = new NBTTagCompound();
                    tag.func_74768_a("x", this.pos_door.X);
                    tag.func_74768_a("y", this.pos_door.Y);
                    tag.func_74768_a("z", this.pos_door.Z);
                    tag.func_74768_a("type", this.dungeon_type.ordinal());
                    tag.func_74778_a("name", this.dungeon_type.toString());
                    tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
                    tag.func_74768_a("mainWorldID", this.mainWorldID);
                    data3.getInstanceDungeonData().func_74782_a(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), (NBTBase)tag);
                    data3.func_76185_a();
                }
                dx = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                dy = 100;
                dz = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                MMM.Logg(new Object[]{"spawn dungeon debug up date ", dx, 100, dz, this.dungeon_type});
                Pos postemp = this.dungeon_type.getPosOffset(this.customname);
                int sx = dx - postemp.X;
                int sy = 100 - postemp.Y;
                int sz = dz - postemp.Z;
                DungeonSpawnObject DSO = new DungeonSpawnObject();
                DSO.name = "InstanceDungeon/" + this.dungeon_type.toString() + ".schematic";
                DSO.type = this.dungeon_type;
                DSO.diff = this.diff;
                DSO.mobuuid = this.mobuuid;
                DSO.keyeffect = this.keyeffect;
                DSO.needLV = this.dungeon_type.getNeedLV(this.customname);
                this.spawnDungeon((World)this.field_85192_a, sx, sy, sz, true, DSO, this.customname);
                MMM.Logg("dungeon refresh success in " + this.pos_door + " DID : " + this.mainWorldID + " , now time " + DimensionManager.getWorld((int)0).func_82737_E() + " , refresh player : " + player.func_70005_c_());
            }
            if (this.movetype == InstanceDungeonTPType.NotYet && !(data = MMM.getWorldData((World)DimensionManager.getWorld((int)0))).getInstanceDungeonData().func_150297_b(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), 10)) {
                MMM.Logg("dungeon " + this.pos_door.toString() + " DID : " + this.mainWorldID + " has dungeon building but don't has save data! , now generate save data ...");
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", this.pos_door.X);
                tag.func_74768_a("y", this.pos_door.Y);
                tag.func_74768_a("z", this.pos_door.Z);
                tag.func_74768_a("type", this.dungeon_type.ordinal());
                tag.func_74778_a("name", this.dungeon_type.toString());
                tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
                tag.func_74768_a("mainWorldID", this.mainWorldID);
                data.getInstanceDungeonData().func_74782_a(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), (NBTBase)tag);
                data.func_76185_a();
            }
            if (this.movetype == InstanceDungeonTPType.FirstTime && !(data = MMM.getWorldData((World)DimensionManager.getWorld((int)0))).getInstanceDungeonData().func_150297_b(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), 10)) {
                MMM.Logg("dungeon " + this.pos_door.toString() + " DID : " + this.mainWorldID + " has dungeon building but don't has save data! , now generate save data ...");
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", this.pos_door.X);
                tag.func_74768_a("y", this.pos_door.Y);
                tag.func_74768_a("z", this.pos_door.Z);
                tag.func_74768_a("type", this.dungeon_type.ordinal());
                tag.func_74778_a("name", this.dungeon_type.toString());
                tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
                tag.func_74768_a("mainWorldID", this.mainWorldID);
                data.getInstanceDungeonData().func_74782_a(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), (NBTBase)tag);
                data.func_76185_a();
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int dx = MathHelper.func_76128_c((double)entity.field_70165_t);
        int dy = 100;
        int dz = MathHelper.func_76128_c((double)entity.field_70161_v);
        this.field_85192_a.func_147465_d(dx, 100, dz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                this.field_85192_a.func_147465_d(dx + x, 99, dz + z, (Block)Blocks.field_150349_c, 0, 2);
            }
        }
        EntityPlayer player = (EntityPlayer)entity;
        ChunkCoordinates chunkcoordinates = new ChunkCoordinates();
        chunkcoordinates.func_71571_b(chunkcoordinates.field_71574_a + 1, chunkcoordinates.field_71572_b, chunkcoordinates.field_71573_c);
        player.setSpawnChunk(chunkcoordinates, true, M3Config.WorldInstanceDungeonID);
        WorldSaveDataMana data = MMM.getWorldData((World)DimensionManager.getWorld((int)0));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", this.pos_door.X);
        tag.func_74768_a("y", this.pos_door.Y);
        tag.func_74768_a("z", this.pos_door.Z);
        tag.func_74768_a("type", this.dungeon_type.ordinal());
        tag.func_74778_a("name", this.dungeon_type.toString());
        tag.func_74772_a("time", DimensionManager.getWorld((int)0).func_82737_E());
        tag.func_74768_a("mainWorldID", this.mainWorldID);
        data.getInstanceDungeonData().func_74782_a(InstanceDungeonCore.getSaveDataName(this.pos_door, this.mainWorldID), (NBTBase)tag);
        data.func_76185_a();
        MMM.Logg(new Object[]{"first spawn : ", dx, 100, dz, this.dungeon_type, " customname : " + this.customname});
        Pos postemp = this.dungeon_type.getPosOffset(this.customname);
        int sx = dx - postemp.X;
        int sy = 100 - postemp.Y;
        int sz = dz - postemp.Z;
        DungeonSpawnObject DSO = new DungeonSpawnObject();
        DSO.name = "InstanceDungeon/" + this.dungeon_type.toString() + ".schematic";
        DSO.type = this.dungeon_type;
        DSO.diff = this.diff;
        DSO.mobuuid = this.mobuuid;
        DSO.keyeffect = this.keyeffect;
        DSO.needLV = this.dungeon_type.getNeedLV(this.customname);
        this.spawnDungeon((World)this.field_85192_a, sx, sy, sz, true, DSO, this.customname);
        return true;
    }

    public void func_85189_a(long par1) {
        if (par1 % 100L == 0L) {
            Iterator iterator = this.field_85190_d.iterator();
            long j = par1 - 600L;
            while (iterator.hasNext()) {
                Long olong = (Long)iterator.next();
                Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.field_85191_c.func_76164_a(olong.longValue());
                if (portalposition != null && portalposition.field_85087_d >= j) continue;
                iterator.remove();
                this.field_85191_c.func_76159_d(olong.longValue());
            }
        }
    }

    public void spawnDungeon(World world, int bx, int by, int bz, boolean baseBlock, DungeonSpawnObject obj, String customname) {
        Schematic sh = new Schematic();
        if (obj.type == InstanceDungeonType.Custom && customname != null) {
            CustomDungeon CD = CustomDungeonCore.get(customname);
            if (CD != null) {
                if (CD.spawnType.equals("IDungeon")) {
                    sh = sh.loanIDungeonFromComponents(customname);
                }
                if (CD.spawnType.equals("schematic")) {
                    sh = sh.loadSchematicFromComponents(customname);
                }
            }
        } else {
            sh = sh.loadSchematicFromJar(obj.name);
        }
        if (sh != null) {
            int blockCount = sh.height * sh.length * sh.width / 10;
            int spawnCount = 0;
            boolean step = true;
            Block blocktemp = null;
            int idtemp = 0;
            int metadata = 0;
            int tx = 0;
            int ty = 0;
            int tz = 0;
            ArrayList<Pos> boxlist = new ArrayList<Pos>();
            BlockData BDT = new BlockData(Blocks.field_150348_b, 0);
            for (int sy = 0; sy < sh.height; ++sy) {
                for (int sz = 0; sz < sh.length; ++sz) {
                    for (int sx = 0; sx < sh.width; ++sx) {
                        TileEntityFlowerPot pot;
                        TileEntityDungeonChest box;
                        DungeonChestType type;
                        TileEntity tile;
                        blocktemp = null;
                        idtemp = Schematic.getBlocksIDFormNegative(sh.blocks[spawnCount]);
                        metadata = sh.data[spawnCount];
                        tx = bx + sx;
                        ty = by + sy;
                        tz = bz + sz;
                        if (baseBlock && NewMinecraftBlockReplace.getReplaceBlock(idtemp, metadata, BDT)) {
                            blocktemp = BDT.block;
                            metadata = BDT.blockMetadata;
                        }
                        if (blocktemp == null) {
                            blocktemp = Block.func_149729_e((int)idtemp);
                        }
                        if (blocktemp == Blocks.field_150335_W) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                            tile = new TileEntityInstanceDungeon(this.dungeon_type);
                            tile.customname = customname;
                            tile.blocktype = 1;
                            Pos postemp = this.dungeon_type.getPosOffset(this.customname);
                            tile.pos = new Pos(bx + postemp.X, by + postemp.Y + 1, bz + postemp.Z);
                            world.func_147455_a(tx, ty, tz, tile);
                            world.func_72921_c(tx, ty, tz, 0, 2);
                        } else if (blocktemp == Blocks.field_150360_v) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                            tile = new TileEntityInstanceDungeon(this.dungeon_type);
                            tile.customname = customname;
                            MMM.Logg("set spawn point ", this.posMainWorld.toString());
                            tile.posMainWorld = this.posMainWorld.copy();
                            tile.blocktype = 0;
                            tile.mainWorldID = this.mainWorldID;
                            world.func_147455_a(tx, ty, tz, tile);
                            world.func_72921_c(tx, ty, tz, 0, 2);
                        } else if (blocktemp == Blocks.field_150380_bt) {
                            this.setDungeonBlock(world, tx, ty, tz, 15, DungeonBlockFunctionType.AntiJump, obj.type, obj.diff, 15, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150339_S) {
                            this.setDungeonBlock(world, tx, ty, tz, 3, DungeonBlockFunctionType.SpawnMonster, obj.type, obj.diff, 3, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150340_R) {
                            this.setDungeonBlock(world, tx, ty, tz, 4, DungeonBlockFunctionType.SpawnElite, obj.type, obj.diff, 4, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150484_ah) {
                            this.setDungeonBlock(world, tx, ty, tz, 5, DungeonBlockFunctionType.SpawnBoss, obj.type, obj.diff, 5, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150440_ba) {
                            type = DungeonChestLoot.getChestType(this.dungeon_type, this.diff, this.field_77187_a, this.keyeffect, false, obj.needLV);
                            world.func_147465_d(tx, ty, tz, DungeonChestLoot.getBlock(type), 0, 2);
                            box = new TileEntityDungeonChest();
                            DungeonChestLoot.loot(box, this.dungeon_type, this.diff, type, world.field_73012_v, 1.0f, customname, this.keyeffect);
                            world.func_147455_a(tx, ty, tz, (TileEntity)box);
                            boxlist.add(new Pos(tx, ty, tz));
                        } else if (blocktemp == Blocks.field_150475_bE) {
                            type = DungeonChestLoot.getChestType(this.dungeon_type, this.diff, this.field_77187_a, this.keyeffect, true, obj.needLV);
                            world.func_147465_d(tx, ty, tz, DungeonChestLoot.getBlock(type), 0, 2);
                            box = new TileEntityDungeonChest();
                            DungeonChestLoot.loot(box, this.dungeon_type, this.diff, type, world.field_73012_v, 1.0f, customname, this.keyeffect);
                            world.func_147455_a(tx, ty, tz, (TileEntity)box);
                            boxlist.add(new Pos(tx, ty, tz));
                        } else if (blocktemp == Blocks.field_150357_h) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.Medical, obj.type, obj.diff, 0, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150353_l) {
                            world.func_147465_d(tx, ty, tz, DungeonCore.LavaTrap, 0, 2);
                        } else if (blocktemp == Blocks.field_150480_ab) {
                            world.func_147465_d(tx, ty, tz, DungeonCore.fireTrap1, 0, 2);
                        } else if (blocktemp == Blocks.field_150449_bY) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.Door, obj.type, obj.diff, sh.data[spawnCount], obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonKeyDoor, true, customname);
                        } else if (blocktemp == Blocks.field_150482_ag) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.KeyTable, obj.type, obj.diff, 0, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonKey, true, customname);
                        } else if (blocktemp == Blocks.field_150367_z && metadata != 15) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.UpTeleport, obj.type, obj.diff, 6, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150367_z && metadata == 15) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.DungeonTeleport, obj.type, obj.diff, 6, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150409_cd) {
                            this.setDungeonBlock(world, tx, ty, tz, 7, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 7, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150354_m && obj.type == InstanceDungeonType.SkyTower) {
                            this.setDungeonBlock(world, tx, ty, tz, 12, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 12, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150412_bA) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.BlockDarkDoors, (int)sh.data[spawnCount], 2);
                        } else if (blocktemp == Blocks.field_150483_bI) {
                            this.setDungeonBlock(world, tx, ty, tz, 9, DungeonBlockFunctionType.SpwanSpecial, obj.type, obj.diff, 9, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150421_aI) {
                            this.setDungeonBlock(world, tx, ty, tz, 8, DungeonBlockFunctionType.SpawnLoop, obj.type, obj.diff, 8, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150438_bZ) {
                            this.setAutoTrap(InstanceDungeonCore.BlockTrapAutoSpikess, world, tx, ty, tz, 1, obj.type, obj.diff, 0);
                        } else if (blocktemp == Blocks.field_150378_br) {
                            this.setAutoTrap(InstanceDungeonCore.BlockTrapAutoFires, world, tx, ty, tz, 2, obj.type, obj.diff, 0);
                        } else if (blocktemp == Blocks.field_150460_al) {
                            this.setAutoTrap(InstanceDungeonCore.BlockTrapAutoArrows, world, tx, ty, tz, 0, obj.type, obj.diff, sh.data[spawnCount]);
                        } else if (blocktemp == Blocks.field_150470_am) {
                            this.setAutoTrap(InstanceDungeonCore.BlockTrapAutoArrowPotions, world, tx, ty, tz, 3, obj.type, obj.diff, sh.data[spawnCount]);
                        } else if (blocktemp == Blocks.field_150418_aU && sh.data[spawnCount] == 0) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150340_R, (int)sh.data[spawnCount], 2);
                        } else if (blocktemp == Blocks.field_150418_aU && sh.data[spawnCount] == 1) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150350_a, (int)sh.data[spawnCount], 2);
                        } else if (blocktemp == Blocks.field_150418_aU && sh.data[spawnCount] == 4) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.ReSpawnPoint, obj.type, obj.diff, 10, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150477_bB) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.BlockColorDoor, (int)sh.data[spawnCount], 2);
                            tile = new TileEntityDoorColor();
                            tile.uuid = obj.mobuuid;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150323_B) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.BlockDungeonstatues, (int)sh.data[spawnCount], 2);
                            tile = new TileEntityDungeonstatue();
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150382_bo) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.BlockColorKeyDoor, (int)sh.data[spawnCount], 2);
                            tile = new TileEntityDoorColor();
                            tile.uuid = obj.mobuuid;
                            tile.type = obj.type;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150461_bJ && obj.type == InstanceDungeonType.WolfPalace) {
                            this.setDungeonBlock(world, tx, ty, tz, 12, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 12, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150461_bJ && obj.type == InstanceDungeonType.DarkDungeon) {
                            this.setDungeonBlock(world, tx, ty, tz, 12, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 12, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (obj.type == InstanceDungeonType.BlackCastle && blocktemp == Blocks.field_150354_m) {
                            world.func_147465_d(tx, ty, tz, FurnitureCore.BlockFurnitureBases, 0, 2);
                            tile = new TileEntityFurniture();
                            tile.type = 130;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150461_bJ && obj.type == InstanceDungeonType.BlackCastle) {
                            this.setDungeonBlock(world, tx, ty, tz, 12, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 12, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150461_bJ && obj.type == InstanceDungeonType.TheHeroTemple) {
                            this.setDungeonBlock(world, tx, ty, tz, sh.data[spawnCount], DungeonBlockFunctionType.HolySpirit, obj.type, obj.diff, sh.data[spawnCount], obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonSummon2, true, customname);
                        } else if (blocktemp == Blocks.field_150425_aM && sh.data[spawnCount] == 0 && obj.type == InstanceDungeonType.TheHeroTemple) {
                            world.func_147465_d(tx, ty, tz, (Block)ChessCore.BlcokChessAI, 0, 2);
                        } else if (blocktemp == Blocks.field_150425_aM && sh.data[spawnCount] == 1 && obj.type == InstanceDungeonType.TheHeroTemple) {
                            world.func_147465_d(tx, ty, tz, WaterGameCore.watergamecore, 2, 2);
                        } else if (blocktemp == Blocks.field_150457_bL && obj.type == InstanceDungeonType.WhiteDragonTemple) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150457_bL, 3, 2);
                            pot = (TileEntityFlowerPot)world.func_147438_o(tx, ty, tz);
                            pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 3);
                        } else if (blocktemp == Blocks.field_150457_bL && obj.type == InstanceDungeonType.WhiteStonePalace) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150457_bL, 3, 2);
                            pot = (TileEntityFlowerPot)world.func_147438_o(tx, ty, tz);
                            pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 3);
                        } else if (blocktemp == Blocks.field_150457_bL && obj.type == InstanceDungeonType.DragonDoor) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150457_bL, 3, 2);
                            pot = (TileEntityFlowerPot)world.func_147438_o(tx, ty, tz);
                            pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 3);
                        } else if (blocktemp == Blocks.field_150457_bL && obj.type == InstanceDungeonType.TrialTower) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150457_bL, 3, 2);
                            pot = (TileEntityFlowerPot)world.func_147438_o(tx, ty, tz);
                            pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 3);
                        } else if ((blocktemp == Blocks.field_150351_n || blocktemp == Blocks.field_150344_f) && obj.type == InstanceDungeonType.TrialTower) {
                            world.func_147465_d(tx, ty, tz, Blocks.field_150350_a, 0, 2);
                        } else if (blocktemp == Blocks.field_150354_m && obj.type == InstanceDungeonType.TrialTower) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.BlockGeneralDungeonObjects, 0, 2);
                            tile = new TileEntityGeneralDungeonObject();
                            tile.type = 0;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150321_G && obj.type == InstanceDungeonType.TrialTower) {
                            this.setDungeonBlock(world, tx, ty, tz, 12, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 12, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150354_m && (obj.type == InstanceDungeonType.GiantMaze || obj.type == InstanceDungeonType.FourSeasonsTemple)) {
                            world.func_147465_d(tx, ty, tz, InstanceDungeonCore.BlockIncreases, 1, 2);
                            tile = new TileEntityIncrease();
                            tile.diff = obj.diff;
                            tile.DungeonType = obj.type;
                            tile.mobuuid = obj.mobuuid;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150432_aD && obj.type == InstanceDungeonType.WhiteDragonTemple) {
                            this.setDungeonBlock(world, tx, ty, tz, 9, DungeonBlockFunctionType.SpwanSpecial, obj.type, obj.diff, 9, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150354_m && obj.type == InstanceDungeonType.RoseGarden) {
                            this.setDungeonBlock(world, tx, ty, tz, 12, DungeonBlockFunctionType.BossSummon, obj.type, obj.diff, 12, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150462_ai && obj.type == InstanceDungeonType.RoseGarden) {
                            this.setDungeonBlock(world, tx, ty, tz, 16, DungeonBlockFunctionType.WeaponSpawn, obj.type, obj.diff, 9, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150423_aK && obj.type == InstanceDungeonType.RoseGarden) {
                            this.setDungeonBlock(world, tx, ty, tz, 16, DungeonBlockFunctionType.WeaponSpawn, obj.type, obj.diff, 9, obj.mobuuid, 1, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150426_aN && obj.type == InstanceDungeonType.RoseGarden) {
                            world.func_147465_d(tx, ty, tz, Decoration.BlockDungeonRotate36, metadata, 2);
                        } else if (blocktemp == Blocks.field_150425_aM && obj.type == InstanceDungeonType.RoseGarden) {
                            world.func_147465_d(tx, ty, tz, Decoration.BlockDungeonRotate37, metadata, 2);
                        } else if (blocktemp == Blocks.field_150342_X && obj.type == InstanceDungeonType.DragonDoor) {
                            world.func_147465_d(tx, ty, tz, AtlantisCore.atlantis_block_0, 4, 2);
                        } else if (blocktemp == Blocks.field_150407_cf && obj.type == InstanceDungeonType.DragonDoor) {
                            world.func_147465_d(tx, ty, tz, AtlantisCore.atlantis_block_0, 12, 2);
                        } else if (blocktemp == Blocks.field_150364_r && metadata == 3 && obj.type == InstanceDungeonType.DragonDoor) {
                            this.setDungeonBlock(world, tx, ty, tz, 0, DungeonBlockFunctionType.AtlantisCrystal, obj.type, obj.diff, 0, obj.mobuuid, 0, 0, 0, InstanceDungeonCore.BlockDungeonItem, true, customname);
                        } else if (blocktemp == Blocks.field_150445_bS) {
                            world.func_147465_d(tx, ty, tz, ArcheologyCore.BlockArcheologys, 0, 2);
                            tile = new TileEntityArcheology();
                            tile.diff = obj.diff;
                            tile.DungeonType = obj.type;
                            tile.advanced = true;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150443_bT) {
                            if (world.field_73012_v.nextInt(100) < (obj.diff.ordinal() + 1) * 4) {
                                world.func_147465_d(tx, ty, tz, ArcheologyCore.BlockArcheologys, 0, 2);
                                tile = new TileEntityArcheology();
                                tile.diff = obj.diff;
                                tile.DungeonType = obj.type;
                                tile.advanced = false;
                                world.func_147455_a(tx, ty, tz, tile);
                            } else {
                                world.func_147465_d(tx, ty, tz, Blocks.field_150350_a, 0, 2);
                            }
                        } else if (blocktemp == Blocks.field_150418_aU && sh.data[spawnCount] == 2) {
                            world.func_147465_d(tx, ty, tz, ArcheologyCore.BlockArcheologyDoors, 1, 2);
                            tile = new TileEntityDungeonItem();
                            tile.diff = obj.diff;
                            tile.DungeonType = obj.type;
                            tile.mobuuid = obj.mobuuid;
                            tile.customname = customname;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (blocktemp == Blocks.field_150418_aU && sh.data[spawnCount] == 3) {
                            world.func_147465_d(tx, ty, tz, ArcheologyCore.BlockArcheologyDoors, 0, 2);
                            tile = new TileEntityDungeonItem();
                            tile.diff = obj.diff;
                            tile.DungeonType = obj.type;
                            tile.mobuuid = obj.mobuuid;
                            tile.customname = customname;
                            world.func_147455_a(tx, ty, tz, tile);
                        } else if (baseBlock && blocktemp != Blocks.field_150350_a) {
                            BlockData data = IDungeonSpawnSpecialReplacement.doSpecialReplacement(world, obj.type, blocktemp, metadata, idtemp);
                            if (!world.func_147465_d(tx, ty, tz, data.block, data.blockMetadata, 2)) {
                                MMM.Logg("[ERROR] can't spawn block " + data.block.getClass().getName());
                            }
                        }
                        ++spawnCount;
                    }
                }
            }
            for (int s = 0; s < boxlist.size(); ++s) {
                Pos postemp = (Pos)boxlist.get(s);
                if (world.func_147439_a(postemp.X + 1, postemp.Y, postemp.Z) == Blocks.field_150350_a) {
                    world.func_72921_c(postemp.X, postemp.Y, postemp.Z, 1, 2);
                    continue;
                }
                if (world.func_147439_a(postemp.X, postemp.Y, postemp.Z + 1) == Blocks.field_150350_a) {
                    world.func_72921_c(postemp.X, postemp.Y, postemp.Z, 2, 2);
                    continue;
                }
                if (world.func_147439_a(postemp.X - 1, postemp.Y, postemp.Z) == Blocks.field_150350_a) {
                    world.func_72921_c(postemp.X, postemp.Y, postemp.Z, 3, 2);
                    continue;
                }
                if (world.func_147439_a(postemp.X, postemp.Y, postemp.Z - 1) != Blocks.field_150350_a) continue;
                world.func_72921_c(postemp.X, postemp.Y, postemp.Z, 0, 2);
            }
        } else {
            world.func_147465_d(bx, by, bz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
            TileEntityInstanceDungeon tile = new TileEntityInstanceDungeon(this.dungeon_type);
            tile.customname = customname;
            MMM.Logg("set spawn point ", this.posMainWorld.toString());
            tile.posMainWorld = this.posMainWorld.copy();
            tile.blocktype = 0;
            tile.mainWorldID = this.mainWorldID;
            world.func_147455_a(bx + 1, by, bz + 1, (TileEntity)tile);
            world.func_72921_c(bx, by, bz, 0, 2);
        }
    }

    public void setAutoTrap(Block block, World world, int x, int y, int z, int type, InstanceDungeonType typed, IDungeonDifficult diff, int medadata) {
        world.func_147465_d(x, y, z, block, medadata, 2);
        TileEntityAutoTrap tile = new TileEntityAutoTrap();
        tile.type = type;
        tile.diff = diff;
        tile.DungeonType = typed;
        tile.waittime = 50 + (10 - world.field_73012_v.nextInt(21));
        world.func_147455_a(x, y, z, (TileEntity)tile);
    }

    public void setDungeonBlock(World world, int x, int y, int z, int type, DungeonBlockFunctionType DBFT, InstanceDungeonType typed, IDungeonDifficult diff, int medadata, long mobuuid, int data1, int data2, int data3, Block block, boolean tileentity, String customname) {
        world.func_147465_d(x, y, z, block, medadata, 2);
        if (tileentity) {
            TileEntityDungeonItem tile = new TileEntityDungeonItem();
            tile.setDiff(diff);
            tile.setDungeonType(typed);
            tile.setType(type);
            tile.setMobuuid(mobuuid);
            tile.data1 = data1;
            tile.data2 = data2;
            tile.data3 = data3;
            tile.keyeffect = this.keyeffect != null ? EnchantmentsKeyEffect.clone(this.keyeffect) : null;
            tile.customname = customname;
            tile.DBFT = DBFT;
            world.func_147455_a(x, y, z, (TileEntity)tile);
        }
    }
}

