/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.items.ItemBase;

public class ItemToolBuildingWand
extends ItemBase {
    public static final int amount = 9;

    public ItemToolBuildingWand() {
        super("ItemToolBuildingWand");
        this.func_77637_a(ManaMetalMod.tab_Magic);
        this.func_77655_b("ItemToolBuildingWand");
        this.func_111206_d("manametalmod:ItemToolBuildingWand");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        if (!world.field_72995_K) {
            ItemToolBuildingWand.placeBlock(stack, player, world, x, y, z, side);
        }
        return true;
    }

    public static boolean checkUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        return MMM.isPlayerCreativeMode(player) || MMM.removePlayerMana(player, 50);
    }

    public boolean hasItem(ItemStack item, EntityPlayer player) {
        if (MMM.isPlayerCreativeMode(player)) {
            return true;
        }
        return ItemToolBuildingWand.clearItems(item, player);
    }

    public static boolean consumeInventoryItem(Item item, int meta, InventoryPlayer inv, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int i = ItemToolBuildingWand.finditem(item, meta, inv);
        if (i < 0) {
            return false;
        }
        if (--inv.field_70462_a[i].field_77994_a <= 0) {
            inv.field_70462_a[i] = null;
        }
        return true;
    }

    public static int finditem(Item item, int meta, InventoryPlayer inv) {
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null || inv.field_70462_a[i].func_77973_b() != item || meta != inv.field_70462_a[i].func_77960_j()) continue;
            return i;
        }
        return -1;
    }

    public static final boolean clearItems(ItemStack target, EntityPlayer player) {
        int need = target.field_77994_a;
        for (int b = 0; b < player.field_71071_by.func_70302_i_(); ++b) {
            if (player.field_71071_by.func_70301_a(b) != null && MMM.isItemStackEqual(player.field_71071_by.func_70301_a(b), target)) {
                if (player.field_71071_by.func_70301_a((int)b).field_77994_a > need) {
                    player.field_71071_by.func_70301_a((int)b).field_77994_a -= need;
                    return true;
                }
                if (player.field_71071_by.func_70301_a((int)b).field_77994_a == need) {
                    player.field_71071_by.func_70299_a(b, null);
                    return true;
                }
                if (player.field_71071_by.func_70301_a((int)b).field_77994_a < need) {
                    need -= player.field_71071_by.func_70301_a((int)b).field_77994_a;
                    player.field_71071_by.func_70299_a(b, null);
                }
            }
            if (need > 0) continue;
            return true;
        }
        return need <= 0;
    }

    public static void placeBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!ItemToolBuildingWand.checkUsage(stack, player, 1.0f)) {
            return;
        }
        boolean noblocks = false;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!MMM.canBlockSpecialOperation(block, world, x, y, z)) {
            MMM.addMessage(player, "MMM.info.noblockbuildingwandcant");
            return;
        }
        Set<Pos> Poss = ItemToolBuildingWand.findSuitableBlocks(stack, world, side, x, y, z, block, meta);
        int count = 0;
        for (Pos Pos2 : Poss) {
            if (ItemToolBuildingWand.consumeInventoryItem(Item.func_150898_a((Block)block), meta, player.field_71071_by, player)) {
                ++count;
                MMM.playSoundFromServer(world, block.field_149762_H.func_150495_a(), Pos2.X, Pos2.Y, Pos2.Z, 1.0, 1.0, 5.0);
                world.func_147465_d(Pos2.X, Pos2.Y, Pos2.Z, block, meta, 2);
                MMM.Logg(Pos2);
                continue;
            }
            noblocks = true;
            break;
        }
        if (noblocks) {
            try {
                ItemStack item = new ItemStack(block, 1, meta);
                MMM.addMessage(player, "MMM.info.noblockbuildingwand", item.func_82833_r());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player.field_71070_bA.func_75142_b();
    }

    public static Set<Pos> findSuitableBlocks(ItemStack stack, World world, int sideHit, int x, int y, int z, Block block, int meta) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)sideHit);
        Pos base = new Pos(x, y, z);
        HashSet<Pos> coordinates = new HashSet<Pos>();
        HashSet<Pos> done = new HashSet<Pos>();
        ArrayDeque<Pos> todo = new ArrayDeque<Pos>();
        todo.addLast(base);
        ItemToolBuildingWand.findSuitableBlocks(world, coordinates, done, todo, direction, block, meta, 9, true);
        return coordinates;
    }

    public static void findSuitableBlocks(World world, Set<Pos> coordinates, Set<Pos> done, Deque<Pos> todo, ForgeDirection direction, Block block, int meta, int maxAmount, boolean rowMode) {
        Pos offset;
        Pos base;
        ForgeDirection dirA = null;
        ForgeDirection dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.add(direction);
            dirA = ItemToolBuildingWand.dir1(direction);
            dirB = dirA.getOpposite();
            if (!ItemToolBuildingWand.isSuitable(world, block, meta, base.add(dirA), offset.add(dirA)) || !ItemToolBuildingWand.isSuitable(world, block, meta, base.add(dirB), offset.add(dirB))) {
                dirA = ItemToolBuildingWand.dir2(direction);
                dirB = dirA.getOpposite();
                if (!ItemToolBuildingWand.isSuitable(world, block, meta, base.add(dirA), offset.add(dirA)) || !ItemToolBuildingWand.isSuitable(world, block, meta, base.add(dirB), offset.add(dirB))) {
                    dirA = ItemToolBuildingWand.dir3(direction);
                    dirB = dirA.getOpposite();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.add(direction);
            if (!ItemToolBuildingWand.isSuitable(world, block, meta, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.add(dirA));
                todo.addLast(base.add(dirB));
                continue;
            }
            todo.addLast(base.add(ItemToolBuildingWand.dir1(direction)));
            todo.addLast(base.add(ItemToolBuildingWand.dir1(direction).getOpposite()));
            todo.addLast(base.add(ItemToolBuildingWand.dir2(direction)));
            todo.addLast(base.add(ItemToolBuildingWand.dir2(direction).getOpposite()));
            todo.addLast(base.add(ItemToolBuildingWand.dir1(direction)).add(ItemToolBuildingWand.dir2(direction)));
            todo.addLast(base.add(ItemToolBuildingWand.dir1(direction)).add(ItemToolBuildingWand.dir2(direction).getOpposite()));
            todo.addLast(base.add(ItemToolBuildingWand.dir1(direction).getOpposite()).add(ItemToolBuildingWand.dir2(direction)));
            todo.addLast(base.add(ItemToolBuildingWand.dir1(direction).getOpposite()).add(ItemToolBuildingWand.dir2(direction).getOpposite()));
        }
    }

    public static boolean isSuitable(World world, Block block, int meta, Pos base, Pos offset) {
        Block destBlock = world.func_147439_a(offset.X, offset.Y, offset.Z);
        if (destBlock == null) {
            destBlock = Blocks.field_150350_a;
        }
        return world.func_147439_a(base.X, base.Y, base.Z) == block && world.func_72805_g(base.X, base.Y, base.Z) == meta && destBlock.isReplaceable((IBlockAccess)world, offset.X, offset.Y, offset.Z);
    }

    static ForgeDirection dir1(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return ForgeDirection.EAST;
            }
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case WEST: 
            case EAST: {
                return ForgeDirection.DOWN;
            }
        }
        return null;
    }

    static ForgeDirection dir2(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return ForgeDirection.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.DOWN;
            }
            case WEST: 
            case EAST: {
                return ForgeDirection.SOUTH;
            }
        }
        return null;
    }

    static ForgeDirection dir3(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return ForgeDirection.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: 
            case EAST: {
                return ForgeDirection.SOUTH;
            }
        }
        return null;
    }
}

