/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.mail;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.mail.Stationery;

public class Mail {
    protected static Random rand = new Random();
    public long money = 0L;
    public ItemStack[] items = null;
    public boolean isPick = false;
    public String text = "";
    public Stationery paper;
    public String SenderName = "system";
    public String TargetName = "";
    public String Title = "";
    public UUID uuid;

    public Mail() {
    }

    public String toString() {
        return "Mail_To_" + this.TargetName + "_" + this.uuid.toString();
    }

    public Mail(String title, String text, String target, String SenderName, long money, ItemStack[] items, Stationery paper) {
        this.Title = title;
        this.text = text;
        this.SenderName = SenderName;
        this.items = items;
        this.money = money;
        this.TargetName = target;
        this.paper = paper;
        this.uuid = UUID.randomUUID();
    }

    public boolean hasItem() {
        if (this.items != null) {
            for (int s = 0; s < this.items.length; ++s) {
                if (this.items[s] == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMoney() {
        return this.money > 0L;
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound mail = new NBTTagCompound();
        mail.func_74778_a("SenderName", this.SenderName);
        mail.func_74778_a("TargetName", this.TargetName);
        mail.func_74778_a("text", this.text);
        mail.func_74778_a("Title", this.Title);
        mail.func_74768_a("paper", this.paper.ordinal());
        mail.func_74772_a("money", this.money);
        mail.func_74757_a("isPick", this.isPick);
        mail.func_74778_a("UUID", this.uuid.toString());
        NBTTagList list = new NBTTagList();
        if (this.items != null) {
            for (int s = 0; s < this.items.length; ++s) {
                if (this.items[s] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                this.items[s].func_77955_b(tag);
                list.func_74742_a((NBTBase)tag);
            }
        }
        mail.func_74782_a("Items", (NBTBase)list);
        return mail;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.SenderName = nbt.func_74779_i("SenderName");
        this.TargetName = nbt.func_74779_i("TargetName");
        this.text = nbt.func_74779_i("text");
        this.Title = nbt.func_74779_i("Title");
        this.paper = Stationery.values()[nbt.func_74762_e("paper")];
        this.money = nbt.func_74763_f("money");
        this.isPick = nbt.func_74767_n("isPick");
        this.uuid = UUID.fromString(nbt.func_74779_i("UUID"));
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.items = new ItemStack[list.func_74745_c()];
        for (int s = 0; s < list.func_74745_c(); ++s) {
            NBTTagCompound tag = list.func_150305_b(s);
            this.items[s] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public synchronized void pickMailItems(EntityPlayer player) {
        if (this.isPick) {
            ManaMetalModRoot root;
            this.isPick = false;
            if (this.hasItem()) {
                // empty if block
            }
            if (this.hasMoney() && (root = MMM.getEntityNBT(player)) != null && root.money.getMoney() + this.money < 9000000000000000000L) {
                root.money.addMoney(this.money, MoneySourceType.Mail);
            }
        }
    }
}

