/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.client.GuiTileEntityBase;
import project.studio.manametalmod.core.FuelType;
import project.studio.manametalmod.core.RecipeOre;

public class NEITileEntityTileBase
extends TemplateRecipeHandler {
    public String TileName = null;
    public List<RecipeOre> recipe;
    public FuelType Fuel = FuelType.Base;
    public PositionedStack FuelStack;
    NEITileEntityTileBase DATA;
    public String data;

    public PositionedStack getResultStack(int recipe) {
        try {
            return recipe < this.arecipes.size() ? ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        if (!this.arecipes.isEmpty() && recipe < this.arecipes.size()) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
        }
        return new ArrayList<PositionedStack>(1);
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        if (!this.arecipes.isEmpty() && recipe < this.arecipes.size()) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getOtherStacks();
        }
        return new ArrayList<PositionedStack>(1);
    }

    public void setData(String name, FuelType type, List<RecipeOre> recipe) {
        this.TileName = name;
        this.Fuel = type;
        this.recipe = recipe;
        this.DATA = this;
    }

    public void set() {
    }

    public void loadTransferRects() {
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(74, 24, 176, 14, 24, 17, 48, 0);
        if (this.Fuel != FuelType.None) {
            this.drawProgressBar(52, 26, 176, 0, 14, 14, 72, 7);
        }
    }

    public String getRecipeName() {
        return NEIClientUtils.translate((String)("recipe.manametalmod.NEI." + this.TileName), (Object[])new Object[0]);
    }

    public String getGuiTexture() {
        return "manametalmod:textures/NEI/" + this.TileName + ".png";
    }

    public List<Class<? extends GuiContainer>> getRecipeTransferRectGuis() {
        Class<? extends GuiContainer> clazz = this.getGuiClass();
        if (clazz != null) {
            LinkedList<Class<? extends GuiContainer>> list = new LinkedList<Class<? extends GuiContainer>>();
            list.add(clazz);
            return list;
        }
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiTileEntityBase.class;
    }

    public TemplateRecipeHandler newInstance() {
        this.DATA.findFuels();
        this.DATA.arecipes.clear();
        return this.DATA;
    }

    public void findFuels() {
        switch (this.Fuel) {
            case Base: {
                this.FuelStack = new PositionedStack((Object)MMM.getBaseItemFuel(), 51, 42);
                break;
            }
            case Mana: {
                this.FuelStack = new PositionedStack((Object)MMM.getManaItemFuel(), 51, 42);
                break;
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
        if (outputId.equals(this.TileName + "_Crafting")) {
            this.addManaRecipeCraft(null);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        super.loadUsageRecipes(inputId, ingredients);
        if (inputId.equals(this.TileName + "_Usage")) {
            this.addManaRecipeUse(null);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.addManaRecipeCraft(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.addManaRecipeUse(ingredient);
    }

    public void addManaRecipeCraft(ItemStack result) {
        boolean flag = false;
        if (result == null) {
            flag = true;
        }
        if (this.recipe != null && !this.recipe.isEmpty()) {
            for (int s = 0; s < this.recipe.size(); ++s) {
                if (!flag && !MMM.isItemStackEqualNoNBT(result, this.recipe.get(s).getOut())) continue;
                this.arecipes.add(new SmeltingPair(this.recipe.get(s).getImp1().getItem(), this.recipe.get(s).getImp2().getItem(), this.recipe.get(s).getOut()));
            }
        }
    }

    public void addManaRecipeUse(ItemStack result) {
        boolean flag = false;
        if (result == null) {
            flag = true;
        }
        if (this.recipe != null && !this.recipe.isEmpty()) {
            for (int s = 0; s < this.recipe.size(); ++s) {
                if (!flag && !MMM.isItemStackEqualToLostNoNBT(result, this.recipe.get(s).getImp1().getItem()) && !MMM.isItemStackEqualToLostNoNBT(result, this.recipe.get(s).getImp2().getItem())) continue;
                this.arecipes.add(new SmeltingPair(this.recipe.get(s).getImp1().getItem(), this.recipe.get(s).getImp2().getItem(), this.recipe.get(s).getOut()));
            }
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack ingred2;
        PositionedStack result;

        public SmeltingPair(Object ingred, Object ingred2, ItemStack result) {
            super((TemplateRecipeHandler)NEITileEntityTileBase.this);
            this.ingred = new PositionedStack(ingred, 51, 6);
            this.ingred2 = new PositionedStack(ingred2, 71, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEITileEntityTileBase.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> result = new ArrayList<PositionedStack>();
            result.add(this.ingred2);
            if (NEITileEntityTileBase.this.Fuel != FuelType.None) {
                result.add(NEITileEntityTileBase.this.FuelStack);
            }
            return result;
        }
    }
}

