/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import project.studio.manametalmod.client.ClientPacketHandle;
import project.studio.manametalmod.core.ExplodeSize;
import project.studio.manametalmod.fx.ExplodeType;

public class MessageExplodeFX
implements IMessage,
IMessageHandler<MessageExplodeFX, IMessage> {
    public double x;
    public double y;
    public double z;
    public ExplodeType explodeType;
    public ExplodeSize explodeSize;
    public int particleCount;

    public MessageExplodeFX() {
    }

    public MessageExplodeFX(double posX, double posY, double posZ, ExplodeType explodeType, ExplodeSize explodeSize, int particleCount) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.explodeType = explodeType;
        this.explodeSize = explodeSize;
        this.particleCount = particleCount;
    }

    public IMessage onMessage(MessageExplodeFX message, MessageContext ctx) {
        ClientPacketHandle.accept(message);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.explodeType = ExplodeType.values()[buf.readInt()];
        this.explodeSize = ExplodeSize.values()[buf.readInt()];
        this.particleCount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.explodeType.ordinal());
        buf.writeInt(this.explodeSize.ordinal());
        buf.writeInt(this.particleCount);
    }
}

