/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Teleporter;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.TeleporterM3;
import project.studio.manametalmod.items.ItemHomeReel;

public class MessageTeleportItem
implements IMessage,
IMessageHandler<MessageTeleportItem, IMessage> {
    private NBTTagCompound tag;
    private int Type;
    private int x;
    private int y;
    private int z;
    private int worldID;

    public MessageTeleportItem() {
    }

    public MessageTeleportItem(int type, int x, int y, int z, int worldID, NBTTagCompound tag) {
        this.Type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.worldID = worldID;
        this.tag = tag;
    }

    public MessageTeleportItem(int type, int x, int y, int z, int worldID) {
        this.Type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.worldID = worldID;
        this.tag = new NBTTagCompound();
    }

    public IMessage onMessage(MessageTeleportItem message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (message.Type == 0) {
            ItemStack item = player.func_71045_bC();
            if (item != null) {
                item.func_77972_a(1, (EntityLivingBase)player);
            }
            if (MMM.getDimensionID(player.field_70170_p) == message.worldID) {
                Pos pos = new Pos(message.x, message.y, message.z);
                ItemHomeReel.tpPets((EntityPlayer)player, player.field_70170_p, pos);
                MMM.teleport((EntityPlayer)player, pos);
            } else {
                Pos pos = new Pos(message.x, message.y, message.z);
                ItemHomeReel.tpDIMPets((EntityPlayer)player, player.field_70170_p, pos, message.worldID);
                player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, message.worldID, (Teleporter)new TeleporterM3(player.field_71133_b.func_71218_a(message.worldID)));
                MMM.teleport((EntityPlayer)player, pos);
            }
            return null;
        }
        if (message.Type == 1) {
            ItemStack item = player.func_71045_bC();
            if (item != null) {
                NBTTagCompound temp = message.tag;
                item.func_77982_d(temp);
            }
            return null;
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.Type = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.worldID = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.Type);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.worldID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }
}

