/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.npc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.common.IPlantable;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.ICoins;
import project.studio.manametalmod.api.IPotion;
import project.studio.manametalmod.api.IWeaponScroll;
import project.studio.manametalmod.card.IManaBattleCards;

public enum NpcGiftType {
    Flower,
    Food,
    Weapon,
    Tool,
    Armor,
    DirtBlock,
    WoodBlock,
    StoneBlock,
    Gem,
    MetalIngot,
    HighPrice,
    PreciousMetal,
    Book,
    Plant,
    Reel,
    Potion,
    Coin,
    Treasure,
    Card,
    Trophy,
    Junk;


    public static boolean testTypeFromItemStack(NpcGiftType type, ItemStack item) {
        switch (type) {
            case Armor: {
                if (!(item.func_77973_b() instanceof ItemArmor)) break;
                return true;
            }
            case Book: {
                break;
            }
            case Card: {
                if (!(item.func_77973_b() instanceof IManaBattleCards)) break;
                return true;
            }
            case Coin: {
                if (!(item.func_77973_b() instanceof ICoins)) break;
                return true;
            }
            case DirtBlock: {
                if (!(item.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)item.func_77973_b()).func_149688_o() != Material.field_151578_c) break;
                return true;
            }
            case Flower: {
                if (!(item.func_77973_b() instanceof ItemBlock) || !(Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockFlower)) break;
                return true;
            }
            case Food: {
                if (!(item.func_77973_b() instanceof ItemFood)) break;
                return true;
            }
            case Gem: {
                if (!MMM.getItemIsGem(item)) break;
                return true;
            }
            case HighPrice: {
                if (MMM.getItemStackMoneyValue(item) < 300L) break;
                return true;
            }
            case MetalIngot: {
                if (!MMM.getItemIsIngot(item)) break;
                return true;
            }
            case Plant: {
                if (!(item.func_77973_b() instanceof ItemBlock) || !(Block.func_149634_a((Item)item.func_77973_b()) instanceof IPlantable)) break;
                return true;
            }
            case Potion: {
                if (!(item.func_77973_b() instanceof ItemPotion) && !(item.func_77973_b() instanceof IPotion)) break;
                return true;
            }
            case PreciousMetal: {
                if (!MMM.getItemIsPreciousIngotl(item)) break;
                return true;
            }
            case Reel: {
                if (!(item.func_77973_b() instanceof IWeaponScroll)) break;
                return true;
            }
            case StoneBlock: {
                if (!(item.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)item.func_77973_b()).func_149688_o() != Material.field_151576_e) break;
                return true;
            }
            case Tool: {
                if (!(item.func_77973_b() instanceof ItemTool)) break;
                return true;
            }
            case Treasure: {
                break;
            }
            case Weapon: {
                if (!MMM.getItemIsWeapon(item)) break;
                return true;
            }
            case WoodBlock: {
                if (!(item.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)item.func_77973_b()).func_149688_o() != Material.field_151575_d) break;
                return true;
            }
            case Trophy: {
                break;
            }
            case Junk: {
                break;
            }
        }
        return false;
    }

    public int getID() {
        return this.ordinal();
    }

    public static int getID(NpcGiftType type) {
        return type.ordinal();
    }

    public static NpcGiftType getTypeFromID(int id) {
        if (id < NpcGiftType.values().length) {
            return NpcGiftType.values()[id];
        }
        return null;
    }
}

