/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.beekeeping;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.addon.Botania.BotaniaCore;
import project.studio.manametalmod.blocks.BlockDirtBase;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.IMythicalAnimal;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.produce.beekeeping.BeeAttributes;
import project.studio.manametalmod.produce.beekeeping.BeeEffect;
import project.studio.manametalmod.produce.beekeeping.BeekeepingCore;
import project.studio.manametalmod.produce.beekeeping.BlockHoneycomb;
import project.studio.manametalmod.produce.beekeeping.ItemBeeQueen;
import project.studio.manametalmod.produce.farming.BlockDirtFarm;
import project.studio.manametalmod.season.Season;
import project.studio.manametalmod.season.WorldSeason;
import project.studio.manametalmod.treasurehunt.TreasurehuntCore;
import project.studio.manametalmod.world.biome.BiomeHelp;

public class TileEntityBeehive
extends TileEntity
implements ISidedInventory {
    public int coin_count = 0;
    public boolean update = false;
    public int time = 0;
    public int speedDarta = 0;
    public int speedBase = 399;
    public boolean canUpdatePlant = false;
    public int planttime = 0;
    public int beeflytime = 100;
    public String TileName = null;
    public ItemStack[] items = new ItemStack[27];
    public List<Pos> flowersPos = new ArrayList<Pos>();
    public int hasBeeFX = 0;
    public int textureType = 0;
    public static final int[] hopperIMP = new int[]{0, 1, 2};
    public static final int[] hopperOUT = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};

    public int[] func_94128_d(int side) {
        if (side == 1) {
            return hopperIMP;
        }
        return hopperOUT;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (item != null) {
            if (slot == 0) {
                return item.func_77973_b() instanceof ItemBeeQueen;
            }
            if (slot == 1 || slot == 2) {
                return item.func_77973_b() == BeekeepingCore.beebase;
            }
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot > 2;
    }

    public TileEntityBeehive(int speed) {
        this.speedBase = speed;
    }

    public TileEntityBeehive() {
        this(399);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.items[index] != null) {
            if (this.items[index].field_77994_a <= count) {
                ItemStack itemstack = this.items[index];
                this.items[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[index].func_77979_a(count);
            if (this.items[index].field_77994_a == 0) {
                this.items[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack itemstack = this.items[slot];
            this.items[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items[slot] = item;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.TileName : "";
    }

    public boolean func_145818_k_() {
        return this.TileName != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.speedBase = NBTHelp.getIntSafe("speedBase", nbt, 399);
        this.time = NBTHelp.getIntSafe("time", nbt, 0);
        this.coin_count = NBTHelp.getIntSafe("coin_count", nbt, 0);
        this.hasBeeFX = NBTHelp.getIntSafe("hasBeeFX", nbt, 0);
        this.textureType = NBTHelp.getIntSafe("textureType", nbt, 0);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.length) continue;
            this.items[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("speedBase", this.speedBase);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("coin_count", this.coin_count);
        nbt.func_74768_a("hasBeeFX", this.hasBeeFX);
        nbt.func_74768_a("textureType", this.textureType);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public float getSpeed() {
        return 0.0f;
    }

    public boolean isDamnedBotaniaFlower(Block block) {
        if (MMM.isBotania) {
            return BotaniaCore.isBotaniaFlower(block);
        }
        return false;
    }

    public int findFlowers() {
        int flowers = 0;
        this.flowersPos.clear();
        int tempX = 0;
        int tempY = 0;
        int tempZ = 0;
        Block block = null;
        for (int dy = -2; dy < 3; ++dy) {
            for (int dx = -16; dx < 17; ++dx) {
                for (int dz = -16; dz < 17; ++dz) {
                    tempX = this.field_145851_c + dx;
                    tempY = this.field_145848_d + dy;
                    tempZ = this.field_145849_e + dz;
                    block = this.field_145850_b.func_147439_a(tempX, tempY, tempZ);
                    if (!(block instanceof BlockFlower)) continue;
                    ++flowers;
                    this.flowersPos.add(new Pos(tempX, tempY, tempZ));
                }
            }
        }
        return flowers;
    }

    public boolean hasBee() {
        return this.items[0] != null && (this.items[1] != null || this.items[2] != null);
    }

    public NBTTagCompound mutationTag() {
        if (this.items[0].func_77942_o()) {
            NBTTagCompound tag = (NBTTagCompound)this.items[0].func_77978_p().func_74737_b();
            tag.func_74768_a("damage", 0);
            int mutation = ItemBeeQueen.getBeeAttributes(BeeAttributes.mutation, this.items[0]);
            if (this.field_145850_b.field_73012_v.nextInt(100) < mutation) {
                int[] arrayold = NBTHelp.getIntArraySafe("BeeEffect", tag, new int[0]);
                ArrayList<Integer> list = new ArrayList<Integer>(16);
                for (int s = 0; s < arrayold.length; ++s) {
                    list.add(arrayold[s]);
                }
                int size = BeeEffect.values().length;
                for (int s = 0; s < mutation; ++s) {
                    BeeEffect effect = BeeEffect.values()[this.field_145850_b.field_73012_v.nextInt(size)];
                    if (this.field_145850_b.field_73012_v.nextInt(100) >= effect.data || list.contains(effect.ordinal())) continue;
                    list.add(effect.ordinal());
                }
                if (this.field_145850_b.field_73012_v.nextInt(100) < mutation * 2) {
                    int lostcount = ItemBeeQueen.isEffect(BeeEffect.variability, this.items[0]) ? 3 : 4;
                    int lost = this.field_145850_b.field_73012_v.nextInt(lostcount);
                    for (int s = 0; s < lost; ++s) {
                        if (list.size() <= 0) continue;
                        list.remove(this.field_145850_b.field_73012_v.nextInt(list.size()));
                    }
                }
                int[] array = list.stream().mapToInt(Integer::intValue).toArray();
                tag.func_74783_a("BeeEffect", array);
            }
            return tag;
        }
        return null;
    }

    public void production(int count) {
        if (this.items[0] != null) {
            int maxcoin = ItemBeeQueen.isEffect(BeeEffect.greedy, this.items[0]) ? 400 : 200;
            block0: for (int z = 0; z < count; ++z) {
                for (int s = 3; s < this.items.length; ++s) {
                    if (this.items[s] == null) {
                        int type = this.field_145850_b.field_73012_v.nextInt(12);
                        if (type == 0) {
                            this.items[s] = new ItemStack(BeekeepingCore.beelarva, 1, this.items[0].func_77960_j());
                            NBTTagCompound tag = this.mutationTag();
                            if (tag != null) {
                                this.items[s].func_77982_d(tag);
                            }
                        } else if (type == 1) {
                            this.items[s] = new ItemStack(BeekeepingCore.Pollen, 2);
                        } else if (this.field_145850_b.field_73012_v.nextInt(200000) == 0) {
                            this.items[s] = new ItemStack(TreasurehuntCore.ItemProduceTreasure, 1, 6 + this.field_145850_b.field_73012_v.nextInt(2));
                        } else {
                            int id = this.items[0].func_77960_j();
                            this.items[s] = this.field_145850_b.field_73012_v.nextInt(2) == 0 ? new ItemStack(BeekeepingCore.honeycomb, 1, id * 2) : new ItemStack(BeekeepingCore.honeycomb, 1, id * 2 + 1);
                        }
                        if (this.coin_count >= maxcoin) continue block0;
                        this.coin_count += 2;
                        continue block0;
                    }
                    if (this.items[s].func_77973_b() != BeekeepingCore.honeycomb || this.items[s].field_77994_a >= 8) continue;
                    this.items[s].field_77994_a += ItemBeeQueen.getBeeAttributes(BeeAttributes.produce, this.items[0]);
                    continue block0;
                }
            }
        }
    }

    public int beeCount() {
        int bee = 0;
        if (this.items[1] != null) {
            bee += this.items[1].field_77994_a;
        }
        if (this.items[2] != null) {
            bee += this.items[2].field_77994_a;
        }
        return bee;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void damageTheBees() {
        int damage;
        if (this.items[0].func_77942_o()) {
            if (!ItemBeeQueen.isEffect(BeeEffect.eternallife, this.items[0])) {
                int maxLife;
                NBTTagCompound tag = this.items[0].func_77978_p();
                int damage2 = NBTHelp.getIntSafe("damage", tag, 0);
                if (damage2 >= (maxLife = ItemBeeQueen.getBeeAttributes(BeeAttributes.health, this.items[0]))) {
                    MMM.removeTileEntityItem(this, 0);
                    return;
                }
                tag.func_74768_a("damage", ++damage2);
            }
        } else {
            ItemBeeQueen.setBaseAttributes(this.items[0], false, false, this.field_145850_b, 8);
        }
        if (this.items[0].func_77942_o() && !this.items[0].func_77978_p().func_150297_b("health", 3)) {
            ItemBeeQueen.setBaseAttributes(this.items[0], false, false, this.field_145850_b, 8);
        }
        int n = damage = ItemBeeQueen.isEffect(BeeEffect.care, this.items[0]) ? 130 : 100;
        if (this.field_145850_b.field_73012_v.nextInt(damage) == 0 && this.items[1] != null) {
            MMM.removeTileEntityItem(this, 1);
        }
        if (this.field_145850_b.field_73012_v.nextInt(damage) == 0 && this.items[2] != null) {
            MMM.removeTileEntityItem(this, 2);
        }
    }

    public void damageFlower() {
        if (this.items[0] != null) {
            Pos pos;
            int damage;
            int n = damage = ItemBeeQueen.isEffect(BeeEffect.withered, this.items[0]) ? 60 : 70;
            if (this.field_145850_b.field_73012_v.nextInt(damage) == 0 && !this.flowersPos.isEmpty() && (pos = MMM.getRandomItemFromList(this.flowersPos)).getPosBlock(this.field_145850_b) instanceof BlockFlower && this.field_145850_b.func_147439_a(pos.X, pos.Y - 1, pos.Z) != Blocks.field_150350_a && !this.isDamnedBotaniaFlower(pos.getPosBlock(this.field_145850_b))) {
                this.field_145850_b.func_147465_d(pos.X, pos.Y, pos.Z, (Block)Blocks.field_150329_H, 0, 2);
            }
        }
    }

    public void spawnBeeFX() {
        if (this.field_145850_b.field_72995_K && !this.flowersPos.isEmpty()) {
            Pos pos = this.flowersPos.get(this.field_145850_b.field_73012_v.nextInt(this.flowersPos.size()));
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.bee, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.0f, (float)this.field_145849_e + 0.5f, 5, (float)pos.X + 0.5f, (float)pos.Y + 0.25f, (float)pos.Z + 0.5f, 1.0f);
            } else {
                FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.bee, (float)pos.X + 0.5f, (float)pos.Y + 0.25f, (float)pos.Z + 0.5f, 5, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.0f, (float)this.field_145849_e + 0.5f, 1.0f);
            }
        }
    }

    public boolean hasMythicalAnimal() {
        List<EntityLivingBase> list = MMM.findEntityLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 16);
        if (!list.isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof IMythicalAnimal)) continue;
                return true;
            }
        }
        return false;
    }

    public void pollination() {
        ++this.planttime;
        if (this.planttime > 19) {
            this.planttime = 0;
            if (this.canUpdatePlant) {
                int beecount = this.beeCount();
                int range = ItemBeeQueen.isEffect(BeeEffect.longrange, this.items[0]) ? 16 : 10;
                int power = ItemBeeQueen.getBeeAttributes(BeeAttributes.pollination, this.items[0]);
                int x = 0;
                int z = 0;
                int radius = range / 2;
                int radiusmax = range + 1;
                for (int s = 0; s < beecount; ++s) {
                    x = radius - this.field_145850_b.field_73012_v.nextInt(radiusmax) + this.field_145851_c;
                    Block block = this.field_145850_b.func_147439_a(x, this.field_145848_d, z = radius - this.field_145850_b.field_73012_v.nextInt(radiusmax) + this.field_145849_e);
                    if (!block.func_149653_t() || block instanceof BlockDirtBase || block instanceof BlockDirtFarm) continue;
                    for (int c = 0; c < power; ++c) {
                        this.field_145850_b.func_147439_a(x, this.field_145848_d, z).func_149674_a(this.field_145850_b, x, this.field_145848_d, z, this.field_145850_b.field_73012_v);
                    }
                }
            }
        }
    }

    public int genBaseSpeed() {
        int speedtemp = 1730;
        if (this.func_145838_q() instanceof BlockHoneycomb) {
            speedtemp = ((BlockHoneycomb)this.func_145838_q()).speed;
        }
        if (MMM.isTargetBiome(this.field_145851_c, this.field_145849_e, this.func_145831_w(), BiomeHelp.BiomeFlowerPalls)) {
            speedtemp -= 120;
        }
        if (this.hasMythicalAnimal()) {
            speedtemp -= 120;
        }
        if (ItemBeeQueen.isEffect(BeeEffect.anotherworld, this.items[0])) {
            speedtemp = (int)((double)speedtemp * 1.2);
        }
        if (ItemBeeQueen.isEffect(BeeEffect.eternallife, this.items[0])) {
            speedtemp = (int)((double)speedtemp * 2.0);
        }
        float beespeed = 1.0f - 0.01f * (float)ItemBeeQueen.getBeeAttributes(BeeAttributes.efficiency, this.items[0]);
        return 20 + speedtemp + (int)((float)speedtemp * beespeed);
    }

    public void func_145845_h() {
        if (this.items[0] == null) {
            return;
        }
        if (!this.update) {
            this.update = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.field_72995_K) {
            --this.beeflytime;
            if (this.beeflytime <= 0) {
                this.beeflytime = this.field_145850_b.field_73012_v.nextInt(60);
                if (this.hasBee() && this.hasBeeFX > 0) {
                    this.spawnBeeFX();
                    --this.hasBeeFX;
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.pollination();
        }
        --this.time;
        if (this.time <= 0) {
            int flowersCount;
            this.time = this.genBaseSpeed();
            if (MMM.getDimensionID(this.field_145850_b) != 0 && !ItemBeeQueen.isEffect(BeeEffect.anotherworld, this.items[0])) {
                return;
            }
            if (MMM.getDimensionID(this.field_145850_b) == 0 && M3Config.SeasonSystem && WorldSeason.NowSeason == Season.winter && !ItemBeeQueen.isEffect(BeeEffect.coldresistant, this.items[0])) {
                return;
            }
            if (MMM.getDimensionID(this.field_145850_b) == 0 && !this.field_145850_b.func_72935_r() && !ItemBeeQueen.isEffect(BeeEffect.nightwalk, this.items[0])) {
                return;
            }
            if (M3Config.DEBUG) {
                MMM.Logg("bee time : " + this.time);
            }
            if ((flowersCount = this.findFlowers() / 4) > 0 && this.hasBee()) {
                int beeCount = this.beeCount();
                if (beeCount > 0 && (beeCount /= 4) <= 0) {
                    beeCount = 1;
                }
                if (beeCount > 0) {
                    if (flowersCount > beeCount) {
                        flowersCount = beeCount;
                    }
                    if (!this.field_145850_b.field_72995_K) {
                        this.production(flowersCount);
                        this.damageFlower();
                        this.damageTheBees();
                        this.canUpdatePlant = true;
                        this.hasBeeFX = this.time / 30;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return;
                }
            }
            this.canUpdatePlant = false;
        }
    }
}

