/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.renderer.jsonblock;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import project.studio.manametalmod.renderer.jsonblock.BlockJsonModelBake;

public class RenderJsonBlockModel
implements ISimpleBlockRenderingHandler {
    public final List<BlockJsonModelBake.BakedQuad>[] quads;
    public final int ID;
    public int rotation = 0;
    public boolean autoRotationY = false;
    public boolean autoOverlay = false;
    public boolean randomRotation = false;
    public boolean renderItem = false;

    public boolean shouldRender3DInInventory(int modelId) {
        return this.renderItem;
    }

    public RenderJsonBlockModel(List<BlockJsonModelBake.BakedQuad>[] quads, int ID, boolean autoRotationY, boolean autoOverlay, int rotation, boolean randomRotation, boolean renderItem) {
        this.quads = quads;
        this.ID = ID;
        this.autoRotationY = autoRotationY;
        this.autoOverlay = autoOverlay;
        this.rotation = rotation;
        this.randomRotation = randomRotation;
        this.renderItem = renderItem;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int renderCount = this.autoOverlay ? this.quads.length : 1;
        int metadata = world.func_72805_g(x, y, z);
        int renderID = metadata;
        if (renderID < this.quads.length) {
            Tessellator t = Tessellator.field_78398_a;
            double a = Math.toRadians(this.randomRotation ? (double)(Math.abs(x + y + z) % 4 * 90) : (double)(this.autoRotationY ? 90 * (metadata % 4) : this.rotation));
            double c = Math.cos(a);
            double s = Math.sin(a);
            for (int w = 0; w < this.quads[renderID].size(); ++w) {
                BlockJsonModelBake.BakedQuad q = this.quads[renderID].get(w);
                int br = RenderJsonBlockModel.sampleBrightnessByNormal(world, x, y, z, q.faceNormal, block);
                int BQ = this.getFaceBrightness(world, x, y, z, block, q.face);
                t.func_78380_c(BQ);
                float shade = RenderJsonBlockModel.shadeByNormal(q.faceNormal);
                t.func_78386_a(shade, shade, shade);
                IIcon icon = q.icon;
                for (int i = 0; i < 4; ++i) {
                    double wx = (double)x + q.vx[i];
                    double wy = (double)y + q.vy[i];
                    double wz = (double)z + q.vz[i];
                    double cx = (double)x + 0.5;
                    double cz = (double)z + 0.5;
                    double px = (double)x + q.vx[i] - cx;
                    double pz = (double)z + q.vz[i] - cz;
                    double rx = px * c - pz * s;
                    double rz = px * s + pz * c;
                    double U = icon.func_94214_a((double)q.up[i]);
                    double V = icon.func_94207_b((double)q.vp[i]);
                    t.func_78374_a(cx + rx, (double)y + q.vy[i], cz + rz, U, V);
                }
            }
        }
        return true;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (metadata < this.quads.length) {
            Tessellator t = Tessellator.field_78398_a;
            GL11.glPushMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            t.func_78382_b();
            t.func_78386_a(1.0f, 1.0f, 1.0f);
            t.func_78380_c(255);
            for (int s = 0; s < this.quads[metadata].size(); ++s) {
                BlockJsonModelBake.BakedQuad q = this.quads[metadata].get(s);
                IIcon icon = q.icon;
                for (int i = 0; i < 4; ++i) {
                    double U = icon.func_94214_a((double)q.up[i]);
                    double V = icon.func_94207_b((double)q.vp[i]);
                    t.func_78374_a(q.vx[i], q.vy[i], q.vz[i], U, V);
                }
            }
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private int getFaceBrightness(IBlockAccess w, int x, int y, int z, Block b, EnumFacing face) {
        switch (face) {
            case UP: {
                return w.func_72802_i(x, y + 1, z, 0);
            }
            case DOWN: {
                return w.func_72802_i(x, y - 1, z, 0);
            }
            case NORTH: {
                return w.func_72802_i(x, y, z - 1, 0);
            }
            case SOUTH: {
                return w.func_72802_i(x, y, z + 1, 0);
            }
            case WEST: {
                return w.func_72802_i(x - 1, y, z, 0);
            }
            case EAST: {
                return w.func_72802_i(x + 1, y, z, 0);
            }
        }
        return b.func_149677_c(w, x, y, z);
    }

    private float getFaceShade(EnumFacing face) {
        switch (face) {
            case UP: {
                return 1.0f;
            }
            case DOWN: {
                return 0.5f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    private static int sampleBrightnessByNormal(IBlockAccess w, int x, int y, int z, double[] n, Block b) {
        double ax = Math.abs(n[0]);
        double ay = Math.abs(n[1]);
        double az = Math.abs(n[2]);
        if (ay >= ax && ay >= az) {
            if (n[1] > 0.0) {
                return w.func_72802_i(x, y + 1, z, 0);
            }
            return w.func_72802_i(x, y - 1, z, 0);
        }
        if (ax >= ay && ax >= az) {
            if (n[0] > 0.0) {
                return w.func_72802_i(x + 1, y, z, 0);
            }
            return w.func_72802_i(x - 1, y, z, 0);
        }
        if (n[2] > 0.0) {
            return w.func_72802_i(x, y, z + 1, 0);
        }
        return w.func_72802_i(x, y, z - 1, 0);
    }

    private static float shadeByNormal(double[] n) {
        double ax = Math.abs(n[0]);
        double ay = Math.abs(n[1]);
        double az = Math.abs(n[2]);
        if (ay >= ax && ay >= az) {
            return n[1] > 0.0 ? 1.0f : 0.5f;
        }
        if (ax >= ay && ax >= az) {
            return 0.6f;
        }
        return 0.8f;
    }

    public int getRenderId() {
        return this.ID;
    }
}

