/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.skyadventure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.skyadventure.Battleship;
import project.studio.manametalmod.skyadventure.BattleshipData;
import project.studio.manametalmod.skyadventure.ChallengeType;
import project.studio.manametalmod.skyadventure.IBattleshipEquipment;
import project.studio.manametalmod.skyadventure.SkyAdventureCore;
import project.studio.manametalmod.skyadventure.SkyCard;
import project.studio.manametalmod.skyadventure.TileEntitySkyAdventure;

public class GameSkyAdventure {
    public boolean isStart = false;
    public boolean isOver = false;
    public boolean landing = false;
    public boolean useCard = false;
    public boolean ClientData = false;
    public int time = 0;
    public ChallengeType Challenge = ChallengeType.None;
    public int island = 0;
    private int challenge_count = 0;
    public int gameplayer = 0;
    public int HP = 0;
    public int maxHP = 0;
    public int MonsterHP = 0;
    public int MonsterHPMax = 0;
    public int damageTime = 0;
    public int weaponattack = 0;
    public int updateTime = 0;
    public int cardCD = 0;
    public int point = 0;
    SkyCard card = SkyCard.Arrow;
    public int deftime = 0;
    public String messagePlayer = " ";
    public static final int[] CS = new int[]{2, 2, 3, 3, 4, 4, 4, 5, 6, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15};
    public static final int MaxChallenge = 40;
    private String gameInfo = "";
    public List<String> players = new ArrayList<String>();
    public List<BattleshipData> battleship = new ArrayList<BattleshipData>();
    public List<Integer> treasure = new ArrayList<Integer>();
    public List<Integer> exp = new ArrayList<Integer>();
    Random random;
    TileEntitySkyAdventure tile;

    public void useCardFX(SkyCard card) {
        this.card = card;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound nbt = tag.func_74775_l("GameSkyAdventure");
        this.isStart = nbt.func_74767_n("isStart");
        this.isOver = nbt.func_74767_n("isOver");
        this.landing = nbt.func_74767_n("landing");
        this.useCard = nbt.func_74767_n("useCard");
        this.ClientData = nbt.func_74767_n("ClientData");
        this.time = nbt.func_74762_e("time");
        this.Challenge = ChallengeType.values()[nbt.func_74762_e("Challenge")];
        this.island = nbt.func_74762_e("island");
        this.setChallenge_count(nbt.func_74762_e("challenge"));
        this.gameplayer = nbt.func_74762_e("gameplayer");
        this.HP = nbt.func_74762_e("HP");
        this.maxHP = nbt.func_74762_e("maxHP");
        this.MonsterHP = nbt.func_74762_e("MonsterHP");
        this.MonsterHPMax = nbt.func_74762_e("MonsterHPMax");
        this.damageTime = nbt.func_74762_e("damageTime");
        this.weaponattack = nbt.func_74762_e("weaponattack");
        this.updateTime = nbt.func_74762_e("updateTime");
        this.cardCD = nbt.func_74762_e("cardCD");
        this.point = nbt.func_74762_e("point");
        this.gameInfo = nbt.func_74779_i("gameInfo");
        this.card = SkyCard.values()[nbt.func_74762_e("SkyCard")];
        this.deftime = nbt.func_74762_e("deftime");
        this.messagePlayer = NBTHelp.getStringSafe("messagePlayer", nbt, this.messagePlayer);
        this.players.clear();
        this.treasure.clear();
        this.exp.clear();
        this.battleship.clear();
        for (int s = 0; s < 4; ++s) {
            if (!nbt.func_150297_b("nbtPlayer" + s, 10)) continue;
            NBTTagCompound nbtPlayer = nbt.func_74775_l("nbtPlayer" + s);
            this.players.add(nbtPlayer.func_74779_i("playerName" + s));
            this.treasure.add(nbtPlayer.func_74762_e("playerTreasure" + s));
            this.exp.add(nbtPlayer.func_74762_e("playerExp" + s));
            BattleshipData dataClone = new BattleshipData(null);
            dataClone.loadNBTData(nbtPlayer);
            this.battleship.add(dataClone);
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("isStart", this.isStart);
        nbt.func_74757_a("isOver", this.isOver);
        nbt.func_74757_a("landing", this.landing);
        nbt.func_74757_a("useCard", this.useCard);
        nbt.func_74757_a("ClientData", this.ClientData);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("Challenge", this.Challenge.ordinal());
        nbt.func_74768_a("island", this.island);
        nbt.func_74768_a("challenge", this.getChallenge_count());
        nbt.func_74768_a("gameplayer", this.gameplayer);
        nbt.func_74768_a("HP", this.HP);
        nbt.func_74768_a("maxHP", this.maxHP);
        nbt.func_74768_a("MonsterHP", this.MonsterHP);
        nbt.func_74768_a("MonsterHPMax", this.MonsterHPMax);
        nbt.func_74768_a("damageTime", this.damageTime);
        nbt.func_74768_a("weaponattack", this.weaponattack);
        nbt.func_74768_a("updateTime", this.updateTime);
        nbt.func_74768_a("cardCD", this.cardCD);
        nbt.func_74768_a("point", this.point);
        nbt.func_74778_a("gameInfo", this.gameInfo);
        nbt.func_74768_a("SkyCard", this.card.ordinal());
        nbt.func_74768_a("deftime", this.deftime);
        nbt.func_74778_a("messagePlayer", this.messagePlayer);
        for (int s = 0; s < this.players.size(); ++s) {
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            nbtPlayer.func_74778_a("playerName" + s, this.players.get(s));
            nbtPlayer.func_74768_a("playerTreasure" + s, this.treasure.get(s).intValue());
            nbtPlayer.func_74768_a("playerExp" + s, this.exp.get(s).intValue());
            this.battleship.get(s).saveNBTData(nbtPlayer);
            nbt.func_74782_a("nbtPlayer" + s, (NBTBase)nbtPlayer);
        }
        tag.func_74782_a("GameSkyAdventure", (NBTBase)nbt);
    }

    public GameSkyAdventure(Random random, TileEntitySkyAdventure tile) {
        this.random = random;
        this.tile = tile;
    }

    public String text(String text) {
        return MMM.getTranslateText("GameSkyAdventure." + text);
    }

    public int getPlayerID(EntityPlayer player) {
        for (int s = 0; s < this.players.size(); ++s) {
            if (!player.func_70005_c_().equals(this.players.get(s))) continue;
            return s;
        }
        return -1;
    }

    public boolean isPlayer(EntityPlayer player) {
        for (int s = 0; s < this.players.size(); ++s) {
            if (!this.players.get(s).equals(player.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public boolean addPlayer(EntityPlayer player) {
        if (!this.isStart) {
            if (this.players.size() < 4) {
                ManaMetalModRoot root = MMM.getEntityNBT(player);
                if (root != null) {
                    if (root.battleCard.getData().boat != Battleship.None && root.battleCard.getData().heal > 0) {
                        this.players.add(player.getDisplayName());
                        this.battleship.add(root.battleCard.getData().copy());
                        this.treasure.add(0);
                        this.exp.add(0);
                        MMM.addMessage(player, "SkyAdventure.addplayer");
                        return true;
                    }
                    MMM.addMessage(player, "SkyAdventure.cantadd");
                }
            } else {
                MMM.addMessage(player, "SkyAdventure.isfull");
            }
        }
        return false;
    }

    public boolean canStart() {
        return !this.players.isEmpty() && !this.battleship.isEmpty() && this.players.size() == this.battleship.size();
    }

    public void attack(int damage, SkyCard card) {
        damage = (int)((float)damage + (float)damage * this.random.nextFloat() / 10.0f);
        this.MonsterHP -= (damage += this.weaponattack);
        this.point += damage;
        this.setGameInfo(card.names() + this.text("attack.card") + damage + this.text("attack.card.2"));
    }

    public void removePlayer(EntityPlayer player) {
        if (!this.players.isEmpty() && !this.battleship.isEmpty()) {
            for (int s = 0; s < this.players.size(); ++s) {
                if (!this.players.get(s).equals(player.getDisplayName())) continue;
                this.addMessagePlayer("SkyAdventure.player.remove");
                if (this.isStart) {
                    this.addRewardForOnlyPlayer(player, s);
                }
                this.players.remove(s);
                this.battleship.remove(s);
                this.treasure.remove(s);
                this.exp.remove(s);
                break;
            }
        }
        if (this.gameplayer >= this.players.size()) {
            this.gameplayer = 0;
        }
        if (this.players.isEmpty()) {
            this.gameOver(1);
        }
    }

    public void startGame() {
        this.landing = false;
        this.isStart = true;
        this.isOver = false;
        this.island = 0;
        this.gameplayer = 0;
        this.weaponattack = 0;
        this.HP = 0;
        this.setChallenge_count(0);
        for (int s = 0; s < this.battleship.size(); ++s) {
            this.HP += this.battleship.get((int)s).heal;
            this.weaponattack += this.battleship.get((int)s).boatLV;
        }
        this.maxHP = this.HP;
        if (this.island < CS.length) {
            this.setChallenge_count(CS[this.island] - this.random.nextInt(4));
        } else {
            this.setChallenge_count(this.island + this.random.nextInt(3));
        }
        this.Challenge = ChallengeType.getRendomTypeFromIsland(this);
        this.damageTime = this.Challenge.getDamageTime(this);
        if (this.Challenge.isBattleChallenge()) {
            this.MonsterHP = this.Challenge.getMonsterHP(this);
            this.MonsterHPMax = this.Challenge.getMonsterHP(this);
        }
        if (this.Challenge.isBattleChallenge()) {
            this.setGameInfo(this.text("Challenge1") + this.Challenge.names());
        } else if (this.Challenge == ChallengeType.None) {
            this.setGameInfo(this.text("Challenge2"));
        } else if (this.Challenge == ChallengeType.Treasure) {
            this.setGameInfo(this.text("Challenge3"));
        } else {
            this.setGameInfo(this.text("Challenge0") + this.Challenge.names());
        }
        this.clearAllplayerCard();
        this.sendEquipmentCardForAll(true);
        this.sendRandomCardForAll(4);
    }

    public void tryUseCardFromPlayer(EntityPlayer player, SkyCard card) {
        if (card == null) {
            return;
        }
        if (card == SkyCard.Tactics) {
            this.goNextChallenge();
            this.cardCD = 10;
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use1"));
            return;
        }
        if (card == SkyCard.Plan) {
            this.ChangePlayer(true);
            this.cardCD = 10;
            return;
        }
        if (this.Challenge == null) {
            this.goNextChallenge();
            this.cardCD = 10;
            return;
        }
        if (card == SkyCard.Service) {
            this.HP += 125;
            if (this.HP > this.maxHP) {
                this.HP = this.maxHP;
            }
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use2"));
        }
        if (card == SkyCard.Potion) {
            this.cardCD = 10;
            this.damageTime += 3;
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use3"));
            return;
        }
        if (card == SkyCard.Magic) {
            this.cardCD = 10;
            ++this.damageTime;
            this.Challenge = ChallengeType.None;
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use5"));
            return;
        }
        if (card == SkyCard.Armor) {
            this.deftime += 3;
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use4"));
        }
        if (card == SkyCard.TNT && this.Challenge.isBattleChallenge()) {
            if (this.MonsterHP > 0) {
                this.MonsterHP /= 2;
            }
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use7"));
        }
        if (card == SkyCard.Card) {
            this.sendRandomCardForAll(2);
            this.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("SkyCard.use6"));
        }
        if (this.Challenge.tryUseCard(this, player, card)) {
            this.goNextChallenge();
            this.point += 50;
        } else {
            --this.damageTime;
            this.tryDamagePlayer();
        }
        this.cardCD = 10;
    }

    public void ChangePlayer(boolean passDamage) {
        ManaMetalModRoot root;
        EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(this.gameplayer));
        if (player != null && (root = MMM.getEntityNBT(player)) != null) {
            root.battleCard.addSkyCard(SkyCard.getRandomrCard(this));
        }
        ++this.gameplayer;
        if (this.gameplayer >= this.players.size()) {
            this.gameplayer = 0;
        }
        this.setGameInfo(this.text("change.player"));
        if (!passDamage) {
            --this.damageTime;
            this.tryDamagePlayer();
        }
    }

    public void tryDamagePlayer() {
        if (this.damageTime <= 0) {
            int damage = this.Challenge.getDamage(this);
            if (this.deftime > 0) {
                --this.deftime;
                damage = (int)((double)damage * 0.6);
            }
            if (M3Config.SoloMode) {
                damage = (int)((double)damage * 0.25);
            }
            if (damage < 0) {
                damage = 1;
            }
            this.HP -= damage;
            this.damageTime = this.Challenge.getDamageTime(this);
            this.setGameInfo(this.text("damage") + damage + this.text("attack.card.2"));
        }
        if (this.HP <= 0) {
            this.gameOver(0);
        }
    }

    public void gameOver(int type) {
        this.setGameInfo(this.text("gameover." + type));
        this.isOver = true;
        this.isStart = false;
        this.landing = false;
        if (type == 0) {
            this.addRewardForPlayer();
        }
        this.tile.func_145831_w().func_147455_a(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, (TileEntity)new TileEntitySkyAdventure());
    }

    public void addRewardForPlayer() {
        for (int s = 0; s < this.players.size(); ++s) {
            EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(s));
            if (player == null) continue;
            this.addRewardForOnlyPlayer(player, s);
        }
    }

    public void addRewardForOnlyPlayer(EntityPlayer player, int s) {
        ManaMetalModRoot root;
        double basehp = this.HP;
        double maxHPs = this.maxHP;
        double hp = basehp / maxHPs;
        if (player != null && (root = MMM.getEntityNBT(player)) != null) {
            int exp_battle = this.exp.get(s);
            int exp = this.exp.get(s) * 30;
            int money = this.treasure.get(s) * 10;
            if (this.island >= 30) {
                this.addItem(5, player);
            } else if (this.island >= 25) {
                this.addItem(4, player);
            } else if (this.island >= 20) {
                this.addItem(3, player);
            } else if (this.island >= 15) {
                this.addItem(2, player);
            } else if (this.island >= 10) {
                this.addItem(1, player);
            } else if (this.island >= 5) {
                this.addItem(0, player);
            }
            root.carrer.addEXP(exp *= this.island);
            player.func_71023_q(exp);
            root.battleCard.addXP(exp_battle *= this.island);
            root.money.addMoney(money *= this.island, MoneySourceType.SkyAdventureGet);
            MMM.addMessage(player, "SkyAdventure.reward", money, exp_battle, exp);
            root.battleCard.getData().heal = (int)((double)root.battleCard.getData().healMax * hp);
            if (root.battleCard.getData().heal < 0) {
                root.battleCard.getData().heal = 0;
            }
            root.battleCard.isInSky = false;
            root.battleCard.send2();
        }
    }

    public void addItem(int id, EntityPlayer player) {
        ItemStack item = new ItemStack(SkyAdventureCore.ItemBagSkyAdventures, 1, id);
        MMM.addMessageGetItem(player, item);
        MMM.addItemToPlayer(item, player);
    }

    public void nextIsland() {
        ++this.island;
        this.point += this.island * 125;
        this.addTreasureAll(100 + this.island * 50);
        this.addExpAll(50 + this.island * 30);
        this.landing = true;
        this.sendEquipmentCardForAll(false);
        this.sendRandomCardForAll(3);
        if (this.island < 13) {
            this.setGameInfo(this.text("nextIsland") + this.text("this.island." + this.island));
        } else {
            this.setGameInfo(this.text("nextIsland") + this.text("this.island.13"));
        }
    }

    public void continueGame() {
        this.landing = false;
        if (this.island < CS.length) {
            this.setChallenge_count(CS[this.island] + this.random.nextInt(2));
        } else {
            this.setChallenge_count(this.island + this.random.nextInt(3));
        }
        if (this.getChallenge_count() > 40) {
            this.setChallenge_count(40);
        }
        this.Challenge = ChallengeType.getRendomTypeFromIsland(this);
        if (this.Challenge.isBattleChallenge()) {
            this.setGameInfo(this.text("Challenge1") + this.Challenge.names());
            this.MonsterHP = this.Challenge.getMonsterHP(this);
            this.MonsterHPMax = this.Challenge.getMonsterHP(this);
        } else if (this.Challenge == ChallengeType.None) {
            this.setGameInfo(this.text("Challenge2"));
        } else if (this.Challenge == ChallengeType.Treasure) {
            this.setGameInfo(this.text("Challenge3"));
        } else {
            this.setGameInfo(this.text("Challenge0") + this.Challenge.names());
        }
    }

    public void goNextChallenge() {
        --this.challenge_count;
        if (this.getChallenge_count() > 0) {
            this.Challenge = ChallengeType.getRendomTypeFromIsland(this);
            this.damageTime = this.Challenge.getDamageTime(this);
            if (this.Challenge.isBattleChallenge()) {
                this.setGameInfo(this.text("Challenge1") + this.Challenge.names());
            } else if (this.Challenge == ChallengeType.None) {
                this.setGameInfo(this.text("Challenge2"));
            } else if (this.Challenge == ChallengeType.Treasure) {
                this.setGameInfo(this.text("Challenge3"));
            } else {
                this.setGameInfo(this.text("Challenges0") + this.Challenge.names());
            }
            if (this.Challenge.isBattleChallenge()) {
                this.MonsterHP = this.Challenge.getMonsterHP(this);
                this.MonsterHPMax = this.Challenge.getMonsterHP(this);
            }
        } else {
            this.nextIsland();
        }
    }

    public void addTreasure(int id, int treasure) {
        this.treasure.set(id, this.treasure.get(id) + treasure);
    }

    public void addTreasureAll(int treasure) {
        for (int s = 0; s < this.treasure.size(); ++s) {
            this.treasure.set(s, this.treasure.get(s) + treasure);
        }
    }

    public void addExp(int id, int exp) {
        this.exp.set(id, this.exp.get(id) + exp);
    }

    public void addExpAll(int exp) {
        for (int s = 0; s < this.exp.size(); ++s) {
            this.exp.set(s, this.exp.get(s) + exp);
        }
    }

    public boolean playerCanUseCard(EntityPlayer player) {
        if (this.cardCD > 0) {
            return false;
        }
        if (!this.isStart || this.isOver || this.landing) {
            return false;
        }
        return this.players.get(this.gameplayer).equals(player.getDisplayName());
    }

    public boolean playerCanDropCard(EntityPlayer player) {
        return this.isStart && !this.isOver && this.landing;
    }

    public void updata() {
        ++this.time;
        if (this.cardCD > 0) {
            --this.cardCD;
        }
        if (this.ClientData) {
            this.setsend();
            this.ClientData = false;
        }
        if (this.time % 10 == 0) {
            this.setsend();
        }
    }

    public void clearAllplayerCard() {
        for (int s = 0; s < this.players.size(); ++s) {
            EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(s));
            if (player != null) {
                ManaMetalModRoot root = MMM.getEntityNBT(player);
                if (root == null) continue;
                root.battleCard.removeSkyCardAll();
                continue;
            }
            MMM.Logg("[ERROR] can't clear player skycard  :" + this.players.get(s));
        }
    }

    public void sendEquipmentCardForAll(boolean isStart) {
        for (int s = 0; s < this.players.size(); ++s) {
            EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(s));
            if (player != null) {
                ManaMetalModRoot root = MMM.getEntityNBT(player);
                if (root == null) continue;
                int size = 0;
                size = root.battleCard.getData().boat.getAttributes()[1];
                if (size > 5) {
                    size = 5;
                }
                for (int z = 0; z < size; ++z) {
                    ItemStack item = root.battleCard.func_70301_a(45 + z);
                    if (item == null || !(item.func_77973_b() instanceof IBattleshipEquipment)) continue;
                    if (isStart) {
                        if (!((IBattleshipEquipment)item.func_77973_b()).onStartCard(item)) continue;
                        root.battleCard.addSkyCard(((IBattleshipEquipment)item.func_77973_b()).getCard(item));
                        continue;
                    }
                    if (!((IBattleshipEquipment)item.func_77973_b()).onLandingCard(item)) continue;
                    root.battleCard.addSkyCard(((IBattleshipEquipment)item.func_77973_b()).getCard(item));
                }
                continue;
            }
            MMM.Logg("[ERROR] can't send skycard to player :" + this.players.get(s));
        }
    }

    public void sendRandomCardForAll(int card) {
        for (int s = 0; s < this.players.size(); ++s) {
            EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(s));
            if (player != null) {
                ManaMetalModRoot root = MMM.getEntityNBT(player);
                if (root == null) continue;
                for (int z = 0; z < card; ++z) {
                    root.battleCard.addSkyCard(SkyCard.getRandomrCard(this));
                }
                continue;
            }
            MMM.Logg("[ERROR] can't send skycard to player :" + this.players.get(s));
        }
    }

    public String getGameInfo() {
        return this.gameInfo;
    }

    public void setGameInfo(String gameInfo) {
        this.gameInfo = gameInfo;
    }

    public void send() {
        this.ClientData = true;
    }

    public void setsend() {
        this.tile.func_145831_w().func_147471_g(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
    }

    public void addMessagePlayer() {
        for (int s = 0; s < this.players.size(); ++s) {
            EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(s));
            if (player == null) continue;
            MMM.addMessage(player, "SkyAdventure.start");
        }
    }

    public void addMessagePlayer(String message) {
        for (int s = 0; s < this.players.size(); ++s) {
            EntityPlayer player = MMM.getPlayer(this.tile.func_145831_w(), this.players.get(s));
            if (player == null) continue;
            MMM.addMessage(player, message);
        }
    }

    public int getChallenge_count() {
        return this.challenge_count;
    }

    public void setChallenge_count(int challenge_count) {
        this.challenge_count = challenge_count;
        if (this.challenge_count > 40) {
            this.challenge_count = 40;
        }
        if (this.challenge_count < 1) {
            this.challenge_count = 1;
        }
    }
}

