/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.soulinherit;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.soulinherit.SoulInheritData;

public class SoulInherit {
    public String player;
    public SoulInheritData[] data = new SoulInheritData[CareerCore.values().length - 1];

    public SoulInherit(String player) {
        this.player = player;
        for (int s = 0; s < this.data.length; ++s) {
            this.data[s] = new SoulInheritData();
            this.data[s].type = CareerCore.values()[s];
        }
    }

    public int totalLVAccurate(ManaMetalModRoot root) {
        int totalLV = 0;
        int LV2 = root.carrer.getLv();
        int[] LVS = this.getLV();
        CareerCore career = CareerCore.getPlayerCarrer(root);
        if (career != null && career != CareerCore.Unknown && career.ordinal() < LVS.length && LV2 > LVS[CareerCore.getPlayerCarrer(root).ordinal()]) {
            LVS[CareerCore.getPlayerCarrer((ManaMetalModRoot)root).ordinal()] = LV2;
        }
        for (int s = 0; s < LVS.length; ++s) {
            totalLV += LVS[s];
        }
        return totalLV;
    }

    public int totalLV() {
        int totalLV = 0;
        for (int s = 0; s < this.data.length; ++s) {
            totalLV += this.data[s].careerLV;
        }
        return totalLV;
    }

    public int[] getLV() {
        int[] datas = new int[this.data.length];
        for (int s = 0; s < datas.length; ++s) {
            datas[s] = this.data[s].careerLV;
        }
        return datas;
    }

    public boolean exist(CareerCore career) {
        return this.data[career.ordinal()].hasSoulInheritData;
    }

    public static void saveToNBT(NBTTagCompound tag, SoulInherit soul) {
        NBTTagList list = new NBTTagList();
        for (int s = 0; s < soul.data.length; ++s) {
            SoulInheritData temp = soul.data[s];
            NBTTagCompound tagtemp = new NBTTagCompound();
            tagtemp.func_74778_a("type", temp.type.toString());
            tagtemp.func_74772_a("careerEXP", temp.careerEXP);
            tagtemp.func_74768_a("careerLV", temp.careerLV);
            tagtemp.func_74768_a("spellPoint", temp.spellPoint);
            tagtemp.func_74768_a("careerPoint", temp.careerPoint);
            tagtemp.func_74768_a("powerPoint", temp.powerPoint);
            tagtemp.func_74768_a("agilePoint", temp.agilePoint);
            tagtemp.func_74768_a("wisdomPoint", temp.wisdomPoint);
            tagtemp.func_74768_a("conPoint", temp.conPoint);
            tagtemp.func_74768_a("wisPoint", temp.wisPoint);
            tagtemp.func_74783_a("spellLV_1", temp.spellLV_1);
            tagtemp.func_74783_a("spellLV_2", temp.spellLV_2);
            tagtemp.func_74757_a("isTransfer2", temp.isTransfer2);
            tagtemp.func_74768_a("usePoint", temp.usePoint);
            tagtemp.func_74768_a("pointNew", temp.pointNew);
            tagtemp.func_74768_a("eatBook", temp.eatBook);
            tagtemp.func_74783_a("spellKey_1", temp.spellKey_1);
            tagtemp.func_74783_a("spellKey_2", temp.spellKey_2);
            tagtemp.func_74783_a("spellKey_3", temp.spellKey_3);
            tagtemp.func_74757_a("hasSoulInheritData", temp.hasSoulInheritData);
            for (int z = 0; z < temp.effect.length; ++z) {
                tagtemp.func_74757_a("e" + z, temp.effect[z]);
            }
            list.func_74742_a((NBTBase)tagtemp);
        }
        tag.func_74782_a("SoulInheritList", (NBTBase)list);
    }

    public static SoulInherit readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagList list = NBTHelp.getNBTTagListSafe("SoulInheritList", nbt, 10, new NBTTagList());
        SoulInherit soul = new SoulInherit(name);
        if (list.func_74745_c() >= soul.data.length) {
            for (int s = 0; s < soul.data.length; ++s) {
                SoulInheritData temp = soul.data[s];
                NBTTagCompound tag = list.func_150305_b(s);
                temp.type = CareerCore.valueOf(NBTHelp.getStringSafe("type", tag, CareerCore.values()[s].toString()));
                temp.careerEXP = NBTHelp.getLongSafe("careerEXP", tag, 0L);
                temp.careerLV = NBTHelp.getIntSafe("careerLV", tag, 1);
                temp.spellPoint = NBTHelp.getIntSafe("spellPoint", tag, 0);
                temp.careerPoint = NBTHelp.getIntSafe("careerPoint", tag, 0);
                temp.powerPoint = NBTHelp.getIntSafe("powerPoint", tag, 0);
                temp.agilePoint = NBTHelp.getIntSafe("agilePoint", tag, 0);
                temp.wisdomPoint = NBTHelp.getIntSafe("wisdomPoint", tag, 0);
                temp.conPoint = NBTHelp.getIntSafe("conPoint", tag, 0);
                temp.wisPoint = NBTHelp.getIntSafe("wisPoint", tag, 0);
                temp.spellLV_1 = NBTHelp.getIntArraySafe("spellLV_1", tag, (int[])temp.spellLV_1.clone());
                temp.spellLV_2 = NBTHelp.getIntArraySafe("spellLV_2", tag, (int[])temp.spellLV_2.clone());
                temp.isTransfer2 = NBTHelp.getBooleanSafe("isTransfer2", tag, false);
                temp.usePoint = NBTHelp.getIntSafe("usePoint", tag, 4);
                temp.pointNew = NBTHelp.getIntSafe("pointNew", tag, 4);
                temp.eatBook = NBTHelp.getIntSafe("eatBook", tag, 0);
                temp.spellKey_1 = NBTHelp.getIntArraySafe("spellKey_1", tag, (int[])temp.spellKey_1.clone());
                temp.spellKey_2 = NBTHelp.getIntArraySafe("spellKey_2", tag, (int[])temp.spellKey_2.clone());
                temp.spellKey_3 = NBTHelp.getIntArraySafe("spellKey_3", tag, (int[])temp.spellKey_3.clone());
                temp.hasSoulInheritData = NBTHelp.getBooleanSafe("hasSoulInheritData", tag, false);
                for (int z = 0; z < temp.effect.length; ++z) {
                    temp.effect[z] = NBTHelp.getBooleanSafe("e" + z, tag, false);
                }
            }
        }
        return soul;
    }

    public void save(ManaMetalModRoot root) {
        if (root != null) {
            CareerCore career = CareerCore.getPlayerCarrer(root);
            SoulInheritData temp = this.data[career.ordinal()];
            temp.careerEXP = root.carrer.getExp();
            temp.careerLV = root.carrer.getLv();
            temp.spellPoint = root.carrer.getSpellPoint();
            temp.careerPoint = root.carrer.getPoints();
            temp.powerPoint = root.carrer.getPowerPoint();
            temp.agilePoint = root.carrer.getAgilePoint();
            temp.wisdomPoint = root.carrer.getIntelligencePoint();
            temp.conPoint = root.carrer.getConPoint();
            temp.wisPoint = root.carrer.getWisPoint();
            temp.spellLV_1 = (int[])root.carrer.getSpellLV_1().clone();
            temp.spellLV_2 = (int[])root.carrer.getSpellLV_2().clone();
            temp.isTransfer2 = root.carrer.isTransfer2();
            temp.effect = (boolean[])root.specialization.getEffect().clone();
            temp.usePoint = root.specialization.usePoint;
            temp.pointNew = root.specialization.pointNew;
            temp.eatBook = root.specialization.eatBook;
            temp.spellKey_1 = (int[])root.carrer.spellKey_1.clone();
            temp.spellKey_2 = (int[])root.carrer.spellKey_2.clone();
            temp.spellKey_3 = (int[])root.carrer.spellKey_3.clone();
            temp.hasSoulInheritData = true;
        }
    }

    public void load(ManaMetalModRoot root, CareerCore career) {
        if (root != null) {
            SoulInheritData temp = this.data[career.ordinal()];
            root.carrer.careerEXP = temp.careerEXP;
            root.carrer.careerLV = temp.careerLV;
            root.carrer.spellPoint = temp.spellPoint;
            root.carrer.careerPoint = temp.careerPoint;
            root.carrer.powerPoint = temp.powerPoint;
            root.carrer.agilePoint = temp.agilePoint;
            root.carrer.intelligencePoint = temp.wisdomPoint;
            root.carrer.conPoint = temp.conPoint;
            root.carrer.wisPoint = temp.wisPoint;
            root.carrer.spellLV_1 = (int[])temp.spellLV_1.clone();
            root.carrer.spellLV_2 = (int[])temp.spellLV_2.clone();
            root.carrer.isTransfer2 = temp.isTransfer2;
            root.carrer.send2();
            root.specialization.setEffect((boolean[])temp.effect.clone());
            root.specialization.usePoint = temp.usePoint;
            root.specialization.pointNew = temp.pointNew;
            root.specialization.eatBook = temp.eatBook;
            root.carrer.spellKey_1 = (int[])temp.spellKey_1.clone();
            root.carrer.spellKey_2 = (int[])temp.spellKey_2.clone();
            root.carrer.spellKey_3 = (int[])temp.spellKey_3.clone();
            temp.hasSoulInheritData = true;
        }
    }
}

