/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.texture;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class TextureCore {
    public static void WriteImage(BufferedImage image, String Filename) {
        try {
            File outputfile = new File(Filename + ".png");
            ImageIO.write((RenderedImage)image, "png", outputfile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BufferedImage LoadImage(String Filename) {
        BufferedImage image;
        try {
            image = ImageIO.read(new File(Filename));
        }
        catch (Exception e) {
            image = null;
        }
        return image;
    }

    public static BufferedImage LoadImageURL(String url) {
        BufferedImage image;
        try {
            URL temp = new URL(url);
            image = ImageIO.read(temp);
        }
        catch (Exception e) {
            image = null;
        }
        return image;
    }

    public static void show(String Filename, BufferedImage image) {
        JFrame windows = new JFrame("");
        JScrollPane scrollPane = new JScrollPane(new JLabel(new ImageIcon(image)));
        windows.getContentPane().add(scrollPane);
        windows.pack();
        windows.setDefaultCloseOperation(3);
        windows.setTitle(Filename + " " + image.getWidth() + " x " + image.getHeight());
        windows.setLocationRelativeTo(null);
        windows.setVisible(true);
    }

    public static BufferedImage Composite(BufferedImage imgBackground, BufferedImage imgForeground) {
        if (!TextureCore.normalCompositePossible(imgBackground, imgForeground)) {
            return null;
        }
        int w = imgBackground.getWidth();
        int h = imgBackground.getHeight();
        BufferedImage imgOutput = new BufferedImage(w, h, imgBackground.getType());
        int[] backgroundData = new int[w * h];
        int[] foregroundData = new int[w * h];
        int[] outputData = new int[w * h];
        imgBackground.getRGB(0, 0, w, h, backgroundData, 0, w);
        imgForeground.getRGB(0, 0, w, h, foregroundData, 0, w);
        for (int i = 0; i < backgroundData.length; ++i) {
            Color colorBackground = new Color(backgroundData[i]);
            Color colorForeground = new Color(foregroundData[i], false);
            outputData[i] = backgroundData[i];
            if ((float)colorForeground.getAlpha() > 0.0f) {
                float alpha = colorForeground.getAlpha();
                float a = colorBackground.getAlpha();
                float r = (float)colorForeground.getRed() * alpha + (float)colorBackground.getRed() * (1.0f - alpha);
                float g = (float)colorForeground.getGreen() * alpha + (float)colorBackground.getGreen() * (1.0f - alpha);
                float b = (float)colorForeground.getBlue() * alpha + (float)colorBackground.getBlue() * (1.0f - alpha);
                outputData[i] = TextureCore.toInt(new Color(r, g, b, a));
                continue;
            }
            outputData[i] = backgroundData[i];
        }
        imgOutput.setRGB(0, 0, w, h, outputData, 0, w);
        return imgOutput;
    }

    private static boolean normalCompositePossible(BufferedImage imgBackground, BufferedImage imgForeground) {
        return imgBackground.getWidth() == imgForeground.getWidth() && imgBackground.getHeight() == imgForeground.getHeight();
    }

    public static int toInt(Color colors) {
        int color = 0;
        color |= (int)((float)colors.getAlpha() * 255.0f) << 24;
        color |= (int)((float)colors.getRed() * 255.0f) << 16;
        color |= (int)((float)colors.getGreen() * 255.0f) << 8;
        return color |= (int)((float)colors.getBlue() * 255.0f);
    }
}

