/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.magicenergy.IMagicEnergyMaker;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;
import project.studio.manametalmod.magicenergy.MagicEnergy;

public class TileEntityManaEnergyGenerator
extends TileEntity
implements IMagicEnergyMaker,
ISidedInventory {
    public MagicEnergy energy;
    public ItemStack[] items = new ItemStack[1];
    public int mana = 0;
    public int time = 0;
    public int timeMAX = 0;
    public int speed = 2;
    public int timeFX = 1;
    public int maxSize = 30000;
    public int timeupdata = 0;

    public TileEntityManaEnergyGenerator() {
        this.energy = new MagicEnergy(0);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
    }

    public TileEntityManaEnergyGenerator(int speed, int timeFX, int maxSize) {
        this.energy = new MagicEnergy(0);
        this.speed = speed;
        this.timeFX = timeFX;
        this.maxSize = maxSize;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.energy.readFromNBT(nbt);
        super.func_145839_a(nbt);
        this.speed = NBTHelp.getIntSafe("speed", nbt, this.speed);
        this.maxSize = NBTHelp.getIntSafe("maxSize", nbt, this.maxSize);
        this.time = nbt.func_74762_e("time");
        this.timeMAX = nbt.func_74762_e("timeMAX");
        this.mana = nbt.func_74762_e("mana");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.length) continue;
            this.items[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        this.energy.writeToNBT(nbt);
        super.func_145841_b(nbt);
        nbt.func_74768_a("speed", this.speed);
        nbt.func_74768_a("maxSize", this.maxSize);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("timeMAX", this.timeMAX);
        nbt.func_74768_a("mana", this.mana);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public boolean getManaItem() {
        int mana = MMM.getManaItemFuelTime(this.items[0]);
        if (mana > 0) {
            this.time = mana / this.timeFX;
            this.timeMAX = mana / this.timeFX;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            IMagicEnergyUse Tile;
            TileEntity tile;
            if (this.time <= 0) {
                if (this.getManaItem()) {
                    if (this.items[0].func_77973_b() == ItemCraft10.BucketMana) {
                        this.items[0] = new ItemStack(Items.field_151133_ar);
                    } else {
                        --this.items[0].field_77994_a;
                    }
                    if (this.items[0].field_77994_a <= 0) {
                        this.items[0] = null;
                    }
                }
            } else if (this.energy.getEnergy() < this.getMaxEnergy()) {
                this.energy.addEnergy(this.speed);
                --this.time;
                if (this.energy.getEnergy() > this.getMaxEnergy()) {
                    this.energy.setEnergy(this.getMaxEnergy());
                }
            }
            if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && tile instanceof IMagicEnergyUse && (Tile = (IMagicEnergyUse)tile).needEnergy()) {
                Tile.getEnergy().moveEnergy(this.energy, Tile, this.MaxOut(this));
                Tile.onImportEnergy();
            }
            ++this.timeupdata;
            if (this.timeupdata > 19) {
                this.timeupdata = 0;
                this.mana = this.energy.getEnergy();
                this.updateData();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void updateData() {
        if (this.mana == 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        } else {
            int id = 1 + this.mana / (this.getMaxEnergy() / 10);
            if (id >= 10) {
                id = 10;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, id, 2);
        }
    }

    @Override
    public boolean canOut() {
        return true;
    }

    @Override
    public int MaxOut(TileEntity tile) {
        return 500;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxSize;
    }

    @Override
    public MagicEnergy getEnergy() {
        return this.energy;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.items[p_70298_1_] != null) {
            if (this.items[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.items[p_70298_1_];
                this.items[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.items[p_70298_1_].field_77994_a == 0) {
                this.items[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack itemstack = this.items[slot];
            this.items[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items[slot] = item;
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[1];
    }

    public boolean func_102007_a(int slot, ItemStack item, int face) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack item, int face) {
        return true;
    }
}

