/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;

public class ChunkProviderFlatMana
implements IChunkProvider {
    private World worldObj;
    private Random random;
    private final Block[] cachedBlockIDs = new Block[256];
    private final byte[] cachedBlockMetadata = new byte[256];
    private final FlatGeneratorInfo flatWorldGenInfo;
    private final List structureGenerators = new ArrayList();

    public ChunkProviderFlatMana(World world, long seed, boolean p4, String worldString) {
        this.worldObj = world;
        this.random = new Random(seed);
        this.flatWorldGenInfo = FlatGeneratorInfo.func_82651_a((String)worldString);
        this.flatWorldGenInfo.func_82650_c().clear();
        this.flatWorldGenInfo.func_82650_c().add(new FlatLayerInfo(1, ItemCraft10.blockU1));
        this.flatWorldGenInfo.func_82650_c().add(new FlatLayerInfo(100, Blocks.field_150350_a));
        this.flatWorldGenInfo.func_82650_c().add(new FlatLayerInfo(1, ItemCraft10.blockU2));
        this.flatWorldGenInfo.func_82645_d();
        for (FlatLayerInfo flatlayerinfo : this.flatWorldGenInfo.func_82650_c()) {
            for (int j = flatlayerinfo.func_82656_d(); j < flatlayerinfo.func_82656_d() + flatlayerinfo.func_82657_a(); ++j) {
                this.cachedBlockIDs[j] = flatlayerinfo.func_151536_b();
                this.cachedBlockMetadata[j] = (byte)flatlayerinfo.func_82658_c();
            }
        }
    }

    public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
        return this.func_73154_d(p_73158_1_, p_73158_2_);
    }

    public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
        int l;
        Chunk chunk = new Chunk(this.worldObj, p_73154_1_, p_73154_2_);
        for (int k = 0; k < this.cachedBlockIDs.length; ++k) {
            Block block = this.cachedBlockIDs[k];
            if (block == null) continue;
            l = k >> 4;
            ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[l];
            if (extendedblockstorage == null) {
                chunk.func_76587_i()[l] = extendedblockstorage = new ExtendedBlockStorage(k, !this.worldObj.field_73011_w.field_76576_e);
            }
            for (int i1 = 0; i1 < 16; ++i1) {
                for (int j1 = 0; j1 < 16; ++j1) {
                    extendedblockstorage.func_150818_a(i1, k & 0xF, j1, block);
                    extendedblockstorage.func_76654_b(i1, k & 0xF, j1, (int)this.cachedBlockMetadata[k]);
                }
            }
        }
        chunk.func_76603_b();
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, p_73154_1_ * 16, p_73154_2_ * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)abiomegenbase[l].field_76756_M;
        }
        for (MapGenBase mapgenbase : this.structureGenerators) {
            mapgenbase.func_151539_a((IChunkProvider)this, this.worldObj, p_73154_1_, p_73154_2_, (Block[])null);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int cX, int cY) {
        int k1;
        int i2;
        int l1;
        int k = cX * 16;
        int l = cY * 16;
        this.worldObj.func_72807_a(k + 16, l + 16);
        this.random.setSeed(this.worldObj.func_72905_C());
        long i1 = this.random.nextLong() / 2L * 2L + 1L;
        long j1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)cX * i1 + (long)cY * j1 ^ this.worldObj.func_72905_C());
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_75051_a(this.worldObj, this.random, cX, cY);
        }
        for (l1 = 0; l1 < 4; ++l1) {
            i2 = k + this.random.nextInt(16) + 8;
            k1 = l + this.random.nextInt(16) + 8;
            this.setStoneNoRndBlock(this.worldObj, this.worldObj.field_73012_v, i2, 35, k1);
        }
        for (l1 = 0; l1 < 8; ++l1) {
            i2 = k + this.random.nextInt(16) + 8;
            k1 = l + this.random.nextInt(16) + 8;
            int k2 = this.random.nextInt(10) + 20;
            for (int i = 0; i < 3; ++i) {
                this.worldObj.func_147465_d(i2, k2 + i, k1, Blocks.field_150371_ca, 2, 2);
            }
        }
        for (l1 = 0; l1 < 4; ++l1) {
            i2 = k + this.random.nextInt(16) + 8;
            k1 = l + this.random.nextInt(16) + 8;
            this.setStoneNoRndBlockU2(this.worldObj, this.worldObj.field_73012_v, i2, 5, k1);
        }
    }

    public void setStoneNoRndBlockU2(World world, Random random, int x, int y, int z) {
        int t;
        int c;
        int d;
        for (d = 0; d < 5; ++d) {
            for (c = 0; c < 7; ++c) {
                for (t = 0; t < 5; ++t) {
                    world.func_147449_b(x + 1 + d, y + t, z + c, ItemCraft10.blockU2);
                }
            }
        }
        for (d = 0; d < 7; ++d) {
            for (c = 0; c < 5; ++c) {
                for (t = 0; t < 5; ++t) {
                    world.func_147449_b(x + d, y + t, z + 1 + c, ItemCraft10.blockU2);
                }
            }
        }
    }

    public void setStoneNoRndBlock(World world, Random random, int x, int y, int z) {
        int t;
        int c;
        int d;
        for (d = 0; d < 5; ++d) {
            for (c = 0; c < 7; ++c) {
                for (t = 0; t < 1; ++t) {
                    world.func_147449_b(x + 1 + d, y + t, z + c, ItemCraft10.blockU1);
                }
            }
        }
        for (d = 0; d < 7; ++d) {
            for (c = 0; c < 5; ++c) {
                for (t = 0; t < 1; ++t) {
                    world.func_147449_b(x + d, y + t, z + 1 + c, ItemCraft10.blockU1);
                }
            }
        }
    }

    public void WorldGenAncientHedgee(World world, Random random, int x, int y, int z) {
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "FlatLevelSource";
    }

    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(p_73155_2_, p_73155_4_);
        return biomegenbase.func_76747_a(p_73155_1_);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        if ("Stronghold".equals(p_147416_2_)) {
            for (MapGenStructure mapgenstructure : this.structureGenerators) {
                if (!(mapgenstructure instanceof MapGenStronghold)) continue;
                return mapgenstructure.func_151545_a(p_147416_1_, p_147416_3_, p_147416_4_, p_147416_5_);
            }
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_151539_a((IChunkProvider)this, this.worldObj, p_82695_1_, p_82695_2_, (Block[])null);
        }
    }
}

