/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.zombiedoomsday;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.zombiedoomsday.EntityGrenadeBase;

public class EntityGrenade
extends EntityGrenadeBase
implements IEntityAdditionalSpawnData {
    private int explodefuse;
    private boolean extinguished;
    public int type;

    public EntityGrenade(World world) {
        super(world);
        this.setPickupMode(0);
        this.extinguished = false;
        this.explodefuse = 50;
    }

    public EntityGrenade(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityGrenade(World world, EntityLivingBase entityliving, int time, int type) {
        this(world);
        this.field_70250_c = entityliving;
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.7f, 4.0f);
        this.explodefuse = time;
        this.type = type;
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70125_A = !this.field_70254_i && !this.beenInGround ? (this.field_70125_A -= 50.0f) : 180.0f;
        if (this.type == 1) {
            for (int s = 0; s < 4; ++s) {
                FXHelp.spawnParticle(this.field_70170_p, Particle.smoke2, this.field_70165_t + (double)this.field_70170_p.field_73012_v.nextInt(7) - 3.0, this.field_70163_u + (double)this.field_70170_p.field_73012_v.nextInt(7) - 3.0, this.field_70161_v + (double)this.field_70170_p.field_73012_v.nextInt(7) - 3.0);
            }
        }
        --this.explodefuse;
        if (!this.extinguished && this.explodefuse <= 0) {
            this.detonate();
            this.func_70106_y();
        }
    }

    @Override
    public void onEntityHit(Entity entity) {
    }

    @Override
    public void onGroundHit(MovingObjectPosition mop) {
        this.xTile = mop.field_72311_b;
        this.yTile = mop.field_72312_c;
        this.zTile = mop.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = (float)(mop.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(mop.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(mop.field_72307_f.field_72449_c - this.field_70161_v);
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70159_w *= -0.2;
        this.field_70179_y *= -0.2;
        if (mop.field_72310_e == 1) {
            this.field_70254_i = true;
            this.beenInGround = true;
        } else {
            this.field_70254_i = false;
            this.field_70170_p.func_72956_a((Entity)this, "random.fizz", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        }
        if (this.inTile != null) {
            this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    public void detonate() {
        if (!this.field_70170_p.field_72995_K && this.extinguished && (this.field_70252_j >= 200 || this.field_70257_an >= 200)) {
            this.func_70106_y();
        }
        if (this.type == 0) {
            MMM.fakeExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3, 150.0f, true);
        }
        if (this.type == 2) {
            MMM.fakeExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 30.0f, true);
            this.doFlash();
        }
    }

    public void doFlash() {
        if (!this.field_70170_p.field_72995_K) {
            List<EntityPlayer> players = MMM.findPlayers((Entity)this, 32);
            for (int s = 0; s < players.size(); ++s) {
                if (!players.get(s).func_70685_l((Entity)this)) continue;
                PacketHandlerMana.INSTANCE.sendTo((IMessage)new MessageFX(9, 0.0f, 0.0f, 0.0f, 0, 0, 0), (EntityPlayerMP)players.get(s));
            }
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public ItemStack getPickupItem() {
        return new ItemStack(Items.field_151032_g, 1);
    }

    @Override
    public float func_70053_R() {
        return 0.2f;
    }

    @Override
    public void playHitSound() {
        this.field_70170_p.func_72956_a((Entity)this, "random.fizz", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74774_a("fuse", (byte)this.explodefuse);
        nbttagcompound.func_74757_a("off", this.extinguished);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.explodefuse = nbttagcompound.func_74771_c("fuse");
        this.extinguished = nbttagcompound.func_74767_n("off");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.explodefuse);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.type = additionalData.readInt();
        this.explodefuse = additionalData.readInt();
    }
}

