/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.atlantis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.EntityTag;
import project.studio.manametalmod.api.IEntityTag;
import project.studio.manametalmod.api.ISynchronousEntity;
import project.studio.manametalmod.atlantis.EntityBossCrystalOmicron;
import project.studio.manametalmod.atlantis.OmicronCrystalType;
import project.studio.manametalmod.atlantis.OmicronTowerType;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.FloatingPos;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.ProjectileHelp;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.magic.EntityLightningBoltPower;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.Entity3DThrowable;
import project.studio.manametalmod.mob.EntityBlossRune;
import project.studio.manametalmod.mob.EntityMagicObject;
import project.studio.manametalmod.mob.IBlossCrystal;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;

public class EntityBossOmicronTower
extends EntityCreature
implements IEntityAdditionalSpawnData,
IBlossCrystal,
ISynchronousEntity,
IEntityTag {
    public boolean isfire;
    public OmicronTowerType towertype = OmicronTowerType.Laser;
    public int time = 0;
    public int attacktime = 0;
    public int towerHP = 10000;
    public EntityPlayer target = null;
    public float dx;
    public float dy;
    public float dz;
    public IDungeonDifficult Difficult = IDungeonDifficult.EASY;
    public boolean locktarget = false;
    public int data1;
    public int data2;
    public int data3;
    public Pos poscenter = new Pos(0, 0, 0);
    public int spawnPosType = 0;
    public int bossStage = 0;
    public int maxHP = 1000;
    public static final EntityTag[] tag = new EntityTag[]{EntityTag.NoExtraHP};

    public EntityBossOmicronTower(World World2) {
        super(World2);
        this.func_70105_a(1.25f, 4.0f);
        this.field_70178_ae = false;
        this.field_70138_W = 0.0f;
        this.field_70145_X = false;
        this.func_110163_bv();
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void laserAttack() {
        float attack = 0.3f * (float)(this.Difficult.ordinal() + 1);
        List<FloatingPos> list = MMM.getLaserPos(new FloatingPos().from((Entity)this), new FloatingPos(this.dx, this.dy, this.dz), 0.4f);
        List players = null;
        FloatingPos temp = null;
        int size = list.size();
        for (int s = 0; s < size; ++s) {
            players = new ArrayList(8);
            temp = list.get(s);
            players = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(temp.dx - 0.5), (double)(temp.dy - 0.5), (double)(temp.dz - 0.5), (double)(temp.dx + 0.5), (double)(temp.dy + 0.5), (double)(temp.dz + 0.5)));
            if (players.isEmpty()) continue;
            int sizet = players.size();
            for (int t = 0; t < sizet; ++t) {
                ((EntityPlayer)players.get(t)).func_70097_a(AttackType.ChaosDamage, ((EntityPlayer)players.get(t)).func_110138_aP() * attack);
                if (!M3Config.DEBUG) continue;
                MMM.addMessage((EntityPlayer)players.get(t), "attack target");
            }
        }
    }

    public void plasmaAttack(EntityLivingBase target) {
        int attack = 30000 * (this.Difficult.ordinal() + 1);
        ProjectileHelp.doBallAttackV2(this.field_70170_p, (EntityLivingBase)this, target, 0.15f, ManaElements.Light, 104, attack, 1.5f, -1, false);
    }

    public void fireAttack(EntityLivingBase target) {
        int attack = 30000 * (this.Difficult.ordinal() + 1);
        ProjectileHelp.doBallAttackV2(this.field_70170_p, (EntityLivingBase)this, target, 1.0f, ManaElements.Fire, 105, attack, 1.5f, -1, true);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.spawn();
        this.dead();
        ++this.time;
        this.field_70158_ak = true;
        switch (this.towertype) {
            case Laser: {
                if (this.field_70170_p.field_72995_K) break;
                if (this.target == null && !this.locktarget && this.time % 2 == 0) {
                    List<EntityPlayer> list = MMM.findPlayersNoCreateCanSee((Entity)this, 64.0f);
                    for (int s = 0; s < list.size(); ++s) {
                        EntityPlayer player = list.get(s);
                        if (!MMM.canEntityBeSeen(this.field_70170_p, (Entity)player, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v) || MMM.isPlayerCreativeMode(player)) continue;
                        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(64, 0.0, 0.0, 0.0, this.field_70165_t, this.field_70163_u, this.field_70161_v).setData(player.func_145782_y(), this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                        this.target = player;
                        break;
                    }
                }
                if (this.target != null && this.target.field_70128_L) {
                    this.target = null;
                    return;
                }
                int chargetime = 60;
                int lasertime = 40;
                switch (this.Difficult) {
                    case EASY: 
                    case NORMAL: {
                        chargetime = 60;
                        lasertime = 40;
                        break;
                    }
                    case HARD: {
                        chargetime = 50;
                        lasertime = 30;
                        break;
                    }
                    case HELL: {
                        chargetime = 40;
                        lasertime = 20;
                    }
                }
                if (this.target != null && !this.locktarget) {
                    ++this.attacktime;
                    if (this.attacktime > chargetime) {
                        this.dx = (float)this.target.field_70165_t;
                        this.dy = (float)this.target.field_70163_u + (this.target.func_70047_e() - 0.3f);
                        this.dz = (float)this.target.field_70161_v;
                        this.locktarget = true;
                        this.attacktime = 0;
                        this.target = null;
                        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(65, (double)this.dx, (double)this.dy, (double)this.dz, this.field_70165_t, this.field_70163_u, this.field_70161_v).setData(this.func_145782_y(), 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                    }
                }
                if (!this.locktarget) break;
                ++this.attacktime;
                if (this.attacktime <= lasertime) break;
                this.locktarget = false;
                this.attacktime = 0;
                if (MMM.getBlockDistance(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.dx, this.dy, this.dz) >= 256) break;
                this.laserAttack();
                MMM.playSoundFromServer(this.field_70170_p, ManaElements.getElementsSounds(ManaElements.Dark), (Entity)this, 10.0, 0.75, 64.0);
                PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(66, (double)this.dx, (double)this.dy, (double)this.dz, this.field_70165_t, this.field_70163_u, this.field_70161_v).setData(this.func_145782_y(), 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                break;
            }
            case Plasma: {
                if (this.field_70170_p.field_72995_K) break;
                if (this.target == null && this.time % 2 == 0) {
                    this.target = MMM.getClosestPlayerNoCreateCanSee((Entity)this, 64.0);
                }
                if (this.target != null && this.target.field_70128_L) {
                    this.target = null;
                    return;
                }
                if (this.target == null) break;
                ++this.attacktime;
                if (this.attacktime == 60 || this.attacktime == 70 || this.attacktime == 80 || this.Difficult == IDungeonDifficult.HARD && this.attacktime == 90 || this.Difficult == IDungeonDifficult.HARD && this.attacktime == 100 || this.Difficult == IDungeonDifficult.HELL && this.attacktime == 110 || this.Difficult == IDungeonDifficult.HELL && this.attacktime == 120) {
                    this.plasmaAttack((EntityLivingBase)this.target);
                }
                if (this.attacktime <= 125) break;
                this.attacktime = 0;
                this.target = null;
                break;
            }
            case Tesla: {
                int s;
                List<EntityPlayer> list;
                if (this.field_70170_p.field_72995_K) break;
                ++this.attacktime;
                if (this.attacktime == 30 || this.attacktime == 60 || this.attacktime == 90 || this.attacktime == 120 || this.attacktime == 150) {
                    list = MMM.findPlayersNoCreateCanSee((Entity)this, 32.0f);
                    int size = list.size();
                    for (s = 0; s < size; ++s) {
                        MMM.spawnRuneFXServerSound((EntityLivingBase)list.get(s), ManaElements.Thunder, 200, 2.0f, true, 5, true);
                    }
                }
                if (this.attacktime <= 200) break;
                this.attacktime = -200;
                if (this.Difficult.ordinal() > 1) {
                    this.attacktime = -100;
                }
                list = MMM.findEntity((Entity)this, 80);
                for (s = 0; s < list.size(); ++s) {
                    if (!(list.get(s) instanceof EntityBlossRune)) continue;
                    EntityBlossRune rune = (EntityBlossRune)list.get(s);
                    if (!rune.isMob || rune.Elements != ManaElements.Thunder) continue;
                    EntityLightningBoltPower bolt = MMM.arcLightning_vanilla(this.field_70170_p, rune.field_70165_t, rune.field_70163_u, rune.field_70161_v, 90000 * (1 + this.Difficult.ordinal()), 255.0f, 0.0f, 0.0f);
                    bolt.hittype = 2;
                    rune.func_70106_y();
                }
                break;
            }
            case EternalTablet: {
                if (this.field_70170_p.field_72995_K) break;
                --this.attacktime;
                if (this.attacktime > 0) break;
                this.attacktime = 400;
                switch (this.Difficult) {
                    case EASY: {
                        this.attacktime = 600;
                        break;
                    }
                    case NORMAL: {
                        this.attacktime = 400;
                        break;
                    }
                    case HARD: {
                        this.attacktime = 300;
                        break;
                    }
                    case HELL: {
                        this.attacktime = 200;
                    }
                }
                for (int s = 0; s < 5 && !this.spawnCrystal(); ++s) {
                }
                break;
            }
            case Fire: {
                if (this.field_70170_p.field_72995_K) break;
                if (this.target == null && this.time % 2 == 0) {
                    this.target = MMM.getClosestPlayerNoCreateCanSee((Entity)this, 64.0);
                }
                if (this.target != null && this.target.field_70128_L) {
                    this.target = null;
                    return;
                }
                if (this.target == null) break;
                ++this.attacktime;
                if (this.attacktime == 60) {
                    this.fireAttack((EntityLivingBase)this.target);
                    this.target = null;
                }
                if (this.attacktime <= 200) break;
                this.attacktime = 0;
                break;
            }
            case Frost: {
                List<EntityPlayer> list;
                if (this.field_70170_p.field_72995_K) break;
                ++this.attacktime;
                if (this.attacktime == 100) {
                    this.attacktime = -250;
                    int count = 32;
                    int explodetime = 200;
                    float damage = 0.3f;
                    switch (this.Difficult) {
                        case EASY: {
                            count = 32;
                            damage = 0.3f;
                            explodetime = 200;
                            break;
                        }
                        case NORMAL: {
                            count = 28;
                            damage = 0.8f;
                            explodetime = 200;
                            break;
                        }
                        case HARD: {
                            count = 20;
                            damage = 0.9f;
                            explodetime = 150;
                            break;
                        }
                        case HELL: {
                            count = 16;
                            damage = 1.5f;
                            explodetime = 100;
                        }
                    }
                    for (int dx = -19; dx < 20; ++dx) {
                        for (int dz = -19; dz < 20; ++dz) {
                            if (this.field_70170_p.field_73012_v.nextInt(count) != 0) continue;
                            EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, explodetime, 79, damage, (EntityLivingBase)this);
                            obj.func_70080_a((float)(this.poscenter.X + dx) + 0.5f, (float)this.poscenter.Y + 1.6f, (float)(this.poscenter.Z + dz) + 0.5f, 0.0f, 0.0f);
                            this.field_70170_p.func_72838_d((Entity)obj);
                        }
                    }
                }
                if (this.Difficult != IDungeonDifficult.HELL || this.time % 10 != 0 || (list = MMM.findPlayersNoCreateCanSee((Entity)this, 64.0f)).isEmpty()) break;
                for (int s = 0; s < list.size(); ++s) {
                    list.get(s).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 100, 0));
                }
                break;
            }
            case Darkness: {
                if (this.field_70170_p.field_72995_K) break;
                if (this.target == null && this.time % 2 == 0) {
                    this.target = MMM.getClosestPlayerNoCreateCanSee((Entity)this, 64.0);
                }
                if (this.target != null && this.target.field_70128_L) {
                    this.target = null;
                    return;
                }
                if (this.target == null) break;
                --this.attacktime;
                if (this.attacktime > 0) break;
                float speed = 1.0f;
                this.attacktime = 100;
                switch (this.Difficult) {
                    case EASY: {
                        speed = 0.5f;
                        this.attacktime = 120;
                        break;
                    }
                    case NORMAL: {
                        speed = 0.5f;
                        this.attacktime = 100;
                        break;
                    }
                    case HARD: {
                        speed = 0.75f;
                        this.attacktime = 70;
                        break;
                    }
                    case HELL: {
                        speed = 1.0f;
                        this.attacktime = 50;
                    }
                }
                this.doArrowAttackBig(this.field_70165_t, this.field_70163_u + 3.5, this.field_70161_v, (EntityLivingBase)this.target, 42000 * (1 + this.Difficult.ordinal()), speed);
                this.target = null;
            }
        }
    }

    public boolean spawnCrystal() {
        OmicronCrystalType ctype;
        int z;
        int x = this.field_70170_p.field_73012_v.nextBoolean() ? -9 : 9;
        List<Entity> list = MMM.findEntity(this.field_70170_p, (float)(this.poscenter.X + x) + 0.5f, (float)this.poscenter.Y + 1.1f, (float)(this.poscenter.Z + (z = this.field_70170_p.field_73012_v.nextBoolean() ? -9 : 9)) + 0.5f, 4.0);
        if (!list.isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof EntityBossCrystalOmicron)) continue;
                return false;
            }
        }
        EntityBossCrystalOmicron entity = new EntityBossCrystalOmicron(this.field_70170_p);
        entity.func_70107_b((float)(this.poscenter.X + x) + 0.5f, (float)this.poscenter.Y + 1.1f, (float)(this.poscenter.Z + z) + 0.5f);
        entity.crystaltype = ctype = OmicronCrystalType.values()[this.field_70170_p.field_73012_v.nextInt(OmicronCrystalType.values().length)];
        int maxHP = 999900;
        switch (this.Difficult) {
            case EASY: {
                maxHP += 1000000;
                break;
            }
            case NORMAL: {
                maxHP += 2000000;
                break;
            }
            case HARD: {
                maxHP += 20000000;
                break;
            }
            case HELL: {
                maxHP += 120000000;
            }
        }
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "TowerHP", (double)maxHP, 0));
        entity.func_110140_aT().func_111147_b((Multimap)attributes);
        entity.func_70606_j(entity.func_110138_aP());
        this.field_70170_p.func_72838_d((Entity)entity);
        MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.EntityBossOmicronTower.spawnCrystal", MMM.getTranslateText("EntityBossCrystalOmicron." + (Object)((Object)ctype)));
        return true;
    }

    public void doArrowAttackBig(double x, double y, double z, EntityLivingBase target, int arrowDamage, float speed) {
        Entity3DThrowable arrow = new Entity3DThrowable(this.field_70170_p, (EntityLivingBase)this, arrowDamage, ManaElements.Fire, 38, 400);
        arrow.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        arrow.field_70125_A -= -20.0f;
        double d0 = target.field_70165_t + target.field_70159_w - this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
        double d1 = target.field_70163_u + (double)0.8f - this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
        double d2 = target.field_70161_v + target.field_70179_y - this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        arrow.func_70186_c(d0, d1, d2, 1.5f, 1.0f);
        arrow.field_70159_w *= (double)speed;
        arrow.field_70181_x *= (double)speed;
        arrow.field_70179_y *= (double)speed;
        this.field_70170_p.func_72838_d((Entity)arrow);
        target.field_70170_p.func_72956_a((Entity)target, "random.bow", 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
    }

    public void dead() {
        if (!this.field_70170_p.field_72995_K && this.towerHP <= 0) {
            MMM.fakeExplosion(this.field_70170_p, (Entity)this, 1, 100.0f, true);
            this.func_70106_y();
        }
    }

    public void setAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.maxHP);
        this.func_70606_j(this.func_110138_aP());
        this.synchronousLivingTag((EntityLiving)this, 64.0f);
    }

    public void spawn() {
        if (!this.isfire) {
            this.isfire = true;
            MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, 0.0f, 85.0f, 255.0f);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == AttackType.Kill || source == AttackType.ThunderAmplification) {
            return super.func_70097_a(source, damage);
        }
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70664_aZ() {
    }

    public void func_70612_e(float f1, float f2) {
    }

    public void func_70100_b_(EntityPlayer EntityPlayer2) {
    }

    protected void func_70670_a(PotionEffect PotionEffect2) {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("towertype", this.towertype.ordinal());
        nbt.func_74768_a("spawnPosType", this.spawnPosType);
        nbt.func_74768_a("bossStage", this.bossStage);
        nbt.func_74768_a("maxHP", this.maxHP);
        nbt.func_74768_a("Difficult", this.Difficult.ordinal());
        nbt.func_74757_a("isfire", this.isfire);
        this.poscenter.saveToNBT(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.towertype = OmicronTowerType.values()[NBTHelp.getIntSafe("towertype", nbt, 0)];
        this.spawnPosType = NBTHelp.getIntSafe("spawnPosType", nbt, 0);
        this.bossStage = NBTHelp.getIntSafe("bossStage", nbt, 0);
        this.maxHP = NBTHelp.getIntSafe("maxHP", nbt, 0);
        this.Difficult = IDungeonDifficult.values()[NBTHelp.getIntSafe("Difficult", nbt, 0)];
        this.isfire = NBTHelp.getBooleanSafe("isfire", nbt, false);
        this.poscenter.readFromNBT(nbt);
    }

    public void readSpawnData(ByteBuf data) {
        this.towertype = OmicronTowerType.values()[data.readInt()];
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.towertype.ordinal());
    }

    @Override
    public EntityTag[] getEntityTags() {
        return tag;
    }

    public String func_70005_c_() {
        return MMM.getTranslateText("EntityBossOmicronTower." + (Object)((Object)this.towertype));
    }
}

