/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.auction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.auction.AuctionCommodity;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.mail.Mail;
import project.studio.manametalmod.mail.MailCore;
import project.studio.manametalmod.mail.Stationery;

public final class Auction {
    public static final List<AuctionCommodity> items = new ArrayList<AuctionCommodity>();
    public static final Map<String, Integer> players = new HashMap<String, Integer>();
    public static final int max_sell_count = 20;
    public static final boolean needUpdate = false;
    public static final String lsitname = "AuctionList";
    public static final String mapname = "AuctionMap";
    public static int time = 0;

    public static final boolean sell(ItemStack item, EntityPlayer player, int money) {
        if (item == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (money <= 0) {
            return false;
        }
        String name = player.func_70005_c_();
        if (players.containsKey(name)) {
            Integer count = players.get(name);
            if (count < 20) {
                players.put(name, count + 1);
                items.add(new AuctionCommodity(item.func_77946_l(), name, money));
                MMM.addMessage(player, "MMM.info.sellAuction");
                return true;
            }
            MMM.addMessage(player, "MMM.info.cantsellitemAuction");
            return false;
        }
        players.put(name, 1);
        items.add(new AuctionCommodity(item.func_77946_l(), name, money));
        MMM.addMessage(player, "MMM.info.sellAuction");
        return true;
    }

    public static final boolean buy(EntityPlayer player, int id, long money) {
        AuctionCommodity temp;
        if (id < items.size() && (temp = items.get(id)).canBuy() && money >= (long)temp.money) {
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            root.money.addMoney(-temp.money, MoneySourceType.BuyAuction);
            MMM.spawnItemToPlayer(temp.item.func_77946_l(), player);
            MMM.addMessage(player, "MMM.info.buyAuction", temp.item.func_82833_r(), temp.money);
            String name_sell = Auction.items.get((int)id).name;
            Mail Mails = new Mail(MMM.getTranslateText("MMM.info.sellAuction"), temp.item.func_82833_r() + MMM.getTranslateText("MMM.info.sellAuctionMoney"), name_sell, "system", Auction.items.get((int)id).money, null, Stationery.None);
            MailCore.sendMail(Mails, player.field_70170_p);
            if (players.containsKey(name_sell)) {
                int count = players.get(name_sell) - 1;
                players.put(name_sell, count);
            }
            items.get(id).clear();
            return true;
        }
        MMM.addMessage(player, "MMM.info.buyAuctionfail");
        return false;
    }

    public static void update(World world) {
        if (++time > 199) {
            time = 0;
            if (items.isEmpty()) {
                return;
            }
            for (int s = 0; s < items.size(); ++s) {
                AuctionCommodity temp = items.get(s);
                if (!temp.canBuy()) {
                    items.remove(s);
                    --s;
                    continue;
                }
                --temp.time;
                if (temp.time > 0) continue;
                Mail Mails = new Mail(MMM.getTranslateText("MMM.info.sellAuctionMail_fail"), MMM.getTranslateText("MMM.info.sellAuctionMail_fail2"), temp.name, "system", 0L, new ItemStack[]{temp.item.func_77946_l()}, Stationery.None);
                MailCore.sendMail(Mails, world);
                temp.clear();
            }
        }
    }

    public static void serverStart(WorldEvent.Load event) {
        try {
            if (MMM.getDimensionID(event.world) == 0 && !event.world.field_72995_K) {
                NBTTagCompound tag;
                int s;
                int size;
                NBTTagList list;
                items.clear();
                players.clear();
                if (MMM.getWorldData(event.world).getData().func_150297_b(lsitname, 9)) {
                    list = MMM.getWorldData(event.world).getData().func_150295_c(lsitname, 10);
                    size = list.func_74745_c();
                    for (s = 0; s < size; ++s) {
                        tag = list.func_150305_b(s);
                        ItemStack temp = ItemStack.func_77949_a((NBTTagCompound)tag);
                        if (temp == null) continue;
                        AuctionCommodity acon = new AuctionCommodity(temp.func_77946_l(), tag.func_74779_i("name"), tag.func_74762_e("money"));
                        acon.time = tag.func_74762_e("time");
                        items.add(acon);
                    }
                }
                if (MMM.getWorldData(event.world).getData().func_150297_b(mapname, 9)) {
                    list = MMM.getWorldData(event.world).getData().func_150295_c(mapname, 10);
                    size = list.func_74745_c();
                    for (s = 0; s < size; ++s) {
                        tag = list.func_150305_b(s);
                        players.put(tag.func_74779_i("name"), tag.func_74762_e("count"));
                    }
                }
                for (int s2 = 0; s2 < items.size(); ++s2) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void serverStop(WorldEvent.Save event) {
        try {
            if (MMM.getDimensionID(event.world) == 0 && !event.world.field_72995_K) {
                NBTTagList list = new NBTTagList();
                for (int s = 0; s < items.size(); ++s) {
                    NBTTagCompound tag = new NBTTagCompound();
                    AuctionCommodity temp = items.get(s);
                    if (temp.item == null) continue;
                    temp.item.func_77955_b(tag);
                    tag.func_74768_a("money", temp.money);
                    tag.func_74768_a("time", temp.time);
                    tag.func_74778_a("name", temp.name);
                    list.func_74742_a((NBTBase)tag);
                }
                MMM.getWorldData(event.world).getData().func_74782_a(lsitname, (NBTBase)list);
                NBTTagList list2 = new NBTTagList();
                for (Map.Entry<String, Integer> entry : players.entrySet()) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74768_a("count", entry.getValue().intValue());
                    tag.func_74778_a("name", entry.getKey());
                    list2.func_74742_a((NBTBase)tag);
                }
                MMM.getWorldData(event.world).getData().func_74782_a(mapname, (NBTBase)list2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

