/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import project.studio.manametalmod.WitheGoldList;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.TextEncryption;
import project.studio.manametalmod.mission.Mission;
import project.studio.manametalmod.mission.MissionJsonUtil;
import project.studio.manametalmod.mission.MissionTarget;
import project.studio.manametalmod.mission.MissionTargetType;
import project.studio.manametalmod.mission.MissionType;

public class M3Test {
    public static final void main(String[] data) {
        System.out.print("M3Test start 3");
        System.out.println("  \r\n");
        M3Test.whitegold();
    }

    public static final void mission() {
        Mission mm = new Mission("test", MissionType.MAIN, UUID.randomUUID());
        mm.addReward(100);
        mm.addTarget(new MissionTarget(MissionTargetType.KILL_TARGET, 100));
        mm.addTarget(new MissionTarget(MissionTargetType.BREAK_BLOCK, 25));
        mm.addTarget(new MissionTarget(MissionTargetType.SUBMIT_ITEM, 100));
        String json = MissionJsonUtil.toJson(mm);
        System.out.println(json);
        System.out.println("  \r\n");
        Mission m2 = MissionJsonUtil.fromJson(json);
        m2.printMission();
    }

    public static final void deNetStroeItems() {
        try {
            String line;
            String targetUrl = "https://www.manametal.net/api/cashshop/whitegoldshoplist.php";
            URL url = new URL(targetUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setRequestProperty("User-agent", "IE/11.0");
            connection.setRequestProperty("Accept", "application/json; charset=utf-8");
            int responseCode = connection.getResponseCode();
            System.out.print("responseCode V3 : " + responseCode + "  \r\n");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            connection.disconnect();
            String jsonString = sb.toString();
            Gson gson = new Gson();
            JsonParser JP = new JsonParser();
            JsonObject root = JP.parse(jsonString).getAsJsonObject();
            String[] categories = new String[]{"fashion", "effects", "decoration", "other"};
            HashMap<String, List> categorizedItems = new HashMap<String, List>();
            for (String category2 : categories) {
                ArrayList<Item> itemList = new ArrayList<Item>();
                JsonArray itemsArray = root.getAsJsonArray(category2);
                if (itemsArray != null) {
                    for (JsonElement element : itemsArray) {
                        JsonObject itemJson = element.getAsJsonObject();
                        int id = itemJson.get("id").getAsInt();
                        String name = itemJson.get("name").getAsString();
                        int price = itemJson.get("price").getAsInt();
                        itemList.add(new Item(id, name, price));
                    }
                }
                categorizedItems.put(category2, itemList);
            }
            categorizedItems.forEach((category, items) -> {
                System.out.println("\n *****[" + category.toUpperCase() + "]*****");
                items.forEach(System.out::println);
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testDecryptedText() {
    }

    private static void decryptFromBase64(final String key) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] decodedBytes;
                    String line;
                    String targetUrl = "https://www.manametal.net/api/cashshop/webinventory.php?list=1";
                    URL url = new URL(targetUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("User-agent", "IE/11.0");
                    connection.setRequestProperty("Accept", "application/json; charset=utf-8");
                    int responseCode = connection.getResponseCode();
                    System.out.print("responseCode V3 : " + responseCode + "  \r\n");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    StringBuffer sb = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    connection.disconnect();
                    String encryptedDataWithIv = sb.toString();
                    System.out.println("\r\n");
                    System.out.println(encryptedDataWithIv);
                    System.out.println("\r\n");
                    try {
                        decodedBytes = Base64.getDecoder().decode(encryptedDataWithIv);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("\u5699\u76e4\u5699\u885d\u8fce\u856dBase64\u5699\u7de8\u5699\u78bc");
                    }
                    if (decodedBytes.length <= 16) {
                        throw new IllegalArgumentException("\u5699\u7a3c\u5699\u76ba\u5699\u8e1d\u856d\uf6c9L\u5699\u7dda");
                    }
                    byte[] iv = new byte[16];
                    System.arraycopy(decodedBytes, 0, iv, 0, 16);
                    byte[] encryptedData = new byte[decodedBytes.length - 16];
                    System.arraycopy(decodedBytes, 16, encryptedData, 0, encryptedData.length);
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    byte[] hashedKey = digest.digest(key.getBytes(StandardCharsets.UTF_8));
                    SecretKeySpec secretKey = new SecretKeySpec(hashedKey, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    cipher.init(2, (Key)secretKey, ivSpec);
                    try {
                        byte[] decryptedBytes = cipher.doFinal(encryptedData);
                        String jsonString = new String(decryptedBytes, StandardCharsets.UTF_8);
                        System.out.println(jsonString);
                        System.out.println("  \r\n");
                        Pattern itemPattern = Pattern.compile("\"(\\d+)\":\"([^\"]+)\"");
                        Matcher itemMatcher = itemPattern.matcher(jsonString);
                        HashMap<Integer, String> itemMap = new HashMap<Integer, String>();
                        while (itemMatcher.find()) {
                            int id = Integer.parseInt(itemMatcher.group(1));
                            String item = itemMatcher.group(2);
                            itemMap.put(id, item);
                            System.out.println("id : " + id + " / item : " + item);
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("\u5699\u8af8\u5bc6\u5699\u8e1d\u856d\u5699\u8e1d\u856d: " + e.getMessage() + (encryptedData.length % 16 != 0 ? " (\u5699\u7a3c\u5699\u76ba\u5699\u8e1d\u856d\uf6ba\u5699\u8e1d\u856d\u86ba\u5699\u8e1d\u856dO16\u5699\u8e1d\u856d\u5699\u8e1d\u856d\u5699\u8e1d\u856d: " + encryptedData.length + ")" : ""), e);
                    }
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (ProtocolException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (NoSuchPaddingException e) {
                    e.printStackTrace();
                }
                catch (InvalidAlgorithmParameterException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public static void detItemList(String jsonString) {
    }

    public static void test() {
        System.out.println("test");
        System.out.println("  \r\n");
        String jsonString = "Item:0,Item:1,Item:2,Item:3,";
        String[] array = jsonString.split(",");
        for (int s = 0; s < array.length; ++s) {
            System.out.print("ID : " + array[s]);
            System.out.println("  \r\n");
        }
    }

    public static void detTable() {
        try {
            String jsonString = null;
            System.out.print("target : " + jsonString);
            System.out.println("  \r\n");
            Pattern timePattern = Pattern.compile("\"time\":\"([^\"]+)\"");
            Matcher timeMatcher = timePattern.matcher(jsonString);
            String time = timeMatcher.find() ? timeMatcher.group(1) : "NO TIME";
            System.out.println("TIME: " + time);
            System.out.println("  \r\n");
            Pattern itemPattern = Pattern.compile("\"(\\d+)\":\"([^\"]+)\"");
            Matcher itemMatcher = itemPattern.matcher(jsonString);
            HashMap<Integer, String> itemMap = new HashMap<Integer, String>();
            while (itemMatcher.find()) {
                int id = Integer.parseInt(itemMatcher.group(1));
                String item = itemMatcher.group(2);
                itemMap.put(id, item);
                System.out.println("id : " + id + " / item : " + item);
                System.out.println("  \r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testAES() {
        try {
            String line;
            String targetUrl = "https://www.manametal.net/api/cashshop/webinventory.php?list=1";
            URL url = new URL(targetUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setRequestProperty("User-agent", "IE/11.0");
            connection.setRequestProperty("Accept", "application/json; charset=utf-8");
            int responseCode = connection.getResponseCode();
            System.out.print("responseCode V3 : " + responseCode + "  \r\n");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            connection.disconnect();
            String encryptedDataWithIv = sb.toString();
            String base64Key = "SyVGG7tR6J4kDGEqW25SCq/PVUtfzwZEx2BHtDaG8926xWLzTBBdUhgnM0mM++RU";
            byte[] decodedKeyBytes = Base64.getDecoder().decode(base64Key);
            if (decodedKeyBytes.length != 32) {
                decodedKeyBytes = Arrays.copyOf(decodedKeyBytes, 32);
            }
            SecretKeySpec secretKey = new SecretKeySpec(decodedKeyBytes, "AES");
            byte[] decodedData = Base64.getDecoder().decode(encryptedDataWithIv);
            byte[] iv = new byte[16];
            System.arraycopy(decodedData, 0, iv, 0, 16);
            byte[] cipherText = new byte[decodedData.length - 16];
            System.arraycopy(decodedData, 16, cipherText, 0, cipherText.length);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKey, ivSpec);
            byte[] decryptedData = cipher.doFinal(cipherText);
            String decryptedText = new String(decryptedData, "UTF-8");
            System.out.println("Decrypted Text: " + decryptedText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whitegold() {
        M3Config.DEBUG = true;
        M3Config.OnlineWhiteGold = false;
        try {
            String fileContent = TextEncryption.readFileFromJar();
            System.out.println("Base original txt : " + fileContent);
            System.out.println("  \r\n");
            String encryptedContent = TextEncryption.encrypt(fileContent);
            System.out.println("Encrypted Content: " + encryptedContent);
            System.out.println("  \r\n");
            String decryptedContent = TextEncryption.decrypt(encryptedContent);
            System.out.println("Decrypted Content: " + decryptedContent);
            System.out.println("  \r\n");
            String decryptedfileContent = TextEncryption.decrypt(fileContent);
            System.out.println("Decrypted  base Content: " + decryptedfileContent);
            System.out.println("  \r\n");
            System.out.println("md5 data: " + TextEncryption.spawnMD5());
            System.out.println("  \r\n");
            WitheGoldList.analyzeOffline();
            WitheGoldList.showAllData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String jarPath = M3Test.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File jarFile = new File(jarPath);
            String absolutePath = jarFile.getAbsolutePath();
            System.out.println("absolutePath: " + absolutePath);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static class Item {
        private int id;
        private String name;
        private int price;

        public Item(int id, String name, int price) {
            this.id = id;
            this.name = name;
            this.price = price;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getPrice() {
            return this.price;
        }

        public String toString() {
            return "Item{id=" + this.id + ", name='" + this.name + "', price=" + this.price + "}";
        }
    }
}

