/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IFishIngRod;
import project.studio.manametalmod.api.weapon.ILevelArmor;
import project.studio.manametalmod.api.weapon.IMagicItem;
import project.studio.manametalmod.archeology.IAntiquities;
import project.studio.manametalmod.client.ClientPacketHandle;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.ManaItemType;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.items.ItemToolBackpackBase;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.produce.Produce;
import project.studio.manametalmod.produce.textile.ContainerManaBackpack;

public class ItemToolBackpackManaItem
extends ItemToolBackpackBase {
    public static final String tagComplete = "tagComplete";
    public static final String tagDisrobeItems = "tagDisrobeItems";

    public ItemToolBackpackManaItem() {
        super("ItemToolBackpackManaItem", 0, "GuiManaItem", 10, 2500);
    }

    @Override
    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.wear(item, world, player);
        } else {
            super.func_77659_a(item, world, player);
        }
        return item;
    }

    public static final void changeComplete(ItemStack backpack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = null;
            boolean complete = false;
            if (backpack.func_77942_o()) {
                tag = backpack.func_77978_p();
            } else {
                tag = new NBTTagCompound();
                tag.func_74782_a("Items", (NBTBase)new NBTTagList());
                tag.func_74782_a("ItemArmor", (NBTBase)new NBTTagList());
            }
            if (tag.func_150297_b(tagComplete, 1)) {
                complete = tag.func_74767_n(tagComplete);
            }
            tag.func_74757_a(tagComplete, !complete);
            if (!complete) {
                MMM.addMessage(player, "MMM.info.ItemToolBackpackManaItem.complete.open", backpack.func_82833_r());
            } else {
                MMM.addMessage(player, "MMM.info.ItemToolBackpackManaItem.complete.close", backpack.func_82833_r());
            }
        }
    }

    public void wear(ItemStack backpack, World world, EntityPlayer player) {
        ManaMetalModRoot root;
        if (!world.field_72995_K && (root = MMM.getEntityNBT(player)) != null && !PotionEffectM3.isPotion(root, PotionM3.potionBadSword)) {
            PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionBadSword, 10, 0);
            NBTTagCompound tag = null;
            if (backpack.func_77942_o()) {
                tag = backpack.func_77978_p();
            } else {
                tag = new NBTTagCompound();
                tag.func_74782_a("Items", (NBTBase)new NBTTagList());
                tag.func_74782_a("ItemArmor", (NBTBase)new NBTTagList());
            }
            if (tag.func_150297_b("Items", 9) && tag.func_150297_b("ItemArmor", 9)) {
                NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
                NBTTagList nbttaglistarmor = tag.func_150295_c("ItemArmor", 10);
                boolean complete = false;
                if (tag.func_150297_b(tagComplete, 1)) {
                    complete = tag.func_74767_n(tagComplete);
                }
                if (complete) {
                    boolean can = true;
                    String reason = "missingNO";
                    for (int s = 0; s < nbttaglist.func_74745_c(); ++s) {
                        NBTTagCompound tagtemp = nbttaglist.func_150305_b(s);
                        byte slotindex = tagtemp.func_74771_c("Slot");
                        ItemStack itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp);
                        if (itemtemp == null || itemtemp.func_77973_b() == null || slotindex == 41 || this.canWear(itemtemp, player, world, root)) continue;
                        can = false;
                        reason = itemtemp.func_82833_r();
                        break;
                    }
                    if (can) {
                        int s;
                        int s2;
                        ItemStack[] accessories = MMM.cloneItemStack(root.item.items);
                        ItemStack[] armors = MMM.cloneItemStack(player.field_71071_by.field_70460_b);
                        for (s2 = 0; s2 < root.item.items.length; ++s2) {
                            if (s2 == 41 || root.item.items[s2] == null) continue;
                            this.disrobeItems(root.item.items[s2], world, player, root, s2);
                        }
                        for (s2 = 0; s2 < player.field_71071_by.field_70460_b.length; ++s2) {
                            if (player.field_71071_by.field_70460_b[s2] == null) continue;
                            this.disrobeItems(player.field_71071_by.field_70460_b[s2], world, player, root, s2);
                        }
                        for (s2 = 0; s2 < nbttaglist.func_74745_c(); ++s2) {
                            NBTTagCompound tagtemp = nbttaglist.func_150305_b(s2);
                            byte slotindex = tagtemp.func_74771_c("Slot");
                            if (slotindex < 0 || slotindex >= 47 || slotindex == 41) continue;
                            ItemStack itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp);
                            this.wearitems(itemtemp, world, player, root, slotindex);
                        }
                        NBTTagList nbttaglistnew = new NBTTagList();
                        for (s = 0; s < 47; ++s) {
                            if (accessories[s] == null || s == 41) continue;
                            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                            nbttagcompound1.func_74774_a("Slot", (byte)s);
                            accessories[s].func_77955_b(nbttagcompound1);
                            nbttaglistnew.func_74742_a((NBTBase)nbttagcompound1);
                        }
                        tag.func_74782_a("Items", (NBTBase)nbttaglistnew);
                        for (s = 0; s < nbttaglistarmor.func_74745_c(); ++s) {
                            NBTTagCompound tagtemp = nbttaglistarmor.func_150305_b(s);
                            byte slotindex = tagtemp.func_74771_c("Slot");
                            if (slotindex < 0 || slotindex >= 4) continue;
                            ItemStack itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp);
                            this.wearitems(itemtemp, world, player, root, slotindex);
                        }
                        NBTTagList nbttaglistnewarmor = new NBTTagList();
                        for (int s3 = 0; s3 < 4; ++s3) {
                            if (armors[s3] == null) continue;
                            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                            byte id = 0;
                            switch (s3) {
                                case 0: {
                                    id = 3;
                                    break;
                                }
                                case 1: {
                                    id = 2;
                                    break;
                                }
                                case 2: {
                                    id = 1;
                                    break;
                                }
                                case 3: {
                                    id = 0;
                                }
                            }
                            nbttagcompound1.func_74774_a("Slot", id);
                            armors[s3].func_77955_b(nbttagcompound1);
                            nbttaglistnewarmor.func_74742_a((NBTBase)nbttagcompound1);
                        }
                        tag.func_74782_a("ItemArmor", (NBTBase)nbttaglistnewarmor);
                        this.verify(world, player, root, nbttaglist);
                        player.field_71069_bz.func_75142_b();
                    } else {
                        MMM.addMessage(player, "MMM.info.cant.wear.items.backpack", reason);
                    }
                } else {
                    ItemStack itemtemp;
                    byte slotindex;
                    NBTTagCompound tagtemp;
                    int s;
                    for (s = 0; s < nbttaglist.func_74745_c(); ++s) {
                        tagtemp = nbttaglist.func_150305_b(s);
                        slotindex = tagtemp.func_74771_c("Slot");
                        if (slotindex < 0 || slotindex >= 47 || slotindex == 41 || (itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp)) == null || itemtemp.func_77973_b() == null || slotindex >= 47 || !this.canWear(itemtemp, player, world, root)) continue;
                        if (root.item.func_70301_a(slotindex) != null) {
                            if (tagtemp.func_150297_b("tag", 10)) {
                                tagtemp.func_82580_o("tag");
                            }
                            tagtemp.func_74774_a("Slot", slotindex);
                            root.item.func_70301_a(slotindex).func_77955_b(tagtemp);
                            this.disrobeItems(root.item.func_70301_a(slotindex), world, player, root, slotindex);
                            this.wearitems(itemtemp, world, player, root, slotindex);
                            continue;
                        }
                        tagtemp.func_74757_a(tagDisrobeItems, true);
                        this.wearitems(itemtemp, world, player, root, slotindex);
                    }
                    for (s = 0; s < nbttaglist.func_74745_c(); ++s) {
                        tagtemp = nbttaglist.func_150305_b(s);
                        if (!tagtemp.func_150297_b(tagDisrobeItems, 1)) continue;
                        nbttaglist.func_74744_a(s);
                        --s;
                    }
                    for (s = 0; s < nbttaglistarmor.func_74745_c(); ++s) {
                        tagtemp = nbttaglistarmor.func_150305_b(s);
                        slotindex = tagtemp.func_74771_c("Slot");
                        if (slotindex < 0 || slotindex >= 4 || (itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp)) == null || itemtemp.func_77973_b() == null || !this.canWear(itemtemp, player, world, root)) continue;
                        int data = EntityLiving.func_82159_b((ItemStack)itemtemp) - 1;
                        if (player.func_82169_q(data) != null) {
                            if (tagtemp.func_150297_b("tag", 10)) {
                                tagtemp.func_82580_o("tag");
                            }
                            tagtemp.func_74774_a("Slot", slotindex);
                            player.func_82169_q(data).func_77955_b(tagtemp);
                            this.wearitems(itemtemp, world, player, root, slotindex);
                            continue;
                        }
                        tagtemp.func_74757_a(tagDisrobeItems, true);
                        this.wearitems(itemtemp, world, player, root, slotindex);
                    }
                    for (s = 0; s < nbttaglistarmor.func_74745_c(); ++s) {
                        tagtemp = nbttaglistarmor.func_150305_b(s);
                        if (!tagtemp.func_150297_b(tagDisrobeItems, 1)) continue;
                        nbttaglistarmor.func_74744_a(s);
                        --s;
                    }
                    this.verify(world, player, root, nbttaglist);
                    player.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    public void verify(World world, EntityPlayer player, ManaMetalModRoot root, NBTTagList nbttaglist) {
        if (nbttaglist.func_74745_c() > 0) {
            NBTTagCompound tagtemp;
            int s;
            ItemStack[] tempstack = new ItemStack[nbttaglist.func_74745_c()];
            for (int s2 = 0; s2 < nbttaglist.func_74745_c(); ++s2) {
                NBTTagCompound tagtemp2 = nbttaglist.func_150305_b(s2);
                ItemStack itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp2);
                if (itemtemp == null || itemtemp.func_77973_b() == null) continue;
                tempstack[s2] = itemtemp;
            }
            int count = 0;
            int verify = 0;
            for (s = 0; s < nbttaglist.func_74745_c(); ++s) {
                IMagicItem magicitem;
                verify = 0;
                count = 0;
                tagtemp = nbttaglist.func_150305_b(s);
                ItemStack itemtemp = ItemStack.func_77949_a((NBTTagCompound)tagtemp);
                byte slotindex = tagtemp.func_74771_c("Slot");
                if (itemtemp == null || itemtemp.func_77973_b() == null) continue;
                if (itemtemp.func_77973_b() instanceof IMagicItem && ((magicitem = (IMagicItem)itemtemp.func_77973_b()).getType(itemtemp) == ManaItemType.Special || magicitem.getType(itemtemp) == ManaItemType.Pearl)) {
                    verify = 1;
                }
                if (itemtemp.func_77973_b() instanceof IAntiquities) {
                    verify = 2;
                }
                if (verify <= 0) continue;
                if (verify == 1) {
                    for (int x = 0; x < tempstack.length; ++x) {
                        if (!MMM.isItemStackEqualNoNBT(itemtemp, tempstack[x])) continue;
                        ++count;
                    }
                }
                if (verify == 2) {
                    for (int x = 0; x < tempstack.length; ++x) {
                        if (!ItemToolBackpackManaItem.isItemStackEqualNoNBTBase(itemtemp, tempstack[x])) continue;
                        ++count;
                    }
                }
                if (count < 2) continue;
                tagtemp.func_74757_a(tagDisrobeItems, true);
                MMM.addItemToPlayer(itemtemp.func_77946_l(), player);
            }
            for (s = 0; s < nbttaglist.func_74745_c(); ++s) {
                tagtemp = nbttaglist.func_150305_b(s);
                if (!tagtemp.func_150297_b(tagDisrobeItems, 1)) continue;
                nbttaglist.func_74744_a(s);
                --s;
            }
        }
    }

    public static boolean isItemStackEqualNoNBTBase(ItemStack item1, ItemStack item2) {
        return item1 != null && item2 != null && item1.func_77973_b() == item2.func_77973_b();
    }

    public void wearitems(ItemStack item, World world, EntityPlayer player, ManaMetalModRoot root, int slotindex) {
        if (item.func_77973_b() instanceof IMagicItem || item.func_77973_b() instanceof IFishIngRod) {
            root.item.wearItem(item.func_77946_l(), false);
            root.item.func_70299_a(slotindex, item.func_77946_l());
        }
        if (item.func_77973_b() instanceof ItemArmor) {
            int data = EntityLiving.func_82159_b((ItemStack)item) - 1;
            player.func_70062_b(data + 1, item.func_77946_l());
        }
        if (item.func_77973_b() instanceof IAntiquities) {
            root.item.wearItem(item.func_77946_l(), false);
            root.item.func_70299_a(slotindex, item.func_77946_l());
        }
        if (M3Config.DEBUG) {
            MMM.addMessage(player, "wearitems > " + item.func_82833_r());
        }
    }

    public void disrobeItems(ItemStack item, World world, EntityPlayer player, ManaMetalModRoot root, int slotindex) {
        if (item.func_77973_b() instanceof IMagicItem || item.func_77973_b() instanceof IFishIngRod) {
            root.item.disrobeItem(item.func_77946_l());
            root.item.func_70299_a(slotindex, null);
        }
        if (item.func_77973_b() instanceof ItemArmor) {
            int data = EntityLiving.func_82159_b((ItemStack)item) - 1;
            player.func_70062_b(data + 1, null);
        }
        if (item.func_77973_b() instanceof IAntiquities) {
            root.item.disrobeItem(item.func_77946_l());
            root.item.func_70299_a(slotindex, null);
        }
        if (M3Config.DEBUG) {
            MMM.addMessage(player, "disrobeItems > " + item.func_82833_r());
        }
    }

    public boolean canWear(ItemStack item, EntityPlayer player, World world, ManaMetalModRoot root) {
        if (item.func_77973_b() instanceof IMagicItem) {
            IMagicItem magicitem = (IMagicItem)item.func_77973_b();
            if (root.carrer.getLv() >= magicitem.getNeedLV(item, player)) {
                if (magicitem.getType(item) == ManaItemType.Special || magicitem.getType(item) == ManaItemType.Pearl) {
                    return !MMM.isItemStackEqualToLostNoNBT(item, root.item.items);
                }
                return true;
            }
        }
        if (item.func_77973_b() instanceof ILevelArmor) {
            ILevelArmor armor = (ILevelArmor)item.func_77973_b();
            return root.carrer.getLv() >= armor.getNeedLV(item);
        }
        if (item.func_77973_b() instanceof IAntiquities) {
            IAntiquities ant = (IAntiquities)item.func_77973_b();
            return root.carrer.getLv() >= ant.getNeedLV(item, player) && this.canAddSpecialAntiquities(item, root.item.items);
        }
        return item.func_77973_b() instanceof IFishIngRod || item.func_77973_b() instanceof ItemArmor;
    }

    public boolean canAddSpecialAntiquities(ItemStack item, ItemStack[] inventory) {
        for (int s = 0; s < inventory.length; ++s) {
            if (inventory[s] == null || inventory[s].func_77973_b() != item.func_77973_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack open(ItemStack item, World world, EntityPlayer player) {
        ManaMetalModRoot root;
        if (item.func_77960_j() + 1 >= item.func_77958_k()) {
            if (!world.field_72995_K) {
                MMM.addMessage(player, "MMM.info.ItemToolBackpackBase.cantuse");
            }
            return item;
        }
        if (item.field_77994_a > 1) {
            MMM.Logg("[warning] the player " + player.func_70005_c_() + " try open Backpack stackSize > 1!");
        }
        item.field_77994_a = 1;
        if (world.field_72995_K) {
            ClientPacketHandle.disableKeyboard();
        } else if (!player.func_70055_a(Material.field_151567_E) && this.canOPen(world, player) && player.field_71088_bW <= 0) {
            player.field_71088_bW = 4;
            ContainerManaBackpack.openbackpack.put(player.func_70005_c_(), item);
            player.openGui((Object)ManaMetalMod.instance, 269, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        if (!world.field_72995_K && M3Config.BackpackDamage && (root = MMM.getEntityNBT(player)) != null) {
            int data = 10;
            if (root.produce.getLV(Produce.Tailor) >= 2) {
                data = 20;
            }
            if (root.produce.getLV(Produce.Tailor) >= 4) {
                data = 40;
            }
            if (root.produce.getLV(Produce.Tailor) >= 8) {
                data = 70;
            }
            if (world.field_73012_v.nextInt(100) > data && item.func_77960_j() < item.func_77958_k()) {
                item.func_77964_b(item.func_77960_j() + 1);
            }
        }
        return item;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean p4) {
        list.add(StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.1"));
        list.add(StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.2"));
        list.add(StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.3"));
        boolean complete = false;
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(tagComplete, 1)) {
            complete = item.func_77978_p().func_74767_n(tagComplete);
        }
        if (complete) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.complete.oepn"));
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.4"));
        } else {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.complete.close"));
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"item.ItemToolBackpackManaItem.lore.5"));
        }
    }
}

