/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.magic.magicItem;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.magic.magicItem.MagicItemType;

public class IMagicEffect {
    private MagicItemType type;
    private float value;

    public IMagicEffect(MagicItemType type, float value) {
        this.setType(type);
        this.setValue(value);
    }

    public MagicItemType getType() {
        return this.type;
    }

    public void setType(MagicItemType type) {
        this.type = type;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public static void applyInfo(List ListInfo, MagicItemType type, EnumChatFormatting color, float value, String Modified) {
        DecimalFormat df1 = (DecimalFormat)NumberFormat.getPercentInstance();
        switch (type) {
            case attackMultiplier: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.attackMultiplier") + Modified + df1.format(value));
                break;
            }
            case attackSpeed: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.attackSpeed") + Modified + df1.format(value));
                break;
            }
            case avoid: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.avoid") + Modified + (int)value);
                break;
            }
            case crit: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.crit") + Modified + (int)value);
                break;
            }
            case defenseMultiplier: {
                if (value < 0.0f) {
                    ListInfo.add(color + MMM.getTranslateText("manaItem.defenseMultiplier") + "+" + df1.format(Math.abs(value)));
                    break;
                }
                ListInfo.add(color + MMM.getTranslateText("manaItem.defenseMultiplier") + "-" + df1.format(value));
                break;
            }
            case holyAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.holyAttack") + Modified + (int)value);
                break;
            }
            case magicAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.magicAttack") + Modified + (int)value);
                break;
            }
            case magicDefense: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.magicDefense") + Modified + (int)value);
                break;
            }
            case physicalAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.physicalAttack") + Modified + (int)value);
                break;
            }
            case manaMax: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.maxMana") + Modified + (int)value);
                break;
            }
            case manaReply: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.manaReply") + Modified + (int)value);
                break;
            }
            case critDamage: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.critDamage") + Modified + df1.format(value));
                break;
            }
            case backstabDamage: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.backstabDamage") + Modified + df1.format(value));
                break;
            }
            case dropRate: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.dropRate") + Modified + (int)value + "%");
                break;
            }
            case healthRecovery: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.healthRecovery") + Modified + df1.format(value));
                break;
            }
            case maxMagicShield: {
                break;
            }
            case maxSP: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.maxSP") + Modified + (int)value);
                break;
            }
            case hpReply: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.hpReply") + Modified + MMM.getFloat(value));
                break;
            }
            case penetrate: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.penetrate") + Modified + (int)value);
                break;
            }
            case HP: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.HP") + Modified + (int)value);
                break;
            }
            case magicRelief: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.magicRelief") + Modified + df1.format(value));
                break;
            }
            case cold: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.cold") + Modified + df1.format(value));
                break;
            }
            case hot: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.hot") + Modified + df1.format(value));
                break;
            }
            case EXP: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.EXP") + Modified + df1.format(value));
                break;
            }
            case produceEXP: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.produceEXP") + Modified + df1.format(value));
                break;
            }
            case water: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.water") + Modified + (int)value);
                break;
            }
            case fatigue: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.fatigue") + Modified + (int)value);
                break;
            }
            case health: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.health") + Modified + (int)value);
                break;
            }
            case MaxDamage: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.MaxDamage") + Modified + (int)value);
                break;
            }
            case Insight: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.Insight") + Modified + df1.format(value));
                break;
            }
            case Willpower: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.Willpower") + Modified + df1.format(value));
                break;
            }
            case craft: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.craft") + Modified + df1.format(value));
                break;
            }
            case maxWeight: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.maxWeight") + Modified + (int)value);
                break;
            }
            case flydata: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.flydata") + Modified + (int)value);
                break;
            }
            case FinalAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.FinalAttack") + Modified + df1.format(value));
                break;
            }
            case career_increase: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.career_increase") + Modified + df1.format(value));
                break;
            }
            case boss_attack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.boss_attack") + Modified + (int)value);
                break;
            }
            case boss_attackMultiplier: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.boss_attackMultiplier") + Modified + df1.format(value));
                break;
            }
            case monster_attack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.monster_attack") + Modified + (int)value);
                break;
            }
            case monster_attackMultiplier: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.monster_attackMultiplier") + Modified + df1.format(value));
                break;
            }
            case monster_final_attackMultiplier: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.monster_final_attackMultiplier") + Modified + df1.format(value));
                break;
            }
            case boss_final_attackMultiplier: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.boss_final_attackMultiplier") + Modified + df1.format(value));
                break;
            }
            case light_power: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.light_power") + Modified + df1.format(value));
                break;
            }
            case light_shield: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.light_shield") + Modified + df1.format(value));
                break;
            }
            case maxCurseDevour: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.maxCurseDevour") + Modified + (int)value);
                break;
            }
            case MaxBloodData: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.MaxBloodData") + Modified + df1.format(value));
                break;
            }
            case trueMagicAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.trueMagicAttack") + Modified + (int)value);
                break;
            }
            case truePhysicalAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.truePhysicalAttack") + Modified + (int)value);
                break;
            }
            case pointAgile: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.pointAgile") + Modified + (int)value);
                break;
            }
            case pointPower: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.pointPower") + Modified + (int)value);
                break;
            }
            case pointWisdom: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.pointWisdom") + Modified + (int)value);
                break;
            }
            case pointCon: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.pointCon") + Modified + (int)value);
                break;
            }
            case pointWis: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.pointWis") + Modified + (int)value);
                break;
            }
            case mixAttack: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.mixAttack") + Modified + (int)value);
                break;
            }
            case InvincibilityFrames: {
                ListInfo.add(color + MMM.getTranslateText("manaItem.InvincibilityFrames") + Modified + (int)value);
            }
        }
    }

    public static void addInformation(ItemStack item, EntityPlayer player, List ListInfo, List<IMagicEffect> effects) {
        if (effects != null && !effects.isEmpty()) {
            EnumChatFormatting color = EnumChatFormatting.AQUA;
            DecimalFormat df1 = (DecimalFormat)NumberFormat.getPercentInstance();
            int size = effects.size();
            for (int s = 0; s < size; ++s) {
                IMagicEffect ime = effects.get(s);
                color = EnumChatFormatting.AQUA;
                float value = ime.getValue();
                String Modified = "+";
                if (value < 0.0f) {
                    color = EnumChatFormatting.RED;
                    Modified = "";
                }
                IMagicEffect.applyInfo(ListInfo, ime.getType(), color, value, Modified);
            }
        }
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74776_a("value", this.value);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.type = MagicItemType.values()[nbt.func_74762_e("type")];
        this.value = nbt.func_74760_g("value");
    }
}

