/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.magic.magicItem;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IQualityItem;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.api.weapon.IMagicItem;
import project.studio.manametalmod.core.ManaItemType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.magic.magicItem.MagicItemType;
import project.studio.manametalmod.network.MessagePlayerMessage;
import project.studio.manametalmod.network.PacketHandlerMana;

public class MagicItemPearl
extends IMagicItem
implements IQualityItem {
    public MagicItemPearl(String Name2) {
        super(Name2);
    }

    @Override
    public ManaItemType getType(ItemStack item) {
        return ManaItemType.Pearl;
    }

    @Override
    public int TypeCount() {
        return 7;
    }

    @Override
    public void onBeAttack(ItemStack item, EntityPlayer player, EntityLivingBase entity, DamageSource source) {
    }

    @Override
    public void onAttack(ItemStack item, EntityPlayer player, EntityLivingBase target, DamageSource source) {
    }

    @Override
    public void onCrit(ItemStack item, EntityPlayer player, EntityLivingBase entity, DamageSource source) {
    }

    @Override
    public int getNeedLV(ItemStack item, EntityPlayer player) {
        return 1;
    }

    @Override
    public void onEquipment(ItemStack item, EntityLivingBase player) {
    }

    @Override
    public void onDisrobe(ItemStack item, EntityLivingBase player) {
    }

    public List<MagicItemType> getRandomTypes(int id) {
        ArrayList<MagicItemType> list = new ArrayList<MagicItemType>();
        list.add(MagicItemType.crit);
        list.add(MagicItemType.avoid);
        list.add(MagicItemType.maxSP);
        list.add(MagicItemType.dropRate);
        list.add(MagicItemType.penetrate);
        switch (id) {
            case 0: {
                list.add(MagicItemType.physicalAttack);
                list.add(MagicItemType.magicAttack);
                list.add(MagicItemType.attackMultiplier);
                return list;
            }
            case 1: {
                list.add(MagicItemType.HP);
                list.add(MagicItemType.defenseMultiplier);
                list.add(MagicItemType.magicDefense);
                return list;
            }
            case 2: {
                list.add(MagicItemType.HP);
                list.add(MagicItemType.hpReply);
                list.add(MagicItemType.healthRecovery);
                return list;
            }
            case 3: {
                list.add(MagicItemType.manaReply);
                list.add(MagicItemType.manaMax);
                list.add(MagicItemType.magicRelief);
                return list;
            }
            case 4: {
                list.add(MagicItemType.HP);
                list.add(MagicItemType.physicalAttack);
                list.add(MagicItemType.magicAttack);
                return list;
            }
            case 5: {
                list.add(MagicItemType.attackMultiplier);
                list.add(MagicItemType.physicalAttack);
                list.add(MagicItemType.magicAttack);
                return list;
            }
            case 6: {
                list.add(MagicItemType.attackMultiplier);
                list.add(MagicItemType.physicalAttack);
                list.add(MagicItemType.magicAttack);
                list.add(MagicItemType.HP);
                list.add(MagicItemType.manaReply);
                list.add(MagicItemType.manaMax);
                list.add(MagicItemType.magicRelief);
                return list;
            }
        }
        return list;
    }

    public int getEffectCount(EntityPlayer player, World world, int drop, Random rand) {
        int id;
        if (player.field_71071_by.func_146026_a(ItemCraft2.ResonanceStone)) {
            return 4;
        }
        if (player.field_71071_by.func_146026_a(ItemCraft2.MiracleResonanceStone)) {
            return 5;
        }
        int data = 200 - (drop - 100);
        if (data < 50) {
            data = 50;
        }
        if ((id = rand.nextInt(data)) == 0) {
            return 5;
        }
        if (id < 20) {
            return 4;
        }
        if (id < 50) {
            return 3;
        }
        if (id < 100) {
            return 2;
        }
        return 1;
    }

    public float getEffect(MagicItemType type, World world, Random rand, EntityPlayer player, ItemStack item) {
        int min_base = 0;
        float min_base_float = 0.0f;
        int max_base = 0;
        float max_base_float = 0.0f;
        if (item.func_77960_j() == 6) {
            min_base += 4;
            min_base_float += 0.08f;
            max_base += 4;
            max_base_float += 0.08f;
        }
        boolean hasClear = false;
        if (player.field_71071_by.func_146026_a(ItemCraft2.GoldenPrism)) {
            min_base += 2;
            min_base_float += 0.02f;
        }
        if (player.field_71071_by.func_146026_a(ItemCraft2.ColorPrism)) {
            max_base += 3;
            max_base_float += 0.03f;
        }
        switch (type) {
            case magicDefense: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case physicalAttack: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case magicAttack: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case crit: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case avoid: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case hpReply: {
                return min_base + 3 + rand.nextInt(max_base + 8);
            }
            case manaReply: {
                return min_base + 3 + rand.nextInt(max_base + 8);
            }
            case dropRate: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case HP: {
                return min_base * 30 + 100 + rand.nextInt(max_base * 30 + 300);
            }
            case manaMax: {
                return min_base * 50 + 400 + rand.nextInt(max_base * 50 + 601);
            }
            case maxSP: {
                return min_base * 20 + 50 + rand.nextInt(max_base * 20 + 101);
            }
            case attackMultiplier: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.08f + max_base_float));
            }
            case defenseMultiplier: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.05f + max_base_float));
            }
            case magicRelief: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.05f + max_base_float));
            }
            case healthRecovery: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.1f, (float)(0.3f + max_base_float));
            }
            case penetrate: {
                return min_base + 1 + rand.nextInt(max_base + 3);
            }
        }
        return 1.0f;
    }

    public void doaddEffect(ItemStack item, World world, EntityPlayer player) {
        if (item != null) {
            int s;
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root == null) {
                return;
            }
            Random rand = new Random();
            MagicItemType[] effects = new MagicItemType[this.getEffectCount(player, world, root.carrer.getFinalDropRate(), rand)];
            List<MagicItemType> list = this.getRandomTypes(item.func_77960_j());
            for (int s2 = 0; s2 < effects.length; ++s2) {
                MagicItemType type;
                int id = rand.nextInt(list.size());
                effects[s2] = type = list.get(id);
                list.remove(id);
            }
            NBTTagList listEffect = new NBTTagList();
            int[] ids = new int[effects.length];
            float[] val = new float[effects.length];
            for (s = 0; s < val.length; ++s) {
                val[s] = this.getEffect(effects[s], world, rand, player, item);
                ids[s] = effects[s].ordinal();
            }
            for (s = 0; s < val.length; ++s) {
                listEffect.func_74742_a((NBTBase)new NBTTagFloat(val[s]));
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a("listID", ids);
            tag.func_74782_a("listEffect", (NBTBase)listEffect);
            item.func_77982_d(tag);
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (!item.func_77942_o()) {
            if (!world.field_72995_K) {
                this.doaddEffect(item, world, player);
                PacketHandlerMana.INSTANCE.sendToAll((IMessage)new MessagePlayerMessage(8, "87", new ItemStack(Items.field_151034_e), item, player.func_70005_c_()));
                player.field_71069_bz.func_75142_b();
            }
            return item;
        }
        return super.func_77659_a(item, world, player);
    }

    @Override
    public void func_77624_a(ItemStack item, EntityPlayer player, List List2, boolean booleans) {
        List2.add(EnumChatFormatting.GREEN + MMM.getTranslateText("manaItemType." + this.getType(item).toString()));
        if (!item.func_77942_o()) {
            List2.add(MMM.getTranslateText("MagicItemPearl.unknown.use"));
        }
    }

    @Override
    public List<IMagicEffect> getItemEffect(ItemStack item) {
        ArrayList<IMagicEffect> list = new ArrayList<IMagicEffect>();
        if (item.func_77942_o()) {
            int[] listID = NBTHelp.getIntArraySafe("listID", item.func_77978_p(), new int[0]);
            NBTTagList listEffect = NBTHelp.getNBTTagListSafe("listEffect", item.func_77978_p(), 5, new NBTTagList());
            for (int s = 0; s < listID.length; ++s) {
                IMagicEffect effect = new IMagicEffect(MagicItemType.values()[listID[s]], listEffect.func_150308_e(s));
                list.add(effect);
            }
        }
        return list;
    }

    @Override
    public long getValue(ItemStack item) {
        return 9999L;
    }

    @Override
    public Quality getQuality(ItemStack item) {
        return Quality.Legend;
    }
}

