/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.mall;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.mall.MallType;

public class IMallItem {
    private ItemStack item = new ItemStack(Items.field_151034_e);
    private int price = 0;
    private boolean limit = false;
    private int maxCount = 64;
    private MallType type;

    public IMallItem(ItemStack item, int money, boolean limit, int maxCount, MallType type) {
        this.setItem(item);
        this.setPrice(money);
        this.setLimit(limit);
        this.setMaxCount(maxCount);
        this.setType(type);
    }

    public IMallItem() {
        this.item = new ItemStack(Items.field_151034_e);
        this.price = 100;
        this.setLimit(false);
        this.setMaxCount(64);
    }

    public IMallItem(ItemStack item) {
        this.setItem(item);
        this.price = 100;
        this.setLimit(this.limit);
        this.setMaxCount(64);
    }

    public boolean equals(Object obj) {
        IMallItem temp;
        if (obj instanceof IMallItem && (temp = (IMallItem)obj).getItem() != null && MMM.isItemStackEqual(temp.getItem(), this.getItem()) && temp.getPrice() == this.getPrice()) {
            return true;
        }
        return super.equals(obj);
    }

    public ItemStack getItem() {
        if (this.item != null) {
            return this.item.func_77946_l();
        }
        return null;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public boolean isLimit() {
        return this.limit;
    }

    public void setLimit(boolean limit) {
        this.limit = limit;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        this.price = NBTHelp.getIntSafe("Money", nbt, 0);
        this.maxCount = NBTHelp.getIntSafe("MaxCount", nbt, 64);
        this.limit = NBTHelp.getBooleanSafe("Limit", nbt, false);
        this.item = NBTHelp.getItemStackSafe(nbt, new ItemStack(Items.field_151034_e));
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Money", this.getPrice());
        this.getItem().func_77955_b(nbt);
        nbt.func_74757_a("Limit", this.isLimit());
        nbt.func_74768_a("MaxCount", this.getMaxCount());
    }

    public MallType getType() {
        return this.type;
    }

    public void setType(MallType type) {
        this.type = type;
    }
}

