/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.blueprint.ItemBlueprint;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;

public class MessageBlueprint
implements IMessage,
IMessageHandler<MessageBlueprint, IMessage> {
    private int ID = 0;
    private int rotate = 0;
    private int x;
    private int y;
    private int z;

    public MessageBlueprint() {
    }

    public MessageBlueprint(int id, int rotate, int x, int y, int z) {
        this.ID = id;
        this.rotate = rotate;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public IMessage onMessage(MessageBlueprint message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemBlueprint) {
            if (!M3Config.UseItemBlueprint) {
                MMM.addMessage((EntityPlayer)player, "MMM.info.UseItemBlueprint.cant");
                return null;
            }
            if (MMM.getDimensionID(player.field_70170_p) == M3Config.WorldInstanceDungeonID) {
                return null;
            }
            ItemStack itemstack_blueprint = player.func_71045_bC();
            ItemBlueprint item = (ItemBlueprint)itemstack_blueprint.func_77973_b();
            String name = item.getSchematicName(itemstack_blueprint);
            if (name != null && MMM.getBlockDistance(player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)message.x, (double)message.y, (double)message.z) < 24) {
                Schematic sh = new Schematic();
                sh = sh.loanIDungeonFromJar(name);
                if (message.rotate > 0) {
                    for (int s = 0; s < message.rotate; ++s) {
                        sh = sh.rotateIdungeon();
                    }
                    MessageBlueprint.spawnIDungeonGZIPRR(player.field_70170_p, message.x, message.y, message.z, sh, message.rotate, player);
                } else {
                    MessageBlueprint.spawnIDungeonGZIP(player.field_70170_p, message.x, message.y, message.z, sh, 2, player);
                }
                MMM.playSoundFromServer(player.field_70170_p, MMM.getMODID() + ":bow2", (Entity)player, 1.0, 1.0, 5.0);
                MMM.removePlayerCurrentItem((EntityPlayer)player);
            }
        }
        return null;
    }

    public static void spawnIDungeonGZIPRR(World world, int x, int y, int z, Schematic sh, int rotate, EntityPlayerMP player) {
        if (sh != null) {
            int sx;
            int sz;
            int sy;
            int i = 0;
            boolean o = false;
            for (sy = 0; sy < sh.height; ++sy) {
                for (sz = 0; sz < sh.length; ++sz) {
                    for (sx = 0; sx < sh.width; ++sx) {
                        if (MMM.isReplaceBlock(world, x + sx, y + sy, z + sz)) continue;
                        MMM.addMessage((EntityPlayer)player, "MMM.info.UseItemBlueprint.cantbuild", x + sx, y + sy, z + sz);
                        return;
                    }
                }
            }
            for (sy = 0; sy < sh.height; ++sy) {
                for (sz = 0; sz < sh.length; ++sz) {
                    for (sx = 0; sx < sh.width; ++sx) {
                        Block block = Blocks.field_150350_a;
                        if (sh.blockName[i] != null) {
                            int temp;
                            String[] str = sh.blockName[i].split(":");
                            block = GameRegistry.findBlock((String)str[0], (String)str[1]);
                            world.func_147465_d(x + sx, y + sy, z + sz, block, (int)sh.data[i], 2);
                            if (sh.isIDungeon && sh.isRotate && (temp = sh.hasTileEntity(i)) != -1 && world.func_147438_o(x + sx, y + sy, z + sz) != null) {
                                TileEntity tile = world.func_147438_o(x + sx, y + sy, z + sz);
                                NBTTagCompound tag = sh.listTileEntity.get((int)temp).data;
                                tag.func_74768_a("x", x + sx);
                                tag.func_74768_a("y", y + sy);
                                tag.func_74768_a("z", z + sz);
                                tile.func_145839_a(tag);
                            }
                            for (int s = 0; s < rotate; ++s) {
                                block.rotateBlock(world, x + sx, y + sy, z + sz, ForgeDirection.UP);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public static void spawnIDungeonGZIP(World world, int x, int y, int z, Schematic sh, int sendtype, EntityPlayerMP player) {
        if (sh != null) {
            int sx;
            int sz;
            int sy;
            int i = 0;
            int o = 0;
            for (sy = 0; sy < sh.height; ++sy) {
                for (sz = 0; sz < sh.length; ++sz) {
                    for (sx = 0; sx < sh.width; ++sx) {
                        if (MMM.isReplaceBlock(world, x + sx, y + sy, z + sz)) continue;
                        MMM.addMessage((EntityPlayer)player, "MMM.info.UseItemBlueprint.cantbuild", x + sx, y + sy, z + sz);
                        return;
                    }
                }
            }
            for (sy = 0; sy < sh.height; ++sy) {
                for (sz = 0; sz < sh.length; ++sz) {
                    for (sx = 0; sx < sh.width; ++sx) {
                        Block block = Blocks.field_150350_a;
                        if (sh.blockName[i] != null) {
                            String[] str = sh.blockName[i].split(":");
                            block = GameRegistry.findBlock((String)str[0], (String)str[1]);
                            world.func_147465_d(x + sx, y + sy, z + sz, block, (int)sh.data[i], sendtype);
                            if (sh.tileID != null && sh.tileID.length > 0 && o < sh.tileID.length && i == sh.tileID[o]) {
                                if (world.func_147438_o(x + sx, y + sy, z + sz) != null) {
                                    TileEntity tile = world.func_147438_o(x + sx, y + sy, z + sz);
                                    NBTTagCompound tag = sh.tileentity[o];
                                    tag.func_74768_a("x", x + sx);
                                    tag.func_74768_a("y", y + sy);
                                    tag.func_74768_a("z", z + sz);
                                    tile.func_145839_a(tag);
                                }
                                ++o;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.ID = buf.readInt();
        this.rotate = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ID);
        buf.writeInt(this.rotate);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }
}

