/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.archeology.ItemAntiquitiesBase;
import project.studio.manametalmod.core.AttributesItemType;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.feeddragon.MobDragonElements;
import project.studio.manametalmod.network.MessagePlayerMessage;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.produce.casting.CastingEffect;
import project.studio.manametalmod.produce.casting.CastingEffectType;
import project.studio.manametalmod.produce.fishing.FishingCore;
import project.studio.manametalmod.soulinherit.SoulInherit;
import project.studio.manametalmod.soulinherit.SoulInheritCore;

public class MessageSeasonTarget
implements IMessage,
IMessageHandler<MessageSeasonTarget, IMessage> {
    public int id;

    public MessageSeasonTarget() {
    }

    public MessageSeasonTarget(int id) {
        this.id = id;
    }

    public IMessage onMessage(MessageSeasonTarget message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (message.id > -1 && message.id < 10 && root != null) {
            boolean ok = false;
            switch (message.id) {
                case 0: {
                    if (root.carrer.getLv() < 80 || !root.carrer.isTransfer2()) break;
                    ok = this.finish(message.id, player, root);
                    break;
                }
                case 1: {
                    if (!MessageSeasonTarget.hasProduction((EntityPlayer)player, root, 4)) break;
                    ok = this.finish(message.id, player, root);
                    break;
                }
                case 2: {
                    if (!MessageSeasonTarget.hasFavorites((EntityPlayer)player, root, 2)) break;
                    ok = this.finish(message.id, player, root);
                    break;
                }
                case 3: {
                    if (root.carrer.AttributesItemUseCount[AttributesItemType.OriginFragments.ordinal()] <= 0) break;
                    ok = this.finish(message.id, player, root);
                    break;
                }
                case 4: {
                    if (!MessageSeasonTarget.isSoulInherit((EntityPlayer)player, root, 300)) break;
                    ok = this.finish(message.id, player, root);
                    break;
                }
                case 5: {
                    if (!MessageSeasonTarget.hasItem(FishingCore.fish_s8, (EntityPlayer)player, true)) break;
                    ok = this.finish(message.id, player, root);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
            }
            if (!ok) {
                MMM.addMessage((EntityPlayer)player, "MMM.info.cantSeasonTarget", MMM.getTranslateText("GuiSeasonTarget.loretitle." + message.id));
            }
        }
        return null;
    }

    public boolean finish(int id, EntityPlayerMP player, ManaMetalModRoot root) {
        if (root.carrer.season_target[id] == 0) {
            MMM.addMessage((EntityPlayer)player, "MMM.info.doneseasonmission", MMM.getTranslateText("GuiSeasonTarget.loretitle." + id));
            root.carrer.season_target[id] = 1;
            ++root.carrer.seasonPoint;
            root.carrer.send2();
            PacketHandlerMana.INSTANCE.sendToAll((IMessage)new MessagePlayerMessage(15, "" + root.carrer.seasonPoint, new ItemStack(Items.field_151034_e), player.func_70005_c_()));
            return true;
        }
        return false;
    }

    public static final boolean isSoulInherit(EntityPlayer player, ManaMetalModRoot root, int need) {
        SoulInherit ss = SoulInheritCore.get(player);
        return ss.totalLV() + root.carrer.getLv() >= need;
    }

    public static final boolean hasSpiritualPower(EntityPlayer player, ManaMetalModRoot root, int need) {
        int count = 0;
        for (int s = 0; s < root.carrer.SpiritualPower.length; ++s) {
            if (root.carrer.SpiritualPower[s] < 5) continue;
            ++count;
        }
        return count >= need;
    }

    public static final boolean hasProduction(EntityPlayer player, ManaMetalModRoot root, int need) {
        int count = 0;
        for (int s = 0; s < 10; ++s) {
            if (root.produce.getLVs()[s] < 10) continue;
            ++count;
        }
        return count >= need;
    }

    public static final boolean hasFavorites(EntityPlayer player, ManaMetalModRoot root, int need) {
        int count = 0;
        for (int s = 0; s < 10; ++s) {
            if (root.money.Favoritesdata[s] < 3) continue;
            ++count;
        }
        return count >= need;
    }

    public static final boolean has60LVdragon(EntityPlayer player) {
        List<EntityLivingBase> list = MMM.findLivingBase(player.field_70170_p, new Pos((Entity)player), 6.0);
        for (int s = 0; s < list.size(); ++s) {
            ManaMetalModRoot root;
            MobDragonElements dragon;
            if (!(list.get(s) instanceof MobDragonElements) || (dragon = (MobDragonElements)list.get(s)).func_70902_q() == null || dragon.func_70902_q() != player || (root = MMM.getEntityNBT((EntityLivingBase)dragon)) == null || root.ManaEntityData.getLV() < 60) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasLegendTools(EntityPlayer player) {
        int s;
        int[] data = new int[]{-1, -1, -1};
        boolean has = false;
        int count = 0;
        for (s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            if (player.field_71071_by.func_70301_a(s) == null) continue;
            CastingEffectType weapon = CastingEffect.getType(player.field_71071_by.func_70301_a(s));
            if (weapon != null) {
                if (weapon == CastingEffectType.legend) {
                    data[count] = s;
                    ++count;
                } else if (weapon == CastingEffectType.myth) {
                    data[count] = s;
                    ++count;
                } else if (weapon == CastingEffectType.holy) {
                    data[count] = s;
                    ++count;
                }
            }
            if (count >= 3) break;
        }
        if (count == 3) {
            for (s = 0; s < 3; ++s) {
                if (data[s] == -1 || player.field_71071_by.func_70301_a(data[s]) == null) continue;
                --player.field_71071_by.func_70301_a((int)data[s]).field_77994_a;
                if (player.field_71071_by.func_70301_a((int)data[s]).field_77994_a > 0) continue;
                player.field_71071_by.func_70299_a(data[s], null);
            }
            has = true;
        }
        return has;
    }

    public static final boolean hasItemStack(ItemStack target, EntityPlayer player, boolean clear) {
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            if (player.field_71071_by.func_70301_a(s) == null || !MMM.isItemStackEqualNoNBT(player.field_71071_by.func_70301_a(s), target)) continue;
            if (clear) {
                --player.field_71071_by.func_70301_a((int)s).field_77994_a;
                if (player.field_71071_by.func_70301_a((int)s).field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(s, null);
                }
            }
            return true;
        }
        return false;
    }

    public static final boolean hasItem(Item target, EntityPlayer player, boolean clear) {
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            if (player.field_71071_by.func_70301_a(s) == null || player.field_71071_by.func_70301_a(s).func_77973_b() != target) continue;
            if (clear) {
                --player.field_71071_by.func_70301_a((int)s).field_77994_a;
                if (player.field_71071_by.func_70301_a((int)s).field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(s, null);
                }
            }
            return true;
        }
        return false;
    }

    public static final boolean hasItemAntiquities(EntityPlayer player, boolean clear) {
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            if (player.field_71071_by.func_70301_a(s) == null || !(player.field_71071_by.func_70301_a(s).func_77973_b() instanceof ItemAntiquitiesBase)) continue;
            if (clear) {
                --player.field_71071_by.func_70301_a((int)s).field_77994_a;
                if (player.field_71071_by.func_70301_a((int)s).field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(s, null);
                }
            }
            return true;
        }
        return false;
    }

    public static final boolean hasPray(EntityPlayer player, boolean clear) {
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            NBTTagCompound tag;
            if (player.field_71071_by.func_70301_a(s) == null || !player.field_71071_by.func_70301_a(s).func_77942_o() || !(tag = player.field_71071_by.func_70301_a(s).func_77978_p()).func_150297_b("PrayerAltar", 8)) continue;
            if (clear) {
                --player.field_71071_by.func_70301_a((int)s).field_77994_a;
                if (player.field_71071_by.func_70301_a((int)s).field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(s, null);
                }
            }
            return true;
        }
        return false;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
    }
}

