/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.brewing;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IAlcoholItem;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.items.ItemCoinSpecial;
import project.studio.manametalmod.produce.Produce;
import project.studio.manametalmod.produce.brewing.BrewingCore;
import project.studio.manametalmod.produce.brewing.ItemWine;
import project.studio.manametalmod.produce.brewing.TileEntityPotionWineBarrel;
import project.studio.manametalmod.produce.brewing.WineFormula;
import project.studio.manametalmod.produce.brewing.WineState;
import project.studio.manametalmod.produce.brewing.WineType;
import project.studio.manametalmod.produce.cuisine.CuisineCore;

public class BlockWineBarrel
extends BlockContainer {
    public int type = 0;
    public int speed = 0;

    public BlockWineBarrel(int type, int speed) {
        super(Material.field_151575_d);
        this.func_149663_c("BlockWineBarrel_" + type);
        this.func_149647_a(ManaMetalMod.tab_Machine);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_149715_a(0.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149658_d(MMM.getTextureName("BlockWineBarrel_" + type));
        this.setHarvestLevel("axe", 0);
        this.type = type;
        this.speed = speed;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityPotionWineBarrel();
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (angle == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (angle == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (angle == 2) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (angle == 3) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (item.func_77942_o() && item.func_77978_p().func_150297_b("winetype", 3)) {
            TileEntityPotionWineBarrel tile = (TileEntityPotionWineBarrel)world.func_147438_o(x, y, z);
            tile.readFromNBTBase(item.func_77978_p());
            tile.canaging = false;
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block Block2, int data) {
        if (!world.field_72995_K) {
            ItemStack items = new ItemStack((Block)this);
            TileEntityPotionWineBarrel tile = (TileEntityPotionWineBarrel)world.func_147438_o(x, y, z);
            if (tile.remaining > 0 || tile.aging || tile.brewing) {
                NBTTagCompound tag = new NBTTagCompound();
                tile.writeToNBTBase(tag);
                tag.func_74757_a("canaging", false);
                items.func_77982_d(tag);
            }
            MMM.spawnItemInWorld(world, items, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        }
        super.func_149749_a(world, x, y, z, Block2, data);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        if (!world.field_72995_K) {
            TileEntityPotionWineBarrel tile = (TileEntityPotionWineBarrel)world.func_147438_o(x, y, z);
            ItemStack item = player.func_71045_bC();
            long time = System.currentTimeMillis();
            if (tile.brewing && time >= tile.targetTime) {
                tile.brewing = false;
                tile.remaining = tile.item != null && tile.item.field_77994_a >= 8 ? tile.item.field_77994_a / 8 : 1;
                tile.item = null;
                if (world.field_73012_v.nextInt(200) < tile.moldcount) {
                    tile.winestate = WineState.Rot;
                }
                if (world.field_73012_v.nextInt(400) < tile.moldcount) {
                    tile.winestate = WineState.Mold;
                    tile.generateEffect();
                }
            }
            if (tile.aging && time >= tile.targetTime) {
                tile.aging = false;
                tile.aginglevel = IAlcoholItem.AgingLevel.values()[tile.aginglevel.ordinal() + 1];
                if (world.field_73012_v.nextInt(200 - tile.aginglevel.ordinal() * 20) < tile.moldcount) {
                    tile.winestate = WineState.Rot;
                }
                if (world.field_73012_v.nextInt(400 - tile.aginglevel.ordinal() * 40) < tile.moldcount) {
                    tile.winestate = WineState.Mold;
                    tile.generateEffect();
                }
            }
            if (!(item == null || item.func_77973_b() != BrewingCore.ItemWine_brewing || tile.remaining >= 8 || tile.brewing || tile.aging || tile.winestate != WineState.Normal || tile.remaining > 0 && item.func_77960_j() != tile.winetype.ordinal() || tile.remaining > 0 && ((ItemWine)item.func_77973_b()).getAgingLevel(item) != tile.aginglevel)) {
                ++tile.remaining;
                ++tile.putcount;
                tile.winetype = WineType.values()[item.func_77960_j()];
                tile.aginglevel = ((ItemWine)item.func_77973_b()).getAgingLevel(item);
                MMM.playSoundFromServer(world, MMM.getMODID() + ":fill_bottle", new Pos(tile), 1.0, 1.0, 2.0);
                MMM.removePlayerCurrentItem(player);
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.has", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), tile.remaining, MMM.getTranslateText("AgingLevel." + tile.aginglevel.toString()));
                return true;
            }
            if (item != null && tile.item == null && tile.remaining > 0 && !tile.brewing && !tile.aging && tile.aginglevel.ordinal() < IAlcoholItem.AgingLevel.values()[IAlcoholItem.AgingLevel.values().length - 1].ordinal() && tile.isAgingLevelItems(item)) {
                if (!tile.canaging) {
                    MMM.addMessage(player, "MMM.info.BlockWineBarrel.cant.aging", tile.remaining);
                    return true;
                }
                if (item.field_77994_a >= tile.remaining) {
                    tile.aging = true;
                    tile.targetTime = System.currentTimeMillis() + (long)(50 * TileEntityPotionWineBarrel.needTimeAgingLV1);
                    MMM.addMessage(player, "MMM.info.BlockWineBarrel.aging", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), MMM.getTranslateText("AgingLevel." + (Object)((Object)IAlcoholItem.AgingLevel.values()[tile.aginglevel.ordinal() + 1])));
                    item.field_77994_a -= tile.remaining;
                    if (item.field_77994_a <= 0) {
                        player.func_71028_bD();
                    }
                    return true;
                }
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.cant.aging.noitem", tile.remaining);
                return true;
            }
            if (item != null && !tile.brewing && tile.remaining > 0) {
                if (item.func_77973_b() == Items.field_151069_bo) {
                    ManaMetalModRoot root;
                    ItemStack wine;
                    NBTTagCompound tag;
                    if (tile.winestate == WineState.Normal) {
                        tag = new NBTTagCompound();
                        tag.func_74768_a("AgingLevel", tile.aginglevel.ordinal());
                        wine = new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal());
                        wine.func_77982_d(tag);
                        MMM.addItemToPlayer(wine, player);
                        --tile.remaining;
                        root = MMM.getEntityNBT(player);
                        if (root != null && tile.putcount <= 0) {
                            root.produce.addEXP(30, Produce.Brewing);
                            root.produce.addEXP(30, Produce.Cooking);
                            MMM.addItemToPlayer(ItemCoinSpecial.getTheCoinDropItems(ItemCoinSpecial.CoinTypes.Potion, 6), player);
                            MMM.addItemToPlayer(ItemCoinSpecial.getTheCoinDropItems(ItemCoinSpecial.CoinTypes.Cooking, 6), player);
                        }
                        if (tile.putcount > 0) {
                            --tile.putcount;
                        }
                    }
                    if (tile.winestate == WineState.Mold) {
                        tag = new NBTTagCompound();
                        tile.effect.saveToNBT(tag, "WinePoison");
                        wine = new ItemStack(CuisineCore.ItemWinePoisons);
                        wine.func_77982_d(tag);
                        MMM.addItemToPlayer(wine, player);
                        --tile.remaining;
                        root = MMM.getEntityNBT(player);
                        if (root != null && tile.putcount <= 0) {
                            root.produce.addEXP(100, Produce.Brewing);
                            root.produce.addEXP(100, Produce.Cooking);
                            MMM.addItemToPlayer(ItemCoinSpecial.getTheCoinDropItems(ItemCoinSpecial.CoinTypes.Potion, 50), player);
                            MMM.addItemToPlayer(ItemCoinSpecial.getTheCoinDropItems(ItemCoinSpecial.CoinTypes.Cooking, 50), player);
                        }
                        if (tile.putcount > 0) {
                            --tile.putcount;
                        }
                    }
                    if (tile.winestate == WineState.Rot) {
                        MMM.addItemToPlayer(new ItemStack(CuisineCore.ItemWineRots), player);
                        --tile.remaining;
                        if (tile.putcount > 0) {
                            --tile.putcount;
                        }
                    }
                    MMM.removePlayerCurrentItem(player);
                    MMM.playSoundFromServer(world, MMM.getMODID() + ":fill_bottle", new Pos(tile), 1.0, 1.0, 2.0);
                    if (tile.remaining > 0) {
                        MMM.addMessage(player, "MMM.info.BlockWineBarrel.has", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), tile.remaining, MMM.getTranslateText("AgingLevel." + tile.aginglevel.toString()));
                    }
                    if (tile.remaining <= 0) {
                        tile.winestate = WineState.Normal;
                        tile.aginglevel = IAlcoholItem.AgingLevel.Classic;
                        tile.moldcount = 0;
                        tile.rotcount = 0;
                        tile.putcount = 0;
                        tile.canaging = false;
                        tile.brewing = false;
                        tile.aging = false;
                    }
                } else {
                    MMM.addMessage(player, "MMM.info.BlockWineBarrel.glassbottle", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), tile.remaining, MMM.getTranslateText("AgingLevel." + tile.aginglevel.toString()));
                }
                return true;
            }
            if (item != null && tile.item == null && tile.remaining <= 0 && !tile.brewing && item.func_77973_b() != Items.field_151069_bo) {
                if (item.field_77994_a > 7) {
                    for (int s = 0; s < ManaMetalAPI.WineFormulaList.size(); ++s) {
                        WineFormula wf = ManaMetalAPI.WineFormulaList.get(s);
                        if (!MMM.isItemStackEqualNoNBT(wf.item, item)) continue;
                        tile.winetype = wf.type;
                        tile.item = item.func_77946_l();
                        tile.targetTime = System.currentTimeMillis() + (long)(50 * (tile.canaging ? TileEntityPotionWineBarrel.needTimeBrewing_core : TileEntityPotionWineBarrel.needTimeBrewing));
                        tile.brewing = true;
                        MMM.addMessage(player, "MMM.info.BlockWineBarrel.winestart", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), item.field_77994_a >= 8 ? item.field_77994_a / 8 : 1);
                        if (item.func_77973_b() == ItemCraft10.ItemWineF) {
                            MMM.addItemToPlayer(new ItemStack(ItemCraft10.ItemBarCup, item.field_77994_a, 0), player);
                        }
                        player.func_71028_bD();
                        return true;
                    }
                    MMM.addMessage(player, "MMM.info.BlockWineBarrel.itemcanwine", item.func_82833_r());
                    return true;
                }
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.cantwine");
                return true;
            }
            if (tile.item != null && tile.brewing) {
                int count = 1;
                if (tile.item != null && tile.item.field_77994_a >= 8) {
                    count = tile.item.field_77994_a / 8;
                }
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.makeing", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), count, MMM.getTranslateText("AgingLevel." + tile.aginglevel.toString()));
            } else if (tile.item == null && tile.aging) {
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.aginging", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), tile.remaining, MMM.getTranslateText("AgingLevel." + (Object)((Object)IAlcoholItem.AgingLevel.values()[tile.aginglevel.ordinal() + 1])));
            } else if (tile.remaining > 0) {
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.has", new ItemStack(BrewingCore.ItemWine_brewing, 1, tile.winetype.ordinal()).func_82833_r(), tile.remaining, MMM.getTranslateText("AgingLevel." + tile.aginglevel.toString()));
            } else {
                MMM.addMessage(player, "MMM.info.BlockWineBarrel.null");
            }
            switch (tile.winestate) {
                case Mold: {
                    MMM.addMessage(player, "MMM.info.BlockWineBarrel.Mold");
                    break;
                }
                case Rot: {
                    MMM.addMessage(player, "MMM.info.BlockWineBarrel.Rot");
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World p_149734_1_, int p_149734_2_, int p_149734_3_, int p_149734_4_, Random p_149734_5_) {
    }
}

