/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.brewing;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.magic.magicItem.MagicItemType;

public class Buff {
    public int time = 0;
    public IMagicEffect[] data;

    public Buff(int time, IMagicEffect[] data) {
        this.time = time;
        this.data = data;
    }

    public boolean LoadFromNBT(NBTTagCompound nbt, int id) {
        if (nbt.func_150297_b("buff_" + id, 10)) {
            NBTTagCompound tag = nbt.func_74775_l("buff_" + id);
            this.time = NBTHelp.getIntSafe("time", tag, 0);
            int count = NBTHelp.getIntSafe("count", tag, 0);
            if (count > 0) {
                this.data = new IMagicEffect[count];
                for (int s = 0; s < count; ++s) {
                    IMagicEffect temp;
                    this.data[s] = temp = new IMagicEffect(MagicItemType.values()[NBTHelp.getIntSafe("data_type_" + s, tag, 0)], NBTHelp.getFloatSafe("data_data_" + s, tag, 0.0f));
                }
            }
        }
        return false;
    }

    public void SaveToNBT(NBTTagCompound nbt, int id) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("time", this.time);
        tag.func_74768_a("count", this.data.length);
        for (int s = 0; s < this.data.length; ++s) {
            tag.func_74768_a("data_type_" + s, this.data[s].getType().ordinal());
            tag.func_74776_a("data_data_" + s, this.data[s].getValue());
        }
        nbt.func_74782_a("buff_" + id, (NBTBase)tag);
    }
}

