/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.casting;

import java.util.List;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.ItemType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.produce.casting.CastingEffectType;

public class CastingItemWord {
    public static final CastingEffectType getTypeUltimate(ItemStack out) {
        List<ItemType> type = MMM.getItemType(out);
        for (int s = 0; s < type.size(); ++s) {
            if (type.get(s) == ItemType.Weapon) {
                return CastingEffectType.eventually;
            }
            if (type.get(s) == ItemType.Tool) {
                return CastingEffectType.skygod;
            }
            if (type.get(s) != ItemType.Armor) continue;
            return CastingEffectType.brilliant;
        }
        return CastingEffectType.eventually;
    }

    public static final CastingEffectType getTypeLegend(ItemStack out) {
        List<ItemType> type = MMM.getItemType(out);
        for (int s = 0; s < type.size(); ++s) {
            if (type.get(s) == ItemType.Weapon) {
                return CastingEffectType.legend;
            }
            if (type.get(s) == ItemType.Tool) {
                return CastingEffectType.holy;
            }
            if (type.get(s) != ItemType.Armor) continue;
            return CastingEffectType.myth;
        }
        return CastingEffectType.legend;
    }

    public static final CastingEffectType getType(ItemStack out, ItemStack base) {
        List<ItemType> type = MMM.getItemType(out);
        for (int s = 0; s < type.size(); ++s) {
            if (type.get(s) == ItemType.Weapon) {
                return CastingItemWord.get(ItemType.Weapon, out, base);
            }
            if (type.get(s) == ItemType.Tool) {
                return CastingItemWord.get(ItemType.Tool, out, base);
            }
            if (type.get(s) != ItemType.Armor) continue;
            return CastingItemWord.get(ItemType.Armor, out, base);
        }
        return CastingEffectType.Junk;
    }

    public static final CastingEffectType get(ItemType type, ItemStack out, ItemStack base) {
        boolean noJunk = false;
        boolean absolute = false;
        boolean hasGood = false;
        if (base != null) {
            noJunk = NBTHelp.getBooleanSafe("hasNoJunk", base.func_77978_p(), false);
            absolute = NBTHelp.getBooleanSafe("hasCrit", base.func_77978_p(), false);
            hasGood = NBTHelp.getBooleanSafe("hasGood", base.func_77978_p(), false);
        }
        if (hasGood && MMM.rand.nextInt(10) == 0) {
            if (type == ItemType.Weapon) {
                return CastingEffectType.legend;
            }
            if (type == ItemType.Tool) {
                return CastingEffectType.holy;
            }
            if (type == ItemType.Armor) {
                return CastingEffectType.myth;
            }
        }
        int weights = 0;
        block5: for (int s = 0; s < 9999; ++s) {
            weights = MMM.rand.nextInt(100);
            CastingEffectType types = CastingEffectType.values()[MMM.rand.nextInt(CastingEffectType.values().length)];
            if (!(absolute && type == ItemType.Weapon || types.weight < weights)) {
                if (types.isBad && !noJunk) {
                    return types;
                }
                if (types.type == type || types.type == ItemType.Other) {
                    return types;
                }
            }
            if (!absolute || type != ItemType.Weapon || types.weight < weights) continue;
            WeaponType weapontype = MMM.getWeaponType(out);
            if (types.ordinal() < 6 || types == CastingEffectType.legend || types == CastingEffectType.eventually) {
                return types;
            }
            switch (weapontype) {
                case Magic: {
                    if (types != CastingEffectType.magical && types != CastingEffectType.mysterious && types != CastingEffectType.Magicguide) continue block5;
                    return types;
                }
                case PhysicalMelee: {
                    if (types != CastingEffectType.Strong && types != CastingEffectType.StrongBig && types != CastingEffectType.powerful) continue block5;
                    return types;
                }
                case PhysicalRange: {
                    if (types != CastingEffectType.Precision && types != CastingEffectType.accurate && types != CastingEffectType.Rapid) continue block5;
                    return types;
                }
            }
        }
        return CastingEffectType.normal;
    }
}

