/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.blocks.BlockTileEntityMetalSeparator;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.items.crafting.MetalSeparatorRecipes;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;
import project.studio.manametalmod.magicenergy.MagicEnergy;

public class TileEntityMetalSeparator
extends TileEntity
implements ISidedInventory,
IMagicEnergyUse {
    public ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    public String customName;
    public MagicEnergy energy = new MagicEnergy(0);
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    public int speed = 350;
    public static final int[] hopperIMP = new int[]{0, 1};
    public static final int[] hopperOUT = new int[]{2, 3};

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return hopperOUT;
        }
        return hopperIMP;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 0) {
            return MetalSeparatorRecipes.smelting().getSmeltingResult(item) != null;
        }
        if (slot == 1) {
            return MMM.getManaItem(item);
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 2 || slot == 3;
    }

    public TileEntityMetalSeparator(int speed) {
        this.speed = speed;
    }

    public TileEntityMetalSeparator() {
        this.speed = 350;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int data) {
        return this.inventory[data];
    }

    public ItemStack func_70298_a(int slot, int data) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= data) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(data);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.inventory[p_70304_1_] != null) {
            ItemStack itemstack = this.inventory[p_70304_1_];
            this.inventory[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventory[p_70299_1_] = p_70299_2_;
        if (p_70299_2_ != null && p_70299_2_.field_77994_a > this.func_70297_j_()) {
            p_70299_2_.field_77994_a = this.func_70297_j_();
        }
    }

    public void setInventoryName(String name) {
        if (name != null && !name.equals("")) {
            this.customName = name;
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.TileEntityMetalSeparator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public static boolean isItemFuel(ItemStack item) {
        return TileEntityMetalSeparator.getItemBurnTime(item) > 0;
    }

    public static int getItemBurnTime(ItemStack items) {
        return MMM.getManaItemFuelTime(items);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityMetalSeparator.getItemBurnTime(this.inventory[1]);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.speed = NBTHelp.getIntSafe("speed", nbt, 350);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energy.writeToNBT(nbt);
        nbt.func_74768_a("speed", this.speed);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int data) {
        return this.furnaceCookTime * data / this.speed;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int data) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.speed;
        }
        return this.furnaceBurnTime * data / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_145845_h() {
        if (this.energy.getEnergy() > 0 && this.inventory[0] != null && this.furnaceBurnTime < this.speed) {
            this.furnaceBurnTime += 4;
            this.energy.removeEnergy(1);
            BlockTileEntityMetalSeparator.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        boolean iscookk = this.furnaceBurnTime > 0;
        boolean updata = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != 0 || this.inventory[1] != null && this.inventory[0] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityMetalSeparator.getItemBurnTime(this.inventory[1]);
                    if (this.furnaceBurnTime > 0) {
                        updata = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].field_77994_a;
                            if (this.inventory[1].field_77994_a == 0) {
                                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime >= this.speed) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        updata = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (iscookk != this.furnaceBurnTime > 0) {
                updata = true;
                BlockTileEntityMetalSeparator.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (updata) {
            this.func_70296_d();
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = MetalSeparatorRecipes.smelting().getSmeltingResult(this.inventory[0]);
            if (this.inventory[3] == null) {
                this.inventory[3] = new ItemStack(ManaMetalMod.MetalEnergy01);
            } else if (this.inventory[3].func_77973_b() == ManaMetalMod.MetalEnergy01 && this.inventory[3].field_77994_a < 64) {
                ++this.inventory[3].field_77994_a;
            }
            if (this.inventory[2] == null) {
                this.inventory[2] = itemstack.func_77946_l();
            } else if (this.inventory[2].func_77973_b() == itemstack.func_77973_b()) {
                this.inventory[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    public boolean canSmelt() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = MetalSeparatorRecipes.smelting().getSmeltingResult(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.inventory[2].func_77976_d();
    }

    @Override
    public boolean needEnergy() {
        return this.energy.getEnergy() < this.getMaxEnergy();
    }

    @Override
    public void onImportEnergy() {
    }

    @Override
    public void addEnergy(MagicEnergy energy) {
    }

    @Override
    public int getMaxEnergy() {
        return 350;
    }

    @Override
    public MagicEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canImport() {
        return true;
    }
}

