/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.watergame;

import net.minecraft.world.World;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.watergame.TileEntityWaterGame;
import project.studio.manametalmod.watergame.WaterDirection;

public enum WaterGameType {
    soure,
    end,
    I,
    L,
    T,
    X,
    rock,
    Pillar,
    WaterDown,
    tunnelI,
    tunnelL,
    tunnelT,
    tunnelX,
    tunnelWaterDown;


    public static boolean canAdd(WaterGameType type, WaterDirection direction, WaterDirection target, boolean isUP) {
        switch (type) {
            case I: 
            case tunnelI: {
                if (isUP) {
                    return true;
                }
                if (direction == WaterDirection.Up || direction == WaterDirection.Dowm) {
                    return target == WaterDirection.Up || target == WaterDirection.Dowm;
                }
                if (direction == WaterDirection.Left || direction == WaterDirection.Right) {
                    return target == WaterDirection.Left || target == WaterDirection.Right;
                }
                return false;
            }
            case X: 
            case tunnelX: 
            case end: {
                return true;
            }
            case L: 
            case tunnelL: {
                if (isUP) {
                    return true;
                }
                switch (direction) {
                    case Up: {
                        return target == WaterDirection.Up || target == WaterDirection.Right;
                    }
                    case Dowm: {
                        return target == WaterDirection.Dowm || target == WaterDirection.Left;
                    }
                    case Left: {
                        return target == WaterDirection.Dowm || target == WaterDirection.Right;
                    }
                    case Right: {
                        return target == WaterDirection.Left || target == WaterDirection.Up;
                    }
                }
                return false;
            }
            case T: 
            case tunnelT: {
                if (isUP) {
                    return true;
                }
                switch (direction) {
                    case Up: {
                        return target == WaterDirection.Left || target == WaterDirection.Right || target == WaterDirection.Dowm;
                    }
                    case Dowm: {
                        return target == WaterDirection.Left || target == WaterDirection.Right || target == WaterDirection.Up;
                    }
                    case Left: {
                        return target == WaterDirection.Up || target == WaterDirection.Dowm || target == WaterDirection.Left;
                    }
                    case Right: {
                        return target == WaterDirection.Up || target == WaterDirection.Dowm || target == WaterDirection.Right;
                    }
                }
                return false;
            }
            case WaterDown: 
            case tunnelWaterDown: {
                if (isUP) {
                    return true;
                }
                switch (direction) {
                    case Up: {
                        return target == WaterDirection.Up;
                    }
                    case Dowm: {
                        return target == WaterDirection.Dowm;
                    }
                    case Left: {
                        return target == WaterDirection.Right;
                    }
                    case Right: {
                        return target == WaterDirection.Left;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void update(TileEntityWaterGame tile, World world, WaterDirection direction) {
        if (this == rock || this == Pillar) {
            return;
        }
        if (this == soure) {
            switch (direction) {
                case Up: {
                    this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                    return;
                }
                case Dowm: {
                    this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                    return;
                }
                case Left: {
                    this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                    return;
                }
                case Right: {
                    this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                    return;
                }
            }
            return;
        }
        if (tile.hasWater) {
            switch (this) {
                case WaterDown: 
                case tunnelWaterDown: {
                    this.addWater(world, tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e, true, WaterDirection.Up, true, new Pos(tile), this);
                    this.addWater(world, tile.field_145851_c, tile.field_145848_d - 2, tile.field_145849_e, true, WaterDirection.Up, true, new Pos(tile), this);
                    switch (direction) {
                        case Up: {
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            return;
                        }
                        case Dowm: {
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            return;
                        }
                        case Left: {
                            this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Up, true, new Pos(tile), this);
                            return;
                        }
                        case Right: {
                            this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Up, true, new Pos(tile), this);
                            return;
                        }
                    }
                    return;
                }
                case X: 
                case tunnelX: {
                    this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                    this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                    this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                    this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                    return;
                }
                case I: 
                case tunnelI: {
                    if (direction == WaterDirection.Up || direction == WaterDirection.Dowm) {
                        this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                        this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                    }
                    if (direction == WaterDirection.Left || direction == WaterDirection.Right) {
                        this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                        this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                    }
                    return;
                }
                case L: 
                case tunnelL: {
                    switch (direction) {
                        case Up: {
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                            return;
                        }
                        case Dowm: {
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                            return;
                        }
                        case Left: {
                            this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            return;
                        }
                        case Right: {
                            this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                            return;
                        }
                    }
                    return;
                }
                case T: 
                case tunnelT: {
                    switch (direction) {
                        case Up: {
                            this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            return;
                        }
                        case Dowm: {
                            this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                            return;
                        }
                        case Left: {
                            this.addWater(world, tile.field_145851_c - 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Right, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                            return;
                        }
                        case Right: {
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e + 1, false, WaterDirection.Up, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e - 1, false, WaterDirection.Dowm, true, new Pos(tile), this);
                            this.addWater(world, tile.field_145851_c + 1, tile.field_145848_d, tile.field_145849_e, false, WaterDirection.Left, true, new Pos(tile), this);
                            return;
                        }
                    }
                    return;
                }
            }
        }
    }

    public void addWater(World world, int x, int y, int z, boolean isDown, WaterDirection type, boolean isadd, Pos pos, WaterGameType soureType) {
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileEntityWaterGame) {
            TileEntityWaterGame target = (TileEntityWaterGame)world.func_147438_o(x, y, z);
            switch (target.type) {
                case rock: 
                case Pillar: 
                case soure: {
                    return;
                }
            }
            if (isDown) {
                switch (target.type) {
                    case tunnelI: 
                    case tunnelX: 
                    case tunnelL: 
                    case tunnelT: 
                    case tunnelWaterDown: {
                        return;
                    }
                }
            }
            if (WaterGameType.canAdd(target.type, target.direction, type, isDown)) {
                target.addWater(isadd, type, pos, soureType, isDown);
            }
        }
    }
}

