/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.generate;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.AreaClear;
import project.studio.manametalmod.core.BlockData;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.dungeon.Dungeon;
import project.studio.manametalmod.dungeon.DungeonCore;
import project.studio.manametalmod.furniture.FurnitureCore;
import project.studio.manametalmod.furniture.TileEntityFurniture;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.TileEntityInstanceDungeon;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.newmc.NewMinecraftBlockReplace;
import project.studio.manametalmod.pagan.BadGuyCore;
import project.studio.manametalmod.pagan.BadGuyType;
import project.studio.manametalmod.pagan.TileEntityBadGuySpawnOneTime;
import project.studio.manametalmod.world.WorldAncient;
import project.studio.manametalmod.world.generate.WorldGenDungeonDoor;

public class WorldGenDungeon
implements IWorldGenerator {
    public static final Map<Dungeon, Schematic> dungeons = new HashMap<Dungeon, Schematic>();
    public static final Map<String, Schematic> villages = new HashMap<String, Schematic>();
    public static final Random random = new Random();

    public static void serverStart(WorldEvent.Load event) {
    }

    public static void serverStop(WorldEvent.Save event) {
    }

    public void generateSurface(World world, Random r, int dx, int dz) {
        int posZ;
        int posX = dx + random.nextInt(15);
        int posYTop = world.func_72976_f(posX, posZ = dz + random.nextInt(15)) - 1;
        if (posYTop > 74) {
            return;
        }
        if (WorldGenDungeonDoor.isCanSpawnBlockTop(world, posX, posYTop, posZ)) {
            if (random.nextInt(M3Config.SpawnProbability_Dungeon) == 0) {
                Dungeon spawntype = Dungeon.values()[random.nextInt(Dungeon.values().length)];
                String name = "dungeon/" + spawntype.toString() + ".schematic";
                Schematic sh = null;
                if (dungeons.containsKey((Object)spawntype)) {
                    sh = dungeons.get((Object)spawntype);
                } else {
                    sh = new Schematic().loadSchematicFromJar(name);
                    dungeons.put(spawntype, sh);
                }
                int extra = 0;
                if (sh.width > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.width - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if (sh.length > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.length - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if (!WorldGenDungeonDoor.isOverlapping(posX, posYTop, posZ, extra)) {
                    WorldGenDungeonDoor.addPos(new Pos(posX, posYTop, posZ));
                    int big = Math.max(sh.width, sh.length);
                    int averageHeight = WorldGenDungeonDoor.getAverageHeight(world, posX + big / 2, posZ + big / 2, big);
                    if (averageHeight > 0) {
                        WorldGenDungeon.spawnDungeonSHBadGuy(world, posX, averageHeight, posZ, spawntype, sh, big);
                    }
                }
                return;
            }
            if (random.nextInt(M3Config.SpawnProbability_Village) == 0) {
                Schematic sh = null;
                String name = "village/village" + (random.nextInt(12) + 1) + ".schematic";
                if (villages.containsKey(name)) {
                    sh = villages.get(name);
                } else {
                    sh = new Schematic().loadSchematicFromJar(name);
                    villages.put(name, sh);
                }
                int extra = 0;
                if (sh.width > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.width - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if (sh.length > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.length - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if (!WorldGenDungeonDoor.isOverlapping(posX, posYTop, posZ, extra)) {
                    WorldGenDungeonDoor.addPos(new Pos(posX, posYTop, posZ));
                    int big = Math.max(sh.width, sh.length);
                    int averageHeight = WorldGenDungeonDoor.getAverageHeight(world, posX + big / 2, posZ + big / 2, big);
                    if (averageHeight > 0) {
                        WorldGenDungeon.spawnSchematicVillage(world, posX, averageHeight, posZ, sh, big);
                    }
                }
                return;
            }
            if (random.nextInt(M3Config.SpawnProbability_Spring) == 0) {
                if (!WorldGenDungeonDoor.isOverlapping(posX, posYTop, posZ, 0)) {
                    WorldGenDungeonDoor.addPos(new Pos(posX, posYTop, posZ));
                    switch (random.nextInt(2)) {
                        case 0: {
                            MMM.spawnSchematicManaS(world, posX, posYTop + 1, posZ, "other/ManaSpring.schematic");
                            return;
                        }
                        case 1: {
                            MMM.spawnSchematicManaS2(world, posX, posYTop + 1, posZ, "other/LifeSpring.schematic");
                            return;
                        }
                    }
                }
                return;
            }
        }
    }

    public static void spawnSchematicVillage(World world, int x, int y, int z, Schematic sh, int big) {
        AreaClear.clearArea(random, world, x - 4, y, z - 4, big + 8);
        int count = 0;
        int yFX = 0;
        BlockData BDT = new BlockData(Blocks.field_150348_b, 0);
        int idtemp = 0;
        int metadata = 0;
        for (int sy = 0; sy < sh.height; ++sy) {
            for (int sz = 0; sz < sh.length; ++sz) {
                for (int sx = 0; sx < sh.width; ++sx) {
                    idtemp = Schematic.getBlocksIDFormNegative(sh.blocks[count]);
                    Block blocktemp = Block.func_149729_e((int)idtemp);
                    metadata = sh.data[count];
                    if (NewMinecraftBlockReplace.getReplaceBlock(idtemp, metadata, BDT)) {
                        blocktemp = BDT.block;
                        metadata = BDT.blockMetadata;
                    } else if (blocktemp == Blocks.field_150340_R) {
                        blocktemp = ManaMetalMod.BLOCKBlockNpcSpawn;
                    } else if (blocktemp == Blocks.field_150484_ah) {
                        blocktemp = ItemCraft10.BlockNpcWoodenBoxs;
                    } else if (blocktemp == Blocks.field_150339_S) {
                        blocktemp = ManaMetalMod.OldUrn;
                    } else if (blocktemp == Blocks.field_150464_aj) {
                        blocktemp = ItemCraft10.WildBarley;
                    } else if (blocktemp == Blocks.field_150480_ab) {
                        blocktemp = DungeonCore.fireTrap1;
                    }
                    world.func_147465_d(x + sx, y + sy, z + sz, blocktemp, metadata, 2);
                    if (sy == 0 && blocktemp != Blocks.field_150350_a) {
                        yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++count;
                }
            }
        }
    }

    public static void spawnDungeonSHBadGuy(World world, int x, int y, int z, Dungeon spawntype, Schematic sh, int big) {
        AreaClear.clearArea(random, world, x - 4, y, z - 4, big + 8);
        BadGuyType mob_type = spawntype.getmob();
        InstanceDungeonType[] IDT = spawntype.getInstanceDungeonType();
        int count = 0;
        BlockData BDT = new BlockData(Blocks.field_150348_b, 0);
        for (int sy = 0; sy < sh.height; ++sy) {
            for (int sz = 0; sz < sh.length; ++sz) {
                for (int sx = 0; sx < sh.width; ++sx) {
                    int idtemp = Schematic.getBlocksIDFormNegative(sh.blocks[count]);
                    Block blocktemp = Block.func_149729_e((int)idtemp);
                    byte metadata = sh.data[count];
                    if (NewMinecraftBlockReplace.getReplaceBlock(idtemp, metadata, BDT)) {
                        world.func_147465_d(x + sx, y + sy, z + sz, BDT.block, BDT.blockMetadata, 2);
                    } else if (blocktemp == Blocks.field_150340_R) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ManaMetalMod.BigCoin, random.nextInt(2), 2);
                    } else if (blocktemp == Blocks.field_150339_S) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ManaMetalMod.OldUrn, random.nextInt(2), 2);
                    } else if (blocktemp == Blocks.field_150486_ae) {
                        world.func_147465_d(x + sx, y + sy, z + sz, (Block)Blocks.field_150486_ae, (int)sh.data[count], 2);
                        TileEntity tileentitychest = world.func_147438_o(x + sx, y + sy, z + sz);
                        if (tileentitychest != null && tileentitychest instanceof TileEntityChest) {
                            switch (random.nextInt(4)) {
                                case 0: {
                                    WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"villageBlacksmith", (Random)random), (IInventory)((TileEntityChest)tileentitychest), (int)spawntype.getItemCount());
                                    break;
                                }
                                case 1: {
                                    WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"pyramidJungleChest", (Random)random), (IInventory)((TileEntityChest)tileentitychest), (int)spawntype.getItemCount());
                                    break;
                                }
                                case 2: {
                                    WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"strongholdCorridor", (Random)random), (IInventory)((TileEntityChest)tileentitychest), (int)spawntype.getItemCount());
                                    break;
                                }
                                case 3: {
                                    WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"dungeonChest", (Random)random), (IInventory)((TileEntityChest)tileentitychest), (int)spawntype.getItemCount());
                                }
                            }
                        }
                    } else if (blocktemp == Blocks.field_150335_W) {
                        if (mob_type == BadGuyType.Mob) {
                            world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150474_ac, 0, 2);
                            TileEntityMobSpawner mob = new TileEntityMobSpawner();
                            mob.func_145881_a().func_98272_a(WorldGenDungeon.getMobName(random));
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)mob);
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, (Block)BadGuyCore.BlockBadGuySpawnOneTimes, 0, 2);
                            TileEntityBadGuySpawnOneTime tile = new TileEntityBadGuySpawnOneTime(mob_type, 0);
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                        }
                    } else if (blocktemp == Blocks.field_150360_v) {
                        TileEntityFurniture tile = new TileEntityFurniture();
                        tile.type = 63;
                        world.func_147465_d(x + sx, y + sy, z + sz, FurnitureCore.BlockFurnitureBases, (int)sh.data[count], 2);
                        world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                    } else if (blocktemp == Blocks.field_150483_bI) {
                        if (random.nextBoolean() && IDT != null) {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                            TileEntityInstanceDungeon tile = new TileEntityInstanceDungeon(IDT[random.nextInt(IDT.length)]);
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.BlockBreakDungeonDoor, 0, 2);
                        }
                    } else {
                        world.func_147465_d(x + sx, y + sy, z + sz, blocktemp, (int)sh.data[count], 2);
                    }
                    if (sy == 0 && blocktemp != Blocks.field_150350_a) {
                        int yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++count;
                }
            }
        }
    }

    public static String getMobName(Random rand) {
        switch (rand.nextInt(22)) {
            case 0: {
                return "Zombie";
            }
            case 1: {
                return "Blaze";
            }
            case 2: {
                return "Spider";
            }
            case 3: {
                return "Creeper";
            }
            case 4: {
                return "Skeleton";
            }
            case 5: {
                return "Enderman";
            }
            case 6: {
                return "CaveSpider";
            }
            case 7: {
                return MMM.getMODID() + ".EntityMummy";
            }
            case 8: {
                return MMM.getMODID() + ".EntityUndeadSkeleton";
            }
            case 9: {
                return MMM.getMODID() + ".EntityGhostMana";
            }
            case 10: {
                return MMM.getMODID() + ".EntityGhostWarrior";
            }
            case 11: {
                return MMM.getMODID() + ".EntityMobDrowned";
            }
            case 12: {
                return MMM.getMODID() + ".EntityMobZombieFat";
            }
            case 13: {
                return MMM.getMODID() + ".EntityScorpion";
            }
            case 14: {
                return MMM.getMODID() + ".EntitySilverfishMana";
            }
            case 15: {
                return MMM.getMODID() + ".EntityStonePuppet";
            }
            case 16: {
                return MMM.getMODID() + ".EntitySandPuppet";
            }
            case 17: {
                return MMM.getMODID() + ".EntitySandSpider";
            }
            case 18: {
                return MMM.getMODID() + ".EntityMobScorchedCorpse";
            }
            case 19: {
                return MMM.getMODID() + ".EntityMobZombieMiner";
            }
            case 20: {
                return MMM.getMODID() + ".EntityMobHusk";
            }
        }
        return "Zombie";
    }

    public void generateSurfaceWorldAncientID(World world, Random random, int dx, int dz) {
        int Zpos;
        int Xpos = dx + random.nextInt(15);
        int YposTop = world.func_72976_f(Xpos, Zpos = dz + random.nextInt(15)) - 1;
        if (YposTop > 74) {
            return;
        }
        if (world.func_147439_a(Xpos, YposTop, Zpos) != null && world.func_147439_a(Xpos, YposTop, Zpos) == WorldAncient.blockAncientGrass && random.nextInt(M3Config.SpawnProbability_Dungeon) == 0) {
            MMM.spawnIDungeonGZIP(world, Xpos, YposTop, Zpos, "bee_ancient");
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
        if (world.field_73011_w.field_76574_g == M3Config.WorldAncientID) {
            this.generateSurfaceWorldAncientID(world, random, chunkX * 16, chunkZ * 16);
        }
    }
}

