/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.generate;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.AreaClear;
import project.studio.manametalmod.core.BlockData;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonDoorStyle;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.TileEntityInstanceDungeon;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.world.biome.BiomeOcean;

public class WorldGenDungeonDoor
implements IWorldGenerator {
    public static final List<Pos> StructureSpawnPos = new ArrayList<Pos>();
    public static final Random random = new Random();
    public static Schematic doorSchematic;
    public static Schematic doorSchematic4;
    public static final InstanceDungeonType[] easyDungeon;
    public static InstanceDungeonType[] hardDungeon;
    public static final List<InstanceDungeonType[]> fourDungeon;

    public static void serverStart(WorldEvent.Load event) {
    }

    public static void serverStop(WorldEvent.Save event) {
    }

    public void generateSurface(World world, Random rand, int dx, int dz) {
        int posZ;
        int posX = dx + random.nextInt(15);
        int posYTop = world.func_72976_f(posX, posZ = dz + random.nextInt(15)) - 1;
        if (posYTop > 74 || WorldGenDungeonDoor.isOverlapping(posX, posYTop, posZ, 0)) {
            return;
        }
        if (WorldGenDungeonDoor.isCanSpawnBlockTop(world, posX, posYTop, posZ) && M3Config.SpawnProbability_DungeonDoor > 0 && random.nextInt(M3Config.SpawnProbability_DungeonDoor) == 0) {
            WorldGenDungeonDoor.addPos(new Pos(posX, posYTop, posZ));
            WorldGenDungeonDoor.trySpawn(world, posX, posYTop, posZ);
            return;
        }
    }

    public static boolean isCanSpawnBlockTop(World world, int x, int y, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome == null || biome instanceof BiomeOcean || biome instanceof BiomeGenBeach || biome instanceof BiomeGenRiver) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150329_H) {
            return true;
        }
        return biome != null && block == biome.field_76752_A && biome.field_76752_A.func_149721_r();
    }

    public static void addPos(Pos pos) {
        if (!StructureSpawnPos.contains(pos)) {
            StructureSpawnPos.add(pos);
        }
    }

    public static boolean isOverlapping(int x, int y, int z, int extra) {
        int size = StructureSpawnPos.size();
        for (int s = 0; s < size; ++s) {
            Pos temppos = StructureSpawnPos.get(s);
            if (MMM.getBlockDistance(x, y, z, temppos.X, temppos.Y, temppos.Z) >= M3Config.SpawnProbability_DungeonDoor_MinRange + extra) continue;
            return true;
        }
        return false;
    }

    public static void trySpawn(World world, int posX, int posYTop, int posZ) {
        int averageHeight = WorldGenDungeonDoor.getAverageHeight(world, posX + 12, posZ + 12, 24);
        if (averageHeight > 0) {
            InstanceDungeonDoorStyle style = new InstanceDungeonDoorStyle();
            style.random(random);
            if (random.nextInt(100) < 25) {
                WorldGenDungeonDoor.four_times(world, posX, averageHeight, posZ, MMM.getRandomItemFromList(fourDungeon), style);
            } else {
                WorldGenDungeonDoor.base(world, posX, averageHeight, posZ, style);
            }
        }
    }

    public static int getAverageHeight(World world, int cx, int cz, int range) {
        int sum = 0;
        int count = 0;
        int rangedata = range / 2;
        int centerY = world.func_72976_f(cx, cz);
        int minY = centerY - 8;
        int maxY = centerY + 8;
        for (int x = cx - rangedata; x <= cx + rangedata; ++x) {
            for (int z = cz - rangedata; z <= cz + rangedata; ++z) {
                int height = world.func_72976_f(x, z);
                if (height <= minY || height >= maxY) continue;
                sum += height;
                ++count;
            }
        }
        return count > 0 ? sum / count : -1;
    }

    public static void four_times(World world, int x, int y, int z, InstanceDungeonType[] dungeons, InstanceDungeonDoorStyle style) {
        MMM.Logg("new dungeon door spawn at X : " + x + " Y : " + y + " Z : " + z + " type : Four Type Dungeon");
        AreaClear.clearArea(random, world, x - 4, y, z - 4, 32);
        int count = 0;
        int ID = 0;
        Block tempblock = null;
        int yFX = 0;
        for (int sy = 0; sy < WorldGenDungeonDoor.doorSchematic4.height; ++sy) {
            for (int sz = 0; sz < WorldGenDungeonDoor.doorSchematic4.length; ++sz) {
                for (int sx = 0; sx < WorldGenDungeonDoor.doorSchematic4.width; ++sx) {
                    ID = Schematic.getBlocksIDFormNegative(WorldGenDungeonDoor.doorSchematic4.blocks[count]);
                    tempblock = Block.func_149729_e((int)ID);
                    if (tempblock == Blocks.field_150339_S) {
                        InstanceDungeonType tempdungeon = dungeons[WorldGenDungeonDoor.doorSchematic4.data[count]];
                        if (tempdungeon != null) {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)new TileEntityInstanceDungeon(tempdungeon));
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.BlockBreakDungeonDoor, 0, 2);
                        }
                    } else if (tempblock == Blocks.field_150340_R) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ItemCraft10.DungeonFourTimes, 0, 2);
                    } else if (tempblock == Blocks.field_150475_bE) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ManaMetalMod.blockRoseGold, 0, 2);
                    } else {
                        WorldGenDungeonDoor.setBlockFromStyle(style, world, x + sx, y + sy, z + sz, WorldGenDungeonDoor.doorSchematic4.data[count], tempblock, ID);
                    }
                    if (sy == 0) {
                        yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++count;
                }
            }
        }
    }

    public static void base(World world, int x, int y, int z, InstanceDungeonDoorStyle style) {
        InstanceDungeonType tempdungeon = InstanceDungeonType.values()[random.nextInt(InstanceDungeonType.values().length)];
        if (M3Config.DistanceDungeonDoor && world.func_72861_E() != null) {
            tempdungeon = MMM.getBlockDistance(x, y, z, world.func_72861_E().field_71574_a, world.func_72861_E().field_71572_b, world.func_72861_E().field_71573_c) < 500 ? easyDungeon[random.nextInt(easyDungeon.length)] : hardDungeon[random.nextInt(hardDungeon.length)];
        }
        MMM.Logg("new dungeon door spawn at X : " + x + " Y : " + y + " Z : " + z + " type : " + tempdungeon.toString());
        BlockData decorate = tempdungeon.getDecorateBlock(null);
        boolean isBreak = random.nextInt(6) == 0;
        AreaClear.clearArea(random, world, x - 4, y, z - 4, 32);
        int count = 0;
        int ID = 0;
        int yFX = 0;
        Block tempblock = null;
        for (int sy = 0; sy < WorldGenDungeonDoor.doorSchematic.height; ++sy) {
            for (int sz = 0; sz < WorldGenDungeonDoor.doorSchematic.length; ++sz) {
                for (int sx = 0; sx < WorldGenDungeonDoor.doorSchematic.width; ++sx) {
                    ID = Schematic.getBlocksIDFormNegative(WorldGenDungeonDoor.doorSchematic.blocks[count]);
                    tempblock = Block.func_149729_e((int)ID);
                    if (tempblock == Blocks.field_150339_S) {
                        if (isBreak) {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.BlockBreakDungeonDoor, 0, 2);
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                            TileEntityInstanceDungeon tile = new TileEntityInstanceDungeon(tempdungeon);
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                        }
                    } else if (tempblock == Blocks.field_150340_R) {
                        if (isBreak) {
                            world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150347_e, 0, 2);
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, decorate.block, decorate.blockMetadata, 2);
                        }
                    } else {
                        WorldGenDungeonDoor.setBlockFromStyle(style, world, x + sx, y + sy, z + sz, WorldGenDungeonDoor.doorSchematic.data[count], tempblock, ID);
                    }
                    if (sy == 0) {
                        yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++count;
                }
            }
        }
    }

    public static void setBlockFromStyle(InstanceDungeonDoorStyle style, World world, int x, int y, int z, int metadata, Block oldblock, int ID) {
        switch (ID) {
            case 4: {
                MMM.setBlock(world, style.Cobblestone, x, y, z);
                return;
            }
            case 48: {
                MMM.setBlock(world, style.MossCobblestone, x, y, z);
                return;
            }
            case 98: {
                MMM.setBlock(world, metadata == 1 ? style.MossStoneBrick : style.StoneBrick, x, y, z);
                return;
            }
            case 139: {
                MMM.setBlock(world, style.CobblestoneWall, x, y, z);
                return;
            }
            case 44: {
                world.func_147465_d(x, y, z, metadata == 8 ? style.HalfSlabUp.block : style.HalfSlabDown.block, metadata == 8 ? style.HalfSlabUp.blockMetadata : style.HalfSlabDown.blockMetadata, 2);
                return;
            }
            case 43: {
                MMM.setBlock(world, style.DoubleHalfSlab, x, y, z);
                return;
            }
            case 18: {
                world.func_147465_d(x, y, z, style.Leaf, 4, 2);
                return;
            }
            case 67: {
                world.func_147465_d(x, y, z, style.CobblestoneStairs, metadata, 2);
                return;
            }
            case 109: {
                world.func_147465_d(x, y, z, style.StoneBrickStairs, metadata, 2);
                return;
            }
            case 156: {
                world.func_147465_d(x, y, z, style.QuartzStairs, metadata, 2);
                return;
            }
            case 22: {
                MMM.setBlock(world, style.Lapis, x, y, z);
                return;
            }
        }
        world.func_147465_d(x, y, z, oldblock, metadata, 2);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    static {
        easyDungeon = new InstanceDungeonType[]{InstanceDungeonType.FireDungeon, InstanceDungeonType.WaterDungeon, InstanceDungeonType.GrassDungeon, InstanceDungeonType.IceDungeon, InstanceDungeonType.SkullDungeon, InstanceDungeonType.SandDungeon};
        fourDungeon = new ArrayList<InstanceDungeonType[]>();
        doorSchematic = new Schematic().loadSchematicFromJar("InstanceDungeon/door.schematic");
        doorSchematic4 = new Schematic().loadSchematicFromJar("InstanceDungeon/door_4.schematic");
        ArrayList<InstanceDungeonType> dungoens = new ArrayList<InstanceDungeonType>();
        dungoens.add(InstanceDungeonType.FeatherSnakeTemple);
        dungoens.add(InstanceDungeonType.RoseTallTower);
        dungoens.add(InstanceDungeonType.Stronghold);
        dungoens.add(InstanceDungeonType.SkyTower);
        dungoens.add(InstanceDungeonType.TheHeroTemple);
        dungoens.add(InstanceDungeonType.SnakeLibrary);
        dungoens.add(InstanceDungeonType.EarthDungeon);
        dungoens.add(InstanceDungeonType.TheGodTemple);
        dungoens.add(InstanceDungeonType.DuckVillage);
        dungoens.add(InstanceDungeonType.DarkDungeon);
        dungoens.add(InstanceDungeonType.GiantMaze);
        dungoens.add(InstanceDungeonType.WhiteDragonTemple);
        dungoens.add(InstanceDungeonType.BlackCastle);
        dungoens.add(InstanceDungeonType.FourSeasonsTemple);
        dungoens.add(InstanceDungeonType.WolfPalace);
        dungoens.add(InstanceDungeonType.WhiteStonePalace);
        dungoens.add(InstanceDungeonType.TrialTower);
        dungoens.add(InstanceDungeonType.RoseGarden);
        dungoens.add(InstanceDungeonType.DragonDoor);
        hardDungeon = dungoens.toArray(new InstanceDungeonType[0]);
        fourDungeon.add(new InstanceDungeonType[]{InstanceDungeonType.FireDungeon, InstanceDungeonType.WaterDungeon, InstanceDungeonType.GrassDungeon, InstanceDungeonType.IceDungeon});
        fourDungeon.add(new InstanceDungeonType[]{InstanceDungeonType.SandDungeon, InstanceDungeonType.SkullDungeon, InstanceDungeonType.Pyramid, InstanceDungeonType.TheLostTemple});
        fourDungeon.add(new InstanceDungeonType[]{InstanceDungeonType.FeatherSnakeTemple, InstanceDungeonType.SnakeLibrary, InstanceDungeonType.RoseTallTower, InstanceDungeonType.Stronghold});
        fourDungeon.add(new InstanceDungeonType[]{InstanceDungeonType.EarthDungeon, InstanceDungeonType.DuckVillage, InstanceDungeonType.WolfPalace, InstanceDungeonType.TheGodTemple});
        fourDungeon.add(new InstanceDungeonType[]{InstanceDungeonType.RoseTallTower, InstanceDungeonType.Stronghold, InstanceDungeonType.RoseGarden, null});
        fourDungeon.add(new InstanceDungeonType[]{InstanceDungeonType.TheGodTemple, InstanceDungeonType.TheHeroTemple, null, InstanceDungeonType.WolfPalace});
    }
}

