/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.origin.biome;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public class WorldChunkManagerOrigin
extends WorldChunkManager {
    public static ArrayList<BiomeGenBase> allowedBiomes = new ArrayList<BiomeGenBase>(Arrays.asList(BiomeGenBase.field_76767_f, BiomeGenBase.field_76772_c, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u, BiomeGenBase.field_76785_t, BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x));
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List biomesToSpawnIn = new ArrayList();

    protected WorldChunkManagerOrigin() {
        this.biomesToSpawnIn.addAll(allowedBiomes);
    }

    public WorldChunkManagerOrigin(long seed, WorldType type) {
        this();
        GenLayer[] agenlayer = GenLayer.func_75901_a((long)seed, (WorldType)type);
        agenlayer = this.getModdedBiomeGenerators(type, seed, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    public WorldChunkManagerOrigin(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int p_76935_1_, int p_76935_2_) {
        return this.biomeCache.func_76837_b(p_76935_1_, p_76935_2_);
    }

    public float[] func_76936_a(float[] p_76936_1_, int p_76936_2_, int p_76936_3_, int p_76936_4_, int p_76936_5_) {
        IntCache.func_76446_a();
        if (p_76936_1_ == null || p_76936_1_.length < p_76936_4_ * p_76936_5_) {
            p_76936_1_ = new float[p_76936_4_ * p_76936_5_];
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(p_76936_2_, p_76936_3_, p_76936_4_, p_76936_5_);
        for (int i1 = 0; i1 < p_76936_4_ * p_76936_5_; ++i1) {
            try {
                float f = (float)BiomeGenBase.func_150568_d((int)aint[i1]).func_76744_g() / 65536.0f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                p_76936_1_[i1] = f;
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                crashreportcategory.func_71507_a("biome id", (Object)i1);
                crashreportcategory.func_71507_a("downfalls[] size", (Object)p_76936_1_.length);
                crashreportcategory.func_71507_a("x", (Object)p_76936_2_);
                crashreportcategory.func_71507_a("z", (Object)p_76936_3_);
                crashreportcategory.func_71507_a("w", (Object)p_76936_4_);
                crashreportcategory.func_71507_a("h", (Object)p_76936_5_);
                throw new ReportedException(crashreport);
            }
        }
        return p_76936_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float p_76939_1_, int p_76939_2_) {
        return p_76939_1_;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] data, int chunkX, int chunkZ, int sizeX, int sizeZ) {
        IntCache.func_76446_a();
        if (data == null || data.length < sizeX * sizeZ) {
            data = new BiomeGenBase[sizeX * sizeZ];
        }
        int[] aint = this.genBiomes.func_75904_a(chunkX, chunkZ, sizeX, sizeZ);
        try {
            for (int s = 0; s < sizeX * sizeZ; ++s) {
                data[s] = BiomeGenBase.func_150568_d((int)aint[s]);
            }
            return data;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)data.length);
            crashreportcategory.func_71507_a("x", (Object)chunkX);
            crashreportcategory.func_71507_a("z", (Object)chunkZ);
            crashreportcategory.func_71507_a("w", (Object)sizeX);
            crashreportcategory.func_71507_a("h", (Object)sizeZ);
            throw new ReportedException(crashreport);
        }
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] biomes, int chunkX, int chunkZ, int sizeX, int sizeZ) {
        return this.func_76931_a(biomes, chunkX, chunkZ, sizeX, sizeZ, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomes, int chunkX, int chunkZ, int sizeX, int sizeZ, boolean cache) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < sizeX * sizeZ) {
            biomes = new BiomeGenBase[sizeX * sizeZ];
        }
        if (cache && sizeX == 16 && sizeZ == 16 && (chunkX & 0xF) == 0 && (chunkZ & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase1 = this.biomeCache.func_76839_e(chunkX, chunkZ);
            System.arraycopy(abiomegenbase1, 0, biomes, 0, sizeX * sizeZ);
            return biomes;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(chunkX, chunkZ, sizeX, sizeZ);
        for (int i1 = 0; i1 < sizeX * sizeZ; ++i1) {
            biomes[i1] = BiomeGenBase.func_150568_d((int)aint[i1]);
        }
        return biomes;
    }

    public boolean func_76940_a(int p_76940_1_, int p_76940_2_, int p_76940_3_, List p_76940_4_) {
        IntCache.func_76446_a();
        int l = p_76940_1_ - p_76940_3_ >> 2;
        int i1 = p_76940_2_ - p_76940_3_ >> 2;
        int j1 = p_76940_1_ + p_76940_3_ >> 2;
        int k1 = p_76940_2_ + p_76940_3_ >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.genBiomes.func_75904_a(l, i1, l1, i2);
        try {
            for (int j2 = 0; j2 < l1 * i2; ++j2) {
                BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[j2]);
                if (p_76940_4_.contains(biomegenbase)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)p_76940_1_);
            crashreportcategory.func_71507_a("z", (Object)p_76940_2_);
            crashreportcategory.func_71507_a("radius", (Object)p_76940_3_);
            crashreportcategory.func_71507_a("allowed", (Object)p_76940_4_);
            throw new ReportedException(crashreport);
        }
    }

    public ChunkPosition func_150795_a(int p_150795_1_, int p_150795_2_, int p_150795_3_, List p_150795_4_, Random p_150795_5_) {
        IntCache.func_76446_a();
        int l = p_150795_1_ - p_150795_3_ >> 2;
        int i1 = p_150795_2_ - p_150795_3_ >> 2;
        int j1 = p_150795_1_ + p_150795_3_ >> 2;
        int k1 = p_150795_2_ + p_150795_3_ >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.genBiomes.func_75904_a(l, i1, l1, i2);
        ChunkPosition chunkposition = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[k2]);
            if (!p_150795_4_.contains(biomegenbase) || chunkposition != null && p_150795_5_.nextInt(j2 + 1) != 0) continue;
            chunkposition = new ChunkPosition(l2, 0, i3);
            ++j2;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newBiomeGens;
    }
}

