/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.Lapuda;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import project.studio.manametalmod.Lapuda.EntityBossHydraItem;
import project.studio.manametalmod.Lapuda.EntityBossHydraItemCore;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.addon.twilight_forest.TwilightForestCore;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityBlossRune;
import project.studio.manametalmod.mob.EntityMagicBallGravity;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.mob.EntityMagicObject;
import project.studio.manametalmod.mob.EntityMobAntiMagic;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;

public class BossHydra
extends EntityMobAntiMagic
implements IBossDisplayData,
IEntityAdditionalSpawnData {
    public int stage = 0;
    public int gravityBall = 0;
    public int slowBall = 0;
    public int rundTime = 0;
    boolean isBad = true;
    public int music = 0;
    public int lightattack = 0;
    public int superBalls = 0;
    public boolean summonHP = false;
    public int time = 0;
    public int timeSameLife = 0;
    public boolean isPowered = false;
    public int field_70729_aU = 0;
    public static int[] posx = new int[]{-5, 0, 5, -5, 0, 5};
    public static int[] posz = new int[]{-5, -5, -5, 5, 5, 5};

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("stage", this.stage);
        nbt.func_74768_a("gravityBall", this.gravityBall);
        nbt.func_74768_a("slowBall", this.slowBall);
        nbt.func_74768_a("rundTime", this.rundTime);
        nbt.func_74768_a("lightattack", this.lightattack);
        nbt.func_74768_a("superBalls", this.superBalls);
        nbt.func_74768_a("timeSameLife", this.timeSameLife);
        nbt.func_74757_a("summonHP", this.summonHP);
        nbt.func_74757_a("isPowered", this.isPowered);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.stage = NBTHelp.getIntSafe("stage", nbt, 0);
        this.gravityBall = NBTHelp.getIntSafe("gravityBall", nbt, 0);
        this.slowBall = NBTHelp.getIntSafe("slowBall", nbt, 0);
        this.rundTime = NBTHelp.getIntSafe("rundTime", nbt, 0);
        this.lightattack = NBTHelp.getIntSafe("lightattack", nbt, 0);
        this.superBalls = NBTHelp.getIntSafe("superBalls", nbt, 0);
        this.timeSameLife = NBTHelp.getIntSafe("timeSameLife", nbt, 0);
        this.summonHP = NBTHelp.getBooleanSafe("summonHP", nbt, false);
        this.isPowered = NBTHelp.getBooleanSafe("isPowered", nbt, false);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.stage);
        buffer.writeBoolean(this.isPowered);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.stage = additionalData.readInt();
        this.isPowered = additionalData.readBoolean();
    }

    public BossHydra(World World2) {
        super(World2);
        this.func_70105_a(1.6f, 3.5f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70178_ae = true;
        this.func_110163_bv();
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        ++this.music;
        ++this.time;
        if (this.music > 1760) {
            this.music = 0;
            this.field_70170_p.func_72956_a((Entity)this, MMM.getMODID() + ":event.boss", 10.0f, 1.0f);
        }
        if (this.field_70128_L) {
            return;
        }
        this.addEffect();
        if (this.stage == 3 && this.func_110143_aJ() < 49990.0f) {
            this.func_70691_i(10.0f);
        }
        if (!this.doSuperBalls()) {
            return;
        }
        if (this.fireSlowBall()) {
            this.fireBallAttackgravity();
        }
        this.spawnRuneStone();
        this.doLightAttack();
    }

    public void addEffect() {
        List<EntityPlayer> lst;
        if (this.time % 80 == 0 && !(lst = MMM.findPlayers((Entity)this, 64)).isEmpty()) {
            for (int b = 0; b < lst.size(); ++b) {
                PotionEffectM3.addPotion((EntityLivingBase)lst.get(b), PotionM3.potionPressure, 5, 3);
                PotionEffectM3.addPotion((EntityLivingBase)lst.get(b), PotionM3.potionFlyInv, 5, 0);
            }
        }
    }

    public void closeInv() {
        MMM.sendBossMessage((Entity)this, -5, 0, 0, 64);
        this.isPowered = false;
        this.func_70674_bp();
        PotionEffectM3.clear((EntityLivingBase)this);
        MMM.fakeExplosion(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 1, 1.0f, false);
    }

    public void summon() {
        if (!this.summonHP) {
            this.summonHP = true;
        }
    }

    public boolean doSuperBalls() {
        if (this.stage == 2) {
            ++this.superBalls;
            if (this.superBalls > 100) {
                if (this.func_70638_az() != null) {
                    this.see_target();
                    this.func_70690_d(new PotionEffect(2, 100, 5));
                    if (this.superBalls % 3 == 0) {
                        EntityLivingBase target = this.func_70638_az();
                        EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, 500, ManaElements.Wind, 0, null);
                        if (!this.field_70170_p.field_72995_K) {
                            ball.field_70125_A -= -20.0f;
                            double d0 = target.field_70165_t + target.field_70159_w - this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                            double d1 = target.field_70163_u - 2.0 - this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                            double d2 = target.field_70161_v + target.field_70179_y - this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                            ball.func_70186_c(d0 *= 1.5, d1 *= 1.5, d2 *= 1.5, 0.75f, 1.0f);
                            this.field_70170_p.func_72838_d((Entity)ball);
                        }
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Wind), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    }
                }
                if (this.superBalls > 300) {
                    this.superBalls = -1000;
                }
                return false;
            }
        }
        return true;
    }

    public void doLightAttack() {
        int s;
        List<EntityPlayer> list;
        ++this.lightattack;
        if (this.lightattack == 30 || this.lightattack == 60 || this.lightattack == 90 || this.lightattack == 120 || this.lightattack == 150) {
            list = MMM.findPlayers((Entity)this, 32);
            int size = list.size();
            for (s = 0; s < size; ++s) {
                MMM.spawnRuneFXServerSound((EntityLivingBase)list.get(s), ManaElements.Thunder, 200, 2.0f, true, 5, true);
            }
        }
        if (this.lightattack > 200) {
            this.lightattack = -800;
            list = MMM.findEntity((Entity)this, 64);
            for (s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof EntityBlossRune)) continue;
                EntityBlossRune rune = (EntityBlossRune)list.get(s);
                if (!rune.isMob || rune.Elements != ManaElements.Thunder) continue;
                MMM.arcLightning_vanilla(this.field_70170_p, ((Entity)list.get((int)s)).field_70165_t, ((Entity)list.get((int)s)).field_70163_u, ((Entity)list.get((int)s)).field_70161_v, 10000.0f, 255.0f, 0.0f, 0.0f);
                rune.func_70106_y();
            }
        }
    }

    public void spawnRuneStone() {
        ++this.rundTime;
        if (this.rundTime > 500) {
            int s;
            if (this.rundTime == 501) {
                this.func_70690_d(new PotionEffect(2, 100, 5));
                this.isBad = this.field_70170_p.field_73012_v.nextInt(2) == 0;
                MMM.spawnRuneFXServerSound((EntityLivingBase)this, this.isBad ? ManaElements.Dark : ManaElements.Light, 100, 4.0f, true, 32);
                for (s = 0; s < 5; ++s) {
                    int[] pos = this.findCanSpawnRuneCoord();
                    if (pos == null) continue;
                    EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, 100, this.isBad ? 14 : 13, 800.0f, (EntityLivingBase)this);
                    obj.func_70080_a(pos[0], pos[1] - 1, pos[2], 0.0f, 0.0f);
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_72838_d((Entity)obj);
                }
            }
            if (this.rundTime > 599) {
                if (!this.isBad) {
                    MMM.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 20, 4.0f, true, 32);
                    List<EntityPlayer> players = MMM.findPlayers((Entity)this, 36);
                    for (s = 0; s < players.size(); ++s) {
                        EntityPlayer temp = players.get(s);
                        boolean attack = true;
                        List<Entity> objs = MMM.findEntity((Entity)temp, 3);
                        for (int z = 0; z < objs.size(); ++z) {
                            if (!(objs.get(z) instanceof EntityMagicObject)) continue;
                            EntityMagicObject obj = (EntityMagicObject)objs.get(z);
                            if (obj.type != 13) continue;
                            attack = false;
                            break;
                        }
                        if (!attack) continue;
                        MMM.arcLightning_vanilla(this.field_70170_p, temp.field_70165_t, temp.field_70163_u, temp.field_70161_v, 2200.0f, 255.0f, 0.0f, 0.0f);
                    }
                }
                this.rundTime = 0;
                MMM.sendBossMessage((Entity)this, -1, 0, 0, 64);
            }
        }
    }

    public int[] findCanSpawnRuneCoord() {
        int dx = 0;
        int dz = 0;
        for (int s = 0; s < 64; ++s) {
            dx = this.field_70170_p.field_73012_v.nextInt(16) - this.field_70170_p.field_73012_v.nextInt(16);
            if (!this.field_70170_p.func_147437_c((int)this.field_70165_t + dx, (int)this.field_70163_u, (int)this.field_70161_v + (dz = this.field_70170_p.field_73012_v.nextInt(16) - this.field_70170_p.field_73012_v.nextInt(16))) || !this.field_70170_p.func_147437_c((int)this.field_70165_t + dx, (int)this.field_70163_u + 1, (int)this.field_70161_v + dz)) continue;
            return new int[]{(int)this.field_70165_t + dx, (int)this.field_70163_u + 1, (int)this.field_70161_v + dz};
        }
        return null;
    }

    public boolean fireSlowBall() {
        if (this.func_70638_az() != null) {
            ++this.slowBall;
            if (this.slowBall > 350) {
                if (this.slowBall == 351) {
                    MMM.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Wind, 60, 4.0f, true, 32);
                }
                if (this.slowBall % 20 == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Magic), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, 500, ManaElements.Magic, 0, (Entity)this.func_70638_az());
                    ball.setTracktype(EntityMagicBallNew.MoveTrackType.Slow);
                    ball.setSpaceTextureID(5);
                    ball.setSize(2.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)ball);
                    }
                }
                if (this.slowBall > 415) {
                    this.slowBall = 0;
                }
                return false;
            }
        }
        return true;
    }

    public void fireBallAttackgravity() {
        if (this.func_70638_az() != null) {
            ++this.gravityBall;
            if (this.gravityBall > 100) {
                this.see_target();
                if (this.gravityBall == 101) {
                    MMM.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 60, 4.0f, true, 32);
                    this.func_70690_d(new PotionEffect(2, 60, 5));
                }
                if (this.gravityBall > 160) {
                    this.gravityBall = 0;
                    this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.5f, 4, 2.0f, 0);
                    EntityMagicBallGravity ball1 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.5f, 4, 2.0f, 12);
                    EntityMagicBallGravity ball2 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.5f, 4, 2.0f, 24);
                    EntityMagicBallGravity ball4 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.5f, 4, 2.0f, -12);
                    EntityMagicBallGravity ball5 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.5f, 4, 2.0f, -24);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)ball0);
                        this.field_70170_p.func_72838_d((Entity)ball1);
                        this.field_70170_p.func_72838_d((Entity)ball2);
                        this.field_70170_p.func_72838_d((Entity)ball4);
                        this.field_70170_p.func_72838_d((Entity)ball5);
                    }
                }
            }
        }
    }

    public void see_target() {
        if (this.func_70638_az() != null) {
            EntityLivingBase targetedEntity = this.func_70638_az();
            this.func_70671_ap().func_75650_a(targetedEntity.field_70165_t, targetedEntity.field_70163_u + (double)targetedEntity.func_70047_e(), targetedEntity.field_70161_v, 10.0f, (float)this.func_70646_bf());
            this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getAngle(targetedEntity.field_70165_t, targetedEntity.field_70161_v, this.field_70165_t, this.field_70161_v) + 90.0f, (float)(targetedEntity.field_70163_u - this.field_70163_u + (double)targetedEntity.func_70047_e()));
            this.func_70671_ap().func_75649_a();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(600000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    @Override
    protected void func_70628_a(boolean playerHIT, int luck) {
        super.func_70628_a(playerHIT, luck);
        if (MMM.isTwilightForest) {
            TwilightForestCore.dropHydraChop(this);
        }
    }

    protected void func_70785_a(Entity target, float distance) {
        if (distance > 2.0f && distance < 6.0f && this.field_70146_Z.nextInt(10) == 0 && MMM.canUpdate((EntityLivingBase)this)) {
            if (this.field_70122_E) {
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
        } else {
            super.func_70785_a(target, distance);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (PotionEffectM3.isPotion((EntityLivingBase)this, PotionM3.potionInvincible)) {
            return false;
        }
        if (this.func_110143_aJ() < 300000.0f && this.stage == 0) {
            this.stage = 1;
            MMM.sendBossMessage((Entity)this, 1, 0, 0, 64);
        }
        if (this.func_110143_aJ() < 200000.0f && this.stage == 1) {
            this.stage = 2;
            MMM.sendBossMessage((Entity)this, 2, 0, 0, 64);
            MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, 255.0f, 0.0f, 0.0f);
        }
        if (this.func_110143_aJ() < 50000.0f && this.stage == 2) {
            this.stage = 3;
            MMM.sendBossMessage((Entity)this, 3, 0, 0, 64);
            this.summon();
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof BossHydra) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(10) == 0 && source instanceof EntityDamageSource && source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
            for (int s = 0; s < 16; ++s) {
                if (!this.teleportRandomly()) continue;
                return false;
            }
        }
        if (source == AttackType.GravityDamage || source.field_76373_n.equals(AttackType.GravityDamage.field_76373_n)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void teleportToEntity(EntityLivingBase target) {
        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
    }

    @Override
    protected boolean teleportTo(double x, double y, double z) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (double)this.field_70146_Z.nextInt(10) - 5.0;
        double d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(6) - 3.0;
        double d2 = this.field_70161_v + (double)this.field_70146_Z.nextInt(10) - 5.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportRandomlyEntity(Entity entity) {
        double d0 = entity.field_70165_t + (double)this.field_70146_Z.nextInt(4) - 1.0;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v + (double)this.field_70146_Z.nextInt(4) - 1.0;
        return this.teleportTo(d0, d1, d2);
    }

    public float getAngle(double px1, double py1, double px2, double py2) {
        double x = px2 - px1;
        double y = py2 - py1;
        double hypotenuse = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double cos = x / hypotenuse;
        double radian = Math.acos(cos);
        double angle = 180.0 / (Math.PI / radian);
        if (y < 0.0) {
            angle = -angle;
        } else if (y == 0.0 && x < 0.0) {
            angle = 180.0;
        }
        return (float)angle;
    }

    protected void func_70609_aI() {
        List<Entity> list;
        ++this.field_70729_aU;
        if (this.field_70729_aU % 4 == 0) {
            MMM.fakeExplosion(this.field_70170_p, (int)this.field_70165_t + this.field_70170_p.field_73012_v.nextInt(3) - this.field_70170_p.field_73012_v.nextInt(3), (int)this.field_70163_u + this.field_70170_p.field_73012_v.nextInt(3) - this.field_70170_p.field_73012_v.nextInt(3), (int)this.field_70161_v + this.field_70170_p.field_73012_v.nextInt(3) - this.field_70170_p.field_73012_v.nextInt(3), 1, 1.0f, false);
        }
        if (this.field_70729_aU % 7 == 0) {
            MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0f, 255.0f, 0.0f, 0.0f);
        }
        if (this.field_70729_aU == 99 && this.field_70729_aU == 101 && !this.field_70170_p.field_72995_K && !(list = MMM.findEntity((Entity)this, 80)).isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                if (list.get(s) instanceof EntityBossHydraItem) {
                    list.get(s).func_70106_y();
                }
                if (!(list.get(s) instanceof EntityBossHydraItemCore)) continue;
                list.get(s).func_70106_y();
            }
        }
        if (this.field_70729_aU > 100) {
            super.func_70609_aI();
        }
    }
}

