/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import project.studio.manametalmod.ai.PathEntityM3;
import project.studio.manametalmod.ai.PathM3;
import project.studio.manametalmod.ai.PathPointM3;

public class PathFinderM3 {
    private IBlockAccess worldMap;
    private PathM3 path = new PathM3();
    private IntHashMap pointMap = new IntHashMap();
    private PathPointM3[] pathOptions = new PathPointM3[32];
    private boolean isWoddenDoorAllowed;
    private boolean isMovementBlockAllowed;
    private boolean isPathingInWater;
    private boolean canEntityDrown;

    public PathFinderM3(IBlockAccess world, boolean isWoddenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        this.worldMap = world;
        this.isWoddenDoorAllowed = isWoddenDoorAllowed;
        this.isMovementBlockAllowed = isMovementBlockAllowed;
        this.isPathingInWater = isPathingInWater;
        this.canEntityDrown = canEntityDrown;
    }

    public static PathEntityM3 getPathEntityToEntity(Entity entity, Entity target, float data, boolean isWoddenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        entity.field_70170_p.field_72984_F.func_76320_a("pathfind");
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)(entity.field_70163_u + 1.0));
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        int l = (int)(data + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(entity.field_70170_p, i1, j1, k1, l1, i2, j2, 0);
        PathEntityM3 pathentity = new PathFinderM3((IBlockAccess)chunkcache, isWoddenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown).createEntityPathTo(entity, target, data);
        entity.field_70170_p.field_72984_F.func_76319_b();
        return pathentity;
    }

    public static PathEntityM3 getEntityPathToXYZ(Entity entity, int dx, int dy, int dz, float data, boolean isWoddenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        entity.field_70170_p.field_72984_F.func_76320_a("pathfind");
        int l = MathHelper.func_76128_c((double)entity.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)entity.field_70163_u);
        int j1 = MathHelper.func_76128_c((double)entity.field_70161_v);
        int k1 = (int)(data + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(entity.field_70170_p, l1, i2, j2, k2, l2, i3, 0);
        PathEntityM3 pathentity = new PathFinderM3((IBlockAccess)chunkcache, isWoddenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown).createEntityPathTo(entity, dx, dy, dz, data);
        entity.field_70170_p.field_72984_F.func_76319_b();
        return pathentity;
    }

    public PathEntityM3 createEntityPathTo(Entity p_75856_1_, Entity p_75856_2_, float p_75856_3_) {
        return this.createEntityPathTo(p_75856_1_, p_75856_2_.field_70165_t, p_75856_2_.field_70121_D.field_72338_b, p_75856_2_.field_70161_v, p_75856_3_);
    }

    public PathEntityM3 createEntityPathTo(Entity p_75859_1_, int p_75859_2_, int p_75859_3_, int p_75859_4_, float p_75859_5_) {
        return this.createEntityPathTo(p_75859_1_, (float)p_75859_2_ + 0.5f, (float)p_75859_3_ + 0.5f, (float)p_75859_4_ + 0.5f, p_75859_5_);
    }

    private PathEntityM3 createEntityPathTo(Entity p_75857_1_, double p_75857_2_, double p_75857_4_, double p_75857_6_, float p_75857_8_) {
        this.path.clearPath();
        this.pointMap.func_76046_c();
        boolean flag = this.isPathingInWater;
        int i = MathHelper.func_76128_c((double)(p_75857_1_.field_70121_D.field_72338_b + 0.5));
        if (this.canEntityDrown && p_75857_1_.func_70090_H()) {
            i = (int)p_75857_1_.field_70121_D.field_72338_b;
            Block block = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)p_75857_1_.field_70165_t), i, MathHelper.func_76128_c((double)p_75857_1_.field_70161_v));
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                block = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)p_75857_1_.field_70165_t), ++i, MathHelper.func_76128_c((double)p_75857_1_.field_70161_v));
            }
            flag = this.isPathingInWater;
            this.isPathingInWater = false;
        } else {
            i = MathHelper.func_76128_c((double)(p_75857_1_.field_70121_D.field_72338_b + 0.5));
        }
        PathPointM3 pathpoint2 = this.openPoint(MathHelper.func_76128_c((double)p_75857_1_.field_70121_D.field_72340_a), i, MathHelper.func_76128_c((double)p_75857_1_.field_70121_D.field_72339_c));
        PathPointM3 pathpoint = this.openPoint(MathHelper.func_76128_c((double)(p_75857_2_ - (double)(p_75857_1_.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)p_75857_4_), MathHelper.func_76128_c((double)(p_75857_6_ - (double)(p_75857_1_.field_70130_N / 2.0f))));
        PathPointM3 pathpoint1 = new PathPointM3(MathHelper.func_76141_d((float)(p_75857_1_.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(p_75857_1_.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(p_75857_1_.field_70130_N + 1.0f)));
        PathEntityM3 pathentity = this.addToPath(p_75857_1_, pathpoint2, pathpoint, pathpoint1, p_75857_8_);
        this.isPathingInWater = flag;
        return pathentity;
    }

    private PathEntityM3 addToPath(Entity p_75861_1_, PathPointM3 p_75861_2_, PathPointM3 p_75861_3_, PathPointM3 p_75861_4_, float p_75861_5_) {
        p_75861_2_.totalPathDistance = 0.0f;
        p_75861_2_.distanceToTarget = p_75861_2_.distanceToNext = p_75861_2_.distanceToSquared(p_75861_3_);
        this.path.clearPath();
        this.path.addPoint(p_75861_2_);
        PathPointM3 pathpoint3 = p_75861_2_;
        while (!this.path.isPathEmpty()) {
            PathPointM3 pathpoint4 = this.path.dequeue();
            if (pathpoint4.equals(p_75861_3_)) {
                return this.createEntityPath(p_75861_2_, p_75861_3_);
            }
            if (pathpoint4.distanceToSquared(p_75861_3_) < pathpoint3.distanceToSquared(p_75861_3_)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.isFirst = true;
            int i = this.findPathOptions(p_75861_1_, pathpoint4, p_75861_4_, p_75861_3_, p_75861_5_);
            for (int j = 0; j < i; ++j) {
                PathPointM3 pathpoint5 = this.pathOptions[j];
                float f1 = pathpoint4.totalPathDistance + pathpoint4.distanceToSquared(pathpoint5);
                if (pathpoint5.isAssigned() && !(f1 < pathpoint5.totalPathDistance)) continue;
                pathpoint5.previous = pathpoint4;
                pathpoint5.totalPathDistance = f1;
                pathpoint5.distanceToNext = pathpoint5.distanceToSquared(p_75861_3_);
                if (pathpoint5.isAssigned()) {
                    this.path.changeDistance(pathpoint5, pathpoint5.totalPathDistance + pathpoint5.distanceToNext);
                    continue;
                }
                pathpoint5.distanceToTarget = pathpoint5.totalPathDistance + pathpoint5.distanceToNext;
                this.path.addPoint(pathpoint5);
            }
        }
        if (pathpoint3 == p_75861_2_) {
            return null;
        }
        return this.createEntityPath(p_75861_2_, pathpoint3);
    }

    private int findPathOptions(Entity p_75860_1_, PathPointM3 p_75860_2_, PathPointM3 p_75860_3_, PathPointM3 p_75860_4_, float p_75860_5_) {
        int i = 0;
        int b0 = 0;
        if (this.getVerticalOffset(p_75860_1_, p_75860_2_.xCoord, p_75860_2_.yCoord + 1, p_75860_2_.zCoord, p_75860_3_) == 1) {
            b0 = 1;
        }
        PathPointM3 pathpoint3 = this.getSafePoint(p_75860_1_, p_75860_2_.xCoord, p_75860_2_.yCoord, p_75860_2_.zCoord + 1, p_75860_3_, b0);
        PathPointM3 pathpoint4 = this.getSafePoint(p_75860_1_, p_75860_2_.xCoord - 1, p_75860_2_.yCoord, p_75860_2_.zCoord, p_75860_3_, b0);
        PathPointM3 pathpoint5 = this.getSafePoint(p_75860_1_, p_75860_2_.xCoord + 1, p_75860_2_.yCoord, p_75860_2_.zCoord, p_75860_3_, b0);
        PathPointM3 pathpoint6 = this.getSafePoint(p_75860_1_, p_75860_2_.xCoord, p_75860_2_.yCoord, p_75860_2_.zCoord - 1, p_75860_3_, b0);
        if (pathpoint3 != null && !pathpoint3.isFirst && pathpoint3.distanceTo(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.isFirst && pathpoint4.distanceTo(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.isFirst && pathpoint5.distanceTo(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.isFirst && pathpoint6.distanceTo(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint6;
        }
        return i;
    }

    private PathPointM3 getSafePoint(Entity p_75858_1_, int p_75858_2_, int p_75858_3_, int p_75858_4_, PathPointM3 p_75858_5_, int p_75858_6_) {
        PathPointM3 pathpoint1 = null;
        int i1 = this.getVerticalOffset(p_75858_1_, p_75858_2_, p_75858_3_, p_75858_4_, p_75858_5_);
        if (i1 == 2) {
            return this.openPoint(p_75858_2_, p_75858_3_, p_75858_4_);
        }
        if (i1 == 1) {
            pathpoint1 = this.openPoint(p_75858_2_, p_75858_3_, p_75858_4_);
        }
        if (pathpoint1 == null && p_75858_6_ > 0 && i1 != -3 && i1 != -4 && this.getVerticalOffset(p_75858_1_, p_75858_2_, p_75858_3_ + p_75858_6_, p_75858_4_, p_75858_5_) == 1) {
            pathpoint1 = this.openPoint(p_75858_2_, p_75858_3_ + p_75858_6_, p_75858_4_);
            p_75858_3_ += p_75858_6_;
        }
        if (pathpoint1 != null) {
            int j1 = 0;
            int k1 = 0;
            while (p_75858_3_ > 0) {
                k1 = this.getVerticalOffset(p_75858_1_, p_75858_2_, p_75858_3_ - 1, p_75858_4_, p_75858_5_);
                if (this.isPathingInWater && k1 == -1) {
                    return null;
                }
                if (k1 != 1) break;
                if (j1++ >= p_75858_1_.func_82143_as()) {
                    return null;
                }
                if (--p_75858_3_ <= 0) continue;
                pathpoint1 = this.openPoint(p_75858_2_, p_75858_3_, p_75858_4_);
            }
            if (k1 == -2) {
                return null;
            }
        }
        return pathpoint1;
    }

    private final PathPointM3 openPoint(int p_75854_1_, int p_75854_2_, int p_75854_3_) {
        int l = PathPointM3.makeHash(p_75854_1_, p_75854_2_, p_75854_3_);
        PathPointM3 pathpoint = (PathPointM3)this.pointMap.func_76041_a(l);
        if (pathpoint == null) {
            pathpoint = new PathPointM3(p_75854_1_, p_75854_2_, p_75854_3_);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }

    public int getVerticalOffset(Entity p_75855_1_, int p_75855_2_, int p_75855_3_, int p_75855_4_, PathPointM3 p_75855_5_) {
        return PathFinderM3.func_82565_a(p_75855_1_, p_75855_2_, p_75855_3_, p_75855_4_, p_75855_5_, this.isPathingInWater, this.isMovementBlockAllowed, this.isWoddenDoorAllowed);
    }

    public static int func_82565_a(Entity entity, int dx, int dy, int dz, PathPointM3 point, boolean isPathingInWater, boolean isMovementBlockAllowed, boolean isWoddenDoorAllowed) {
        boolean data = false;
        for (int l = dx; l < dx + point.xCoord; ++l) {
            for (int i1 = dy; i1 < dy + point.yCoord; ++i1) {
                for (int j1 = dz; j1 < dz + point.zCoord; ++j1) {
                    Block block = entity.field_70170_p.func_147439_a(l, i1, j1);
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    if (block == Blocks.field_150415_aT) {
                        data = true;
                    } else if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                        if (!isWoddenDoorAllowed && block instanceof BlockDoor) {
                            return 0;
                        }
                    } else {
                        if (isPathingInWater) {
                            return -1;
                        }
                        data = true;
                    }
                    int k1 = block.func_149645_b();
                    if (entity.field_70170_p.func_147439_a(l, i1, j1).func_149645_b() == 9) {
                        int i2;
                        int l1;
                        int j2 = MathHelper.func_76128_c((double)entity.field_70165_t);
                        if (entity.field_70170_p.func_147439_a(j2, l1 = MathHelper.func_76128_c((double)entity.field_70163_u), i2 = MathHelper.func_76128_c((double)entity.field_70161_v)).func_149645_b() == 9 || entity.field_70170_p.func_147439_a(j2, l1 - 1, i2).func_149645_b() == 9) continue;
                        return -3;
                    }
                    if (block.func_149655_b((IBlockAccess)entity.field_70170_p, l, i1, j1) || isMovementBlockAllowed && block instanceof BlockDoor) continue;
                    if (k1 == 11 || block == Blocks.field_150396_be || k1 == 32) {
                        return -3;
                    }
                    if (block == Blocks.field_150415_aT) {
                        return -4;
                    }
                    Material material = block.func_149688_o();
                    if (material != Material.field_151587_i) {
                        return 0;
                    }
                    if (entity.func_70058_J()) continue;
                    return -2;
                }
            }
        }
        return data ? 2 : 1;
    }

    private PathEntityM3 createEntityPath(PathPointM3 p_75853_1_, PathPointM3 p_75853_2_) {
        int i = 1;
        PathPointM3 pathpoint2 = p_75853_2_;
        while (pathpoint2.previous != null) {
            ++i;
            pathpoint2 = pathpoint2.previous;
        }
        PathPointM3[] apathpoint = new PathPointM3[i];
        pathpoint2 = p_75853_2_;
        apathpoint[--i] = p_75853_2_;
        while (pathpoint2.previous != null) {
            pathpoint2 = pathpoint2.previous;
            apathpoint[--i] = pathpoint2;
        }
        return new PathEntityM3(apathpoint);
    }
}

