/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.archeology;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.archeology.AntiquitiesAffix;
import project.studio.manametalmod.archeology.AntiquitiesModify;
import project.studio.manametalmod.archeology.AntiquitiesType;
import project.studio.manametalmod.archeology.BlockArcheology;
import project.studio.manametalmod.archeology.BlockArcheologyDoor;
import project.studio.manametalmod.archeology.ItemAntiquitiesAlicia;
import project.studio.manametalmod.archeology.ItemAntiquitiesAstrid;
import project.studio.manametalmod.archeology.ItemAntiquitiesBase;
import project.studio.manametalmod.archeology.ItemAntiquitiesMashardaba;
import project.studio.manametalmod.archeology.ItemArcheologyKey;
import project.studio.manametalmod.archeology.ItemArcheologyLantern;
import project.studio.manametalmod.archeology.ItemArcheologyTool;
import project.studio.manametalmod.archeology.ItemBreakAntiquities;
import project.studio.manametalmod.archeology.ItemUnidentifiedAntiquities;
import project.studio.manametalmod.archeology.TileEntityArcheology;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.core.BaseCraft;
import project.studio.manametalmod.core.Craft;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.items.ItemBase;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.magic.magicItem.MagicItemType;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.produce.beekeeping.BeekeepingCore;
import project.studio.manametalmod.produce.textile.TextileCore;

public class ArcheologyCore {
    public static final Item ItemArcheologyTools = new ItemArcheologyTool();
    public static final Item ItemArcheologyKeys = new ItemArcheologyKey();
    public static final Block BlockArcheologys = new BlockArcheology();
    public static final Item ItemArcheologyLantern_1 = new ItemArcheologyLantern("ItemArcheologyLantern_1", 20000);
    public static final Item ItemArcheologyLantern_2 = new ItemArcheologyLantern("ItemArcheologyLantern_2", 30000);
    public static final List<ItemAntiquitiesBase> list = new ArrayList<ItemAntiquitiesBase>();
    public static final Item ItemAntiquities_Fire = new ItemAntiquitiesBase("ItemAntiquities_Fire", 30, ManaElements.Fire, 14360576, AntiquitiesType.None, InstanceDungeonType.FireDungeon).setResonancePearl(0).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.crit, MagicItemType.avoid, MagicItemType.dropRate);
    public static final Item ItemAntiquities_Water = new ItemAntiquitiesBase("ItemAntiquities_Water", 30, ManaElements.Water, 4433135, AntiquitiesType.None, InstanceDungeonType.WaterDungeon).setResonancePearl(1).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.water, MagicItemType.fatigue, MagicItemType.health);
    public static final Item ItemAntiquities_Grass = new ItemAntiquitiesBase("ItemAntiquities_Grass", 30, ManaElements.Grass, 46345, AntiquitiesType.None, InstanceDungeonType.GrassDungeon).setResonancePearl(2).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.crit, MagicItemType.avoid, MagicItemType.dropRate);
    public static final Item ItemAntiquities_Ice = new ItemAntiquitiesBase("ItemAntiquities_Ice", 30, ManaElements.Ice, 12252159, AntiquitiesType.None, InstanceDungeonType.IceDungeon).setResonancePearl(3).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.water, MagicItemType.fatigue, MagicItemType.health);
    public static final Item ItemAntiquities_Masadabah = new ItemAntiquitiesMashardaba("ItemAntiquities_Masadabah", 110, ManaElements.Dark, 9510403, AntiquitiesType.None, InstanceDungeonType.RoseTallTower).setResonancePearl(3).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.water, MagicItemType.fatigue, MagicItemType.health);
    public static final Item ItemAntiquities_Alicia = new ItemAntiquitiesAlicia("ItemAntiquities_Alicia", 120, ManaElements.Light, 2538239, AntiquitiesType.None, InstanceDungeonType.TrialTower).setResonancePearl(3).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.water, MagicItemType.fatigue, MagicItemType.health);
    public static final Item ItemAntiquities_Astrid = new ItemAntiquitiesAstrid("ItemAntiquities_Astrid", 125, ManaElements.Fire, 8978436, AntiquitiesType.None, InstanceDungeonType.RoseGarden).setResonancePearl(3).setAttributes(MagicItemType.attackMultiplier, MagicItemType.physicalAttack, MagicItemType.magicAttack, MagicItemType.monster_attack, MagicItemType.monster_attackMultiplier, MagicItemType.HP, MagicItemType.manaMax, MagicItemType.water, MagicItemType.fatigue, MagicItemType.health);
    public static final int AntiquitiesCount = list.size();
    public static final Item ItemBreakAntiquities = new ItemBreakAntiquities();
    public static final Item ItemBreakAntiquitiesRock = new ItemBase("ItemBreakAntiquitiesRock").func_77637_a(ManaMetalMod.tab_Archeology);
    public static final Item ItemUnidentifiedAntiquitiess = new ItemUnidentifiedAntiquities(AntiquitiesCount);
    public static final Block BlockArcheologyDoors = new BlockArcheologyDoor();
    public static final Item moistureproofStick = new ItemBase("moistureproofStick").func_77637_a(ManaMetalMod.tab_Archeology);

    public static final void init() {
        GameRegistry.registerItem((Item)ItemArcheologyTools, (String)"ItemArcheologyTools");
        GameRegistry.registerItem((Item)ItemArcheologyKeys, (String)"ItemArcheologyKeys");
        GameRegistry.registerBlock((Block)BlockArcheologys, (String)"BlockArcheologys");
        GameRegistry.registerItem((Item)ItemArcheologyLantern_1, (String)"ItemArcheologyLantern_1");
        GameRegistry.registerItem((Item)ItemArcheologyLantern_2, (String)"ItemArcheologyLantern_2");
        GameRegistry.registerItem((Item)ItemAntiquities_Fire, (String)"ItemAntiquities_Fire");
        GameRegistry.registerItem((Item)ItemAntiquities_Water, (String)"ItemAntiquities_Water");
        GameRegistry.registerItem((Item)ItemAntiquities_Grass, (String)"ItemAntiquities_Grass");
        GameRegistry.registerItem((Item)ItemAntiquities_Ice, (String)"ItemAntiquities_Ice");
        GameRegistry.registerItem((Item)ItemBreakAntiquities, (String)"ItemBreakAntiquities");
        GameRegistry.registerItem((Item)ItemBreakAntiquitiesRock, (String)"ItemBreakAntiquitiesRock");
        GameRegistry.registerItem((Item)ItemUnidentifiedAntiquitiess, (String)"ItemUnidentifiedAntiquitiess");
        GameRegistry.registerItem((Item)ItemAntiquities_Masadabah, (String)"ItemAntiquities_Masadabah");
        GameRegistry.registerItem((Item)ItemAntiquities_Alicia, (String)"ItemAntiquities_Alicia");
        GameRegistry.registerItem((Item)ItemAntiquities_Astrid, (String)"ItemAntiquities_Astrid");
        MMM.registerSubBlock(BlockArcheologyDoors, 2, "BlockArcheologyDoor", false);
        GameRegistry.registerItem((Item)moistureproofStick, (String)"moistureproofStick");
        for (int s = 0; s < AntiquitiesCount; ++s) {
            BaseCraft.block(new ItemStack(ItemBreakAntiquities, 1, s), new ItemStack(ItemUnidentifiedAntiquitiess, 1, s));
            Craft.addShapedRecipe(new ItemStack(ItemUnidentifiedAntiquitiess, 1, s), "SSS", "SXS", "SSS", Character.valueOf('X'), ManaMetalMod.TrueTimeHourglass, Character.valueOf('S'), new ItemStack(ItemBreakAntiquities, 1, s));
            Craft.addShapedRecipe(new ItemStack(ItemBreakAntiquities, 4, s), "SSS", "SBS", "SSS", Character.valueOf('B'), new ItemStack(ItemBreakAntiquities, 2, s), Character.valueOf('S'), ItemBreakAntiquitiesRock);
            Craft.addShapelessRecipe(new ItemStack(ItemBreakAntiquitiesRock, 2), ManaMetalMod.Antimatter, new ItemStack(ItemBreakAntiquities, 1, s));
        }
        Craft.addShapelessRecipe(moistureproofStick, BeekeepingCore.moistureproofPlank, BeekeepingCore.moistureproofPlank);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 0), "PPP", "#S#", "#S#", Character.valueOf('P'), "ingotSteel", Character.valueOf('S'), moistureproofStick);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 1), "PPP", "#S#", "#S#", Character.valueOf('P'), "ingotBrass", Character.valueOf('S'), moistureproofStick);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 2), "PPP", "PPP", "#S#", Character.valueOf('P'), "ingotSteel", Character.valueOf('S'), moistureproofStick);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 3), "PPP", "PPP", "#S#", Character.valueOf('P'), "ingotBrass", Character.valueOf('S'), moistureproofStick);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 4), "EEE", "PPP", "#S#", Character.valueOf('P'), "ingotSteel", Character.valueOf('S'), moistureproofStick, Character.valueOf('E'), TextileCore.ItemTextiles);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 5), "EEE", "PPP", "#S#", Character.valueOf('P'), "ingotBrass", Character.valueOf('S'), moistureproofStick, Character.valueOf('E'), TextileCore.ItemTextiles);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 6), "GGG", "PPP", "#S#", Character.valueOf('P'), "ingotSteel", Character.valueOf('S'), moistureproofStick, Character.valueOf('G'), ManaMetalMod.GemGlassPane);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 7), "GGG", "PPP", "#S#", Character.valueOf('P'), "ingotBrass", Character.valueOf('S'), moistureproofStick, Character.valueOf('G'), ManaMetalMod.GemGlassPane);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 8), "PPP", "S##", "PPP", Character.valueOf('P'), "ingotSteel", Character.valueOf('S'), moistureproofStick);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyTools, 1, 9), "PPP", "S##", "PPP", Character.valueOf('P'), "ingotBrass", Character.valueOf('S'), moistureproofStick);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyLantern_1, 1, 0), "PPP", "PSP", "PPP", Character.valueOf('P'), "ingotSteel", Character.valueOf('S'), ManaMetalMod.gemMagical);
        Craft.addShapedOreRecipe(new ItemStack(ItemArcheologyLantern_2, 1, 0), "PPP", "PSP", "PPP", Character.valueOf('P'), "ingotBrass", Character.valueOf('S'), ManaMetalMod.gemMagical);
        ArcheologyCore.addItemRwards(InstanceDungeonType.FireDungeon, ItemAntiquities_Fire);
        ArcheologyCore.addItemRwards(InstanceDungeonType.WaterDungeon, ItemAntiquities_Water);
        ArcheologyCore.addItemRwards(InstanceDungeonType.GrassDungeon, ItemAntiquities_Grass);
        ArcheologyCore.addItemRwards(InstanceDungeonType.IceDungeon, ItemAntiquities_Ice);
        ManaMetalAPI.ArcheologyAwardsCommon.add(new ItemStack(ItemBreakAntiquitiesRock, 1));
        ManaMetalAPI.ArcheologyAwardsCommon.add(new ItemStack(ItemCraft2.ItemGoldenBeetle, 1));
        ManaMetalAPI.ArcheologyAwardsCommon.add(new ItemStack(ItemCraft2.ItemClover, 1));
        GameRegistry.registerTileEntity(TileEntityArcheology.class, (String)"TileEntityArcheology");
    }

    public static void addItemRwards(InstanceDungeonType type, Item ant) {
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquities, 1, type.ordinal()), 60);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquities, 2, type.ordinal()), 50);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquities, 3, type.ordinal()), 40);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquities, 4, type.ordinal()), 30);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquitiesRock, 1), 50);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquitiesRock, 2), 40);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquitiesRock, 3), 30);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquitiesRock, 4), 20);
        ManaMetalAPI.addArcheologyAwards(type, new ItemStack(ItemBreakAntiquitiesRock, 5), 10);
    }

    public static final ItemStack get(Item item, World world, EntityPlayer player) {
        ManaMetalModRoot root = MMM.getEntityNBT(player);
        if (root != null) {
            int treasure = root.carrer.getDropRate();
            float insight = root.carrer.Insight;
            float craft = root.carrer.craft;
            ItemAntiquitiesBase IAB = (ItemAntiquitiesBase)item;
            Random rand = new Random();
            Quality qualitys = ArcheologyCore.getQuality(insight, rand);
            int count = ArcheologyCore.getEffectCount(player, world, treasure, rand);
            ItemStack items = new ItemStack(item, 1, world.field_73012_v.nextInt(5));
            MagicItemType[] effects = new MagicItemType[count];
            ArrayList<MagicItemType> list = new ArrayList<MagicItemType>();
            list.addAll(IAB.list);
            for (int s = 0; s < effects.length; ++s) {
                MagicItemType type;
                int id = rand.nextInt(list.size());
                effects[s] = type = (MagicItemType)((Object)list.get(id));
                list.remove(id);
            }
            int[] ids = new int[effects.length];
            float[] val = new float[effects.length];
            for (int s = 0; s < val.length; ++s) {
                val[s] = ArcheologyCore.getAttributes(effects[s], world, rand, player, items, qualitys, craft);
                ids[s] = effects[s].ordinal();
            }
            NBTTagList listEffect = new NBTTagList();
            for (int s = 0; s < val.length; ++s) {
                listEffect.func_74742_a((NBTBase)new NBTTagFloat(val[s]));
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a("listID", ids);
            tag.func_74782_a("listEffect", (NBTBase)listEffect);
            AntiquitiesAffix afx = null;
            while ((afx = AntiquitiesAffix.values()[rand.nextInt(AntiquitiesAffix.values().length)]) == AntiquitiesAffix.None) {
            }
            AntiquitiesModify mod = null;
            while ((mod = AntiquitiesModify.values()[rand.nextInt(AntiquitiesModify.values().length)]) == AntiquitiesModify.None) {
            }
            tag.func_74768_a("AntiquitiesAffix", afx.ordinal());
            tag.func_74768_a("AntiquitiesModify", mod.ordinal());
            tag.func_74768_a("pattern", rand.nextInt(5));
            tag.func_74768_a("quality", qualitys.ordinal());
            items.func_77982_d(tag);
            return items;
        }
        return null;
    }

    public static Quality getQuality(float insight, Random rand) {
        int power;
        int data = 100;
        if (insight > 1.0f && (data = (int)((float)data - (float)data * (insight - 1.0f) * 0.33f)) < 50) {
            data = 50;
        }
        if ((power = rand.nextInt(data)) == 0) {
            return Quality.Myth;
        }
        if (power < 5) {
            return Quality.Epic;
        }
        if (power < 20) {
            return Quality.VeryRare;
        }
        if (power < 30) {
            return Quality.Rare;
        }
        return Quality.Normal;
    }

    public static AttackEffect attack(AttackEffect data, EntityPlayer player, EntityLivingBase target, DamageSource source, ManaMetalModRoot root_player, ManaMetalModRoot root_target) {
        int index = 0;
        for (int s = 0; s < 5; ++s) {
            index = 42 + s;
            if (root_player.item.items[index] == null || !(root_player.item.items[index].func_77973_b() instanceof ItemAntiquitiesBase)) continue;
            ArcheologyCore.attack_effect(root_player.item.items[index], data, player, target, source, root_player, root_target);
        }
        return data;
    }

    public static AttackEffect beattacked(AttackEffect data, EntityPlayer player, EntityLivingBase target, DamageSource source, ManaMetalModRoot root_player, ManaMetalModRoot root_target) {
        int index = 0;
        for (int s = 0; s < 5; ++s) {
            index = 42 + s;
            if (root_player.item.items[index] == null || !(root_player.item.items[index].func_77973_b() instanceof ItemAntiquitiesBase)) continue;
            ArcheologyCore.beattacked_effect(root_player.item.items[index], data, player, target, source, root_player, root_target);
        }
        return data;
    }

    public static AttackEffect attack_effect(ItemStack item, AttackEffect data, EntityPlayer player, EntityLivingBase target, DamageSource source, ManaMetalModRoot root, ManaMetalModRoot root_target) {
        ItemAntiquitiesBase ant = (ItemAntiquitiesBase)item.func_77973_b();
        AntiquitiesType type = ant.getAntiquitiesType(item, player);
        AntiquitiesAffix afx = ant.getAntiquitiesAffix(item.func_77978_p());
        AntiquitiesModify mod = ant.getAntiquitiesModify(item.func_77978_p());
        ant.attack_effect(item, data, player, target, source, root, root_target);
        switch (mod) {
            case Gorgeous: {
                data.no_tack_damage += (float)(root.avoid.getAvoid() * 2);
                break;
            }
            case Magic: {
                data.no_tack_damage += (float)root.mana.getMana() * 0.04f;
                break;
            }
            case Miracle: {
                if (player.field_70170_p.field_73012_v.nextInt(100) != 0) break;
                data.final_attack += 0.1f;
                break;
            }
            case Mystery: {
                if (!((float)root.mana.getMana() >= (float)root.mana.getMagicMax() * 0.5f)) break;
                data.attack += 0.2f;
                break;
            }
            case Sacred: {
                if (target == null || !(target.func_110143_aJ() <= target.func_110138_aP() * 0.5f)) break;
                data.attack += 0.2f;
                break;
            }
            case Reincarnation: {
                data.attack += MathHelper.func_151240_a((Random)player.field_70170_p.field_73012_v, (float)0.01f, (float)0.3f);
                break;
            }
            case Fantasy: {
                if (player.field_70170_p.field_73012_v.nextInt(100) >= 3) break;
                data.attack += 1.2f;
                break;
            }
            case Illusory: {
                data.no_tack_damage += (float)(root.crit.getCrit() * 2);
                break;
            }
            case Liberation: {
                if (!(player.func_110143_aJ() <= player.func_110138_aP() * 0.5f)) break;
                data.attack += 0.4f;
                break;
            }
            case Strange: {
                data.attack = data.attack + (player.field_70170_p.field_73012_v.nextBoolean() ? MathHelper.func_151240_a((Random)player.field_70170_p.field_73012_v, (float)0.01f, (float)0.5f) : -MathHelper.func_151240_a((Random)player.field_70170_p.field_73012_v, (float)0.01f, (float)0.5f));
                break;
            }
            case Passionate: {
                data.hp_blood += 0.02f;
                break;
            }
            case Curse: {
                data.attack += 0.25f;
                if (player.field_70170_p.field_73012_v.nextInt(100) >= 5) break;
                PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionCurse, 8, 0);
                break;
            }
            case Death: {
                data.attack += 0.4f;
                if (player.field_70170_p.field_73012_v.nextInt(100) >= 3) break;
                PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionPoison, 20, 0);
                break;
            }
            case Demon: {
                data.attack += 0.4f;
                break;
            }
            case Dream: {
                data.hp_blood += 0.01f;
                break;
            }
            case Fatal: {
                data.attack += 0.4f;
                break;
            }
            case Fear: {
                data.attack += 0.3f;
                break;
            }
            case Nightmare: {
                data.attack += 0.6f;
                if (player.field_70170_p.field_73012_v.nextInt(100) >= 1 || source == AttackType.HighlyToxic) break;
                player.func_70097_a(AttackType.HighlyToxic, player.func_110143_aJ() * 0.1f);
                break;
            }
            case Weird: {
                data.attack += 0.25f;
                try {
                    player.func_70690_d(new PotionEffect(2, 160, 0));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        switch (afx) {
            case Shine: {
                data.attack_base_magic += 10;
                break;
            }
            case Gray: {
                data.attack_base_physical += 10;
                break;
            }
            case Bloodthirsty: {
                data.hp_blood += 0.01f;
                break;
            }
            case Fast: {
                data.crit += 5;
                data.critDamage += 0.1f;
                break;
            }
            case Flexible: {
                data.crit += 9;
                break;
            }
            case Spell: {
                if (target == null || player.field_70170_p.field_73012_v.nextInt(100) != 0) break;
                switch (player.field_70170_p.field_73012_v.nextInt(3)) {
                    case 0: {
                        PotionEffectM3.addPotion(target, PotionM3.potionStone, 3, 0);
                        break;
                    }
                    case 1: {
                        PotionEffectM3.addPotion(target, PotionM3.potionFreeze, 3, 0);
                        break;
                    }
                    case 2: {
                        PotionEffectM3.addPotion(target, PotionM3.potionThunder, 3, 0);
                    }
                }
                break;
            }
            case Heal: {
                if (player.field_70170_p.field_73012_v.nextInt(100) >= 5) break;
                player.func_70691_i(500.0f);
            }
        }
        return data;
    }

    public static AttackEffect beattacked_effect(ItemStack item, AttackEffect data, EntityPlayer player, EntityLivingBase target, DamageSource source, ManaMetalModRoot root_player, ManaMetalModRoot root_target) {
        ItemAntiquitiesBase ant = (ItemAntiquitiesBase)item.func_77973_b();
        AntiquitiesType type = ant.getAntiquitiesType(item, player);
        AntiquitiesAffix afx = ant.getAntiquitiesAffix(item.func_77978_p());
        AntiquitiesModify mod = ant.getAntiquitiesModify(item.func_77978_p());
        ant.beattacked_effect(item, data, player, target, source, root_player, root_target);
        switch (mod) {
            case Fear: {
                data.damage_add += 0.3f;
                data.defense -= 100;
                break;
            }
            case Demon: {
                data.damage_add += 1.0f;
                break;
            }
            case Fatal: {
                if (source != AttackType.GravityDamage) break;
                data.damage_add += 1.0f;
                break;
            }
            case Pray: {
                if (player.field_70170_p.field_73012_v.nextInt(100) != 0) break;
                data.del_damage = true;
                break;
            }
            case Ppure: {
                data.damage_reduce += 0.04f;
                break;
            }
            case Dream: {
                data.defense += 30;
                break;
            }
            case Eternal: {
                if (!(player.func_110143_aJ() <= player.func_110138_aP() * 0.5f)) break;
                data.defense += 40;
                data.damage_reduce += 0.06f;
            }
        }
        switch (afx) {
            case AntiMagic: {
                if (!source.func_82725_o()) break;
                data.damage_reduce += 0.04f;
                break;
            }
            case DharmaProtector: {
                data.rdamage += 5;
                break;
            }
            case Guard: {
                data.defense += 40;
                break;
            }
            case Insight: {
                data.defense += 20;
                data.avoid += 5;
                break;
            }
            case Reply: {
                try {
                    player.func_70690_d(new PotionEffect(10, 200, 0));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return data;
    }

    public static int getEffectCount(EntityPlayer player, World world, int drop, Random rand) {
        int id;
        int data = (int)(300.0f - (float)drop * 0.5f);
        if (data < 50) {
            data = 50;
        }
        if ((id = rand.nextInt(data)) == 0) {
            return 5;
        }
        if (id < 30) {
            return 4;
        }
        if (id < 60) {
            return 3;
        }
        if (id < 90) {
            return 2;
        }
        return 1;
    }

    public static float getAttributes(MagicItemType type, World world, Random rand, EntityPlayer player, ItemStack item, Quality quality, float craft) {
        int min_base = 0;
        int max_base = 0;
        float min_base_float = 0.0f;
        float max_base_float = 0.0f;
        switch (quality) {
            case Normal: {
                min_base = 0;
                max_base = 0;
                min_base_float = 0.0f;
                max_base_float = 0.0f;
                break;
            }
            case Rare: {
                min_base = 1;
                max_base = 1;
                min_base_float = 0.01f;
                max_base_float = 0.01f;
                break;
            }
            case VeryRare: {
                min_base = 2;
                max_base = 2;
                min_base_float = 0.02f;
                max_base_float = 0.02f;
                break;
            }
            case Epic: {
                min_base = 3;
                max_base = 3;
                min_base_float = 0.03f;
                max_base_float = 0.03f;
                break;
            }
            case Myth: {
                min_base = 4;
                max_base = 4;
                min_base_float = 0.04f;
                max_base_float = 0.04f;
            }
        }
        if (craft - 1.0f + rand.nextFloat() > 1.0f) {
            ++min_base;
            max_base += 2;
            min_base_float += 0.01f;
            max_base_float += 0.02f;
        }
        switch (type) {
            case magicDefense: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case physicalAttack: {
                return min_base + 3 + rand.nextInt(max_base + 7);
            }
            case magicAttack: {
                return min_base + 3 + rand.nextInt(max_base + 7);
            }
            case crit: {
                return min_base + 5 + rand.nextInt(max_base + 7);
            }
            case avoid: {
                return min_base + 5 + rand.nextInt(max_base + 7);
            }
            case hpReply: {
                return min_base + 3 + rand.nextInt(max_base + 8);
            }
            case manaReply: {
                return min_base + 3 + rand.nextInt(max_base + 8);
            }
            case dropRate: {
                return min_base + 5 + rand.nextInt(max_base + 11);
            }
            case HP: {
                return min_base * 30 + 200 + rand.nextInt(max_base * 30 + 201);
            }
            case manaMax: {
                return min_base * 30 + 200 + rand.nextInt(max_base * 50 + 201);
            }
            case attackMultiplier: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.08f + max_base_float));
            }
            case defenseMultiplier: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.03f + max_base_float));
            }
            case magicRelief: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.05f + max_base_float));
            }
            case healthRecovery: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.1f, (float)(0.3f + max_base_float));
            }
            case penetrate: {
                return min_base + 1 + rand.nextInt(max_base + 4);
            }
            case water: {
                return min_base * 20 + 100 + rand.nextInt(max_base * 20 + 101);
            }
            case fatigue: {
                return min_base * 20 + 100 + rand.nextInt(max_base * 20 + 101);
            }
            case health: {
                return min_base * 20 + 100 + rand.nextInt(max_base * 20 + 101);
            }
            case monster_attack: {
                return min_base + 10 + rand.nextInt(max_base + 21);
            }
            case MaxBloodData: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.1f + max_base_float));
            }
            case monster_attackMultiplier: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.02f, (float)(0.2f + max_base_float));
            }
            case craft: {
                return min_base_float + MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)(0.05f + max_base_float));
            }
        }
        return 1.0f;
    }
}

