/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import project.studio.manametalmod.blocks.BlockBase;

public class BlockRainbowColor
extends BlockBase {
    public BlockRainbowColor() {
        super(Material.field_151576_e, "BlockRainbowColor");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return BlockRainbowColor.getSmoothRainbowColorAtXZ(x, z);
    }

    public static int getRainbowColorAtX(int x) {
        int range = 100;
        x = (x % range + range) % range;
        float hue = (float)x / (float)range * 360.0f;
        return BlockRainbowColor.hsvToRgb(hue, 1.0f, 1.0f);
    }

    public static int getSmoothRainbowColorAtXZ(int x, int z) {
        float hue = ((float)x * 0.01f + (float)z * 0.01f) % 1.0f;
        if (hue < 0.0f) {
            hue += 1.0f;
        }
        return BlockRainbowColor.hsvToRgb(hue * 360.0f, 1.0f, 1.0f);
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (hue < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (hue < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (hue < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (hue < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (hue < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        int ri = (int)((r + m) * 255.0f);
        int gi = (int)((g + m) * 255.0f);
        int bi = (int)((b + m) * 255.0f);
        return ri << 16 | gi << 8 | bi;
    }
}

