/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.blueprint;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.DimensionManager;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.SchematicTileEntity;

public class Schematic {
    public short width;
    public short height;
    public short length;
    public byte[] blocks;
    public byte[] data;
    public String[] blockName;
    public int[] tileID;
    public NBTTagCompound[] tileentity;
    public boolean isIDungeon = false;
    public boolean isRotate = false;
    public List<SchematicTileEntity> listTileEntity = null;

    public Schematic() {
    }

    public Schematic(short width, short height, short length, byte[] blocks, byte[] data) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.blocks = blocks;
        this.data = data;
    }

    public Schematic(short width, short height, short length, String[] blocks, byte[] data, int[] tileID, NBTTagCompound[] tileentity) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.blockName = blocks;
        this.data = data;
        this.tileentity = tileentity;
        this.tileID = tileID;
    }

    public Schematic loanIDungeonFromComponents(String name) {
        try {
            int z;
            File file = new File(DimensionManager.getCurrentSaveRootDirectory().getParentFile().getParentFile().getAbsolutePath() + "/ManaMetalModData/CustomDungeon/" + name + ".IDungeon");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            NBTTagCompound nbtdata = CompressedStreamTools.func_74797_a((File)file);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            NBTTagList blockname = nbtdata.func_150295_c("BlocksName", 8);
            NBTTagList tileids = nbtdata.func_150295_c("TileEntityID", 3);
            NBTTagList tileentitys = nbtdata.func_150295_c("TileEntity", 10);
            String[] blockNames = new String[blockname.func_74745_c()];
            int[] tileID = new int[nbtdata.func_150295_c("TileEntityID", 3).func_74745_c()];
            NBTTagCompound[] tileentity = new NBTTagCompound[nbtdata.func_150295_c("TileEntity", 10).func_74745_c()];
            for (z = 0; z < blockname.func_74745_c(); ++z) {
                NBTTagString s = new NBTTagString(blockname.func_150307_f(z));
                blockNames[z] = s.func_150285_a_();
            }
            for (z = 0; z < tileids.func_74745_c(); ++z) {
                tileID[z] = Integer.parseInt(tileids.func_150307_f(z));
            }
            for (z = 0; z < tileentitys.func_74745_c(); ++z) {
                tileentity[z] = tileentitys.func_150305_b(z);
            }
            MMM.Logg("load iDungeon from world , name:", name, " size:", width, "x", height, "x", length);
            Schematic sh = new Schematic(width, height, length, blockNames, data, tileID, tileentity);
            sh.isIDungeon = true;
            return sh;
        }
        catch (Exception e) {
            MMM.Error("can't load iDungeon from world");
            e.printStackTrace();
            return null;
        }
    }

    public Schematic loadSchematicFromComponents(String name) {
        InputStream is = null;
        try {
            File file = new File(DimensionManager.getCurrentSaveRootDirectory().getParentFile().getParentFile().getAbsolutePath() + "/ManaMetalModData/CustomDungeon/" + name + ".schematic");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            is = new FileInputStream(file);
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            MMM.Logg("load schematic from jar , name:", name, " size:", width, "x", height, "x", length);
            is.close();
            return new Schematic(width, height, length, blocks, data);
        }
        catch (Exception e) {
            MMM.Error("can't load schematic from jar");
            e.printStackTrace();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    public Schematic loadSchematicFromJar(String name) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("assets/manametalmod/schematic/" + name);
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            MMM.Logg("load schematic from jar , name:", name, " size:", width, "x", height, "x", length);
            is.close();
            return new Schematic(width, height, length, blocks, data);
        }
        catch (Exception e) {
            MMM.Error("can't load schematic from jar");
            e.printStackTrace();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    public Schematic loadSchematicFromWorld(String name) {
        try {
            File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "ManaMetalMod/SchematicExport/" + name + ".schematic");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                ManaMetalMod.LOGGER.info("Folder does not exist : ManaMetalMod/SchematicExport/");
            }
            NBTTagCompound nbtdata = CompressedStreamTools.func_74797_a((File)file);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            MMM.Logg("load schematic from world , name:", name, " size:", width, "x", height, "x", length);
            return new Schematic(width, height, length, blocks, data);
        }
        catch (Exception e) {
            MMM.Error("can't load schematic from world");
            return null;
        }
    }

    public Schematic loanIDungeonFromJar(String name) {
        InputStream is = null;
        try {
            int z;
            is = this.getClass().getClassLoader().getResourceAsStream("assets/manametalmod/IDungeon/" + name + ".IDungeonGZIP");
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] data = nbtdata.func_74770_j("Data");
            NBTTagList blockname = nbtdata.func_150295_c("BlocksName", 8);
            NBTTagList tileids = nbtdata.func_150295_c("TileEntityID", 3);
            NBTTagList tileentitys = nbtdata.func_150295_c("TileEntity", 10);
            String[] blockNames = new String[blockname.func_74745_c()];
            int[] tileID = new int[nbtdata.func_150295_c("TileEntityID", 3).func_74745_c()];
            NBTTagCompound[] tileentity = new NBTTagCompound[nbtdata.func_150295_c("TileEntity", 10).func_74745_c()];
            for (z = 0; z < blockname.func_74745_c(); ++z) {
                NBTTagString s = new NBTTagString(blockname.func_150307_f(z));
                blockNames[z] = s.func_150285_a_();
            }
            for (z = 0; z < tileids.func_74745_c(); ++z) {
                tileID[z] = Integer.parseInt(tileids.func_150307_f(z));
            }
            for (z = 0; z < tileentitys.func_74745_c(); ++z) {
                tileentity[z] = tileentitys.func_150305_b(z);
            }
            MMM.Logg("load iDungeonGZIP from jar , name:", name, " size:", width, "x", height, "x", length);
            Schematic sh = new Schematic(width, height, length, blockNames, data, tileID, tileentity);
            sh.isIDungeon = true;
            is.close();
            return sh;
        }
        catch (Exception e) {
            MMM.Error("can't load iDungeonGZIP from jar : " + name);
            e.printStackTrace();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    public Schematic loanIDungeonFromWorld(String name) {
        try {
            int z;
            File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "ManaMetalMod/IDungeon/" + name + ".IDungeon");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                ManaMetalMod.LOGGER.info("Folder does not exist : ManaMetalMod/IDungeon/");
            }
            NBTTagCompound nbtdata = CompressedStreamTools.func_74797_a((File)file);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            NBTTagList blockname = nbtdata.func_150295_c("BlocksName", 8);
            NBTTagList tileids = nbtdata.func_150295_c("TileEntityID", 3);
            NBTTagList tileentitys = nbtdata.func_150295_c("TileEntity", 10);
            String[] blockNames = new String[blockname.func_74745_c()];
            int[] tileID = new int[nbtdata.func_150295_c("TileEntityID", 3).func_74745_c()];
            NBTTagCompound[] tileentity = new NBTTagCompound[nbtdata.func_150295_c("TileEntity", 10).func_74745_c()];
            for (z = 0; z < blockname.func_74745_c(); ++z) {
                NBTTagString s = new NBTTagString(blockname.func_150307_f(z));
                blockNames[z] = s.func_150285_a_();
            }
            for (z = 0; z < tileids.func_74745_c(); ++z) {
                tileID[z] = Integer.parseInt(tileids.func_150307_f(z));
            }
            for (z = 0; z < tileentitys.func_74745_c(); ++z) {
                tileentity[z] = tileentitys.func_150305_b(z);
            }
            MMM.Logg("load iDungeon from world , name:", name, " size:", width, "x", height, "x", length);
            Schematic sh = new Schematic(width, height, length, blockNames, data, tileID, tileentity);
            sh.isIDungeon = true;
            return sh;
        }
        catch (Exception e) {
            MMM.Error("can't load iDungeon from world");
            e.printStackTrace();
            return null;
        }
    }

    public Schematic rotateIdungeon() {
        int indexbase;
        Schematic temp_schematic = new Schematic();
        int blockcount = this.height * this.length * this.width;
        int size = this.length * this.width;
        temp_schematic.blockName = new String[blockcount];
        temp_schematic.data = new byte[blockcount];
        temp_schematic.height = this.height;
        temp_schematic.length = this.length;
        temp_schematic.width = this.width;
        temp_schematic.tileID = (int[])this.tileID.clone();
        temp_schematic.tileentity = (NBTTagCompound[])this.tileentity.clone();
        temp_schematic.listTileEntity = new ArrayList<SchematicTileEntity>();
        temp_schematic.isIDungeon = true;
        temp_schematic.isRotate = true;
        int spawnid = indexbase = this.index(0, 0, this.length - 1);
        boolean spawntileentity = false;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    int index;
                    int data;
                    String blockname = this.getBlock(x, y, this.length - 1 - z);
                    byte metadata = this.getBlockMetadata(x, y, this.length - 1 - z);
                    temp_schematic.setBlock(z, y, x, blockname, metadata);
                    if (this.isRotate) {
                        data = this.hasTileEntity(spawnid);
                        if (data != -1) {
                            index = this.index(z, y, x);
                            temp_schematic.listTileEntity.add(new SchematicTileEntity(index, this.listTileEntity.get((int)data).data));
                        }
                    } else {
                        data = this.hasTileEntityID(spawnid);
                        if (data != -1) {
                            temp_schematic.tileID[data] = index = this.index(z, y, x);
                            temp_schematic.tileentity[data] = (NBTTagCompound)this.tileentity[data].func_74737_b();
                            temp_schematic.listTileEntity.add(new SchematicTileEntity(index, this.tileentity[data]));
                        }
                    }
                    ++spawnid;
                }
                spawnid -= this.width * 2;
            }
            spawnid = size * (y + 1) + indexbase;
        }
        return temp_schematic;
    }

    public int hasTileEntityID(int target) {
        for (int s = 0; s < this.tileID.length; ++s) {
            if (this.tileID[s] != target) continue;
            return s;
        }
        return -1;
    }

    public int hasTileEntity(int index) {
        for (int s = 0; s < this.listTileEntity.size(); ++s) {
            if (this.listTileEntity.get((int)s).index != index) continue;
            return s;
        }
        return -1;
    }

    public Pos toPos(int index, int y) {
        int size = this.width * this.length;
        int data = index % size;
        int x = data % this.width;
        int z = data / this.length;
        return new Pos(x, y, z);
    }

    public int index(int x, int y, int z) {
        int index = y * this.width * this.length + z * this.width + x;
        return index;
    }

    public String getBlock(int x, int y, int z) {
        int index = y * this.width * this.length + z * this.width + x;
        return this.blockName[index];
    }

    public byte getBlockMetadata(int x, int y, int z) {
        int index = y * this.width * this.length + z * this.width + x;
        return this.data[index];
    }

    public void setBlock(int x, int y, int z, String block, byte metaData) {
        int index = y * this.width * this.length + z * this.width + x;
        this.blockName[index] = block;
        this.data[index] = metaData;
    }

    public void setMetadata(int x, int y, int z, byte metaData) {
        int index = y * this.width * this.length + z * this.width + x;
        this.data[index] = metaData;
    }

    public static int getBlocksIDFormNegative(int id) {
        if (id < 0) {
            return Math.abs(Math.abs(Math.abs(id) - 128) + 128);
        }
        return id;
    }
}

