/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.blueprint;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.util.ForgeDirection;
import project.studio.manametalmod.blueprint.FakeISaveHandler;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.SchematicTileEntity;

@SideOnly(value=Side.CLIENT)
public class WorldFake
extends World {
    public Schematic sh;
    public Pos pos;
    public Map<Integer, TileEntity> tileentity;
    private static final WorldSettings WORLD_SETTINGS = new WorldSettings(0L, WorldSettings.GameType.CREATIVE, false, false, WorldType.field_77138_c);

    public WorldFake(Schematic sh) {
        super((ISaveHandler)new FakeISaveHandler(), "Schematica", WORLD_SETTINGS, null, null);
        this.sh = sh;
        this.pos = new Pos();
        this.tileentity = new HashMap<Integer, TileEntity>();
        this.tileentity.clear();
        if (sh.isRotate) {
            for (int s = 0; s < sh.listTileEntity.size(); ++s) {
                SchematicTileEntity ste = sh.listTileEntity.get(s);
                TileEntity temp = TileEntity.func_145827_c((NBTTagCompound)ste.data);
                int index = ste.index;
                temp.func_145834_a((World)this);
                this.tileentity.put(index, temp);
            }
        } else {
            for (int s = 0; s < sh.tileID.length; ++s) {
                TileEntity temp = TileEntity.func_145827_c((NBTTagCompound)sh.tileentity[s]);
                temp.func_145834_a((World)this);
                this.tileentity.put(sh.tileID[s], temp);
            }
        }
    }

    public void updatePos(int x, int y, int z) {
        this.pos.X = x;
        this.pos.Y = y;
        this.pos.Z = z;
    }

    public Block func_147439_a(int x, int y, int z) {
        int sx = 0;
        int sy = 0;
        int sz = 0;
        sx = x < 0 ? x + -this.pos.X : x - this.pos.X;
        sy = y - this.pos.Y;
        sz = z < 0 ? z + -this.pos.Z : z - this.pos.Z;
        if (sx >= this.sh.width || sy < 0 || sy >= this.sh.height || sz >= this.sh.length || sx < 0 || sz < 0) {
            return Blocks.field_150350_a;
        }
        String name = this.sh.getBlock(sx, sy, sz);
        String[] str = name.split(":");
        Block block = GameRegistry.findBlock((String)str[0], (String)str[1]);
        if (block != null) {
            return block;
        }
        return Blocks.field_150350_a;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        int sx = 0;
        int sy = 0;
        int sz = 0;
        sx = x < 0 ? x + -this.pos.X : x - this.pos.X;
        sy = y - this.pos.Y;
        sz = z < 0 ? z + -this.pos.Z : z - this.pos.Z;
        if (sx >= this.sh.width || sy < 0 || sy >= this.sh.height || sz >= this.sh.length || sx < 0 || sz < 0) {
            return null;
        }
        int index = this.sh.index(sx, sy, sz);
        if (this.tileentity.containsKey(index)) {
            return this.tileentity.get(index);
        }
        return null;
    }

    public int func_72805_g(int x, int y, int z) {
        int sx = 0;
        int sy = 0;
        int sz = 0;
        sx = x < 0 ? x + -this.pos.X : x - this.pos.X;
        sy = y - this.pos.Y;
        sz = z < 0 ? z + -this.pos.Z : z - this.pos.Z;
        if (sx >= this.sh.width || sy < 0 || sy >= this.sh.height || sz >= this.sh.length || sx < 0 || sz < 0) {
            return 0;
        }
        return this.sh.getBlockMetadata(sx, sy, sz);
    }

    public boolean func_72921_c(int x, int y, int z, int metadata, int flag) {
        int sx = 0;
        int sy = 0;
        int sz = 0;
        sx = x < 0 ? x + -this.pos.X : x - this.pos.X;
        sy = y - this.pos.Y;
        sz = z < 0 ? z + -this.pos.Z : z - this.pos.Z;
        if (sx >= this.sh.width || sy < 0 || sy >= this.sh.height || sz >= this.sh.length || sx < 0 || sz < 0) {
            return false;
        }
        this.sh.setMetadata(sx, sy, sz, (byte)metadata);
        return true;
    }

    public boolean func_147468_f(int x, int y, int z) {
        return false;
    }

    public boolean func_147437_c(int x, int y, int z) {
        Block block = this.func_147439_a(x, y, z);
        return block.func_149688_o() == Blocks.field_150350_a.func_149688_o();
    }

    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        return 0;
    }

    public int func_72879_k(int p_72879_1_, int p_72879_2_, int p_72879_3_, int p_72879_4_) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72925_a(EnumSkyBlock skyBlock, int x, int y, int z) {
        return 15;
    }

    public float func_72801_o(int x, int y, int z) {
        return 1.0f;
    }

    public BiomeGenBase func_72807_a(int p_72807_1_, int p_72807_2_) {
        return BiomeGenBase.field_76772_c;
    }

    public int func_72800_K() {
        return this.sh.height;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return false;
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return 0;
    }

    public Entity func_73045_a(int p_73045_1_) {
        return null;
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int metadata, int flags) {
        return false;
    }

    public void func_147455_a(int x, int y, int z, TileEntity tileEntity) {
    }

    public void func_147475_p(int x, int y, int z) {
    }
}

