/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.chess;

import org.apache.commons.lang3.time.StopWatch;
import project.studio.manametalmod.chess.AIChess;
import project.studio.manametalmod.chess.AIChessMove;
import project.studio.manametalmod.chess.AIChessPosition;
import project.studio.manametalmod.chess.AIMain;

public class AICaller
extends Thread {
    public AIChess chess;
    boolean bStart = false;
    private boolean bRunning = false;
    public AIMain main;

    public AICaller(AIMain main) {
        this.main = main;
        this.chess = main.chess;
    }

    public void go() {
        if (!this.bStart) {
            this.chess.pos = new AIChessPosition(this.main);
            this.bStart = true;
        }
    }

    public void cancel() {
        this.bStart = false;
    }

    public void exit() {
        this.bRunning = false;
    }

    @Override
    public void run() {
        if (this.bRunning) {
            return;
        }
        this.bRunning = true;
        while (!this.chess.main.bQuit && this.bRunning) {
            if (this.bStart) {
                this.bStart = false;
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    System.out.println("AICaller Thread Sleep Error");
                }
                StopWatch stopwatch = new StopWatch();
                stopwatch.start();
                this.chess.bThinking = true;
                AIChessMove n = this.chess.playGame(this.chess.pos, this.chess.PROGRAM);
                if (this.chess.bThinking) {
                    this.chess.bThinking = false;
                    this.main.tile.executeMove(n);
                    this.chess.pos.makeMove(n);
                    this.chess.main.bQuit = true;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                System.out.println("AICaller Thread Sleep Error");
            }
        }
        this.bRunning = false;
    }
}

