/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.HumanReform;
import project.studio.manametalmod.core.ItemEffect;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.entity.nbt.NbtCareer;
import project.studio.manametalmod.event.EventFx;
import project.studio.manametalmod.world.thuliumempire.DemonReform;

public class HumanReformMagic {
    public int time = 0;
    public EntityPlayer player;
    public int timeBlood = 6000;
    public NbtCareer NbtCareer;
    public ManaMetalModRoot obj;
    public static final int maxReforms = 3;
    public HumanReform[] Reforms = new HumanReform[]{HumanReform.None, HumanReform.None, HumanReform.None};
    public DemonReform[] Demon = new DemonReform[]{DemonReform.None, DemonReform.None, DemonReform.None};
    public int[] HumanDurability = new int[3];
    public int[] DemonDurability = new int[3];

    public HumanReformMagic(EntityPlayer player, NbtCareer NbtCareer2, ManaMetalModRoot obj) {
        this.NbtCareer = NbtCareer2;
        this.player = player;
        this.obj = obj;
    }

    public static final boolean hasHumanReform(ManaMetalModRoot root, HumanReform type) {
        for (int s = 0; s < 3; ++s) {
            if (root.carrer.HRM.Reforms[s] != type) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasDemonReform(ManaMetalModRoot root, DemonReform type) {
        for (int s = 0; s < 3; ++s) {
            if (root.carrer.HRM.Demon[s] != type) continue;
            return true;
        }
        return false;
    }

    public void dyingdead(int remove) {
        if (HumanReformMagic.hasDemonReform(this.obj, DemonReform.TwistedPoisonSac) && this.player.field_70170_p.field_73012_v.nextInt(100) < 33) {
            return;
        }
        for (int s = 0; s < 3; ++s) {
            if (this.Reforms[s] != null && this.Reforms[s] != HumanReform.None && this.Reforms[s] != HumanReform.Reset) {
                int n = s;
                this.HumanDurability[n] = this.HumanDurability[n] - remove;
                if (this.HumanDurability[s] <= 0) {
                    this.effect(this.Reforms[s], true);
                    this.Reforms[s] = HumanReform.None;
                }
            }
            if (this.Demon[s] == null || this.Demon[s] == DemonReform.None || this.Demon[s] == DemonReform.Reset) continue;
            int n = s;
            this.DemonDurability[n] = this.DemonDurability[n] - remove;
            if (this.DemonDurability[s] > 0) continue;
            this.effect(this.Demon[s], true);
            this.Demon[s] = DemonReform.None;
        }
        this.obj.carrer.send2();
    }

    public static final int getHumanReformDurability(HumanReform type) {
        switch (type) {
            case Claw: {
                return 200;
            }
            case Skin: {
                return 400;
            }
            case Gill: {
                return 800;
            }
            case Lava: {
                return 400;
            }
            case Eye: {
                return 300;
            }
            case Hair: {
                return 800;
            }
            case Blood: {
                return 800;
            }
            case Bone: {
                return 500;
            }
            case Magic: {
                return 400;
            }
            case Shield: {
                return 800;
            }
        }
        return 0;
    }

    public static final int getDemonReformDurability(DemonReform type) {
        switch (type) {
            case BalrogSkin: {
                return 500;
            }
            case CornerChaos: {
                return 200;
            }
            case CurseEvilEye: {
                return 200;
            }
            case DemonBlood: {
                return 800;
            }
            case DemonClaw: {
                return 100;
            }
            case EvilSoul: {
                return 800;
            }
            case ForbiddenFeather: {
                return 800;
            }
            case PoisonousHeart: {
                return 800;
            }
            case TwistedPoisonSac: {
                return 500;
            }
            case WitheringBone: {
                return 300;
            }
        }
        return 0;
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74783_a("HumanReformMagic", MMM.enumToArray((Enum[])this.Reforms));
        nbt.func_74783_a("DemonReformMagic", MMM.enumToArray((Enum[])this.Demon));
        nbt.func_74783_a("HumanDurability", this.HumanDurability);
        nbt.func_74783_a("DemonDurability", this.DemonDurability);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.Reforms = (HumanReform[])MMM.intToEnum(HumanReform.class, (int[])NBTHelp.getIntArraySafe("HumanReformMagic", nbt, new int[]{11, 11, 11}));
        this.Demon = (DemonReform[])MMM.intToEnum(DemonReform.class, (int[])NBTHelp.getIntArraySafe("DemonReformMagic", nbt, new int[]{11, 11, 11}));
        this.HumanDurability = NBTHelp.getIntArraySafe("HumanDurability", nbt, this.HumanDurability);
        this.DemonDurability = NBTHelp.getIntArraySafe("DemonDurability", nbt, this.DemonDurability);
    }

    public void addHumanReform(HumanReform type) {
        this.effect(type, false);
        if (this.NbtCareer.GetSide().isServer()) {
            this.NbtCareer.send2();
        }
    }

    public void effect(HumanReform type, boolean isRemove) {
        if (isRemove) {
            MMM.addMessage(this.player, MMM.getTranslateText("GuiHumanReform.remove").replaceAll("%effect%", MMM.getTranslateText(((Object)((Object)type)).getClass().getSimpleName() + ".name." + type.ordinal())));
        } else {
            MMM.addMessage(this.player, MMM.getTranslateText("GuiHumanReform.add").replaceAll("%effect%", MMM.getTranslateText(((Object)((Object)type)).getClass().getSimpleName() + ".name." + type.ordinal())));
        }
        int data = 1;
        if (isRemove) {
            data = -1;
        }
        switch (type) {
            case Claw: {
                this.NbtCareer.addattackMultiplier(0.2f * (float)data);
                this.NbtCareer.addphysicalAttack(10.0f * (float)data);
                this.NbtCareer.addmagicAttack(10.0f * (float)data);
                return;
            }
            case Skin: {
                this.obj.defe.addDefe(50 * data);
                this.NbtCareer.addExtraHP(600 * data);
                CareerCore.setModPointUseRanUUID(this.player, ItemEffect.HP, 600 * data);
                return;
            }
            case Bone: {
                this.NbtCareer.setSPMax(this.NbtCareer.getSPMax() + 120 * data);
                return;
            }
            case Magic: {
                this.obj.mana.setMagicMax(this.obj.mana.getMagicMax() + 800 * data);
                this.obj.mana.addRep(40 * data);
                return;
            }
            case Blood: {
                this.NbtCareer.addbloodDataMax(0.15f * (float)data);
                return;
            }
            case Hair: {
                this.NbtCareer.setHpReply(this.NbtCareer.getHpReply() + 50.0f * (float)data);
                return;
            }
            case Shield: {
                this.obj.mana.setWaterMax(this.obj.mana.getWaterMax() + 350 * data);
                this.obj.mana.setOxygenMax(this.obj.mana.getOxygenMax() + 350 * data);
                this.obj.mana.setFatigueMax(this.obj.mana.getFatigueMax() + 350 * data);
                return;
            }
            case Gill: {
                this.NbtCareer.addExtraHP(400 * data);
                CareerCore.setModPointUseRanUUID(this.player, ItemEffect.HP, 400 * data);
                this.obj.mana.setWaterMax(this.obj.mana.getWaterMax() + 500 * data);
                return;
            }
            case Lava: {
                this.obj.avoid.addAvoid(8 * data);
                return;
            }
            case Eye: {
                this.obj.crit.addCrit(8 * data);
                return;
            }
        }
    }

    public void resetHumanReform() {
        for (int s = 0; s < 3; ++s) {
            this.effect(this.Reforms[s], true);
        }
    }

    public boolean setHumanReform(HumanReform type) {
        int s;
        if (type == HumanReform.Reset) {
            this.resetHumanReform();
            this.Reforms = new HumanReform[3];
            for (int s2 = 0; s2 < 3; ++s2) {
                this.Reforms[s2] = HumanReform.None;
            }
            this.NbtCareer.send();
            return true;
        }
        for (s = 0; s < 3; ++s) {
            if (this.Reforms[s] != type) continue;
            return false;
        }
        for (s = 0; s < 3; ++s) {
            if (this.Reforms[s] != null && this.Reforms[s] != HumanReform.None && this.Reforms[s] != HumanReform.Reset) continue;
            this.Reforms[s] = type;
            this.addHumanReform(type);
            this.HumanDurability[s] = HumanReformMagic.getHumanReformDurability(type);
            this.NbtCareer.send();
            return true;
        }
        this.NbtCareer.send();
        return false;
    }

    public void tickHumanReform() {
        block6: for (int s = 0; s < 3; ++s) {
            switch (this.Reforms[s]) {
                case Gill: {
                    this.player.func_70050_g(300);
                    if (!this.player.func_70090_H() || !M3Config.SurvivalFactor || !(this.obj.mana.getTemperature() < 12.0f)) continue block6;
                    this.obj.mana.setTemperature(12.0f);
                    continue block6;
                }
                case Lava: {
                    this.player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 200, 0));
                    continue block6;
                }
                case Eye: {
                    this.player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 400, 0));
                    continue block6;
                }
                case Hair: {
                    if (!M3Config.SurvivalFactor || this.player.func_71024_bL().func_75116_a() < 20 || HumanReformMagic.hasDemonReform(this.obj, DemonReform.DemonClaw)) continue block6;
                    this.obj.mana.addFatigue(2);
                }
            }
        }
    }

    public void addDemonReform(DemonReform type) {
        this.effect(type, false);
        if (this.NbtCareer.GetSide().isServer()) {
            this.NbtCareer.send2();
        }
    }

    public void effect(DemonReform type, boolean isRemove) {
        if (isRemove) {
            MMM.addMessage(this.player, MMM.getTranslateText("GuiHumanReform.remove").replaceAll("%effect%", MMM.getTranslateText(((Object)((Object)type)).getClass().getSimpleName() + ".name." + type.ordinal())));
        } else {
            MMM.addMessage(this.player, MMM.getTranslateText("GuiHumanReform.add").replaceAll("%effect%", MMM.getTranslateText(((Object)((Object)type)).getClass().getSimpleName() + ".name." + type.ordinal())));
        }
        int data = 1;
        if (isRemove) {
            data = -1;
        }
        switch (type) {
            case BalrogSkin: {
                this.obj.defe.addDefe(100 * data);
                this.obj.carrer.adddefenseMultiplier(0.1f * (float)data);
                this.obj.avoid.addAvoid(15 * data);
                break;
            }
            case CornerChaos: {
                this.obj.carrer.addphysicalAttack(40 * data);
                this.obj.carrer.addmagicAttack(40 * data);
                this.obj.carrer.addattackMultiplier(0.5f * (float)data);
                this.obj.defe.addDefe(-200 * data);
                break;
            }
            case CurseEvilEye: {
                this.obj.carrer.addPenetrate(20 * data);
                this.obj.defe.addDefe(-400 * data);
                break;
            }
            case DemonBlood: {
                this.obj.carrer.addbloodDataMax(0.3f * (float)data);
                this.NbtCareer.addExtraHP(5000 * data);
                CareerCore.setModPointUseRanUUID(this.player, ItemEffect.HP, 5000 * data);
                break;
            }
            case DemonClaw: {
                this.obj.carrer.finalDamage += 0.12f * (float)data;
                this.obj.carrer.addPenetrate(12 * data);
                this.obj.defe.addDefe(-150 * data);
                break;
            }
            case EvilSoul: {
                this.obj.crit.addCrit(20 * data);
                this.obj.avoid.addAvoid(20 * data);
                this.obj.mana.setWaterMax(this.obj.mana.getWaterMax() + 500 * data);
                this.obj.mana.addMagicReply(200 * data);
                break;
            }
            case ForbiddenFeather: {
                this.obj.carrer.addWillpower(0.1f * (float)data);
                this.NbtCareer.setSPMax(this.NbtCareer.getSPMax() + 120 * data);
                break;
            }
            case PoisonousHeart: {
                this.obj.carrer.addDropRate(30 * data);
                this.obj.carrer.addcraft(0.1f * (float)data);
                this.obj.carrer.addInsight(0.1f * (float)data);
                break;
            }
            case TwistedPoisonSac: {
                this.obj.mana.addMagicMax(4000 * data);
                break;
            }
            case WitheringBone: {
                this.obj.carrer.addattackMultiplier(0.4f * (float)data);
                this.obj.carrer.addPenetrate(4 * data);
            }
        }
    }

    public void resetDemonReform() {
        for (int s = 0; s < 3; ++s) {
            this.effect(this.Demon[s], true);
        }
    }

    public boolean setDemonReform(DemonReform type) {
        int s;
        if (type == DemonReform.Reset) {
            this.resetDemonReform();
            this.Demon = new DemonReform[3];
            for (int s2 = 0; s2 < 3; ++s2) {
                this.Demon[s2] = DemonReform.Reset;
            }
            this.NbtCareer.send();
            return true;
        }
        for (s = 0; s < 3; ++s) {
            if (this.Demon[s] != type) continue;
            return false;
        }
        for (s = 0; s < 3; ++s) {
            if (this.Demon[s] != null && this.Demon[s] != DemonReform.None && this.Demon[s] != DemonReform.Reset) continue;
            this.Demon[s] = type;
            this.addDemonReform(type);
            this.DemonDurability[s] = HumanReformMagic.getDemonReformDurability(type);
            this.NbtCareer.send();
            return true;
        }
        this.NbtCareer.send();
        return false;
    }

    public void tickDemonReform() {
        block5: for (int s = 0; s < 3; ++s) {
            switch (this.Demon[s]) {
                case EvilSoul: {
                    if (this.player.func_71024_bL().func_75116_a() < 20) continue block5;
                    this.player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 200, 0));
                    continue block5;
                }
                case DemonBlood: {
                    this.obj.carrer.addBloodData((int)(this.player.func_110138_aP() * 0.05f));
                    continue block5;
                }
                case DemonClaw: {
                    if (!M3Config.SurvivalFactor) continue block5;
                    this.obj.mana.addFatigue(-1);
                    this.obj.mana.addOxygen(-1);
                }
            }
        }
    }

    public void update() {
        if (this.player != null) {
            ++this.time;
            if (this.time > 99) {
                this.time = 0;
                if (MMM.getDimensionID(this.player.field_70170_p) != M3Config.WorldFutureID) {
                    this.tickHumanReform();
                    this.tickDemonReform();
                    EventFx.player_fivetick_event(this.player, this.obj);
                }
            }
        }
    }
}

