/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;

public class NBTHelp {
    public static final int ByteID = 1;
    public static final int ShortID = 2;
    public static final int IntegerID = 3;
    public static final int LongID = 4;
    public static final int FloatID = 5;
    public static final int DoubleID = 6;
    public static final int ByteArrayID = 7;
    public static final int StringID = 8;
    public static final int ListID = 9;
    public static final int NBTTagCompoundID = 10;
    public static final int IntegerArrayID = 11;

    public static final Object getObjectAutoSafe(Object type, NBTTagCompound nbt, String key, Object defaul, int listKey) {
        if (type instanceof Byte && nbt.func_150297_b(key, 1)) {
            return nbt.func_74771_c(key);
        }
        if (type instanceof Short && nbt.func_150297_b(key, 2)) {
            return nbt.func_74765_d(key);
        }
        if (type instanceof Integer && nbt.func_150297_b(key, 3)) {
            return nbt.func_74762_e(key);
        }
        if (type instanceof Long && nbt.func_150297_b(key, 4)) {
            return nbt.func_74763_f(key);
        }
        if (type instanceof Float && nbt.func_150297_b(key, 5)) {
            return Float.valueOf(nbt.func_74760_g(key));
        }
        if (type instanceof Double && nbt.func_150297_b(key, 6)) {
            return nbt.func_74769_h(key);
        }
        if (type instanceof byte[] && nbt.func_150297_b(key, 7)) {
            return nbt.func_74770_j(key);
        }
        if (type instanceof String && nbt.func_150297_b(key, 8)) {
            return nbt.func_74779_i(key);
        }
        if (type instanceof NBTTagList && nbt.func_150297_b(key, 9)) {
            return nbt.func_150295_c(key, listKey);
        }
        if (type instanceof NBTTagCompound && nbt.func_150297_b(key, 10)) {
            return nbt.func_74775_l(key);
        }
        if (type instanceof int[] && nbt.func_150297_b(key, 11)) {
            return nbt.func_74759_k(key);
        }
        return defaul;
    }

    public static final void setBooleanArray(NBTTagCompound nbt, String name, boolean[] data) {
        byte[] temp = new byte[data.length];
        for (int s = 0; s < temp.length; ++s) {
            temp[s] = data[s] ? (byte)1 : 0;
        }
        nbt.func_74773_a(name, temp);
    }

    public static final boolean[] getBooleanArraySafe(NBTTagCompound nbt, String key, boolean[] defaul) {
        if (nbt.func_150297_b(key, 7)) {
            byte[] data = nbt.func_74770_j(key);
            boolean[] temp = new boolean[data.length];
            for (int s = 0; s < temp.length; ++s) {
                temp[s] = data[s] == 1;
            }
            return temp;
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get boolean[] from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final ItemStack getItemStackSafe(NBTTagCompound nbt, ItemStack defaul) {
        try {
            ItemStack temp;
            if (nbt.func_150297_b("id", 2) && nbt.func_150297_b("Count", 1) && nbt.func_150297_b("Damage", 2) && (temp = ItemStack.func_77949_a((NBTTagCompound)nbt)) != null && temp.func_77973_b() != null) {
                return temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaul;
    }

    public static final boolean getBooleanSafe(String key, NBTTagCompound nbt, boolean defaul) {
        if (nbt.func_150297_b(key, 1)) {
            return nbt.func_74767_n(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get boolean from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final byte getByteSafe(String key, NBTTagCompound nbt, byte defaul) {
        if (nbt.func_150297_b(key, 1)) {
            return nbt.func_74771_c(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get byte from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final short getShortSafe(String key, NBTTagCompound nbt, short defaul) {
        if (nbt.func_150297_b(key, 2)) {
            return nbt.func_74765_d(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get short from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final int getIntSafe(String key, NBTTagCompound nbt, int defaul) {
        if (nbt.func_150297_b(key, 3)) {
            return nbt.func_74762_e(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get int from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final long getLongSafe(String key, NBTTagCompound nbt, long defaul) {
        if (nbt.func_150297_b(key, 4)) {
            return nbt.func_74763_f(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get long from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final float getFloatSafe(String key, NBTTagCompound nbt, float defaul) {
        if (nbt.func_150297_b(key, 5)) {
            return nbt.func_74760_g(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get float from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final double getDoubleSafe(String key, NBTTagCompound nbt, double defaul) {
        if (nbt.func_150297_b(key, 6)) {
            return nbt.func_74769_h(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get double from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final byte[] getByteArraySafe(String key, NBTTagCompound nbt, byte[] defaul) {
        if (nbt.func_150297_b(key, 7)) {
            return nbt.func_74770_j(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get byte[] from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final String getStringSafe(String key, NBTTagCompound nbt, String defaul) {
        if (nbt.func_150297_b(key, 8)) {
            return nbt.func_74779_i(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get String from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final NBTTagList getNBTTagListSafe(String key, NBTTagCompound nbt, int type, NBTTagList defaul) {
        if (nbt.func_150297_b(key, 9)) {
            return nbt.func_150295_c(key, type);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get NBTTagList from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final NBTTagCompound getTagSafe(String key, NBTTagCompound nbt, NBTTagCompound defaul) {
        if (nbt.func_150297_b(key, 10)) {
            return nbt.func_74775_l(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get NBTTagCompound from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final int[] getIntArraySafe(String key, NBTTagCompound nbt, int[] defaul) {
        if (nbt.func_150297_b(key, 11)) {
            return nbt.func_74759_k(key);
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get int[] from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final int[] getIntArraySafeDefSize(String key, NBTTagCompound nbt, int[] defaul, int size) {
        int[] data;
        if (nbt.func_150297_b(key, 11) && (data = nbt.func_74759_k(key)).length == size) {
            return data;
        }
        if (M3Config.DEBUG) {
            MMM.Error("can't get int[] from nbt name : " + key + " !!!");
        }
        return defaul;
    }

    public static final Integer[] getIntegerArraySafe(String key, NBTTagCompound nbt, Integer[] defaul) {
        if (nbt.func_150297_b(key, 11)) {
            int[] type = nbt.func_74759_k(key);
            Integer[] temp = new Integer[type.length];
            for (int s = 0; s < type.length; ++s) {
                temp[s] = type[s];
            }
            return temp;
        }
        return defaul;
    }

    public static final short getShortFromListSafe(NBTTagList list, int index, short defaul) {
        short target = 0;
        try {
            String text = list.func_150307_f(index);
            if (text != null) {
                text.replaceAll("s", "");
                target = Short.decode(text);
                return target;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaul;
    }

    public static final byte getByteFromListSafe(NBTTagList list, int index, byte defaul) {
        byte target = 0;
        try {
            String text = list.func_150307_f(index);
            if (text != null) {
                text.replaceAll("b", "");
                target = Byte.decode(text);
                return target;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaul;
    }

    public static final ItemStack addUnbreakableItem(ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("Unbreakable", true);
        item.func_77982_d(tag);
        return item;
    }

    public static final boolean hasItemStackTag(NBTTagCompound nbt) {
        return nbt.func_150297_b("id", 2) && nbt.func_150297_b("Count", 1) && nbt.func_150297_b("Damage", 2);
    }
}

