/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import project.studio.manametalmod.core.NCV;

public class Vector3D
implements Cloneable {
    private static final long serialVersionUID = -2657651106777219169L;
    private static Random random = new Random();
    private static final double epsilon = 1.0E-6;
    protected double x;
    protected double y;
    protected double z;

    public Vector3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3D(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D add(Vector3D vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vector3D subtract(Vector3D vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vector3D multiply(Vector3D vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public Vector3D divide(Vector3D vec) {
        this.x /= vec.x;
        this.y /= vec.y;
        this.z /= vec.z;
        return this;
    }

    public Vector3D copy(Vector3D vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    public double length() {
        return Math.sqrt(NCV.square(this.x) + NCV.square(this.y) + NCV.square(this.z));
    }

    public double lengthSquared() {
        return NCV.square(this.x) + NCV.square(this.y) + NCV.square(this.z);
    }

    public double distance(Vector3D o) {
        return Math.sqrt(NCV.square(this.x - o.x) + NCV.square(this.y - o.y) + NCV.square(this.z - o.z));
    }

    public double distanceSquared(Vector3D o) {
        return NCV.square(this.x - o.x) + NCV.square(this.y - o.y) + NCV.square(this.z - o.z);
    }

    public float angle(Vector3D other) {
        double dot = this.dot(other) / (this.length() * other.length());
        return (float)Math.acos(dot);
    }

    public Vector3D midpoint(Vector3D other) {
        this.x = (this.x + other.x) / 2.0;
        this.y = (this.y + other.y) / 2.0;
        this.z = (this.z + other.z) / 2.0;
        return this;
    }

    public Vector3D getMidpoint(Vector3D other) {
        double x = (this.x + other.x) / 2.0;
        double y = (this.y + other.y) / 2.0;
        double z = (this.z + other.z) / 2.0;
        return new Vector3D(x, y, z);
    }

    public Vector3D multiply(int m) {
        this.x *= (double)m;
        this.y *= (double)m;
        this.z *= (double)m;
        return this;
    }

    public Vector3D multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return this;
    }

    public Vector3D multiply(float m) {
        this.x *= (double)m;
        this.y *= (double)m;
        this.z *= (double)m;
        return this;
    }

    public double dot(Vector3D other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3D crossProduct(Vector3D o) {
        double newX = this.y * o.z - o.y * this.z;
        double newY = this.z * o.x - o.z * this.x;
        double newZ = this.x * o.y - o.x * this.y;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vector3D normalize() {
        double length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public Vector3D zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public boolean isInAABB(Vector3D min, Vector3D max) {
        return this.x >= min.x && this.x <= max.x && this.y >= min.y && this.y <= max.y && this.z >= min.z && this.z <= max.z;
    }

    public boolean isInSphere(Vector3D origin, double radius) {
        return NCV.square(origin.x - this.x) + NCV.square(origin.y - this.y) + NCV.square(origin.z - this.z) <= NCV.square(radius);
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return NCV.floor(this.x);
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return NCV.floor(this.y);
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return NCV.floor(this.z);
    }

    public Vector3D setX(int x) {
        this.x = x;
        return this;
    }

    public Vector3D setX(double x) {
        this.x = x;
        return this;
    }

    public Vector3D setX(float x) {
        this.x = x;
        return this;
    }

    public Vector3D setY(int y) {
        this.y = y;
        return this;
    }

    public Vector3D setY(double y) {
        this.y = y;
        return this;
    }

    public Vector3D setY(float y) {
        this.y = y;
        return this;
    }

    public Vector3D setZ(int z) {
        this.z = z;
        return this;
    }

    public Vector3D setZ(double z) {
        this.z = z;
        return this;
    }

    public Vector3D setZ(float z) {
        this.z = z;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3D)) {
            return false;
        }
        Vector3D other = (Vector3D)obj;
        return Math.abs(this.x - other.x) < 1.0E-6 && Math.abs(this.y - other.y) < 1.0E-6 && Math.abs(this.z - other.z) < 1.0E-6 && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public Vector3D clone() {
        try {
            return (Vector3D)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }

    public static double getEpsilon() {
        return 1.0E-6;
    }

    public static Vector3D getMinimum(Vector3D v1, Vector3D v2) {
        return new Vector3D(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.min(v1.z, v2.z));
    }

    public static Vector3D getMaximum(Vector3D v1, Vector3D v2) {
        return new Vector3D(Math.max(v1.x, v2.x), Math.max(v1.y, v2.y), Math.max(v1.z, v2.z));
    }

    public static Vector3D getRandom() {
        return new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("x", this.getX());
        result.put("y", this.getY());
        result.put("z", this.getZ());
        return result;
    }

    public static Vector3D deserialize(Map<String, Object> args) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (args.containsKey("x")) {
            x = (Double)args.get("x");
        }
        if (args.containsKey("y")) {
            y = (Double)args.get("y");
        }
        if (args.containsKey("z")) {
            z = (Double)args.get("z");
        }
        return new Vector3D(x, y, z);
    }
}

