/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IEntityData;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.chess.TileEntityChessAI;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.instance_dungeon.BaseDungeonMob;
import project.studio.manametalmod.instance_dungeon.IDungeonBoss;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityMagicBallGravity;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.mob.EntityMagicObject;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;

public class MobDunageonHeroTemple
extends BaseDungeonMob
implements IEntityData,
IRangedAttackMob,
IEntityAdditionalSpawnData,
IDungeonBoss {
    public IDungeonDifficult Difficult = IDungeonDifficult.EASY;
    public int type = 0;
    public EntityAIArrowAttack bowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f);
    public EntityAIAttackOnCollide swordAttack = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false);
    public EntityAIWander EntityAIWander = new EntityAIWander((EntityCreature)this, 1.0);
    public EntityAIHurtByTarget EntityAIHurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, false);
    public EntityAINearestAttackableTarget EntityAINearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true);
    public long mobuuid = -1L;
    Pos posspawn = new Pos();
    public boolean isUP = false;
    public float wing1 = 2.0f;
    public float wing2 = 1.0f;
    public boolean update = false;
    public boolean spawneffect = false;
    public int time = 0;
    public int timespawn = 0;
    public int timepower = 0;
    public int hptime = 0;
    public int attacktime = 0;
    public int railtime = 0;
    public int gravityBall = 0;
    public int stage = 0;
    public int superBalls;

    public MobDunageonHeroTemple(World world) {
        this(world, IDungeonDifficult.EASY, 0, -1L, new Pos());
    }

    @Override
    public void setIDungeonDifficult(IDungeonDifficult diff) {
        this.Difficult = diff;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public MobDunageonHeroTemple(World world, IDungeonDifficult diff, int type, long mobuuid, Pos posspawn) {
        super(world);
        this.field_70178_ae = true;
        this.Difficult = diff;
        this.type = type;
        this.mobuuid = mobuuid;
        this.posspawn = posspawn;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        switch (this.type) {
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.EntityAIWander);
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.EntityAIHurtByTarget);
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.EntityAINearestAttackableTarget);
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.swordAttack);
            }
        }
        this.func_70105_a(1.5f, 2.0f);
        this.func_110163_bv();
        this.setAttributes();
    }

    public void setBox(float x, float y) {
        this.field_70121_D.field_72336_d = this.field_70121_D.field_72340_a + (double)x;
        this.field_70121_D.field_72334_f = this.field_70121_D.field_72339_c + (double)x;
        this.field_70121_D.field_72337_e = this.field_70121_D.field_72338_b + (double)y;
    }

    public void setAttributes() {
        switch (this.type) {
            case 0: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(19000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2800.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000000.0);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(100.0);
                break;
            }
            case 6: {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6500.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
                this.setBox(1.5f, 3.0f);
                break;
            }
            case 7: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(19000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2800.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
                break;
            }
            case 8: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(19000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2800.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
                break;
            }
            case 9: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3500.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
                break;
            }
            case 10: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2800.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
                break;
            }
            case 11: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6000.0 * (double)this.Difficult.getDiffcultHPmultiplier());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2800.0 * (double)this.Difficult.getDiffcultAttackmultiplier());
            }
        }
        this.func_70606_j(this.func_110138_aP());
    }

    public String func_70005_c_() {
        return MMM.getTranslateText("MobDunageonHeroTemple." + this.type);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void wing() {
        if (this.field_70170_p.field_72995_K) {
            if (this.isUP) {
                this.wing1 += 0.15f;
                this.wing2 -= 0.15f;
                if (this.wing1 >= 3.0f) {
                    this.isUP = false;
                    this.wing1 = 3.0f;
                    this.wing2 = 0.0f;
                }
            } else {
                this.wing1 -= 0.15f;
                this.wing2 += 0.15f;
                if (this.wing1 <= 2.0f) {
                    this.isUP = true;
                    this.wing1 = 2.0f;
                    this.wing2 = 1.0f;
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("type", this.type);
        nbt.func_74768_a("Difficult", this.Difficult.ordinal());
        nbt.func_74772_a("mobuuid", this.mobuuid);
        nbt.func_74757_a("spawneffect", this.spawneffect);
        this.posspawn.saveToNBT(nbt);
        nbt.func_74768_a("timespawn", this.timespawn);
        nbt.func_74768_a("timepower", this.timepower);
        nbt.func_74768_a("hptime", this.hptime);
        nbt.func_74768_a("attacktime", this.attacktime);
        nbt.func_74768_a("railtime", this.railtime);
        nbt.func_74768_a("gravityBall", this.gravityBall);
        nbt.func_74768_a("stage", this.stage);
        nbt.func_74768_a("superBalls", this.superBalls);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.type = NBTHelp.getIntSafe("type", nbt, 0);
        this.Difficult = IDungeonDifficult.values()[NBTHelp.getIntSafe("Difficult", nbt, 0)];
        this.mobuuid = NBTHelp.getLongSafe("mobuuid", nbt, -1L);
        this.spawneffect = NBTHelp.getBooleanSafe("spawneffect", nbt, this.isUP);
        this.posspawn.readFromNBT(nbt);
        this.timespawn = NBTHelp.getIntSafe("timespawn", nbt, 0);
        this.timepower = NBTHelp.getIntSafe("timepower", nbt, 0);
        this.hptime = NBTHelp.getIntSafe("hptime", nbt, 0);
        this.attacktime = NBTHelp.getIntSafe("attacktime", nbt, 0);
        this.railtime = NBTHelp.getIntSafe("railtime", nbt, 0);
        this.gravityBall = NBTHelp.getIntSafe("gravityBall", nbt, 0);
        this.stage = NBTHelp.getIntSafe("stage", nbt, 0);
        this.superBalls = NBTHelp.getIntSafe("superBalls", nbt, 0);
    }

    public void func_70636_d() {
        int s;
        List<Entity> list;
        MobDunageonHeroTemple mob;
        super.func_70636_d();
        if (!this.update) {
            this.update = true;
            switch (this.type) {
                case 0: 
                case 7: 
                case 10: 
                case 11: {
                    this.func_70105_a(1.0f, 2.0f);
                    break;
                }
                case 6: 
                case 9: {
                    this.func_70105_a(2.0f, 3.5f);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.EntityAIWander);
                    this.field_70715_bh.func_85156_a((EntityAIBase)this.EntityAIHurtByTarget);
                    this.field_70715_bh.func_85156_a((EntityAIBase)this.EntityAINearestAttackableTarget);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.swordAttack);
                }
            }
        }
        ++this.time;
        this.wing();
        if (this.type == 1 || this.type == 2) {
            if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)(this.field_70163_u - 1.0), (int)this.field_70161_v) != Blocks.field_150350_a) {
                this.field_70181_x = 0.5;
            }
            if (this.field_70181_x < 0.0) {
                this.field_70181_x = 0.02f;
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.type != 1 && this.type != 2 && this.type != 3 && this.type != 4 && this.type != 5 || this.time % 100 != 0)) {
            MMM.teleport((Entity)this, this.posspawn);
        }
        if (this.type == 0) {
            // empty if block
        }
        if (this.type == 1) {
            if (!this.spawneffect && this.time > 50) {
                this.spawneffect = true;
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.0");
                }
                this.spanwobj((float)this.posspawn.X + 0.5f + 11.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f + 5.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f + 11.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f - 5.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f - 11.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f + 5.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f - 11.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f - 5.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f + 5.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f + 11.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f - 5.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f + 11.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f + 5.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f - 11.0f, 36, 0, 100, null);
                this.spanwobj((float)this.posspawn.X + 0.5f - 5.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f - 11.0f, 36, 0, 100, null);
            }
            if (this.time % 60 == 0 && !this.field_70170_p.field_72995_K && this.canSpawn()) {
                mob = new MobDunageonHeroTemple(this.field_70170_p, this.Difficult, 7 + this.field_70170_p.field_73012_v.nextInt(2), this.mobuuid, this.posspawn);
                mob.func_70080_a(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(11), this.field_70163_u + 1.0, this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(11), 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)mob);
                MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":laser1", this.posspawn, 1.0, 1.0 + (double)this.field_70170_p.field_73012_v.nextFloat() * 0.3, 16.0);
            }
            if (this.time % 200 == 0 && !this.field_70170_p.field_72995_K) {
                list = MMM.findEntity((Entity)this, 32);
                int ok = 0;
                for (int s2 = 0; s2 < list.size(); ++s2) {
                    if (!(list.get(s2) instanceof EntityMagicObject)) continue;
                    EntityMagicObject tree = (EntityMagicObject)list.get(s2);
                    if (tree.type != 35) continue;
                    ++ok;
                }
                if (ok >= 8) {
                    List<Entity> list2 = MMM.findEntity((Entity)this, 32);
                    for (int s3 = 0; s3 < list2.size(); ++s3) {
                        IEntityAdditionalSpawnData tree;
                        if (list2.get(s3) instanceof EntityMagicObject) {
                            tree = (EntityMagicObject)list2.get(s3);
                            if (tree.type == 35 || tree.type == 36) {
                                list2.get(s3).func_70106_y();
                            }
                        }
                        if (!(list2.get(s3) instanceof MobDunageonHeroTemple)) continue;
                        tree = (MobDunageonHeroTemple)list2.get(s3);
                        if (tree.type != 7 && tree.type != 8) continue;
                        list2.get(s3).func_70106_y();
                    }
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.1");
                    this.dropTestItems();
                    this.func_70106_y();
                }
            }
        }
        if (this.type == 2) {
            TileEntity tile;
            if (!this.spawneffect && this.time > 50) {
                this.spawneffect = true;
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.2");
                    tile = this.posspawn.getPosTileEntity(this.field_70170_p);
                    if (tile != null && tile instanceof TileEntityChessAI) {
                        TileEntityChessAI AI = (TileEntityChessAI)tile;
                        this.field_70170_p.func_72921_c(this.posspawn.X, this.posspawn.Y, this.posspawn.Z, 0, 2);
                        AI.dowater = 5;
                        AI.spawn();
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K && this.attacktime > 0) {
                --this.attacktime;
                if (this.attacktime == 0) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.3");
                    tile = this.posspawn.getPosTileEntity(this.field_70170_p);
                    if (tile != null && tile instanceof TileEntityChessAI) {
                        TileEntityChessAI AI = (TileEntityChessAI)tile;
                        AI.dowater += 10;
                        AI.spawn();
                    }
                }
            }
        }
        if (this.type == 3) {
            if (!this.spawneffect && this.time > 50) {
                this.spawneffect = true;
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.5");
                }
            }
            if (this.time % 30 == 0 && !this.field_70170_p.field_72995_K && this.canSpawn()) {
                mob = new MobDunageonHeroTemple(this.field_70170_p, this.Difficult, 10 + this.field_70170_p.field_73012_v.nextInt(2), this.mobuuid, this.posspawn);
                mob.func_70080_a(this.field_70165_t - 6.0 + (double)this.field_70170_p.field_73012_v.nextInt(12), this.field_70163_u + 1.0, this.field_70161_v - 6.0 + (double)this.field_70170_p.field_73012_v.nextInt(12), 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)mob);
                MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":laser1", this.posspawn, 1.0, 1.0 + (double)this.field_70170_p.field_73012_v.nextFloat() * 0.3, 16.0);
            }
            if (this.time % 200 == 0 && !this.field_70170_p.field_72995_K && this.attacktime >= 30 && this.railtime >= 30) {
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.6");
                list = MMM.findLivingBase((Entity)this, 16.0);
                for (s = 0; s < list.size(); ++s) {
                    if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
                    MobDunageonHeroTemple tree = (MobDunageonHeroTemple)list.get(s);
                    if (tree.type != 10 && tree.type != 11) continue;
                    ((EntityLivingBase)list.get(s)).func_70106_y();
                }
                this.func_70106_y();
                this.dropTestItems();
            }
        }
        if (this.type == 4) {
            if (!this.spawneffect && this.time > 50) {
                this.spawneffect = true;
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.7");
                    this.spanwobj((float)this.posspawn.X + 0.5f + 6.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f, 37, 800 * (this.Difficult.ordinal() + 1), 10000, (EntityLivingBase)this);
                    this.spanwobj((float)this.posspawn.X + 0.5f - 6.0f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f, 37, 800 * (this.Difficult.ordinal() + 1), 10000, (EntityLivingBase)this);
                    this.spanwobj((float)this.posspawn.X + 0.5f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f - 6.0f, 37, 800 * (this.Difficult.ordinal() + 1), 10000, (EntityLivingBase)this);
                    this.spanwobj((float)this.posspawn.X + 0.5f, (float)this.posspawn.Y + 0.3f, (float)this.posspawn.Z + 0.5f + 6.0f, 37, 800 * (this.Difficult.ordinal() + 1), 10000, (EntityLivingBase)this);
                }
            }
            if (this.time % 60 == 0) {
                List<EntityPlayer> lst;
                if (!this.field_70170_p.field_72995_K && this.canSpawn()) {
                    mob = new MobDunageonHeroTemple(this.field_70170_p, this.Difficult, 9, this.mobuuid, this.posspawn);
                    mob.func_70080_a(this.field_70165_t - 6.0 + (double)this.field_70170_p.field_73012_v.nextInt(12), this.field_70163_u + 1.0, this.field_70161_v - 6.0 + (double)this.field_70170_p.field_73012_v.nextInt(12), 0.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)mob);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":laser1", this.posspawn, 1.0, 1.0 + (double)this.field_70170_p.field_73012_v.nextFloat() * 0.3, 16.0);
                }
                if (!(lst = MMM.findPlayers((Entity)this, 32)).isEmpty()) {
                    for (s = 0; s < lst.size(); ++s) {
                        ManaMetalModRoot root = MMM.getEntityNBT(lst.get(s));
                        PotionEffectM3.addPotion(root, PotionM3.potionFireTwitch, 100, 0);
                    }
                }
            }
            if (this.time % 200 == 0 && !this.field_70170_p.field_72995_K && this.attacktime >= 30) {
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.8");
                List<Entity> list2 = MMM.findEntity((Entity)this, 32);
                for (s = 0; s < list2.size(); ++s) {
                    if (list2.get(s) instanceof EntityMagicObject) {
                        EntityMagicObject tree = (EntityMagicObject)list2.get(s);
                        if (tree.type == 37) {
                            list2.get(s).func_70106_y();
                        }
                    }
                    if (!(list2.get(s) instanceof MobDunageonHeroTemple)) continue;
                    MobDunageonHeroTemple tree = (MobDunageonHeroTemple)list2.get(s);
                    if (tree.type != 9) continue;
                    list2.get(s).func_70106_y();
                }
                this.func_70106_y();
                this.dropTestItems();
            }
        }
        if (this.type == 5) {
            if (!this.spawneffect && this.time > 50) {
                this.spawneffect = true;
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.9");
                }
            }
            if (this.time % 50 == 0) {
                PotionEffectM3.addPotionList(MMM.findPlayers((Entity)this, 16), PotionM3.potionWatergame, 8, 0);
            }
            if (this.attacktime > 0) {
                --this.attacktime;
                if (this.attacktime == 0) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.10");
                    this.dropTestItems();
                    for (int dz = 0; dz < 8; ++dz) {
                        for (int dx = 0; dx < 8; ++dx) {
                            this.field_70170_p.func_147465_d(this.posspawn.X + dx - 3, this.posspawn.Y - 1, this.posspawn.Z + dz + 3, Blocks.field_150371_ca, 0, 2);
                        }
                    }
                    for (int dy = 0; dy < 6; ++dy) {
                        for (int dz = 0; dz < 8; ++dz) {
                            for (int dx = 0; dx < 8; ++dx) {
                                this.field_70170_p.func_147465_d(this.posspawn.X + dx - 3, this.posspawn.Y + dy, this.posspawn.Z + dz + 3, Blocks.field_150350_a, 0, 2);
                            }
                        }
                    }
                    this.func_70106_y();
                    this.addXP();
                }
            }
        }
        if (this.type == 10 || this.type == 11) {
            if (this.time > 260) {
                MMM.fakeExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4, (float)(6000 * (this.Difficult.ordinal() + 1)), true, (Entity)this);
                this.func_70106_y();
            }
            if (this.time % 100 == 0 && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
                EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, 1250 * this.Difficult.getDiffcultAttackmultiplier(), ManaElements.Dark, 0, (Entity)this.func_70638_az());
                this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)ball);
                }
            }
        }
        if (this.type == 9) {
            this.fireBallAttackgravityOne();
        }
        if ((this.type == 7 || this.type == 8) && this.time % 100 == 0 && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, 800 * this.Difficult.getDiffcultAttackmultiplier(), ManaElements.Dark, 0, (Entity)this.func_70638_az());
            this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)ball);
            }
        }
        if (this.type == 6) {
            if (!this.spawneffect && this.time > 50) {
                this.spawneffect = true;
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.11");
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.12");
                }
            }
            this.fly();
            if (this.stage == 0 && this.fireBallAttackgravity(4000.0f, 15)) {
                this.doSuperBalls(3200);
            }
            if (this.stage == 1) {
                if (this.fireBallAttackgravity(4500.0f, 15)) {
                    this.doSuperBalls(3200);
                }
                this.doPotionBall();
            }
            if (this.stage == 2) {
                if (this.fireBallAttackgravity(5000.0f, 15)) {
                    this.doSuperBalls(3200);
                }
                this.doPotionBall();
            }
            if (this.stage == 3) {
                if (this.fireBallAttackgravity(5500.0f, 15)) {
                    this.doSuperBalls(3200);
                }
                this.doPotionBall();
                this.summon();
                this.func_70691_i(100.0f);
            }
        }
    }

    public void summon() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.timespawn;
            if (this.timespawn > 400) {
                MMM.teleport((Entity)this, this.posspawn.add(0, 1, 0));
                if (this.canSpawn()) {
                    for (int s = 0; s < 6; ++s) {
                        MobDunageonHeroTemple mob = new MobDunageonHeroTemple(this.field_70170_p, this.Difficult, 7 + this.field_70170_p.field_73012_v.nextInt(5), this.mobuuid, this.posspawn);
                        mob.func_70080_a(this.field_70165_t - 6.0 + (double)this.field_70170_p.field_73012_v.nextInt(12), this.field_70163_u + 1.0, this.field_70161_v - 6.0 + (double)this.field_70170_p.field_73012_v.nextInt(12), 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)mob);
                    }
                }
            }
        }
    }

    public void fly() {
        EntityLivingBase entity;
        this.field_70181_x *= 0.3000000238418579;
        if (!this.field_70170_p.field_72995_K && (entity = this.func_70638_az()) != null) {
            double d1;
            double d0;
            double d3;
            if (this.field_70163_u < entity.field_70163_u || this.field_70163_u < entity.field_70163_u + 1.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * 0.3000000238418579;
            }
            if (!this.func_82165_m(2) && (d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 9.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * 0.2000000238418579;
                this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * 0.2000000238418579;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.02000000074505806) {
            this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
    }

    public void doPotionBall() {
        ++this.railtime;
        if (this.railtime > 900) {
            if (this.railtime % 4 == 0) {
                int dx = 25 - this.field_70170_p.field_73012_v.nextInt(50);
                int dz = 25 - this.field_70170_p.field_73012_v.nextInt(50);
                EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, this.field_70165_t + (double)dx, this.field_70163_u + 7.0, this.field_70161_v + (double)dz, 3000, ManaElements.Dark, 12, null);
                ball.field_70181_x = -4.0;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)ball);
                }
                MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":magic.dark", this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f, 64.0);
            }
            if (this.railtime > 1100) {
                this.railtime = -100;
            }
        }
    }

    public boolean fireBallAttackgravity(float attack_ball, int type) {
        if (this.func_70638_az() != null) {
            ++this.gravityBall;
            if (this.gravityBall > 100) {
                this.see_target();
                if (this.gravityBall == 101) {
                    MMM.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 100, 4.0f, true, 32);
                    this.func_70690_d(new PotionEffect(2, 100, 5));
                }
                if (this.gravityBall > 150) {
                    if (this.gravityBall % 10 == 0) {
                        int data = this.field_70170_p.field_73012_v.nextInt(12);
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 0, 2.0f);
                        EntityMagicBallGravity ball1 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 16 + data, 2.0f);
                        EntityMagicBallGravity ball2 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 32 + data, 2.0f);
                        EntityMagicBallGravity ball7 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, -16 + data, 2.0f);
                        EntityMagicBallGravity ball4 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, -32 - data, 2.0f);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)ball0);
                            this.field_70170_p.func_72838_d((Entity)ball1);
                            this.field_70170_p.func_72838_d((Entity)ball2);
                            this.field_70170_p.func_72838_d((Entity)ball4);
                            this.field_70170_p.func_72838_d((Entity)ball7);
                        }
                    }
                    if (this.gravityBall > 200) {
                        this.gravityBall = -100;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean doSuperBalls(int damage) {
        ++this.superBalls;
        if (this.superBalls > 100) {
            if (this.func_70638_az() != null) {
                this.see_target();
                this.func_70690_d(new PotionEffect(2, 100, 2));
                if (this.superBalls % 2 == 0) {
                    EntityLivingBase target = this.func_70638_az();
                    EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, damage, ManaElements.Light, 19, null);
                    if (!this.field_70170_p.field_72995_K) {
                        ball.field_70125_A -= -20.0f;
                        double d0 = target.field_70165_t + target.field_70159_w - this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                        double d1 = target.field_70163_u - 1.0 - this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                        double d2 = target.field_70161_v + target.field_70179_y - this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                        ball.func_70186_c(d0 *= (double)2.85f, d1 *= (double)2.85f, d2 *= (double)2.85f, 1.5f, 1.0f);
                        ball.setSpaceTextureID(0);
                        this.field_70170_p.func_72838_d((Entity)ball);
                    }
                    this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Light), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
            }
            if (this.superBalls > 300) {
                this.superBalls = -400;
            }
            return false;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof MobDunageonHeroTemple) {
            return false;
        }
        if (this.type == 1 || this.type == 2 || this.type == 3 || this.type == 4 || this.type == 5) {
            return false;
        }
        if (this.type == 6) {
            if (this.stage == 0) {
                if (this.func_110143_aJ() < this.func_110138_aP() * 0.75f) {
                    this.stage = 1;
                    MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, 255.0f, 0.0f, 0.0f);
                }
            } else if (this.stage == 1) {
                if (this.func_110143_aJ() < this.func_110138_aP() * 0.5f) {
                    this.stage = 2;
                    MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, 255.0f, 0.0f, 0.0f);
                }
            } else if (this.stage == 2 && this.func_110143_aJ() < this.func_110138_aP() * 0.25f) {
                this.stage = 3;
                MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, 255.0f, 0.0f, 0.0f);
            }
        }
        if (source == AttackType.GravityDamage || source.field_76373_n.equals(AttackType.GravityDamage.field_76373_n)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void dropTestItems() {
        if (!this.field_70170_p.field_72995_K) {
            MMM.StopPlayerSoundClinet(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack(InstanceDungeonCore.ItemHeroTestok, 1, this.type - 1));
            list.add(new ItemStack(InstanceDungeonCore.ItemFoodHeroTest, 3, this.type - 1));
            MMM.spawnItemInHolyDevice(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, list, false);
        }
    }

    public void drawTest(int type) {
        if (type == 20) {
            this.attacktime = 100;
        }
        if (type == 21) {
            MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.MobDunageonHeroTemple.say.4");
            this.dropTestItems();
            this.func_70106_y();
            this.addXP();
        }
        if (type == 50) {
            this.attacktime = 100;
        }
    }

    public void addXP() {
        try {
            List<EntityPlayer> list = MMM.findPlayers(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 16);
            for (int s = 0; s < list.size(); ++s) {
                ManaMetalModRoot root = MMM.getEntityNBT(list.get(s));
                if (root == null) continue;
                root.carrer.addEXP(CareerCore.LVMonsterXP[100] * 100);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70652_k(Entity entity) {
        boolean attack = super.func_70652_k(entity);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.type == 7 || this.type == 8) {
                PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionSpirits, 10, 0);
            }
            if (this.type == 9) {
                PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potiotBlood, 5, 0);
            }
            if (this.type == 10 || this.type == 11) {
                if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                    player.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 100, 0));
                } else {
                    PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionPoison, 20, 0);
                }
            }
        }
        return attack;
    }

    public void fireBallAttackgravityOne() {
        if (this.func_70638_az() != null) {
            ++this.gravityBall;
            if (this.gravityBall > 100) {
                this.see_target();
                if (this.gravityBall == 101) {
                    MMM.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 60, 4.0f, true, 32);
                    this.func_70690_d(new PotionEffect(2, 60, 4));
                }
                if (this.gravityBall == 130) {
                    this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.9f, 0, 2.0f, 0);
                    EntityMagicBallGravity ball1 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.9f, 0, 2.0f, 12);
                    EntityMagicBallGravity ball2 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.9f, 0, 2.0f, 24);
                    EntityMagicBallGravity ball4 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.9f, 0, 2.0f, -12);
                    EntityMagicBallGravity ball5 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 0.9f, 0, 2.0f, -24);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)ball0);
                        this.field_70170_p.func_72838_d((Entity)ball1);
                        this.field_70170_p.func_72838_d((Entity)ball2);
                        this.field_70170_p.func_72838_d((Entity)ball4);
                        this.field_70170_p.func_72838_d((Entity)ball5);
                    }
                }
                if (this.gravityBall > 190) {
                    this.gravityBall = -200;
                }
            }
        }
    }

    public void see_target() {
        if (this.func_70638_az() != null) {
            EntityLivingBase targetedEntity = this.func_70638_az();
            this.func_70671_ap().func_75650_a(targetedEntity.field_70165_t, targetedEntity.field_70163_u + (double)targetedEntity.func_70047_e(), targetedEntity.field_70161_v, 10.0f, (float)this.func_70646_bf());
            this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getAngle(targetedEntity.field_70165_t, targetedEntity.field_70161_v, this.field_70165_t, this.field_70161_v) + 90.0f, (float)(targetedEntity.field_70163_u - this.field_70163_u + (double)targetedEntity.func_70047_e()));
            this.func_70671_ap().func_75649_a();
        }
    }

    public float getAngle(double px1, double py1, double px2, double py2) {
        double x = px2 - px1;
        double y = py2 - py1;
        double hypotenuse = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double cos = x / hypotenuse;
        double radian = Math.acos(cos);
        double angle = 180.0 / (Math.PI / radian);
        if (y < 0.0) {
            angle = -angle;
        } else if (y == 0.0 && x < 0.0) {
            angle = 180.0;
        }
        return (float)angle;
    }

    public void func_70645_a(DamageSource source) {
        MobDunageonHeroTemple dragon;
        int s;
        List<EntityLivingBase> list;
        super.func_70645_a(source);
        if (this.type == 10 || this.type == 11) {
            list = MMM.findLivingBase((Entity)this, 20.0);
            for (s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
                dragon = (MobDunageonHeroTemple)list.get(s);
                if (dragon.type != 3) continue;
                if (this.type == 10) {
                    ++dragon.attacktime;
                    continue;
                }
                ++dragon.railtime;
            }
        }
        if (this.type == 9) {
            list = MMM.findLivingBase((Entity)this, 20.0);
            for (s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
                dragon = (MobDunageonHeroTemple)list.get(s);
                if (dragon.type != 4) continue;
                ++dragon.attacktime;
            }
        }
    }

    public boolean canSpawn() {
        List<EntityLivingBase> list = MMM.findLivingBase((Entity)this, 16.0);
        int count = 0;
        for (int s = 0; s < list.size(); ++s) {
            if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
            ++count;
        }
        return count < 8;
    }

    public void spanwobj(float x, float y, float z, int type, int attack, int timemax, EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K) {
            EntityMagicObject tree1 = new EntityMagicObject(this.field_70170_p, timemax, type, attack, entity);
            tree1.func_70080_a(x, y, z, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)tree1);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected Item func_146068_u() {
        return super.func_146068_u();
    }

    protected void func_70628_a(boolean kill, int lucky) {
        if ((this.type == 7 || this.type == 8) && this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            this.func_145779_a(InstanceDungeonCore.ItemTestTree, 1);
        }
    }

    public void drop(int id) {
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            this.func_70099_a(new ItemStack(ItemCraft10.ItemTrophys, 1, id), 1.0f);
        } else {
            this.func_70099_a(new ItemStack(ItemCraft10.ItemTrophys, 1, id + 1), 1.0f);
        }
    }

    @Override
    public ManaElements getEntityElements() {
        return ManaElements.Earthm;
    }

    @Override
    public float getDefense() {
        return 0.3f;
    }

    @Override
    public int getLV() {
        return InstanceDungeonType.TheHeroTemple.getNeedLV(null);
    }

    @Override
    public float getExtraAttack() {
        return 0.0f;
    }

    @Override
    public int getFightPower() {
        return 0;
    }

    @Override
    public int getPenetrationDefense() {
        return 200;
    }

    public void func_82196_d(EntityLivingBase target, float dif) {
        EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, 2900 * this.Difficult.getDiffcultAttackmultiplier(), ManaElements.Dark, 0, (Entity)target);
        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.Difficult.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.type = additionalData.readInt();
        this.Difficult = IDungeonDifficult.values()[additionalData.readInt()];
    }

    @Override
    public boolean isBoss() {
        return this.type == 6;
    }

    @Override
    public IDungeonDifficult getIDungeonDifficult() {
        return this.Difficult;
    }

    @Override
    public long getMobUUID() {
        return this.mobuuid;
    }

    @Override
    public EntityLivingBase getEntity() {
        return this;
    }

    @Override
    public InstanceDungeonType getDungeonType() {
        return InstanceDungeonType.TheHeroTemple;
    }
}

