/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import project.studio.manametalmod.Lapuda.BossMasadabah;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.atlantis.AtlantisCore;
import project.studio.manametalmod.atlantis.BossOmicron;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.TileEntityUpdate;
import project.studio.manametalmod.enchantmentskey.EnchantmentsKeyEffect;
import project.studio.manametalmod.enchantmentskey.EnchantmentsKeyEffectType;
import project.studio.manametalmod.festival.FestivalCore;
import project.studio.manametalmod.instance_dungeon.DungeonBlockFunctionType;
import project.studio.manametalmod.instance_dungeon.DungeonMobType;
import project.studio.manametalmod.instance_dungeon.EntityBlossCrystalDungeon11;
import project.studio.manametalmod.instance_dungeon.IDungeonBoss;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.MobDunageonDark;
import project.studio.manametalmod.instance_dungeon.MobDunageonDuck;
import project.studio.manametalmod.instance_dungeon.MobDunageonEarth;
import project.studio.manametalmod.instance_dungeon.MobDunageonFeatherSnakeLibrary;
import project.studio.manametalmod.instance_dungeon.MobDunageonFire;
import project.studio.manametalmod.instance_dungeon.MobDunageonFourSeasonsTemple;
import project.studio.manametalmod.instance_dungeon.MobDunageonGiantMaze;
import project.studio.manametalmod.instance_dungeon.MobDunageonGrass;
import project.studio.manametalmod.instance_dungeon.MobDunageonHeroTemple;
import project.studio.manametalmod.instance_dungeon.MobDunageonIce;
import project.studio.manametalmod.instance_dungeon.MobDunageonMars;
import project.studio.manametalmod.instance_dungeon.MobDunageonMechanism;
import project.studio.manametalmod.instance_dungeon.MobDunageonPyramid;
import project.studio.manametalmod.instance_dungeon.MobDunageonSand;
import project.studio.manametalmod.instance_dungeon.MobDunageonSkeleton;
import project.studio.manametalmod.instance_dungeon.MobDunageonStronghold;
import project.studio.manametalmod.instance_dungeon.MobDunageonTheLostTemple;
import project.studio.manametalmod.instance_dungeon.MobDunageonWater;
import project.studio.manametalmod.instance_dungeon.MobDunageonWhiteDragonTemple;
import project.studio.manametalmod.instance_dungeon.MobDunageonWhiteStonePalace;
import project.studio.manametalmod.instance_dungeon.MobDunageonWolf;
import project.studio.manametalmod.instance_dungeon.MobDungeonMobFeatherSnakeTemple;
import project.studio.manametalmod.instance_dungeon.MobPureDragon;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeon;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeonCore;
import project.studio.manametalmod.mob.EntityAstridWeapon;
import project.studio.manametalmod.mob.boss.BossSnakeWhite;
import project.studio.manametalmod.spell.ISummoner;

public class TileEntityDungeonItem
extends TileEntityUpdate {
    public int time = 0;
    public int type = 0;
    public InstanceDungeonType DungeonType = InstanceDungeonType.FireDungeon;
    public IDungeonDifficult diff = IDungeonDifficult.EASY;
    public long mobuuid = -1L;
    public int loopTime = -10;
    public int data1 = 0;
    public int data2 = 0;
    public int data3 = 0;
    public EnchantmentsKeyEffect keyeffect = null;
    public String customname;
    public DungeonBlockFunctionType DBFT = DungeonBlockFunctionType.None;
    public static final int[] xpos = new int[]{1, -1, 0, 0};
    public static final int[] zpos = new int[]{0, 0, -1, 1};

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public InstanceDungeonType getDungeonType() {
        return this.DungeonType;
    }

    public void setDungeonType(InstanceDungeonType dungeonType) {
        this.DungeonType = dungeonType;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = NBTHelp.getIntSafe("type", nbt, 0);
        this.DungeonType = InstanceDungeonType.values()[NBTHelp.getIntSafe("DungeonType", nbt, 0)];
        this.diff = IDungeonDifficult.values()[NBTHelp.getIntSafe("diff", nbt, 0)];
        this.mobuuid = NBTHelp.getLongSafe("mobuuid", nbt, -1L);
        this.data1 = NBTHelp.getIntSafe("data1", nbt, 0);
        this.data2 = NBTHelp.getIntSafe("data2", nbt, 0);
        this.data3 = NBTHelp.getIntSafe("data3", nbt, 0);
        this.loopTime = NBTHelp.getIntSafe("lootTime", nbt, 0);
        this.DBFT = DungeonBlockFunctionType.values()[NBTHelp.getIntSafe("DBFT", nbt, 0)];
        if (EnchantmentsKeyEffect.canReadFromNBT(nbt)) {
            this.keyeffect = EnchantmentsKeyEffect.readFromNBT(nbt);
        }
        if (nbt.func_150297_b("customname", 8)) {
            this.customname = nbt.func_74779_i("customname");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.type);
        nbt.func_74768_a("DungeonType", this.DungeonType.ordinal());
        nbt.func_74768_a("diff", this.diff.ordinal());
        nbt.func_74772_a("mobuuid", this.mobuuid);
        nbt.func_74768_a("data1", this.data1);
        nbt.func_74768_a("data2", this.data2);
        nbt.func_74768_a("data3", this.data3);
        nbt.func_74768_a("lootTime", this.loopTime);
        nbt.func_74768_a("DBFT", this.DBFT.ordinal());
        nbt.func_74778_a("FunctionType", this.DBFT.toString());
        if (this.keyeffect != null) {
            this.keyeffect.saveToNBT(nbt);
        }
        if (this.customname != null) {
            nbt.func_74778_a("customname", this.customname);
        }
    }

    public void spawnBossSacrifice(EntityLivingBase entity, EntityPlayer player, String sound) {
        MMM.removePlayerCurrentItemNoCheck(player);
        entity.func_70080_a((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)entity);
        if (sound != null) {
            MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":" + sound, (Entity)player, 10.0, 1.0, 64.0);
        }
        BossMasadabah.arcLightning_vanilla(this.field_145850_b, new Pos(this), 1.0f, 255.0f, 0.0f, 0.0f);
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
        this.DBFT = DungeonBlockFunctionType.InvalidSpawn;
        this.update_data();
    }

    public void antiJump() {
        List<EntityPlayer> players = MMM.findPlayers(this, 64.0);
        for (int s = 0; s < players.size(); ++s) {
            players.get(s).func_82170_o(Potion.field_76430_j.field_76415_H);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ++this.time;
            if (this.time > 9) {
                this.time = 0;
                switch (this.DBFT) {
                    case AntiJump: {
                        this.antiJump();
                        break;
                    }
                    case WeaponSpawn: {
                        this.spawnRoseWeapon();
                        break;
                    }
                    case SpawnBoss: {
                        this.spawn(DungeonMobType.Boss, true);
                        break;
                    }
                    case SpawnElite: {
                        this.spawn(DungeonMobType.Elite, true);
                        break;
                    }
                    case SpawnLoop: {
                        this.spawnLoop(DungeonMobType.Loop);
                        break;
                    }
                    case SpawnMonster: {
                        this.spawn(DungeonMobType.Monster, true);
                        break;
                    }
                    case SpwanSpecial: {
                        this.spawn(DungeonMobType.Special, true);
                        break;
                    }
                    case AtlantisCrystalEffect: {
                        this.doAtlantisCrystalEffect();
                        break;
                    }
                    case AtlantisCrystalOver: {
                        this.doAtlantisCrystalOverText();
                    }
                }
            }
            switch (this.DBFT) {
                case BreakBlock: {
                    this.breakBlcok(DungeonBlockFunctionType.BreakBlock);
                    break;
                }
                case BreakBracket: {
                    this.breakBlcok(DungeonBlockFunctionType.BreakBracket);
                }
            }
        }
    }

    public void doAtlantisCrystalOverText() {
        if (this.data1 == 0) {
            ++this.loopTime;
            if (this.loopTime == 1) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalOver.0");
            }
            if (this.loopTime == 4) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalOver.1");
            }
            if (this.loopTime == 7) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalOver.2");
            }
            if (this.loopTime == 10) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalOver.3");
            }
            if (this.loopTime == 13) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalOver.4");
            }
        }
    }

    public void doAtlantisCrystalOver() {
        int y = this.field_145848_d - 3;
        int x = this.field_145851_c - 19;
        int z = this.field_145849_e - 19;
        for (int dx = 0; dx < 40; ++dx) {
            for (int dz = 0; dz < 40; ++dz) {
                if (MMM.isBlockData(this.field_145850_b, x + dx, y, z + dz, Blocks.field_150350_a, 0)) {
                    this.field_145850_b.func_147465_d(x + dx, y, z + dz, AtlantisCore.atlantis_block_0, 12, 2);
                }
                if (!MMM.isBlockData(this.field_145850_b, x + dx, y, z + dz, AtlantisCore.BlockAtlantisNoCollisions, 1)) continue;
                this.field_145850_b.func_147465_d(x + dx, y, z + dz, AtlantisCore.atlantis_block_0, 4, 2);
            }
        }
    }

    public void breakBlcok(DungeonBlockFunctionType type) {
        ++this.loopTime;
        boolean breakflag = false;
        if (this.field_145850_b.field_73012_v.nextInt(30) == 0) {
            breakflag = true;
        }
        if (this.loopTime > 120) {
            breakflag = true;
        }
        if (breakflag) {
            switch (type) {
                case BreakBlock: {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":dig.bone_block", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0, 1.0, 32.0);
                    break;
                }
                case BreakBracket: {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, AtlantisCore.BlockAtlantisNoCollisions, 1, 2);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":dig.crystal", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0, 1.0, 32.0);
                }
            }
        }
    }

    public void doAtlantisCrystalEffect() {
        if (this.data1 == 0) {
            ++this.loopTime;
            if (this.loopTime == 1) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalEffect.0");
            }
            if (this.loopTime == 4) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalEffect.1");
            }
            if (this.loopTime == 7) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalEffect.2");
            }
            if (this.loopTime == 10) {
                MMM.addMessageWorldDistance(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0, "MMM.info.AtlantisCrystalEffect.3");
                int y = this.field_145848_d - 3;
                int x = this.field_145851_c - 19;
                int z = this.field_145849_e - 19;
                for (int dx = 0; dx < 40; ++dx) {
                    for (int dz = 0; dz < 40; ++dz) {
                        TileEntityDungeonItem tile;
                        if (MMM.isBlockData(this.field_145850_b, x + dx, y, z + dz, AtlantisCore.atlantis_block_0, 12)) {
                            this.field_145850_b.func_147465_d(x + dx, y, z + dz, InstanceDungeonCore.BlockDungeonItem, 14, 2);
                            tile = new TileEntityDungeonItem();
                            tile.DBFT = DungeonBlockFunctionType.BreakBlock;
                            this.field_145850_b.func_147455_a(x + dx, y, z + dz, (TileEntity)tile);
                        }
                        if (!MMM.isBlockData(this.field_145850_b, x + dx, y, z + dz, AtlantisCore.atlantis_block_0, 4)) continue;
                        this.field_145850_b.func_147465_d(x + dx, y, z + dz, InstanceDungeonCore.BlockDungeonItem, 15, 2);
                        tile = new TileEntityDungeonItem();
                        tile.DBFT = DungeonBlockFunctionType.BreakBracket;
                        this.field_145850_b.func_147455_a(x + dx, y, z + dz, (TileEntity)tile);
                    }
                }
            }
            if (this.loopTime == 13) {
                BossOmicron boss = new BossOmicron(this.field_145850_b);
                boss.func_70080_a((float)this.field_145851_c + 0.5f, (float)this.field_145848_d - 11.0f, (float)this.field_145849_e + 0.5f, 0.0f, 0.0f);
                boss.Difficult = this.diff;
                boss.mobuuid = this.mobuuid;
                boss.spawnPointPos = new Pos(this).add(0, -12, 0);
                boss.crystalPos = new Pos(this);
                this.field_145850_b.func_72838_d((Entity)boss);
                MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss31", this.field_145851_c, this.field_145848_d, this.field_145849_e, 10.0, 1.0, 128.0);
            }
        }
    }

    public void spawnLoop(DungeonMobType type) {
        if (!MMM.findPlayers(this, 32.0).isEmpty()) {
            this.removeOldMob();
            this.removeOldItems();
            this.spawnMobBlock(type);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
            return;
        }
    }

    public void spawn(DungeonMobType type, boolean invalid) {
        if (!MMM.findPlayers(this, 20.0).isEmpty()) {
            this.removeOldMob();
            this.removeOldItems();
            this.spawnMobBlock(type);
            if (invalid) {
                this.type = 2;
                this.DBFT = DungeonBlockFunctionType.InvalidSpawn;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
            return;
        }
    }

    public void spawnMobBlock(DungeonMobType type) {
        try {
            switch (type) {
                case Monster: {
                    for (int s = 0; s < 4; ++s) {
                        EntityLivingBase mob = this.getMob(s);
                        if (mob == null) continue;
                        mob.func_70080_a((double)this.field_145851_c + 0.5 + (double)xpos[s], (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5 + (double)zpos[s], 0.0f, 0.0f);
                        if (!this.field_145850_b.field_72995_K) {
                            this.entitySpawnEffect(mob, s);
                            this.field_145850_b.func_72838_d((Entity)mob);
                        }
                        this.field_145850_b.func_72926_e(2004, this.field_145851_c + xpos[s], this.field_145848_d + 1, this.field_145849_e + zpos[s], 0);
                    }
                    this.spawnMobKeyEffect(type);
                    FestivalCore.valentineDay(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    return;
                }
                case Elite: {
                    EntityLivingBase mob2 = this.getMob(4);
                    if (mob2 != null) {
                        mob2.func_70080_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                        if (!this.field_145850_b.field_72995_K) {
                            this.entitySpawnEffect(mob2, 4);
                            this.field_145850_b.func_72838_d((Entity)mob2);
                        }
                        this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0);
                        FestivalCore.valentineDay(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    }
                    this.spawnMobKeyEffect(type);
                    return;
                }
                case Boss: {
                    EntityLivingBase mobboss = this.getMob(5);
                    if (mobboss != null) {
                        mobboss.func_70080_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                        if (!this.field_145850_b.field_72995_K) {
                            this.entitySpawnEffect(mobboss, 5);
                            this.field_145850_b.func_72838_d((Entity)mobboss);
                        }
                        this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0);
                    }
                    this.spawnMobKeyEffect(type);
                    return;
                }
                case Loop: {
                    ++this.loopTime;
                    if (this.loopTime > 39) {
                        int types;
                        EntityMob mob;
                        BossSnakeWhite target;
                        this.loopTime = 0;
                        if (this.canSpawn() && (target = this.hasSnake()) != null && (mob = (EntityMob)this.getMob(types = this.field_145850_b.field_73012_v.nextInt(4))) != null) {
                            mob.func_70080_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, 0.0f, 0.0f);
                            mob.func_70624_b((EntityLivingBase)target);
                            if (!this.field_145850_b.field_72995_K) {
                                this.entitySpawnEffect((EntityLivingBase)mob, types);
                                this.field_145850_b.func_72838_d((Entity)mob);
                            }
                            this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0);
                            this.removeOldItems();
                        }
                    }
                    return;
                }
                case Special: {
                    EntityTameable life = null;
                    if (this.DungeonType == InstanceDungeonType.SnakeLibrary || this.DungeonType == InstanceDungeonType.FeatherSnakeTemple) {
                        life = new BossSnakeWhite(this.field_145850_b);
                    }
                    if (this.DungeonType == InstanceDungeonType.WhiteDragonTemple) {
                        life = new MobPureDragon(this.field_145850_b);
                    }
                    if (life != null) {
                        life.func_70080_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0.0f, 0.0f);
                        if (!this.field_145850_b.field_72995_K) {
                            this.field_145850_b.func_72838_d((Entity)life);
                        }
                        this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0);
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void spawnMobKeyEffect(DungeonMobType type) {
        if (this.keyeffect != null) {
            switch (type) {
                case Monster: 
                case Elite: {
                    float monster = this.keyeffect.getEffect(EnchantmentsKeyEffectType.enemyCountBuff);
                    if (monster > 0.0f) {
                        for (int s = 0; s < 10 && monster > 0.0f && this.field_145850_b.field_73012_v.nextFloat() < monster; ++s) {
                            monster -= 1.0f;
                            EntityLivingBase mob = this.getMob(this.field_145850_b.field_73012_v.nextInt(4));
                            if (mob == null) continue;
                            mob.func_70080_a((double)this.field_145851_c + 0.5 + (double)xpos[s], (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5 + (double)zpos[s], 0.0f, 0.0f);
                            if (!this.field_145850_b.field_72995_K) {
                                this.entitySpawnEffect(mob, s);
                                this.field_145850_b.func_72838_d((Entity)mob);
                            }
                            this.field_145850_b.func_72926_e(2004, this.field_145851_c + xpos[s], this.field_145848_d + 1, this.field_145849_e + zpos[s], 0);
                        }
                    }
                    return;
                }
                case Boss: {
                    EntityLivingBase mobboss;
                    float boss = this.keyeffect.getEffect(EnchantmentsKeyEffectType.extraBossCount);
                    if (boss > 0.0f && this.field_145850_b.field_73012_v.nextFloat() < boss && (mobboss = this.getMob(5)) != null) {
                        mobboss.func_70080_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                        if (!this.field_145850_b.field_72995_K) {
                            this.entitySpawnEffect(mobboss, 5);
                            this.field_145850_b.func_72838_d((Entity)mobboss);
                        }
                        this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0);
                    }
                    return;
                }
            }
        }
    }

    public EntityLivingBase getMob(int id) {
        CustomDungeon CD;
        if (this.DungeonType == InstanceDungeonType.Custom && this.customname != null && (CD = CustomDungeonCore.get(this.customname)) != null) {
            Entity entity = null;
            switch (id) {
                case 3: 
                case 8: {
                    entity = EntityList.func_75620_a((String)CD.mobName[0], (World)this.field_145850_b);
                    break;
                }
                case 4: {
                    entity = EntityList.func_75620_a((String)CD.mobName[1], (World)this.field_145850_b);
                    break;
                }
                case 5: {
                    entity = EntityList.func_75620_a((String)CD.mobName[2], (World)this.field_145850_b);
                }
            }
            if (entity != null && entity instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
        }
        switch (this.DungeonType) {
            case FireDungeon: {
                return new MobDunageonFire(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case GrassDungeon: {
                return new MobDunageonGrass(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case IceDungeon: {
                return new MobDunageonIce(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case WaterDungeon: {
                return new MobDunageonWater(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case SkullDungeon: {
                return new MobDunageonSkeleton(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case Pyramid: {
                return new MobDunageonPyramid(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case TheLostTemple: {
                return new MobDunageonTheLostTemple(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case FeatherSnakeTemple: {
                return new MobDungeonMobFeatherSnakeTemple(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case Stronghold: {
                return new MobDunageonStronghold(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case EarthDungeon: {
                return new MobDunageonEarth(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case SnakeLibrary: {
                return new MobDunageonFeatherSnakeLibrary(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case Mechanism: {
                return new MobDunageonMechanism(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case TheGodTemple: {
                return new MobDunageonMars(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case DuckVillage: {
                return new MobDunageonDuck(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case TheHeroTemple: {
                return new MobDunageonHeroTemple(this.field_145850_b, this.getDiff(), 0, this.mobuuid, new Pos(this));
            }
            case WolfPalace: {
                return new MobDunageonWolf(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case DarkDungeon: {
                return new MobDunageonDark(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case SandDungeon: {
                return new MobDunageonSand(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case GiantMaze: {
                return new MobDunageonGiantMaze(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case WhiteDragonTemple: {
                return new MobDunageonWhiteDragonTemple(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case FourSeasonsTemple: {
                return new MobDunageonFourSeasonsTemple(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
            case WhiteStonePalace: {
                return new MobDunageonWhiteStonePalace(this.field_145850_b, this.getDiff(), id, this.mobuuid);
            }
        }
        return null;
    }

    public void spawnRoseWeapon() {
        if (!MMM.findPlayers(this, 64.0).isEmpty() && !this.hasRoseWeapon()) {
            EntityAstridWeapon weapon = new EntityAstridWeapon(this.field_145850_b);
            weapon.func_70080_a((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.0f, (float)this.field_145849_e + 0.5f, 0.0f, 0.0f);
            weapon.typeweapon = this.data1;
            this.field_145850_b.func_72838_d((Entity)weapon);
        }
    }

    public boolean hasRoseWeapon() {
        List<EntityLivingBase> list = MMM.findEntityLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 3);
        int size = list.size();
        for (int s = 0; s < size; ++s) {
            if (!(list.get(s) instanceof EntityAstridWeapon)) continue;
            return true;
        }
        return false;
    }

    public void spawnDoors() {
        if (!MMM.findPlayers(this, 10.0).isEmpty()) {
            EntityBlossCrystalDungeon11 mob = new EntityBlossCrystalDungeon11(this.field_145850_b);
            mob.func_70080_a((double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)mob);
            }
            this.type = 2;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
        }
    }

    public void removeOldItems() {
        if (M3Config.DungeonClearItems) {
            try {
                List<EntityItem> list = MMM.findEntityItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
                for (int s = 0; s < list.size(); ++s) {
                    EntityItem item = list.get(s);
                    if (item.field_70292_b <= 600) continue;
                    item.func_70106_y();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeOldMob() {
        if (M3Config.DungeonClearMobs) {
            try {
                List<EntityLivingBase> list = MMM.findMobs(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
                for (int s = 0; s < list.size(); ++s) {
                    IDungeonBoss mobtemp;
                    EntityLivingBase target = list.get(s);
                    if (target instanceof IDungeonBoss && (mobtemp = (IDungeonBoss)target).getMobUUID() != this.mobuuid && mobtemp.canRemove(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this)) {
                        target.func_70106_y();
                    }
                    if (target instanceof BossSnakeWhite) {
                        target.func_70106_y();
                    }
                    if (target instanceof ISummoner) {
                        target.func_70106_y();
                    }
                    if (!(target instanceof MobPureDragon)) continue;
                    target.func_70106_y();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void entitySpawnEffect(EntityLivingBase mob, int id) {
        if (mob instanceof IDungeonBoss) {
            IDungeonBoss idb = (IDungeonBoss)mob;
            idb.onMobSpawn(id, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this, this.func_145832_p());
            MMM.Logg("IDungeonBoss");
            if (this.keyeffect != null) {
                int LV2;
                MMM.Logg("setKeyEffect");
                idb.setKeyEffect(EnchantmentsKeyEffect.clone(this.keyeffect));
                float hp = this.keyeffect.getEffect(EnchantmentsKeyEffectType.enemyHPBuff);
                if (hp > 0.0f) {
                    HashMultimap attributes = HashMultimap.create();
                    attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "EnchantmentsKeyEffect", (double)(mob.func_110138_aP() * hp), 0));
                    mob.func_110140_aT().func_111147_b((Multimap)attributes);
                    mob.func_70606_j(mob.func_110138_aP());
                }
                if ((LV2 = (int)this.keyeffect.getEffect(EnchantmentsKeyEffectType.enemyLVBuff)) > 0) {
                    mob.getEntityData().func_74768_a("ExtraLV", LV2);
                }
            }
        }
    }

    public BossSnakeWhite hasSnake() {
        List<EntityLivingBase> list = MMM.findEntityLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 22);
        int size = list.size();
        for (int s = 0; s < size; ++s) {
            if (!(list.get(s) instanceof BossSnakeWhite)) continue;
            return (BossSnakeWhite)list.get(s);
        }
        return null;
    }

    public boolean canSpawn() {
        int count = 0;
        List<EntityLivingBase> list = MMM.findEntityLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 12);
        int size = list.size();
        for (int s = 0; s < size; ++s) {
            if (!(list.get(s) instanceof IDungeonBoss)) continue;
            ++count;
        }
        return count < 8;
    }

    public IDungeonDifficult getDiff() {
        return this.diff;
    }

    public void setDiff(IDungeonDifficult diff) {
        this.diff = diff;
    }

    public long getMobuuid() {
        return this.mobuuid;
    }

    public void setMobuuid(long mobuuid) {
        this.mobuuid = mobuuid;
    }
}

