/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.AbstractItemStack;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeon;

public class CustomDungeonCore {
    public static final List<CustomDungeon> pool = new ArrayList<CustomDungeon>();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static boolean hasCustomDungeon = false;

    public static void init() {
        try {
            File[] jsonFiles;
            File folder = new File(DimensionManager.getCurrentSaveRootDirectory().getParentFile().getParentFile().getAbsolutePath() + "/ManaMetalModData/CustomDungeon");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if ((jsonFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"))) != null) {
                pool.clear();
                for (File file : jsonFiles) {
                    String content = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                    MMM.Logg("[M3Components] load custom dungeon json : " + file.getAbsolutePath());
                    CustomDungeon CD = CustomDungeonCore.fromJson(content);
                    pool.add(CD);
                }
                hasCustomDungeon = !pool.isEmpty();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String toJson(CustomDungeon mission) {
        return gson.toJson((Object)mission);
    }

    public static CustomDungeon fromJson(String json) {
        return (CustomDungeon)gson.fromJson(json, CustomDungeon.class);
    }

    public static CustomDungeon example() {
        CustomDungeon CD = new CustomDungeon();
        CD.name = "ExampleCustomDungeon";
        CD.needLV = 1;
        CD.offset = new int[]{10, 10, 10};
        CD.mobName = new String[]{"Zombie", "manametalmod.EntityZombitBow", "manametalmod.EntityScorpion"};
        CD.keyItem = new AbstractItemStack[]{new AbstractItemStack("manametalmod", "ItemKeyDungeon", 1, 0), new AbstractItemStack("manametalmod", "ItemKeyDungeon", 1, 1), new AbstractItemStack("manametalmod", "ItemKeyDungeon", 1, 2), new AbstractItemStack("manametalmod", "ItemKeyDungeon", 1, 3)};
        CD.spawnType = "schematic";
        CD.repairItem = new AbstractItemStack("minecraft", "apple", 1, 0);
        CD.natureSpawn = true;
        CD.isBossDungeon = false;
        CD.canRepair = true;
        CD.guiTexture = "manametalmod:textures/gui/dungeon/0.png";
        CD.modelTexture = "manametalmod:textures/model/dungeon/0.png";
        return CD;
    }

    public static final CustomDungeon get(String customname) {
        for (int s = 0; s < pool.size(); ++s) {
            if (!CustomDungeonCore.pool.get((int)s).name.equals(customname)) continue;
            return pool.get(s);
        }
        return null;
    }

    public static final void main(String[] pass) {
        CustomDungeon CD = CustomDungeonCore.example();
        System.out.print(CustomDungeonCore.toJson(CD));
    }
}

