/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.items;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

class ModularDungeonGenerator {
    static final int SIZE = 5;
    static final int ROOM_WIDTH = 16;
    static final int ROOM_HEIGHT = 10;
    static final int ROOM_LENGTH = 16;

    ModularDungeonGenerator() {
    }

    public static void generateDungeon(World world, int baseX, int baseY, int baseZ) {
        Room[][] grid = new Room[5][5];
        Random random = new Random();
        int roomCount = 12;
        ArrayList<Room> roomList = new ArrayList<Room>();
        while (roomList.size() < roomCount) {
            Room room;
            int z;
            int x = random.nextInt(5);
            if (grid[x][z = random.nextInt(5)] != null) continue;
            grid[x][z] = room = new Room(x, z);
            roomList.add(room);
        }
        HashSet<Room> connected = new HashSet<Room>();
        LinkedList<Room> queue = new LinkedList<Room>();
        Room start = (Room)roomList.get(0);
        connected.add(start);
        queue.add(start);
        while (!queue.isEmpty()) {
            int[][] dirs;
            Room current = (Room)queue.poll();
            int x = current.x;
            int z = current.z;
            for (int[] d : dirs = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
                int nx = x + d[0];
                int nz = z + d[1];
                if (nx < 0 || nx >= 5 || nz < 0 || nz >= 5 || grid[nx][nz] == null || connected.contains(grid[nx][nz])) continue;
                connected.add(grid[nx][nz]);
                queue.add(grid[nx][nz]);
            }
        }
        for (Room room : roomList) {
            if (connected.contains(room)) continue;
            grid[room.x][room.z] = null;
        }
        for (Room room : roomList) {
            if (!connected.contains(room)) continue;
            int worldX = baseX + room.x * 18;
            int worldZ = baseZ + room.z * 18;
            ModularDungeonGenerator.placeRoomAt(world, worldX, baseY, worldZ);
        }
        for (Room room : roomList) {
            int[][] dirs;
            int x = room.x;
            int z = room.z;
            for (int[] d : dirs = new int[][]{{1, 0}, {0, 1}}) {
                int nx = x + d[0];
                int nz = z + d[1];
                if (nx >= 5 || nz >= 5 || grid[nx][nz] == null) continue;
                int startX = baseX + x * 18;
                int startZ = baseZ + z * 18;
                ModularDungeonGenerator.placeCorridorBetween(world, startX, baseY, startZ, d[0], d[1]);
                ModularDungeonGenerator.carveDoorway(world, startX, baseY, startZ, d[0], d[1]);
                ModularDungeonGenerator.carveDoorway(world, baseX + nx * 18, baseY, baseZ + nz * 18, -d[0], -d[1]);
            }
        }
    }

    private static void placeRoomAt(World world, int x, int y, int z) {
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                for (int dy = 0; dy < 10; ++dy) {
                    boolean isWall = dx == 0 || dx == 15 || dz == 0 || dz == 15 || dy == 0 || dy == 9;
                    Block block = isWall ? Blocks.field_150417_aV : Blocks.field_150350_a;
                    world.func_147449_b(x + dx, y + dy, z + dz, block);
                }
            }
        }
    }

    private static void placeCorridorBetween(World world, int x, int y, int z, int dx, int dz) {
        int len = 18;
        int width = 4;
        int height = 4;
        for (int i = 0; i <= len; ++i) {
            int cx = x + dx * i + (dx == 0 ? 8 : 0);
            int cz = z + dz * i + (dz == 0 ? 8 : 0);
            for (int wx = -width / 2; wx <= width / 2; ++wx) {
                for (int wz = -width / 2; wz <= width / 2; ++wz) {
                    for (int wy = 0; wy < height; ++wy) {
                        boolean isWall = wx == -width / 2 || wx == width / 2 || wz == -width / 2 || wz == width / 2 || wy == 0 || wy == height - 1;
                        Block block = isWall ? Blocks.field_150417_aV : Blocks.field_150350_a;
                        world.func_147449_b(cx + wx, y + wy, cz + wz, block);
                    }
                }
            }
        }
    }

    private static void carveDoorway(World world, int x, int y, int z, int dx, int dz) {
        int doorX = x + (dx == 1 ? 15 : (dx == -1 ? 0 : 8));
        int doorZ = z + (dz == 1 ? 15 : (dz == -1 ? 0 : 8));
        for (int dy = 1; dy <= 2; ++dy) {
            world.func_147449_b(doorX, y + dy, doorZ, Blocks.field_150350_a);
        }
    }

    static class Room {
        int x;
        int z;
        boolean isConnected = false;

        Room(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

